/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.game;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.Sounds;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.game.GameOverPacket;
import me.jfenn.bingo.common.game.GameOverService;
import me.jfenn.bingo.common.map.CardViewService;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.options.BingoWinCondition;
import me.jfenn.bingo.common.options.EndWhen;
import me.jfenn.bingo.common.scoring.ScoreRanking;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.MessageService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.dialog.IDialogHandle;
import me.jfenn.bingo.platform.dialog.IDialogManager;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001Bo\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010(\u001a\u00020'2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010+\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020'H\u0002\u00a2\u0006\u0004\b+\u0010,R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010-R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010.R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010/R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00100R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00101R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00102R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u00103R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u00104R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u00105R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u00106R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u00107R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u00108\u00a8\u00069"}, d2={"Lme/jfenn/bingo/common/game/GameOverController;", "", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/common/game/GameOverService;", "gameOverService", "Lme/jfenn/bingo/common/map/CardViewService;", "cardViewService", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packetManager", "Lme/jfenn/bingo/common/text/MessageService;", "messageService", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/platform/dialog/IDialogManager;", "dialogManager", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "<init>", "(Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/common/game/GameOverService;Lme/jfenn/bingo/common/map/CardViewService;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/common/text/MessageService;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/platform/dialog/IDialogManager;Lorg/slf4j/Logger;Lme/jfenn/bingo/common/event/ScopedEvents;)V", "Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;", "info", "", "broadcastGameOver", "(Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "Lme/jfenn/bingo/common/game/GameOverPacket;", "packet", "", "openGameOverDialog", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/game/GameOverPacket;)Z", "isUpdate", "sendGameOverPacket", "(Lme/jfenn/bingo/common/game/GameOverService$GameOverInfo;Z)V", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/common/game/GameOverService;", "Lme/jfenn/bingo/common/map/CardViewService;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/common/text/MessageService;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/platform/dialog/IDialogManager;", "Lorg/slf4j/Logger;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nGameOverController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameOverController.kt\nme/jfenn/bingo/common/game/GameOverController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1#2:176\n774#3:177\n865#3,2:178\n1869#3:180\n1869#3,2:181\n1870#3:183\n*S KotlinDebug\n*F\n+ 1 GameOverController.kt\nme/jfenn/bingo/common/game/GameOverController\n*L\n84#1:177\n84#1:178,2\n87#1:180\n89#1:181,2\n87#1:183\n*E\n"})
public final class GameOverController {
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final GameOverService gameOverService;
    @NotNull
    private final CardViewService cardViewService;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final ServerPacketEvents packetManager;
    @NotNull
    private final MessageService messageService;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final IDialogManager dialogManager;
    @NotNull
    private final Logger log;

    public GameOverController(@NotNull MinecraftServer server, @NotNull BingoState state, @NotNull BingoOptions options, @NotNull TextProvider text, @NotNull GameOverService gameOverService, @NotNull CardViewService cardViewService, @NotNull IPlayerManager playerManager, @NotNull ServerPacketEvents packetManager, @NotNull MessageService messageService, @NotNull TeamService teamService, @NotNull IDialogManager dialogManager, @NotNull Logger log, @NotNull ScopedEvents events) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)gameOverService, (String)"gameOverService");
        Intrinsics.checkNotNullParameter((Object)cardViewService, (String)"cardViewService");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)packetManager, (String)"packetManager");
        Intrinsics.checkNotNullParameter((Object)messageService, (String)"messageService");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.server = server;
        this.state = state;
        this.options = options;
        this.text = text;
        this.gameOverService = gameOverService;
        this.cardViewService = cardViewService;
        this.playerManager = playerManager;
        this.packetManager = packetManager;
        this.messageService = messageService;
        this.teamService = teamService;
        this.dialogManager = dialogManager;
        this.log = log;
        ScopedEvents.onEnter$default(events, GameState.POSTGAME, false, arg_0 -> GameOverController._init_$lambda$0(this, arg_0), 2, null);
        events.onUpdateTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> GameOverController._init_$lambda$1(this, arg_0)));
        events.onPlayerChannelRegister((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> GameOverController._init_$lambda$2(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void broadcastGameOver(GameOverService.GameOverInfo info) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object it;
        Pair[] pairArray;
        Pair[] $this$broadcastGameOver_u24lambda_u240 = pairArray = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-GameOverController$broadcastGameOver$scores$22 = false;
        if ((!(this.options.getEndGameWhen() instanceof EndWhen.FirstWin) || this.options.getWinCondition() instanceof BingoWinCondition.Infinite) && info.getScoreRankings().size() > 1) {
            $this$broadcastGameOver_u24lambda_u240.add(this.text.empty());
            for (ScoreRanking score : info.getScoreRankings()) {
                Object object;
                Object duration2;
                Object object2 = score.getDuration();
                if (object2 == null || (object2 = DurationKt.formatString((Duration)object2)) == null) {
                    object2 = duration2 = "DNF";
                }
                if ((object = this.state.getTeams().get(BingoTeamKey.box-impl(score.getKey-zo6Dpdc()))) == null || (object = BingoTeam.getName$default((BingoTeam)object, this.text, true, false, false, null, 28, null)) == null) {
                    object = this.text.literal("[unknown]");
                }
                Object teamName = object;
                Object object3 = new class_124[]{class_124.field_1080};
                object3 = this.text.empty().append(this.text.literal(score.getIndex() + 1 + ". ").formatted((class_124[])object3)).append((IText)teamName).append(" - ").append(score.getScore().formatText(this.text)).append(" - " + (String)duration2);
                Object it2 = object3;
                boolean bl = false;
                $this$broadcastGameOver_u24lambda_u240.add(it2);
            }
        }
        List scores = CollectionsKt.build((List)pairArray);
        $this$broadcastGameOver_u24lambda_u240 = new Pair[4];
        IText iText = this.gameOverService.getMessage(info);
        if (iText == null) {
            iText = this.gameOverService.getTitle(info);
        }
        IText iText2 = iText;
        String string = "%game_end_reason%";
        int n = 0;
        Pair[] pairArray2 = $this$broadcastGameOver_u24lambda_u240;
        boolean bl = false;
        Object object = this.text.literal("  ").append((IText)it);
        pairArray2[n] = TuplesKt.to((Object)string, (Object)CollectionsKt.listOf((Object)object));
        Object $i$a$-buildList-GameOverController$broadcastGameOver$scores$22 = new Object[1];
        class_124[] class_124Array = this.state.ingameDuration();
        if (class_124Array == null) {
            class_124Array = Duration.ZERO;
        }
        it = class_124Array;
        Intrinsics.checkNotNull((Object)it);
        IText iText3 = this.text.literal(DurationKt.formatString((Duration)it));
        it = new class_124[]{class_124.field_1060};
        $i$a$-buildList-GameOverController$broadcastGameOver$scores$22[0] = iText3.formatted((class_124)it);
        it = this.text.string(StringKey.GameEndDuration, $i$a$-buildList-GameOverController$broadcastGameOver$scores$22);
        string = "%time%";
        n = 1;
        pairArray2 = $this$broadcastGameOver_u24lambda_u240;
        boolean bl2 = false;
        object = CollectionsKt.listOf((Object)this.text.literal("  ").append((IText)it));
        pairArray2[n] = TuplesKt.to((Object)string, (Object)object);
        $i$a$-buildList-GameOverController$broadcastGameOver$scores$22 = new Object[]{this.text.bracketedCopyable(String.valueOf(this.server.method_30002().method_8412()))};
        it = this.text.string(StringKey.GameEndSeed, $i$a$-buildList-GameOverController$broadcastGameOver$scores$22);
        string = "%seed%";
        n = 2;
        pairArray2 = $this$broadcastGameOver_u24lambda_u240;
        boolean $i$a$-let-GameOverController$broadcastGameOver$placeholders$42 = false;
        object = CollectionsKt.listOf((Object)this.text.literal("  ").append((IText)it));
        pairArray2[n] = TuplesKt.to((Object)string, (Object)object);
        $this$broadcastGameOver_u24lambda_u240[3] = TuplesKt.to((Object)"%scores%", (Object)scores);
        Map placeholders = MapsKt.mapOf((Pair[])$this$broadcastGameOver_u24lambda_u240);
        $i$a$-buildList-GameOverController$broadcastGameOver$scores$22 = this.playerManager.getPlayers();
        boolean $i$f$filter = false;
        void $i$a$-let-GameOverController$broadcastGameOver$placeholders$42 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it3 = (IPlayerHandle)element$iv$iv;
            boolean bl3 = false;
            if (!(this.state.isLobbyMode() || this.teamService.isPlaying(it3))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List players = (List)destination$iv$iv;
        $this$filter$iv = this.messageService.getLines(MessageService.MessageType.GAME_END, placeholders);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IText line = (IText)element$iv;
            boolean bl4 = false;
            this.log.info(line.toString());
            Iterable $this$forEach$iv2 = players;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IPlayerHandle it4 = (IPlayerHandle)element$iv2;
                boolean bl5 = false;
                it4.sendMessage(line);
            }
        }
    }

    private final boolean openGameOverDialog(IPlayerHandle player, GameOverPacket packet) {
        IDialogHandle iDialogHandle = this.gameOverService.createDialog(packet);
        if (iDialogHandle == null) {
            return false;
        }
        IDialogHandle dialog = iDialogHandle;
        this.dialogManager.showDialog(player, dialog);
        return true;
    }

    private final void sendGameOverPacket(GameOverService.GameOverInfo info, boolean isUpdate) {
        if (!isUpdate) {
            for (BingoTeam team : this.state.getRegisteredTeams()) {
                this.cardViewService.updateCard(team, true);
            }
        }
        IText title = this.gameOverService.getTitle(info);
        IText message = this.gameOverService.getMessage(info);
        List<GameOverPacket.ScoreRanking> scoreRankings = this.gameOverService.getScoreRankings(info);
        for (IPlayerHandle player : this.playerManager.getPlayers()) {
            GameOverPacket packet = this.gameOverService.createPacket(player, info, isUpdate, title, message, scoreRankings);
            if (this.packetManager.getGameOverV8().send(player.getPlayer(), packet) || this.packetManager.getGameOverV7().send(player.getPlayer(), packet) || this.packetManager.getGameOverV6().send(player.getPlayer(), packet) || this.packetManager.getGameOverV5().send(player.getPlayer(), packet) || this.packetManager.getGameOverV4().send(player.getPlayer(), packet) || this.packetManager.getGameOverV3().send(player.getPlayer(), packet) || isUpdate || this.packetManager.getGameOverV2().send(player.getPlayer(), packet)) continue;
            if (this.packetManager.getGameOverV1().send(player.getPlayer(), packet)) {
                Sounds.INSTANCE.playGameOver(player);
                continue;
            }
            if (this.openGameOverDialog(player, packet)) {
                Sounds.INSTANCE.playGameOver(player);
                continue;
            }
            player.sendTitle(title, message);
            Sounds.INSTANCE.playGameOver(player);
        }
    }

    private static final Unit _init_$lambda$0(GameOverController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        GameOverService.GameOverInfo gameOverInfo = this$0.state.getGameOverInfo$bingo_common();
        if (gameOverInfo == null) {
            return Unit.INSTANCE;
        }
        GameOverService.GameOverInfo info = gameOverInfo;
        this$0.broadcastGameOver(info);
        this$0.sendGameOverPacket(info, false);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(GameOverController this$0, TickEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            GameOverService.GameOverInfo gameOverInfo = this$0.state.getGameOverInfo$bingo_common();
            if (gameOverInfo == null) break block0;
            GameOverService.GameOverInfo it2 = gameOverInfo;
            boolean bl = false;
            this$0.sendGameOverPacket(it2, true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(GameOverController this$0, PlayerEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            GameOverService.GameOverInfo gameOverInfo = this$0.state.getGameOverInfo$bingo_common();
            if (gameOverInfo == null) break block0;
            GameOverService.GameOverInfo it2 = gameOverInfo;
            boolean bl = false;
            this$0.sendGameOverPacket(it2, true);
        }
        return Unit.INSTANCE;
    }
}

