/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.commands;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.integrations.permissions.PermissionKey;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.commands.IExecutionSource;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a%\u0010\u0005\u001a\u00020\u0004*\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001\"\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0019\u0010\t\u001a\u00020\u0004*\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0011\u0010\u000b\u001a\u00020\u0004*\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a#\u0010\u0011\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0016\u001a\u00020\u0013*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lme/jfenn/bingo/platform/commands/IExecutionSource;", "", "Lme/jfenn/bingo/common/state/GameState;", "requiredState", "", "hasState", "(Lme/jfenn/bingo/platform/commands/IExecutionSource;[Lme/jfenn/bingo/common/state/GameState;)Z", "Lme/jfenn/bingo/integrations/permissions/PermissionKey;", "key", "hasPermission", "(Lme/jfenn/bingo/platform/commands/IExecutionSource;Lme/jfenn/bingo/integrations/permissions/PermissionKey;)Z", "hasLobby", "(Lme/jfenn/bingo/platform/commands/IExecutionSource;)Z", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/platform/text/IText;", "text", "first", "formatWarning", "(Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/platform/text/IText;Z)Lme/jfenn/bingo/platform/text/IText;", "", "getRunByName", "(Lme/jfenn/bingo/platform/commands/IExecutionSource;)Ljava/lang/String;", "runByName", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Common.kt\nme/jfenn/bingo/common/commands/CommonKt\n+ 2 Scope.kt\norg/koin/core/scope/Scope\n*L\n1#1,37:1\n132#2,5:38\n132#2,5:43\n132#2,5:48\n*S KotlinDebug\n*F\n+ 1 Common.kt\nme/jfenn/bingo/common/commands/CommonKt\n*L\n18#1:38,5\n25#1:43,5\n30#1:48,5\n*E\n"})
public final class CommonKt {
    @NotNull
    public static final String getRunByName(@NotNull IExecutionSource $this$runByName) {
        Intrinsics.checkNotNullParameter((Object)$this$runByName, (String)"<this>");
        return $this$runByName.isConsole() ? "RCON" : $this$runByName.getPlayerOrThrow().getPlayerName();
    }

    public static final boolean hasState(@NotNull IExecutionSource $this$hasState, GameState ... requiredState) {
        Intrinsics.checkNotNullParameter((Object)$this$hasState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requiredState, (String)"requiredState");
        Scope $this$iv = $this$hasState.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        BingoState state = (BingoState)$this$iv.get(Reflection.getOrCreateKotlinClass(BingoState.class), qualifier$iv, parameters$iv);
        return ArraysKt.contains((Object[])requiredState, (Object)((Object)state.getState()));
    }

    public static final boolean hasPermission(@NotNull IExecutionSource $this$hasPermission, @NotNull PermissionKey key2) {
        Intrinsics.checkNotNullParameter((Object)$this$hasPermission, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        if ($this$hasPermission.isConsole()) {
            return true;
        }
        IPlayerHandle iPlayerHandle = $this$hasPermission.getPlayer();
        if (iPlayerHandle == null) {
            return false;
        }
        IPlayerHandle player = iPlayerHandle;
        Scope $this$iv = $this$hasPermission.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        IPermissionsApi permissions = (IPermissionsApi)$this$iv.get(Reflection.getOrCreateKotlinClass(IPermissionsApi.class), qualifier$iv, parameters$iv);
        return permissions.hasPermission(player, key2);
    }

    public static final boolean hasLobby(@NotNull IExecutionSource $this$hasLobby) {
        Intrinsics.checkNotNullParameter((Object)$this$hasLobby, (String)"<this>");
        Scope $this$iv = $this$hasLobby.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        return ((BingoState)$this$iv.get(Reflection.getOrCreateKotlinClass(BingoState.class), qualifier$iv, parameters$iv)).isLobbyMode();
    }

    @NotNull
    public static final IText formatWarning(@NotNull TextProvider $this$formatWarning, @NotNull IText text, boolean first) {
        Intrinsics.checkNotNullParameter((Object)$this$formatWarning, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        class_124[] class_124Array = new class_124[]{class_124.field_1054};
        return $this$formatWarning.literal(first ? "\u26a0  " : "   ").append(text).formatted(class_124Array);
    }

    public static /* synthetic */ IText formatWarning$default(TextProvider textProvider, IText iText, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CommonKt.formatWarning(textProvider, iText, bl);
    }
}

