/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.map;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.map.CardImagePacket;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001b\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001eR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001fR&\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lme/jfenn/bingo/common/map/CardImageService;", "", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packets", "Lme/jfenn/bingo/common/state/BingoState;", "state", "<init>", "(Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/common/state/BingoState;)V", "", "id", "Ljava/io/InputStream;", "readCardImageStream", "(Ljava/lang/String;)Ljava/io/InputStream;", "Lme/jfenn/bingo/common/map/CardImagePacket;", "readCardImage", "(Ljava/lang/String;)Lme/jfenn/bingo/common/map/CardImagePacket;", "", "clearPlayerStates", "()V", "Ljava/util/UUID;", "player", "clearPlayerState", "(Ljava/util/UUID;)V", "sendNecessaryImages", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/common/state/BingoState;", "", "", "playersWithImages", "Ljava/util/Map;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nCardImageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardImageService.kt\nme/jfenn/bingo/common/map/CardImageService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n1#2:97\n1374#3:84\n1460#3,2:85\n1617#3,9:87\n1869#3:96\n1870#3:98\n1626#3:99\n1462#3,3:100\n774#3:103\n865#3,2:104\n1563#3:106\n1634#3,3:107\n*S KotlinDebug\n*F\n+ 1 CardImageService.kt\nme/jfenn/bingo/common/map/CardImageService\n*L\n49#1:97\n49#1:84\n49#1:85,2\n49#1:87,9\n49#1:96\n49#1:98\n49#1:99\n49#1:100,3\n57#1:103\n57#1:104,2\n66#1:106\n66#1:107,3\n*E\n"})
public final class CardImageService {
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final ServerPacketEvents packets;
    @NotNull
    private final BingoState state;
    @NotNull
    private final Map<String, Set<UUID>> playersWithImages;

    public CardImageService(@NotNull MinecraftServer server, @NotNull IPlayerManager playerManager, @NotNull ServerPacketEvents packets, @NotNull BingoState state) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.server = server;
        this.playerManager = playerManager;
        this.packets = packets;
        this.state = state;
        this.playersWithImages = new LinkedHashMap();
    }

    @Nullable
    public final InputStream readCardImageStream(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String namespace = StringsKt.substringBefore$default((String)id, (char)':', null, (int)2, null);
        String path = "yet-another-minecraft-bingo/images/" + StringsKt.substringAfterLast$default((String)id, (char)':', null, (int)2, null) + ".png";
        Optional optional = this.server.method_34864().method_14486(class_2960.method_43902((String)namespace, (String)path));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getResource(...)");
        class_3298 class_32982 = (class_3298)OptionalsKt.getOrNull((Optional)optional);
        return class_32982 != null ? class_32982.method_14482() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CardImagePacket readCardImage(String id) {
        Object object;
        block9: {
            block8: {
                byte[] byArray;
                object = this.readCardImageStream(id);
                if (object == null) break block8;
                Closeable closeable = (Closeable)object;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    byArray = it.readAllBytes();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = byArray;
                if (byArray != null) break block9;
            }
            return null;
        }
        Object bytes = object;
        return new CardImagePacket(id, (byte[])bytes);
    }

    public final void clearPlayerStates() {
        this.playersWithImages.clear();
    }

    public final void clearPlayerState(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        for (Map.Entry<String, Set<UUID>> entry : this.playersWithImages.entrySet()) {
            entry.setValue(SetsKt.minus(entry.getValue(), (Object)player));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendNecessaryImages() {
        Set<UUID> playerSet;
        Iterable list$iv$iv;
        IPlayerHandle $this$forEach$iv$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.state.getCards();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            BingoCard card = (BingoCard)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = card.getObjectives().values();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                BingoObjective it = (BingoObjective)element$iv$iv2;
                boolean bl3 = false;
                if (it.getDisplay().getImage() == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set images = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List<IPlayerHandle> players = this.playerManager.getPlayers();
        for (String image2 : images) {
            void $this$mapTo$iv$iv;
            Set $this$map$iv;
            Object playerNeeded2;
            void $this$filterTo$iv$iv;
            Set<UUID> set = this.playersWithImages.get(image2);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            playerSet = set;
            Iterable $this$filter$iv = players;
            boolean $i$f$filter22 = false;
            list$iv$iv = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IPlayerHandle it = (IPlayerHandle)element$iv$iv;
                boolean bl = false;
                if (!(!playerSet.contains(it.getUuid()))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List playersNeeded = (List)destination$iv$iv3;
            if (playersNeeded.isEmpty() || this.readCardImage(image2) == null) continue;
            for (Object playerNeeded2 : playersNeeded) {
                CardImagePacket packet;
                this.packets.getCardImageV1().send(playerNeeded2.getPlayer(), packet);
            }
            Map<String, Set<UUID>> $i$f$filter22 = this.playersWithImages;
            playerNeeded2 = playersNeeded;
            Set<UUID> set2 = playerSet;
            boolean $i$f$map = false;
            void $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                $this$forEach$iv$iv$iv = (IPlayerHandle)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl = false;
                collection.add(it.getUuid());
            }
            $this$map$iv = SetsKt.plus(set2, (Iterable)((List)destination$iv$iv4));
            $i$f$filter22.put(image2, $this$map$iv);
        }
        for (String removedImage : SetsKt.minus(this.playersWithImages.keySet(), (Iterable)images)) {
            if (this.playersWithImages.get(removedImage) == null) continue;
            CardImagePacket packet = new CardImagePacket(removedImage, null);
            for (UUID uuid : playerSet) {
                IPlayerHandle player;
                if (this.playerManager.getPlayer(uuid) == null) continue;
                this.packets.getCardImageV1().send(player.getPlayer(), packet);
            }
            this.playersWithImages.remove(removedImage);
        }
    }
}

