/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.scoring;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.config.PlayerSettingsService;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.map.CardTileImage;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.scoring.GameMessage;
import me.jfenn.bingo.common.scoring.GameMessageClearPacket;
import me.jfenn.bingo.common.scoring.GameMessagePacket;
import me.jfenn.bingo.common.scoring.ScoreMessagePacket;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0019\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020 H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010$\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020#H\u0002\u00a2\u0006\u0004\b$\u0010%J\u0019\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020&H\u0002\u00a2\u0006\u0004\b'\u0010(J\u001d\u0010*\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010.\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u001a\u00a2\u0006\u0004\b.\u0010/J\u0015\u00100\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b0\u00101J\u0015\u00102\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b2\u00103R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00104R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00105R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00106R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00107R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00108R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00109R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010:\u00a8\u0006;"}, d2={"Lme/jfenn/bingo/common/scoring/GameMessageService;", "", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packets", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "playerSettingsService", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "<init>", "(Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/common/config/PlayerSettingsService;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/team/TeamService;)V", "Lme/jfenn/bingo/common/scoring/GameMessage;", "gameMessage", "Lme/jfenn/bingo/platform/text/IText;", "message", "formatWithTime", "(Lme/jfenn/bingo/common/scoring/GameMessage;Lme/jfenn/bingo/platform/text/IText;)Lme/jfenn/bingo/platform/text/IText;", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "createMessagePacket", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/scoring/GameMessage;)Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "Lme/jfenn/bingo/common/scoring/GameMessage$ItemScored;", "createItemScoredMessage", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/scoring/GameMessage$ItemScored;)Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "Lme/jfenn/bingo/common/scoring/GameMessage$LineScored;", "createLineScoredMessage", "(Lme/jfenn/bingo/common/scoring/GameMessage$LineScored;)Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "Lme/jfenn/bingo/common/scoring/GameMessage$CardCompleted;", "createCardCompletedMessage", "(Lme/jfenn/bingo/common/scoring/GameMessage$CardCompleted;)Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "Lme/jfenn/bingo/common/scoring/GameMessage$LeadingTeam;", "createLeadingTeamMessage", "(Lme/jfenn/bingo/common/scoring/GameMessage$LeadingTeam;)Lme/jfenn/bingo/common/scoring/GameMessagePacket;", "", "isEnabled", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/scoring/GameMessage;)Z", "packet", "", "sendMessagePacket", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/scoring/GameMessagePacket;)V", "sendClearMessagesPacket", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "addGameMessage", "(Lme/jfenn/bingo/common/scoring/GameMessage;)V", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/team/TeamService;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nGameMessageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameMessageService.kt\nme/jfenn/bingo/common/scoring/GameMessageService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n1#2:228\n774#3:229\n865#3,2:230\n1869#3,2:232\n*S KotlinDebug\n*F\n+ 1 GameMessageService.kt\nme/jfenn/bingo/common/scoring/GameMessageService\n*L\n213#1:229\n213#1:230,2\n214#1:232,2\n*E\n"})
public final class GameMessageService {
    @NotNull
    private final ServerPacketEvents packets;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final BingoState state;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final PlayerSettingsService playerSettingsService;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final TeamService teamService;

    public GameMessageService(@NotNull ServerPacketEvents packets, @NotNull BingoOptions options, @NotNull BingoState state, @NotNull TextProvider text, @NotNull PlayerSettingsService playerSettingsService, @NotNull IPlayerManager playerManager, @NotNull TeamService teamService) {
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)playerSettingsService, (String)"playerSettingsService");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        this.packets = packets;
        this.options = options;
        this.state = state;
        this.text = text;
        this.playerSettingsService = playerSettingsService;
        this.playerManager = playerManager;
        this.teamService = teamService;
    }

    private final IText formatWithTime(GameMessage gameMessage, IText message) {
        class_124[] class_124Array = new class_124[]{class_124.field_1080};
        return this.text.empty().append(this.text.literal(DurationKt.formatHHMMSS(gameMessage.getTimeElapsed())).bracketed().formatted(class_124Array)).append(" ").append(message);
    }

    @Nullable
    public final GameMessagePacket createMessagePacket(@NotNull IPlayerHandle player, @NotNull GameMessage message) {
        GameMessagePacket gameMessagePacket;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GameMessage gameMessage = message;
        if (gameMessage instanceof GameMessage.ItemScored) {
            gameMessagePacket = this.createItemScoredMessage(player, (GameMessage.ItemScored)message);
        } else if (gameMessage instanceof GameMessage.LineScored) {
            gameMessagePacket = this.createLineScoredMessage((GameMessage.LineScored)message);
        } else if (gameMessage instanceof GameMessage.CardCompleted) {
            gameMessagePacket = this.createCardCompletedMessage((GameMessage.CardCompleted)message);
        } else if (gameMessage instanceof GameMessage.LeadingTeam) {
            gameMessagePacket = this.createLeadingTeamMessage((GameMessage.LeadingTeam)message);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return gameMessagePacket;
    }

    private final GameMessagePacket createItemScoredMessage(IPlayerHandle player, GameMessage.ItemScored message) {
        IText iText;
        IText iText2;
        Object v1;
        Object it;
        Object object2;
        BingoTeam team;
        block10: {
            BingoTeam bingoTeam = this.state.getTeams().get(BingoTeamKey.box-impl(message.getTeam-zo6Dpdc()));
            if (bingoTeam == null) {
                return null;
            }
            team = bingoTeam;
            Iterable iterable = this.state.getCards();
            for (Object object2 : iterable) {
                it = (class_124[])object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)message.getCardId())) continue;
                v1 = object2;
                break block10;
            }
            v1 = null;
        }
        BingoCard bingoCard = v1;
        if (bingoCard == null) {
            return null;
        }
        BingoCard card = bingoCard;
        boolean isOnTeamOrSpectator = team.includesPlayer(player) || !this.teamService.isPlaying(player);
        boolean isItemHidden = card.getOptions().isHiddenItemsMode() && !isOnTeamOrSpectator && this.state.getState() != GameState.POSTGAME;
        if (isItemHidden) {
            class_124[] class_124Array = new class_124[]{class_124.field_1051};
            iText2 = this.text.literal("*****").formatted(class_124Array);
        } else {
            iText2 = message.getItemName();
        }
        IText itemText = iText2.bracketed();
        StringKey stringKey = message.isLost() ? StringKey.GameMessageLostItem : StringKey.GameMessageCapturedItem;
        object2 = new Object[2];
        if (message.getPlayer() != null) {
            String string = team.getSymbol();
            Object object3 = string != null ? string + " " : null;
            if (object3 == null) {
                object3 = "";
            }
            it = new class_124[]{team.getTextColor()};
            iText = this.text.literal((String)object3 + message.getPlayer().getName()).formatted((class_124)it);
        } else {
            iText = BingoTeam.getName$default(team, this.text, true, false, false, null, 20, null);
        }
        object2[0] = iText;
        object2[1] = itemText;
        it = this.text.string(stringKey, object2);
        boolean $i$a$-let-GameMessageService$createItemScoredMessage$chatMessage$22 = false;
        IText chatMessage = this.formatWithTime(message, (IText)it);
        Object $i$a$-let-GameMessageService$createItemScoredMessage$chatMessage$22 = it = message.getImage();
        String string = team.getKey-zo6Dpdc();
        Duration duration2 = message.getTimeElapsed();
        UUID uUID = message.getId();
        boolean bl = false;
        boolean bl2 = !isItemHidden;
        Object object4 = bl2 ? it : null;
        if (object4 == null) {
            object4 = CardTileImage.Companion.getEMPTY();
        }
        object2 = message.getImageList();
        it = object2;
        Object object5 = object4;
        boolean bl3 = false;
        boolean bl4 = !isItemHidden;
        Object object6 = bl4 ? object2 : null;
        if (object6 == null) {
            object6 = CollectionsKt.emptyList();
        }
        object2 = message.getDecoration();
        it = object2;
        Object object7 = object6;
        boolean bl5 = false;
        boolean bl6 = !isItemHidden;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 256;
        boolean bl7 = false;
        IText iText3 = chatMessage;
        ScoreMessagePacket.MessageType messageType = ScoreMessagePacket.MessageType.ITEM_SCORED;
        Object object8 = bl6 ? object2 : null;
        Object object9 = object7;
        Object object10 = object5;
        String string2 = string;
        Duration duration3 = duration2;
        UUID uUID2 = uUID;
        return new GameMessagePacket(uUID2, duration3, string2, (CardTileImage)object10, (List)object9, (CardTile.Decoration)((Object)object8), messageType, iText3, bl7, n, defaultConstructorMarker);
    }

    private final GameMessagePacket createLineScoredMessage(GameMessage.LineScored message) {
        BingoTeam bingoTeam = this.state.getTeams().get(BingoTeamKey.box-impl(message.getTeam-zo6Dpdc()));
        if (bingoTeam == null) {
            return null;
        }
        BingoTeam team = bingoTeam;
        IText teamName = BingoTeam.getName$default(team, this.text, true, false, false, null, 28, null);
        Object[] objectArray = new Object[]{teamName, this.text.lineCount(message.getLines())};
        IText iText = this.text.string(StringKey.GameMessageScoredLine, objectArray);
        objectArray = new class_124[]{class_124.field_1054};
        IText it = iText.formatted((class_124[])objectArray);
        boolean bl = false;
        IText chatMessage = this.formatWithTime(message, it);
        return new GameMessagePacket(message.getId(), message.getTimeElapsed(), team.getKey-zo6Dpdc(), null, null, null, ScoreMessagePacket.MessageType.LINE_SCORED, chatMessage, false, 280, null);
    }

    private final GameMessagePacket createCardCompletedMessage(GameMessage.CardCompleted message) {
        BingoTeam bingoTeam = this.state.getTeams().get(BingoTeamKey.box-impl(message.getTeam-zo6Dpdc()));
        if (bingoTeam == null) {
            return null;
        }
        BingoTeam team = bingoTeam;
        StringKey string = message.isAutoWin() ? StringKey.GameMessageCompletedCardByStalemate : StringKey.GameMessageCompletedCard;
        Object[] objectArray = new Object[]{BingoTeam.getName$default(team, this.text, true, false, false, null, 28, null)};
        IText iText = this.text.string(string, objectArray);
        objectArray = new class_124[]{class_124.field_1054};
        IText it = iText.formatted((class_124[])objectArray);
        boolean bl = false;
        IText chatMessage = this.formatWithTime(message, it);
        return new GameMessagePacket(message.getId(), message.getTimeElapsed(), team.getKey-zo6Dpdc(), null, null, null, ScoreMessagePacket.MessageType.CARD_COMPLETED, chatMessage, false, 280, null);
    }

    private final GameMessagePacket createLeadingTeamMessage(GameMessage.LeadingTeam message) {
        IText iText;
        Object[] objectArray;
        IText iText2;
        BingoTeam bingoTeam = this.state.getTeams().get(BingoTeamKey.box-impl(message.getTeam-zo6Dpdc()));
        if (bingoTeam == null) {
            return null;
        }
        BingoTeam team = bingoTeam;
        IText teamName = BingoTeam.getName$default(team, this.text, true, false, false, null, 28, null);
        if (message.getCards() != null) {
            iText2 = this.text.cardCount(message.getCards());
        } else if (message.getLines() != null) {
            iText2 = this.text.lineCount(message.getLines());
        } else if (message.getItems() != null) {
            iText2 = this.text.itemCount(message.getItems());
        } else {
            throw new IllegalStateException("Invalid leading team GameMessage".toString());
        }
        IText scoreText = iText2;
        if (message.isTied() && this.options.getShowCompletedItems()) {
            objectArray = new Object[]{teamName, scoreText};
            iText = this.text.string(StringKey.GameMessageLeadingTiedWithScore, objectArray);
        } else if (message.isTied()) {
            objectArray = new Object[]{teamName};
            iText = this.text.string(StringKey.GameMessageLeadingTied, objectArray);
        } else if (this.options.getShowCompletedItems()) {
            objectArray = new Object[]{teamName, scoreText};
            iText = this.text.string(StringKey.GameMessageLeadingWithScore, objectArray);
        } else {
            objectArray = new Object[]{teamName};
            iText = this.text.string(StringKey.GameMessageLeading, objectArray);
        }
        objectArray = new class_124[]{class_124.field_1054};
        IText it = iText.formatted((class_124[])objectArray);
        boolean bl = false;
        IText chatMessage = this.formatWithTime(message, it);
        return new GameMessagePacket(message.getId(), message.getTimeElapsed(), team.getKey-zo6Dpdc(), null, null, null, ScoreMessagePacket.MessageType.LEADING_TEAM, chatMessage, false, 280, null);
    }

    /*
     * Unable to fully structure code
     */
    public final boolean isEnabled(@NotNull IPlayerHandle player, @NotNull GameMessage message) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        playerTeam = this.teamService.getPlayerTeam(player);
        if (playerTeam == null) ** GOTO lbl-1000
        var5_4 = playerTeam.getKey-zo6Dpdc();
        v0 = message.getTeam-fzvlhXk();
        if (v0 == null ? false : BingoTeamKey.equals-impl0((String)var5_4, v0)) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        isOnTeamOrSpectator = v1;
        var5_4 = message;
        if (var5_4 instanceof GameMessage.ItemScored) {
            v2 = (this.options.getShowCompletedItems() || isOnTeamOrSpectator) && this.playerSettingsService.getPlayer(player).getItemMessages();
        } else if (var5_4 instanceof GameMessage.LineScored) {
            v2 = (this.options.getShowCompletedLines() || isOnTeamOrSpectator) && this.playerSettingsService.getPlayer(player).getScoreMessages();
        } else if (var5_4 instanceof GameMessage.CardCompleted) {
            v2 = this.playerSettingsService.getPlayer(player).getScoreMessages();
        } else if (var5_4 instanceof GameMessage.LeadingTeam) {
            v2 = this.options.getShowLeadingTeam() && this.playerSettingsService.getPlayer(player).getLeadingMessages();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return v2;
    }

    public final void sendMessagePacket(@NotNull IPlayerHandle player, @NotNull GameMessagePacket packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (!this.packets.getGameMessageV1().send(player, packet) && !packet.isUpdate()) {
            boolean isViewerOnTeam = switch (WhenMappings.$EnumSwitchMapping$0[packet.getMessageType().ordinal()]) {
                case 1 -> {
                    BingoTeam v0 = this.state.getTeams().get(BingoTeamKey.box-impl(packet.getTeam-zo6Dpdc()));
                    if (!(v0 != null ? !v0.includesPlayer(player) : false) || !this.teamService.isPlaying(player)) {
                        yield true;
                    }
                    yield false;
                }
                case 2, 3, 4 -> true;
                default -> throw new NoWhenBranchMatchedException();
            };
            ScoreMessagePacket scoreMessagePacket = ScoreMessagePacket.Companion.fromGameMessage(packet, isViewerOnTeam);
            if (!(this.packets.getScoreMessageV3().send(player, scoreMessagePacket) || this.packets.getScoreMessageV2().send(player, scoreMessagePacket) || this.packets.getScoreMessageV1().send(player, scoreMessagePacket))) {
                player.sendMessage(packet.getMessage());
            }
        }
    }

    public final void sendClearMessagesPacket(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.packets.getGameMessageClearV1().send(player, GameMessageClearPacket.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public final void addGameMessage(@NotNull GameMessage message) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.state.getGameMessages().add(message);
        Iterable $this$filter$iv = this.playerManager.getPlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv$iv;
            boolean bl = false;
            if (!this.isEnabled(it, message)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv;
            boolean bl = false;
            GameMessagePacket gameMessagePacket = this.createMessagePacket(it, message);
            if (gameMessagePacket == null) continue;
            GameMessagePacket packet = gameMessagePacket;
            boolean bl2 = false;
            this.sendMessagePacket(it, packet);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScoreMessagePacket.MessageType.values().length];
            try {
                nArray[ScoreMessagePacket.MessageType.ITEM_SCORED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScoreMessagePacket.MessageType.LINE_SCORED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScoreMessagePacket.MessageType.CARD_COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScoreMessagePacket.MessageType.LEADING_TEAM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

