/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.mixin;

import java.util.Optional;
import me.jfenn.bingo.common.spawn.SpawnData;
import me.jfenn.bingo.mixinhandler.PlayerManagerMixinHelper;
import me.jfenn.bingo.platform.block.BlockPosition;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_4969;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public abstract class PlayerManagerMixin {
    @Shadow
    @Final
    private MinecraftServer field_14360;
    @Unique
    private final Logger log = LoggerFactory.getLogger(PlayerManagerMixin.class);

    @Inject(at={@At(value="HEAD")}, method={"method_14605(Lnet/minecraft/class_1657;DDDDLnet/minecraft/class_5321;Lnet/minecraft/class_2596;)V"}, cancellable=true)
    private void sendToAround(@Nullable class_1657 player, double x, double y, double z, double distance, class_5321<class_1937> worldKey, class_2596<?> packet, CallbackInfo ci) {
        if (packet instanceof class_2767 && PlayerManagerMixinHelper.Companion.shouldPreventLobbyChaos()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"method_14600(Lnet/minecraft/class_3222;)Lnet/minecraft/class_2487;"}, cancellable=true)
    private void loadPlayerData(class_3222 player, CallbackInfoReturnable<class_2487> ci) {
        if (ci.getReturnValue() == null && PlayerManagerMixinHelper.Companion.shouldSpawnInLobby()) {
            SpawnData spawn = PlayerManagerMixinHelper.Companion.getPregameSpawnData();
            if (spawn == null) {
                return;
            }
            class_2487 nbt = new class_2487();
            nbt.method_10582("Dimension", spawn.getDimension());
            class_2499 position = new class_2499();
            BlockPosition blockPosition = spawn.getPosition();
            position.add((Object)class_2489.method_23241((double)((double)blockPosition.getX() + 0.5)));
            position.add((Object)class_2489.method_23241((double)blockPosition.getY()));
            position.add((Object)class_2489.method_23241((double)((double)blockPosition.getZ() + 0.5)));
            nbt.method_10566("Pos", (class_2520)position);
            class_2499 rotation = new class_2499();
            rotation.add((Object)class_2494.method_23244((float)spawn.getYaw()));
            rotation.add((Object)class_2494.method_23244((float)0.0f));
            nbt.method_10566("Rotation", (class_2520)rotation);
            player.method_5651(nbt);
            ci.setReturnValue((Object)nbt);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"method_14556(Lnet/minecraft/class_3222;Z)Lnet/minecraft/class_3222;"})
    private void respawnPlayer(class_3222 player, boolean alive, CallbackInfoReturnable<class_3222> info) {
        class_2680 respawnAnchorBlockState;
        if (!PlayerManagerMixinHelper.Companion.exists()) {
            return;
        }
        if (alive) {
            if (PlayerManagerMixinHelper.Companion.shouldOverrideEndRespawn()) {
                class_3218 overworld = player.field_13995.method_30002();
                player.method_26284(overworld.method_27983(), overworld.method_43126(), overworld.method_43127(), false, false);
            }
            return;
        }
        class_3218 respawnAnchorWorld = this.field_14360.method_3847(player.method_26281());
        class_2338 respawnAnchorBlockPos = player.method_26280();
        class_2680 class_26802 = respawnAnchorBlockState = respawnAnchorWorld != null && respawnAnchorBlockPos != null ? respawnAnchorWorld.method_8320(respawnAnchorBlockPos) : null;
        if (respawnAnchorBlockState == null || !(respawnAnchorBlockState.method_26204() instanceof class_4969)) {
            respawnAnchorWorld = null;
        }
        Optional targetRespawn = Optional.empty();
        try {
            class_3218 spawnWorld = player.field_13995.method_3847(player.method_26281());
            class_2338 spawnPosition = player.method_26280();
            if (spawnWorld != null && spawnPosition != null) {
                targetRespawn = class_1657.method_26091((class_3218)spawnWorld, (class_2338)spawnPosition, (float)player.method_30631(), (boolean)player.method_26282(), (boolean)alive);
            }
        }
        catch (Throwable e) {
            this.log.error("Exception thrown during PlayerEntity.findRespawnPosition", e);
        }
        if (respawnAnchorWorld != null) {
            respawnAnchorWorld.method_8501(respawnAnchorBlockPos, respawnAnchorBlockState);
        }
        if (targetRespawn.isEmpty()) {
            PlayerManagerMixinHelper.Companion.setPlayerSpawnpoint(player);
        }
    }
}

