/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.hud;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.client.platform.renderer.IDrawService;
import me.jfenn.bingo.common.map.Color;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.platform.text.IText;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001#B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0015R\u0016\u0010\u0007\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001cR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lme/jfenn/bingo/client/common/hud/BingoEndFireworkRenderer;", "", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Ljava/time/Instant;", "startedAt", "", "range", "<init>", "(Lme/jfenn/bingo/common/text/TextProvider;Ljava/time/Instant;I)V", "", "isDone", "()Z", "Lme/jfenn/bingo/client/platform/renderer/IDrawService;", "drawService", "centerX", "centerY", "now", "", "render", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;IILjava/time/Instant;)V", "Ljava/time/Instant;", "I", "", "starVelocityScale", "D", "", "colors", "Ljava/util/List;", "", "Lme/jfenn/bingo/client/common/hud/BingoEndFireworkRenderer$StarInfo;", "stars", "Lme/jfenn/bingo/platform/text/IText;", "starText", "Lme/jfenn/bingo/platform/text/IText;", "StarInfo", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
public final class BingoEndFireworkRenderer {
    @NotNull
    private final Instant startedAt;
    private int range;
    private final double starVelocityScale;
    @NotNull
    private final List<Integer> colors;
    @NotNull
    private final List<StarInfo> stars;
    @NotNull
    private final IText starText;

    public BingoEndFireworkRenderer(@NotNull TextProvider text, @NotNull Instant startedAt, int range) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        this.startedAt = startedAt;
        this.range = range;
        this.starVelocityScale = 1.5;
        Object[] objectArray = new Integer[]{-671581, -6031965, -6031929, -6050827, -3365899, -678954};
        this.colors = CollectionsKt.listOf((Object[])objectArray);
        int n = 50;
        BingoEndFireworkRenderer bingoEndFireworkRenderer = this;
        ArrayList<StarInfo> arrayList = new ArrayList<StarInfo>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<StarInfo> arrayList2 = arrayList;
            boolean bl = false;
            double theta = Math.random() * Math.PI * (double)2;
            double vel = 1.0 + Math.random();
            arrayList2.add(new StarInfo(0.0, 0.0, Math.random() * Math.PI * (double)2, Math.cos(theta) * vel * this.starVelocityScale, Math.sin(theta) * vel * this.starVelocityScale - 0.2, (Math.random() - 0.5) * 0.5 * this.starVelocityScale, Color.Companion.fromInt(((Number)CollectionsKt.random((Collection)this.colors, (Random)((Random)Random.Default))).intValue())));
        }
        bingoEndFireworkRenderer.stars = arrayList;
        this.starText = text.literal("\u2605");
    }

    public /* synthetic */ BingoEndFireworkRenderer(TextProvider textProvider, Instant instant, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            instant = Instant.now();
        }
        if ((n2 & 4) != 0) {
            n = 500;
        }
        this(textProvider, instant, n);
    }

    public final boolean isDone() {
        return this.stars.isEmpty();
    }

    public final void render(@NotNull IDrawService drawService, int centerX, int centerY, @NotNull Instant now) {
        Iterator<StarInfo> iterator;
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        double ticks = (double)DurationKt.minus(now, this.startedAt).toMillis() / 50.0;
        Iterator<StarInfo> iterator2 = iterator = this.stars.iterator();
        while (iterator2.hasNext()) {
            StarInfo star = iterator2.next();
            double x = star.getX() + star.getXVel() * ticks;
            double y = star.getY() + star.getYVel() * ticks;
            double rot = star.getRot() + star.getRotVel() * ticks;
            float alpha = 1.0f - (float)Math.pow((float)(new Vector2d(x, y).length() / (double)this.range), 3);
            if (alpha <= 0.025f) {
                iterator.remove();
                continue;
            }
            drawService.getMatrices().push();
            drawService.getMatrices().translate(centerX, centerY, 0.0f);
            drawService.getMatrices().translate((float)x, (float)y, 2000.0f);
            drawService.getMatrices().rotate((float)rot);
            int color2 = Color.copy$default(star.getColor(), 0, 0, 0, RangesKt.coerceIn((int)((int)(alpha * (float)255)), (int)1, (int)255), 7, null).getAsIntWithAlpha();
            drawService.drawText(this.starText, -4, -4, color2, false);
            drawService.getMatrices().pop();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\r\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\r\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\r\u001a\u0004\b\u0013\u0010\u000fR\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\r\u001a\u0004\b\u0014\u0010\u000fR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lme/jfenn/bingo/client/common/hud/BingoEndFireworkRenderer$StarInfo;", "", "", "x", "y", "rot", "xVel", "yVel", "rotVel", "Lme/jfenn/bingo/common/map/Color;", "color", "<init>", "(DDDDDDLme/jfenn/bingo/common/map/Color;)V", "D", "getX", "()D", "getY", "getRot", "getXVel", "getYVel", "getRotVel", "Lme/jfenn/bingo/common/map/Color;", "getColor", "()Lme/jfenn/bingo/common/map/Color;", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class StarInfo {
        private final double x;
        private final double y;
        private final double rot;
        private final double xVel;
        private final double yVel;
        private final double rotVel;
        @NotNull
        private final Color color;

        public StarInfo(double x, double y, double rot, double xVel, double yVel, double rotVel, @NotNull Color color2) {
            Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
            this.x = x;
            this.y = y;
            this.rot = rot;
            this.xVel = xVel;
            this.yVel = yVel;
            this.rotVel = rotVel;
            this.color = color2;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getRot() {
            return this.rot;
        }

        public final double getXVel() {
            return this.xVel;
        }

        public final double getYVel() {
            return this.yVel;
        }

        public final double getRotVel() {
            return this.rotVel;
        }

        @NotNull
        public final Color getColor() {
            return this.color;
        }
    }
}

