/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.world;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.client.platform.IWorldService;
import me.jfenn.bingo.client.platform.event.model.ScreenEvent;
import me.jfenn.bingo.client.platform.event.model.ScreenType;
import me.jfenn.bingo.client.platform.screen.IButtonFactory;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.game.ScopeStopped;
import me.jfenn.bingo.platform.text.ITextFactory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4185;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u000fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0010R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lme/jfenn/bingo/client/common/world/BingoWorldManager;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/client/platform/screen/IButtonFactory;", "buttonFactory", "Lme/jfenn/bingo/client/platform/IWorldService;", "worldService", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/platform/text/ITextFactory;", "text", "<init>", "(Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/client/platform/screen/IButtonFactory;Lme/jfenn/bingo/client/platform/IWorldService;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/platform/text/ITextFactory;)V", "Lme/jfenn/bingo/client/platform/screen/IButtonFactory;", "Lme/jfenn/bingo/client/platform/IWorldService;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/platform/text/ITextFactory;", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nBingoWorldManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoWorldManager.kt\nme/jfenn/bingo/client/common/world/BingoWorldManager\n+ 2 Scope.kt\norg/koin/core/scope/Scope\n*L\n1#1,52:1\n132#2,5:53\n132#2,5:58\n*S KotlinDebug\n*F\n+ 1 BingoWorldManager.kt\nme/jfenn/bingo/client/common/world/BingoWorldManager\n*L\n26#1:53,5\n27#1:58,5\n*E\n"})
public final class BingoWorldManager
extends BingoComponent {
    @NotNull
    private final IButtonFactory buttonFactory;
    @NotNull
    private final IWorldService worldService;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final ITextFactory text;

    public BingoWorldManager(@NotNull IEventBus eventBus, @NotNull IButtonFactory buttonFactory, @NotNull IWorldService worldService, @NotNull BingoConfig config, @NotNull ITextFactory text) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)buttonFactory, (String)"buttonFactory");
        Intrinsics.checkNotNullParameter((Object)worldService, (String)"worldService");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.buttonFactory = buttonFactory;
        this.worldService = worldService;
        this.config = config;
        this.text = text;
        eventBus.register(ScopeStopped.Companion, arg_0 -> BingoWorldManager._init_$lambda$0(this, arg_0));
        eventBus.register(ScreenEvent.AfterInit.INSTANCE, arg_0 -> BingoWorldManager._init_$lambda$2(this, arg_0));
    }

    private static final Unit _init_$lambda$0(BingoWorldManager this$0, ScopeStopped it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Scope $this$iv = it.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        BingoState state = (BingoState)$this$iv.get(Reflection.getOrCreateKotlinClass(BingoState.class), qualifier$iv, parameters$iv);
        Scope $this$iv2 = it.getScope();
        Qualifier qualifier$iv2 = null;
        Function0<? extends ParametersHolder> parameters$iv2 = null;
        boolean $i$f$get2 = false;
        MinecraftServer server = (MinecraftServer)$this$iv2.get(Reflection.getOrCreateKotlinClass(MinecraftServer.class), qualifier$iv2, parameters$iv2);
        if (state.getState() != GameState.PLAYING && this$0.worldService.isBingoWorld(server) && state.isLobbyMode()) {
            this$0.worldService.deleteSave(server);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$2$lambda$1(BingoWorldManager this$0, class_4185 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.worldService.createBingoWorld();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(BingoWorldManager this$0, ScreenEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getType() == ScreenType.TitleScreen && this$0.config.getClient().getShowQuickStartButton()) {
            it.getScreen().addButton(IButtonFactory.DefaultImpls.createButton$default(this$0.buttonFactory, 10, it.getScreen().getHeight() - 70, 80, 50, "minecraft:bingo/button", "minecraft:bingo/button_focused", null, arg_0 -> BingoWorldManager.lambda$2$lambda$1(this$0, arg_0), this$0.text.literal("BINGO!"), 64, null));
        }
        return Unit.INSTANCE;
    }
}

