/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.autorestart;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.autorestart.ResetService;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IModEnvironment;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001aR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lme/jfenn/bingo/common/autorestart/ResetOnLeaveController;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/autorestart/ResetService;", "resetService", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "serverTaskExecutor", "Lme/jfenn/bingo/platform/IModEnvironment;", "environment", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/autorestart/ResetService;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lme/jfenn/bingo/platform/IModEnvironment;Lme/jfenn/bingo/common/event/ScopedEvents;)V", "", "checkRestartOnLeave", "()V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/autorestart/ResetService;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "bingo-common"})
public final class ResetOnLeaveController {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoState state;
    @NotNull
    private final ResetService resetService;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IExecutors.IServerTaskExecutor serverTaskExecutor;

    public ResetOnLeaveController(@NotNull Logger log, @NotNull BingoConfig config, @NotNull BingoState state, @NotNull ResetService resetService, @NotNull IPlayerManager playerManager, @NotNull IExecutors.IServerTaskExecutor serverTaskExecutor, @NotNull IModEnvironment environment, @NotNull ScopedEvents events) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)resetService, (String)"resetService");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)serverTaskExecutor, (String)"serverTaskExecutor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this.log = log;
        this.config = config;
        this.state = state;
        this.resetService = resetService;
        this.playerManager = playerManager;
        this.serverTaskExecutor = serverTaskExecutor;
        if (environment.getEnvType() == IModEnvironment.EnvType.SERVER) {
            events.onPlayerDisconnect((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> ResetOnLeaveController._init_$lambda$2(this, arg_0)));
        }
    }

    private final void checkRestartOnLeave() {
        if (this.config.getNextRoundWhenEveryoneDisconnects() && this.state.isLobbyMode() && this.state.getState() == GameState.POSTGAME && this.playerManager.getPlayers().isEmpty()) {
            this.log.info("[ResetOnLeaveController] Last player has disconnected and 'nextRoundWhenEveryoneDisconnects' is true; Resetting...");
            this.serverTaskExecutor.execute(() -> ResetOnLeaveController.checkRestartOnLeave$lambda$0(this));
        }
    }

    private static final void checkRestartOnLeave$lambda$0(ResetOnLeaveController this$0) {
        this$0.resetService.resetGame();
    }

    private static final void lambda$2$lambda$1(ResetOnLeaveController this$0) {
        this$0.checkRestartOnLeave();
    }

    private static final Unit _init_$lambda$2(ResetOnLeaveController this$0, PlayerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS, this$0.serverTaskExecutor).execute(() -> ResetOnLeaveController.lambda$2$lambda$1(this$0));
        return Unit.INSTANCE;
    }
}

