/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.card.objective;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.CardGeneratorState;
import me.jfenn.bingo.common.card.data.CommonKt;
import me.jfenn.bingo.common.card.data.ObjectiveData;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.card.objective.BingoObjectiveCapture;
import me.jfenn.bingo.common.card.objective.IObjectiveManager;
import me.jfenn.bingo.common.card.objective.ObjectiveDisplay;
import me.jfenn.bingo.common.card.objective.ObjectiveDisplayService;
import me.jfenn.bingo.common.card.objective.ObjectiveService;
import me.jfenn.bingo.common.card.objective.OpponentObjectiveManager;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001eR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001f\u00a8\u0006 "}, d2={"Lme/jfenn/bingo/common/card/objective/OpponentObjectiveManager;", "Lme/jfenn/bingo/common/card/objective/IObjectiveManager;", "Lme/jfenn/bingo/common/data/ScopedData;", "data", "Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;", "objectiveDisplayService", "Lme/jfenn/bingo/common/card/objective/ObjectiveService;", "objectiveService", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "<init>", "(Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;Lme/jfenn/bingo/common/card/objective/ObjectiveService;Lme/jfenn/bingo/common/text/TextProvider;)V", "", "", "list", "()Ljava/lang/Iterable;", "id", "Lme/jfenn/bingo/common/card/CardGeneratorState;", "state", "Lme/jfenn/bingo/common/card/objective/BingoObjective;", "find", "(Ljava/lang/String;Lme/jfenn/bingo/common/card/CardGeneratorState;)Lme/jfenn/bingo/common/card/objective/BingoObjective;", "Lme/jfenn/bingo/common/card/BingoCard;", "card", "", "init", "(Lme/jfenn/bingo/common/card/BingoCard;)V", "tick", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;", "Lme/jfenn/bingo/common/card/objective/ObjectiveService;", "Lme/jfenn/bingo/common/text/TextProvider;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nOpponentObjectiveManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpponentObjectiveManager.kt\nme/jfenn/bingo/common/card/objective/OpponentObjectiveManager\n+ 2 BingoCard.kt\nme/jfenn/bingo/common/card/BingoCard\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,93:1\n34#2:94\n34#2:106\n808#3,11:95\n808#3,11:107\n1056#3:120\n1669#3,8:121\n1761#3,3:129\n216#4,2:118\n*S KotlinDebug\n*F\n+ 1 OpponentObjectiveManager.kt\nme/jfenn/bingo/common/card/objective/OpponentObjectiveManager\n*L\n38#1:94\n52#1:106\n38#1:95,11\n52#1:107,11\n70#1:120\n72#1:121,8\n82#1:129,3\n61#1:118,2\n*E\n"})
public final class OpponentObjectiveManager
implements IObjectiveManager {
    @NotNull
    private final ScopedData data;
    @NotNull
    private final ObjectiveDisplayService objectiveDisplayService;
    @NotNull
    private final ObjectiveService objectiveService;
    @NotNull
    private final TextProvider text;

    public OpponentObjectiveManager(@NotNull ScopedData data, @NotNull ObjectiveDisplayService objectiveDisplayService, @NotNull ObjectiveService objectiveService, @NotNull TextProvider text) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)objectiveDisplayService, (String)"objectiveDisplayService");
        Intrinsics.checkNotNullParameter((Object)objectiveService, (String)"objectiveService");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.data = data;
        this.objectiveDisplayService = objectiveDisplayService;
        this.objectiveService = objectiveService;
        this.text = text;
    }

    @Override
    @NotNull
    public Iterable<String> list() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(CommonKt.getRootObjectives(this.data.getObjectives()), OpponentObjectiveManager::list$lambda$0), OpponentObjectiveManager::list$lambda$1));
    }

    @Override
    @Nullable
    public BingoObjective find(@NotNull String id, @NotNull CardGeneratorState state) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ObjectiveData objectiveData = this.data.getObjectives().get(id);
        ObjectiveData.Opponent opponent = objectiveData instanceof ObjectiveData.Opponent ? (ObjectiveData.Opponent)objectiveData : null;
        if (opponent == null) {
            return null;
        }
        ObjectiveData.Opponent data = opponent;
        return new BingoObjective.OpponentEntry(id, data, data.expandReference(id, data.getObjective()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull BingoCard card) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        BingoCard this_$iv = card;
        boolean $i$f$objectivesByInstance = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getObjectives().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BingoObjective.OpponentEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.OpponentEntry objective : (List)destination$iv$iv$iv) {
            ObjectiveDisplay.Resolved resolved;
            if (card.getObjectives().get(objective.getOpponentObjective()) != null) {
                BingoObjective opponent;
                boolean bl = false;
                Object[] objectArray = new Object[1];
                IText iText = opponent.getDisplay().getName();
                if (iText == null) {
                    iText = class_2561.method_43473();
                }
                objectArray[0] = iText;
                resolved = new ObjectiveDisplay.Resolved(this.text.string(StringKey.ObjectiveOpponent, objectArray), null, opponent.getDisplay().getItem(), CardTile.Decoration.ADVANCEMENT, null, 18, null);
            } else {
                resolved = ObjectiveDisplay.Resolved.Companion.getEMPTY();
            }
            ObjectiveDisplay.Resolved display2 = resolved;
            objective.setDisplay(ObjectiveDisplayService.resolve$default(this.objectiveDisplayService, objective.getId(), objective.getData().getDisplay(), display2, null, 8, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick(@NotNull BingoCard card) {
        Iterator<Map.Entry<UUID, BingoObjectiveCapture>> $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        BingoCard this_$iv = card;
        boolean $i$f$objectivesByInstance = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getObjectives().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv = iterator.next();
            if (!(element$iv$iv$iv instanceof BingoObjective.OpponentEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.OpponentEntry objective : (List)destination$iv$iv$iv) {
            void $this$distinctBy$iv;
            Iterable $this$sortedBy$iv;
            BingoObjective opponent;
            if (card.getObjectives().get(objective.getOpponentObjective()) == null) continue;
            this.objectiveService.updateTeamsOnceAchieved(objective);
            objective.setTeamsSeen(opponent.getTeamsSeen());
            if (objective.getPermanent()) {
                Map<UUID, BingoObjectiveCapture> $this$forEach$iv = opponent.getPlayersHolding();
                boolean $i$f$forEach = false;
                $this$filterIsInstanceTo$iv$iv$iv = $this$forEach$iv.entrySet().iterator();
                while ($this$filterIsInstanceTo$iv$iv$iv.hasNext()) {
                    Map.Entry<UUID, BingoObjectiveCapture> element$iv;
                    Map.Entry<UUID, BingoObjectiveCapture> $i$f$filterIsInstanceTo2 = element$iv = $this$filterIsInstanceTo$iv$iv$iv.next();
                    boolean bl = false;
                    UUID uuid = $i$f$filterIsInstanceTo2.getKey();
                    BingoObjectiveCapture capture = $i$f$filterIsInstanceTo2.getValue();
                    objective.getOpponentsAchieved().putIfAbsent(uuid, capture);
                }
            } else {
                objective.setOpponentsAchieved(opponent.getPlayersHolding());
            }
            Iterable $i$f$forEach = objective.getOpponentsAchieved().values();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    BingoObjectiveCapture it = (BingoObjectiveCapture)a;
                    boolean bl = false;
                    Comparable comparable = it.getInstant();
                    it = (BingoObjectiveCapture)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getInstant());
                }
            });
            boolean $i$f$distinctBy = false;
            HashSet<BingoTeamKey> set$iv = new HashSet<BingoTeamKey>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                BingoObjectiveCapture it = (BingoObjectiveCapture)e$iv;
                boolean bl = false;
                BingoTeamKey key$iv = BingoTeamKey.box-impl(it.getTeam-zo6Dpdc());
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List captures = list$iv;
            boolean bl = false;
            List opponentCaptures = card.getOptions().isLockoutMode() ? CollectionsKt.take((Iterable)captures, (int)1) : captures;
            Set teams2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(this.objectiveService.getAllTeams(), arg_0 -> OpponentObjectiveManager.tick$lambda$8(opponentCaptures, arg_0)), (Function1)tick.teams.2.INSTANCE));
            ObjectiveService.update$default(this.objectiveService, objective, null, null, null, teams2, 14, null);
        }
    }

    @Override
    @NotNull
    public Iterable<String> listExcludedIds() {
        return IObjectiveManager.DefaultImpls.listExcludedIds(this);
    }

    private static final boolean list$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ObjectiveData it = (ObjectiveData)entry.getValue();
        return it instanceof ObjectiveData.Opponent;
    }

    private static final String list$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getKey();
    }

    private static final boolean tick$lambda$8(List $opponentCaptures, BingoTeam team) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)team, (String)"team");
            Iterable $this$any$iv = $opponentCaptures;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BingoObjectiveCapture it = (BingoObjectiveCapture)element$iv;
                    boolean bl2 = false;
                    if (!(!BingoTeamKey.equals-impl0(it.getTeam-zo6Dpdc(), team.getKey-zo6Dpdc()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

