/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.chat;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.chat.ChatMessageService;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.commands.ISignedMessage;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.AllowChatMessageEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u000fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0010R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lme/jfenn/bingo/common/chat/ChatMessageController;", "", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/chat/ChatMessageService;", "chatMessageService", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "<init>", "(Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/chat/ChatMessageService;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/team/TeamService;)V", "Lme/jfenn/bingo/common/chat/ChatMessageService;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/team/TeamService;", "bingo-common"})
public final class ChatMessageController {
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final TeamService teamService;

    public ChatMessageController(@NotNull IEventBus eventBus, @NotNull ChatMessageService chatMessageService, @NotNull BingoState state, @NotNull BingoConfig config, @NotNull TeamService teamService) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        this.chatMessageService = chatMessageService;
        this.state = state;
        this.config = config;
        this.teamService = teamService;
        eventBus.register(AllowChatMessageEvent.Companion, arg_0 -> ChatMessageController._init_$lambda$0(this, arg_0));
    }

    private static final Boolean _init_$lambda$0(ChatMessageController this$0, AllowChatMessageEvent allowChatMessageEvent) {
        boolean sent;
        boolean shouldTeamChat;
        Intrinsics.checkNotNullParameter((Object)allowChatMessageEvent, (String)"<destruct>");
        ISignedMessage message = allowChatMessageEvent.component1();
        IPlayerHandle player = allowChatMessageEvent.component2();
        if (this$0.chatMessageService.getBypassAllowMessageCheck()) {
            return true;
        }
        boolean bl = shouldTeamChat = this$0.teamService.isPlaying(player) ? this$0.config.getChat().getDefaultToTeamChat() : this$0.config.getChat().getDefaultToSpectatorChat();
        return this$0.state.getState().isPlayingOrCountdown() && shouldTeamChat ? !(sent = this$0.chatMessageService.sendTeamMessage(message, player)) : true;
    }
}

