/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.platform.event.ICallbackHandle;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.IReturnEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JG\u0010\u000e\u001a\u00020\r\"\b\b\u0000\u0010\u0007*\u00020\u0006\"\u0004\b\u0001\u0010\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJA\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011\"\b\b\u0000\u0010\u0007*\u00020\u0006\"\u0004\b\u0001\u0010\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R1\u0010\u0017\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b0\u00160\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lme/jfenn/bingo/common/event/EventBus;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lorg/slf4j/Logger;", "log", "<init>", "(Lorg/slf4j/Logger;)V", "", "T", "R", "Lme/jfenn/bingo/platform/event/IReturnEvent;", "type", "Ljava/util/function/Function;", "callback", "Lme/jfenn/bingo/platform/event/ICallbackHandle;", "register", "(Lme/jfenn/bingo/platform/event/IReturnEvent;Ljava/util/function/Function;)Lme/jfenn/bingo/platform/event/ICallbackHandle;", "event", "", "emit", "(Lme/jfenn/bingo/platform/event/IReturnEvent;Ljava/lang/Object;)Ljava/util/List;", "Lorg/slf4j/Logger;", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/CopyOnWriteArraySet;", "events", "Ljava/util/concurrent/ConcurrentHashMap;", "getEvents", "()Ljava/util/concurrent/ConcurrentHashMap;", "CallbackHandle", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventBus.kt\nme/jfenn/bingo/common/event/EventBus\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n72#2,2:51\n1#3:53\n1#3:54\n*S KotlinDebug\n*F\n+ 1 EventBus.kt\nme/jfenn/bingo/common/event/EventBus\n*L\n17#1:51,2\n17#1:53\n*E\n"})
public final class EventBus
implements IEventBus {
    @NotNull
    private final Logger log;
    @NotNull
    private final ConcurrentHashMap<Object, CopyOnWriteArraySet<Function<?, ?>>> events;

    public EventBus(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.events = new ConcurrentHashMap();
    }

    @NotNull
    public final ConcurrentHashMap<Object, CopyOnWriteArraySet<Function<?, ?>>> getEvents() {
        return this.events;
    }

    @Override
    @NotNull
    public <T, R> ICallbackHandle register(@NotNull IReturnEvent<T, R> type, @NotNull Function<T, R> callback) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ConcurrentMap $this$getOrPut$iv = this.events;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(type);
        if (object == null) {
            boolean bl = false;
            CopyOnWriteArraySet default$iv = new CopyOnWriteArraySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(type, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        CopyOnWriteArraySet subscribers = (CopyOnWriteArraySet)object;
        subscribers.add(callback);
        this.log.debug("[EventBus] Registered {} from {}", (Object)type.getName(), (Object)callback.getClass().getSimpleName());
        String string = type.getName();
        Intrinsics.checkNotNull((Object)subscribers);
        return new CallbackHandle(string, subscribers, callback);
    }

    @Override
    @NotNull
    public <T, R> List<R> emit(@NotNull IReturnEvent<T, R> type, @NotNull T event) {
        Iterator<Function<?, ?>> iterator;
        Iterator<Function<?, ?>> iterator2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(type, (String)"type");
                Intrinsics.checkNotNullParameter(event, (String)"event");
                CopyOnWriteArraySet<Function<?, ?>> copyOnWriteArraySet = this.events.get(type);
                if (copyOnWriteArraySet == null || (iterator2 = copyOnWriteArraySet.iterator()) == null) break block5;
                Iterator<Function<?, ?>> it = iterator2;
                boolean bl = false;
                iterator = it;
                if (iterator != null) break block6;
            }
            return CollectionsKt.emptyList();
        }
        Iterator<Function<?, ?>> subscribers = iterator;
        List responses = new ArrayList();
        iterator2 = subscribers;
        while (iterator2.hasNext()) {
            Function<?, ?> subscriber = iterator2.next();
            try {
                responses.add(subscriber.apply(event));
            }
            catch (Throwable e) {
                this.log.error("Exception in event handler (" + type.getName() + ", " + subscriber.getClass().getSimpleName() + "):", e);
            }
        }
        return responses;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u0004\u0012\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\"\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u000eR\u001c\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lme/jfenn/bingo/common/event/EventBus$CallbackHandle;", "Lme/jfenn/bingo/platform/event/ICallbackHandle;", "", "name", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Ljava/util/function/Function;", "subscribers", "callback", "<init>", "(Lme/jfenn/bingo/common/event/EventBus;Ljava/lang/String;Ljava/util/concurrent/CopyOnWriteArraySet;Ljava/util/function/Function;)V", "", "close", "()V", "Ljava/lang/String;", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Ljava/util/function/Function;", "bingo-common"})
    public final class CallbackHandle
    implements ICallbackHandle {
        @NotNull
        private final String name;
        @NotNull
        private final CopyOnWriteArraySet<Function<?, ?>> subscribers;
        @NotNull
        private final Function<?, ?> callback;

        public CallbackHandle(@NotNull String name2, @NotNull CopyOnWriteArraySet<Function<?, ?>> subscribers, Function<?, ?> callback) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.name = name2;
            this.subscribers = subscribers;
            this.callback = callback;
        }

        @Override
        public void close() {
            EventBus.this.log.debug("[EventBus] Unregistered {} from {}", (Object)this.name, (Object)this.callback.getClass().getSimpleName());
            this.subscribers.remove(this.callback);
        }
    }
}

