/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.event.model.ScoreChangedEvent;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.event.model.TeamChangedEvent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.TeamScore;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.player.PlayerProfile;
import me.jfenn.bingo.platform.scoreboard.IObjectiveHandle;
import me.jfenn.bingo.platform.scoreboard.IScoreboardManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u001d\u0010\u001b\u001a\u00020\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010!R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\"\u00a8\u0006#"}, d2={"Lme/jfenn/bingo/common/scoreboard/ScoreboardDataController;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;", "scoreboardManager", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "serverTaskExecutor", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/platform/event/IEventBus;)V", "Lme/jfenn/bingo/platform/scoreboard/IObjectiveHandle;", "createItemsObjective", "()Lme/jfenn/bingo/platform/scoreboard/IObjectiveHandle;", "createLinesObjective", "createCardsObjective", "", "Lme/jfenn/bingo/platform/IPlayerHandle;", "players", "", "updatePlayers", "(Ljava/util/List;)V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "Lme/jfenn/bingo/common/text/TextProvider;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nScoreboardDataController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreboardDataController.kt\nme/jfenn/bingo/common/scoreboard/ScoreboardDataController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1617#2,9:88\n1869#2:97\n1870#2:99\n1626#2:100\n1#3:98\n1#3:101\n*S KotlinDebug\n*F\n+ 1 ScoreboardDataController.kt\nme/jfenn/bingo/common/scoreboard/ScoreboardDataController\n*L\n72#1:88,9\n72#1:97\n72#1:99\n72#1:100\n72#1:98\n*E\n"})
public final class ScoreboardDataController {
    @NotNull
    private final BingoState state;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final IScoreboardManager scoreboardManager;
    @NotNull
    private final IExecutors.IServerTaskExecutor serverTaskExecutor;
    @NotNull
    private final TextProvider text;

    public ScoreboardDataController(@NotNull BingoState state, @NotNull IPlayerManager playerManager, @NotNull TeamService teamService, @NotNull IScoreboardManager scoreboardManager, @NotNull IExecutors.IServerTaskExecutor serverTaskExecutor, @NotNull TextProvider text, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)scoreboardManager, (String)"scoreboardManager");
        Intrinsics.checkNotNullParameter((Object)serverTaskExecutor, (String)"serverTaskExecutor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.state = state;
        this.playerManager = playerManager;
        this.teamService = teamService;
        this.scoreboardManager = scoreboardManager;
        this.serverTaskExecutor = serverTaskExecutor;
        this.text = text;
        if (this.state.isLobbyMode()) {
            eventBus.register(StateChangedEvent.Companion, arg_0 -> ScoreboardDataController._init_$lambda$3(this, arg_0));
            eventBus.register(ScoreChangedEvent.Companion, arg_0 -> ScoreboardDataController._init_$lambda$6(this, arg_0));
            eventBus.register(PlayerEvent.Join.INSTANCE, arg_0 -> ScoreboardDataController._init_$lambda$8(this, arg_0));
            eventBus.register(TeamChangedEvent.Companion, arg_0 -> ScoreboardDataController._init_$lambda$9(this, arg_0));
        }
    }

    private final IObjectiveHandle createItemsObjective() {
        IObjectiveHandle iObjectiveHandle;
        IObjectiveHandle $this$createItemsObjective_u24lambda_u240 = iObjectiveHandle = this.scoreboardManager.createDummyObjective("bingo_items");
        boolean bl = false;
        $this$createItemsObjective_u24lambda_u240.setDisplayName(this.text.string(StringKey.GoalItems));
        return iObjectiveHandle;
    }

    private final IObjectiveHandle createLinesObjective() {
        IObjectiveHandle iObjectiveHandle;
        IObjectiveHandle $this$createLinesObjective_u24lambda_u241 = iObjectiveHandle = this.scoreboardManager.createDummyObjective("bingo_lines");
        boolean bl = false;
        $this$createLinesObjective_u24lambda_u241.setDisplayName(this.text.string(StringKey.GoalLines));
        return iObjectiveHandle;
    }

    private final IObjectiveHandle createCardsObjective() {
        IObjectiveHandle iObjectiveHandle;
        IObjectiveHandle $this$createCardsObjective_u24lambda_u242 = iObjectiveHandle = this.scoreboardManager.createDummyObjective("bingo_cards");
        boolean bl = false;
        $this$createCardsObjective_u24lambda_u242.setDisplayName(this.text.string(StringKey.GoalCards));
        return iObjectiveHandle;
    }

    private final void updatePlayers(List<? extends IPlayerHandle> players) {
        IObjectiveHandle items = this.createItemsObjective();
        IObjectiveHandle lines2 = this.createLinesObjective();
        IObjectiveHandle cards = this.createCardsObjective();
        Iterator<? extends IPlayerHandle> iterator = players.iterator();
        while (iterator.hasNext()) {
            IPlayerHandle player;
            BingoTeam team = this.teamService.getPlayerTeam(player = iterator.next());
            Object object = team;
            items.setPlayer(player, object != null && (object = ((BingoTeam)object).getScore()) != null ? ((TeamScore)object).getItems() : 0);
            Object object2 = team;
            lines2.setPlayer(player, object2 != null && (object2 = ((BingoTeam)object2).getScore()) != null ? ((TeamScore)object2).getLines() : 0);
            Object object3 = team;
            cards.setPlayer(player, object3 != null && (object3 = ((BingoTeam)object3).getScore()) != null ? ((TeamScore)object3).getCards() : 0);
        }
    }

    private static final Unit _init_$lambda$3(ScoreboardDataController this$0, StateChangedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.createItemsObjective();
        this$0.createLinesObjective();
        this$0.createCardsObjective();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$6(ScoreboardDataController this$0, ScoreChangedEvent event) {
        block1: {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Set<PlayerProfile> set;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            BingoTeam bingoTeam = this$0.state.getTeams().get(BingoTeamKey.box-impl(event.getTeam-zo6Dpdc()));
            if (bingoTeam == null || (set = bingoTeam.getPlayers()) == null) break block1;
            Iterable iterable = set;
            boolean $i$f$mapNotNull = false;
            void var6_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IPlayerHandle it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PlayerProfile it = (PlayerProfile)element$iv$iv;
                boolean bl2 = false;
                if (this$0.playerManager.getPlayer(it.getUuid()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            this$0.updatePlayers(it);
        }
        return Unit.INSTANCE;
    }

    private static final void lambda$8$lambda$7(ScoreboardDataController this$0, PlayerEvent $it) {
        this$0.updatePlayers(CollectionsKt.listOf((Object)$it.getPlayer()));
    }

    private static final Unit _init_$lambda$8(ScoreboardDataController this$0, PlayerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.serverTaskExecutor.execute(() -> ScoreboardDataController.lambda$8$lambda$7(this$0, it));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(ScoreboardDataController this$0, TeamChangedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updatePlayers(CollectionsKt.listOf((Object)it.getPlayer()));
        return Unit.INSTANCE;
    }
}

