/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.stats;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.platform.IModEnvironment;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.ApplicationCloseEvent;
import me.jfenn.bingo.sql.BingoDatabase;
import me.jfenn.bingo.sqldelight.db.AfterVersion;
import me.jfenn.bingo.sqldelight.driver.jdbc.JdbcDriver;
import me.jfenn.bingo.sqldelight.driver.jdbc.JdbcDrivers;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lme/jfenn/bingo/common/stats/ConnectionFactory;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/platform/IModEnvironment;", "environment", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/platform/IModEnvironment;Lme/jfenn/bingo/platform/event/IEventBus;)V", "", "doMigrations", "()V", "Lme/jfenn/bingo/sql/BingoDatabase;", "create", "()Lme/jfenn/bingo/sql/BingoDatabase;", "close", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/config/BingoConfig;", "", "defaultUrl", "Ljava/lang/String;", "url", "Lcom/zaxxer/hikari/HikariDataSource;", "dataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nConnectionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionFactory.kt\nme/jfenn/bingo/common/stats/ConnectionFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\nme/jfenn/bingo/common/utils/LoggerKt\n*L\n1#1,103:1\n1#2:104\n10#3,8:105\n*S KotlinDebug\n*F\n+ 1 ConnectionFactory.kt\nme/jfenn/bingo/common/stats/ConnectionFactory\n*L\n83#1:105,8\n*E\n"})
public final class ConnectionFactory {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final String defaultUrl;
    @NotNull
    private final String url;
    @NotNull
    private final HikariDataSource dataSource;

    /*
     * WARNING - void declaration
     */
    public ConnectionFactory(@NotNull Logger log, @NotNull BingoConfig config, @NotNull IModEnvironment environment, @NotNull IEventBus eventBus) {
        void $this$dataSource_u24lambda_u241;
        HikariDataSource hikariDataSource;
        HikariDataSource configDir;
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.log = log;
        this.config = config;
        String string = ((Object)environment.getConfigDir().toAbsolutePath()).toString();
        ConnectionFactory connectionFactory = this;
        boolean bl = false;
        connectionFactory.defaultUrl = "jdbc:sqlite:" + (String)configDir + "/yet-another-minecraft-bingo/bingo.db";
        String string2 = this.config.getDatabaseUrl();
        if (string2 == null) {
            string2 = this.defaultUrl;
        }
        this.url = string2;
        configDir = hikariDataSource = new HikariDataSource();
        connectionFactory = this;
        boolean bl2 = false;
        $this$dataSource_u24lambda_u241.setJdbcUrl(this.url);
        String string3 = this.config.getDatabaseUser();
        if (string3 == null) {
            string3 = "";
        }
        $this$dataSource_u24lambda_u241.setUsername(string3);
        String string4 = this.config.getDatabasePass();
        if (string4 == null) {
            string4 = "";
        }
        $this$dataSource_u24lambda_u241.setPassword(string4);
        connectionFactory.dataSource = hikariDataSource;
        eventBus.register(ApplicationCloseEvent.INSTANCE, arg_0 -> ConnectionFactory._init_$lambda$7(this, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doMigrations() {
        long l;
        JdbcDriver driver = JdbcDrivers.fromDataSource((DataSource)this.dataSource);
        Connection connection = this.dataSource.getConnection();
        try {
            long it22;
            AutoCloseable autoCloseable = connection.createStatement();
            Throwable throwable = null;
            try {
                Statement it22 = (Statement)autoCloseable;
                boolean bl = false;
                it22 = it22.executeQuery("PRAGMA user_version").getLong("user_version");
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            l = it22;
        }
        catch (Throwable e) {
            this.log.error("Error determining user_version", e);
            l = 0L;
        }
        long oldVersion = l;
        if (oldVersion == 0L) {
            long l2;
            try {
                long it32;
                AutoCloseable autoCloseable = connection.createStatement();
                Throwable bl = null;
                try {
                    Statement it32 = (Statement)autoCloseable;
                    boolean bl2 = false;
                    it32 = it32.executeQuery("SELECT max(version) AS flyway_version FROM flyway_schema_history").getLong("flyway_version");
                }
                catch (Throwable bl2) {
                    bl = bl2;
                    throw bl2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)bl);
                }
                long it = it32;
                boolean bl3 = false;
                l2 = it > 0L ? it + 1L : it;
            }
            catch (Throwable e) {
                l2 = 0L;
            }
            long flywayVersion = l2;
            oldVersion = Math.max(oldVersion, flywayVersion);
        }
        long newVersion = BingoDatabase.Companion.getSchema().getVersion();
        this.log.info("[ConnectionFactory] Migrating database from version " + oldVersion + " to " + newVersion + "...");
        Object object = oldVersion <= 0L ? BingoDatabase.Companion.getSchema().create(driver).unbox-impl() : BingoDatabase.Companion.getSchema().migrate(driver, oldVersion, newVersion, new AfterVersion[0]).unbox-impl();
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            boolean bl4 = it.execute("PRAGMA user_version = " + newVersion);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final BingoDatabase create() {
        void $this$measureTime$iv;
        Logger logger = this.log;
        String message$iv = "Running database migrations...";
        boolean $i$f$measureTime = false;
        long start$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        $this$measureTime$iv.info(message$iv);
        try {
            boolean bl = false;
            try {
                this.doMigrations();
            }
            catch (Throwable e) {
                this.log.error("[ConnectionFactory] Unable to run migrations - things might be broken!", e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measureTime$iv.info(message$iv + " - done in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)start$iv)) + "!");
        }
        return BingoDatabase.Companion.invoke(JdbcDrivers.fromDataSource((DataSource)this.dataSource));
    }

    public final void close() {
        this.log.info("[ConnectionFactory] Closing stats data source...");
        this.dataSource.close();
    }

    private static final Unit _init_$lambda$7(ConnectionFactory this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.close();
        return Unit.INSTANCE;
    }
}

