/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.timer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.spawn.SpawnService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.timer.CountdownPacket;
import me.jfenn.bingo.common.timer.CountdownService;
import me.jfenn.bingo.common.utils.Vector3dKt;
import me.jfenn.bingo.platform.EffectType;
import me.jfenn.bingo.platform.EntityType;
import me.jfenn.bingo.platform.IBatEntity;
import me.jfenn.bingo.platform.IEntityManager;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.IServerWorld;
import me.jfenn.bingo.platform.ITickManager;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.ActionResult;
import me.jfenn.bingo.platform.event.model.AttackEntityEvent;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.event.model.UseBlockEvent;
import me.jfenn.bingo.platform.event.model.UseEntityEvent;
import me.jfenn.bingo.platform.event.model.UseItemEvent;
import me.jfenn.bingo.platform.player.PlayerProfile;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b \u0010\u001eJ\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010$R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010%R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010&R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010'R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010(R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010)R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010*R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010+R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010,R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010-R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010.R\u0018\u00100\u001a\u0004\u0018\u00010/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R \u00105\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u000204028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u000208078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006<"}, d2={"Lme/jfenn/bingo/common/timer/CountdownController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/timer/CountdownService;", "countdownService", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/platform/ITickManager;", "tickManager", "Lme/jfenn/bingo/common/spawn/SpawnService;", "spawnService", "Lme/jfenn/bingo/platform/IEntityManager;", "entityManager", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "serverTaskExecutor", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/timer/CountdownService;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/platform/ITickManager;Lme/jfenn/bingo/common/spawn/SpawnService;Lme/jfenn/bingo/platform/IEntityManager;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;)V", "", "forcePlayersInvisible", "()V", "forcePlayersOnBats", "scheduleCountdown", "", "shouldPreventActions", "()Z", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lme/jfenn/bingo/common/timer/CountdownService;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/platform/ITickManager;", "Lme/jfenn/bingo/common/spawn/SpawnService;", "Lme/jfenn/bingo/platform/IEntityManager;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "", "countdownDelayTicks", "Ljava/lang/Integer;", "", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "Lme/jfenn/bingo/platform/IBatEntity;", "entityMap", "Ljava/util/Map;", "", "Lme/jfenn/bingo/platform/IPlayerHandle;", "getPlayingPlayerList", "()Ljava/util/List;", "playingPlayerList", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nCountdownController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountdownController.kt\nme/jfenn/bingo/common/timer/CountdownController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n774#2:179\n865#2,2:180\n1869#2:182\n1617#2,9:190\n1869#2:199\n1870#2:201\n1626#2:202\n1870#2:203\n382#3,7:183\n1#4:200\n*S KotlinDebug\n*F\n+ 1 CountdownController.kt\nme/jfenn/bingo/common/timer/CountdownController\n*L\n40#1:179\n40#1:180,2\n57#1:182\n86#1:190,9\n86#1:199\n86#1:201\n86#1:202\n57#1:203\n58#1:183,7\n86#1:200\n*E\n"})
public final class CountdownController
extends BingoComponent {
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoState state;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final CountdownService countdownService;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final ITickManager tickManager;
    @NotNull
    private final SpawnService spawnService;
    @NotNull
    private final IEntityManager entityManager;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IExecutors.IServerTaskExecutor serverTaskExecutor;
    @Nullable
    private Integer countdownDelayTicks;
    @NotNull
    private final Map<BingoTeamKey, IBatEntity> entityMap;

    public CountdownController(@NotNull ScopedEvents events, @NotNull MinecraftServer server, @NotNull BingoConfig config, @NotNull BingoState state, @NotNull IEventBus eventBus, @NotNull CountdownService countdownService, @NotNull TeamService teamService, @NotNull ITickManager tickManager, @NotNull SpawnService spawnService, @NotNull IEntityManager entityManager, @NotNull IPlayerManager playerManager, @NotNull IExecutors.IServerTaskExecutor serverTaskExecutor) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)countdownService, (String)"countdownService");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)tickManager, (String)"tickManager");
        Intrinsics.checkNotNullParameter((Object)spawnService, (String)"spawnService");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)serverTaskExecutor, (String)"serverTaskExecutor");
        this.server = server;
        this.config = config;
        this.state = state;
        this.eventBus = eventBus;
        this.countdownService = countdownService;
        this.teamService = teamService;
        this.tickManager = tickManager;
        this.spawnService = spawnService;
        this.entityManager = entityManager;
        this.playerManager = playerManager;
        this.serverTaskExecutor = serverTaskExecutor;
        this.entityMap = new LinkedHashMap();
        ScopedEvents.onEnter$default(events, GameState.COUNTDOWN, false, arg_0 -> CountdownController._init_$lambda$6(this, arg_0), 2, null);
        events.onStateChange((Function1<? super StateChangedEvent, Unit>)((Function1)arg_0 -> CountdownController._init_$lambda$7(this, arg_0)));
        this.eventBus.register(TickEvent.Start.INSTANCE, arg_0 -> CountdownController._init_$lambda$9(this, arg_0));
        if (this.state.isLobbyMode()) {
            this.eventBus.register(UseBlockEvent.Companion, arg_0 -> CountdownController._init_$lambda$10(this, arg_0));
            this.eventBus.register(UseEntityEvent.Companion, arg_0 -> CountdownController._init_$lambda$11(this, arg_0));
            this.eventBus.register(UseItemEvent.Companion, arg_0 -> CountdownController._init_$lambda$12(this, arg_0));
            this.eventBus.register(AttackEntityEvent.Companion, arg_0 -> CountdownController._init_$lambda$13(this, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IPlayerHandle> getPlayingPlayerList() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.playerManager.getPlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it = (IPlayerHandle)element$iv$iv;
            boolean bl = false;
            if (!this.teamService.isPlaying(it.getPlayer())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void forcePlayersInvisible() {
        for (IPlayerHandle player : this.getPlayingPlayerList()) {
            player.addEffect(EffectType.INVISIBILITY, -1, 0, false, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void forcePlayersOnBats() {
        Iterable $this$forEach$iv = this.state.getRegisteredTeams();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapNotNullTo$iv$iv;
            Object object;
            void $this$getOrPut$iv;
            BingoTeam team = (BingoTeam)element$iv;
            boolean bl = false;
            Map<BingoTeamKey, IBatEntity> map = this.entityMap;
            BingoTeamKey key$iv = BingoTeamKey.box-impl(team.getKey-zo6Dpdc());
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                BlockPosition spawnPoint;
                IBatEntity marker;
                IBatEntity iBatEntity;
                boolean bl2 = false;
                IServerWorld world = this.spawnService.getSpawnDimension();
                IBatEntity $this$forcePlayersOnBats_u24lambda_u244_u24lambda_u242_u24lambda_u241 = iBatEntity = (marker = this.entityManager.createEntity(EntityType.Companion.getBAT(), world.getWorld()));
                boolean bl3 = false;
                $this$forcePlayersOnBats_u24lambda_u244_u24lambda_u242_u24lambda_u241.setInvulnerable(true);
                $this$forcePlayersOnBats_u24lambda_u244_u24lambda_u242_u24lambda_u241.setNoGravity(true);
                $this$forcePlayersOnBats_u24lambda_u244_u24lambda_u242_u24lambda_u241.setSilent(true);
                $this$forcePlayersOnBats_u24lambda_u244_u24lambda_u242_u24lambda_u241.setNoAI(true);
                $this$forcePlayersOnBats_u24lambda_u244_u24lambda_u242_u24lambda_u241.setPersistenceRequired(true);
                if (team.getSpawnpoint() == null) continue;
                marker.setPos(Vector3dKt.plus(spawnPoint.toVector3d(), new Vector3d(0.5, -0.4, 0.5)));
                this.entityManager.spawnEntity(world.getWorld(), marker);
                marker.addEffect(EffectType.INVISIBILITY, -1, 0, false, false);
                IBatEntity answer$iv = marker;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            IBatEntity entity = (IBatEntity)object;
            Iterable $this$mapNotNull$iv = team.getPlayers();
            boolean $i$f$mapNotNull = false;
            value$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IPlayerHandle it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                PlayerProfile it = (PlayerProfile)element$iv$iv;
                boolean bl5 = false;
                if (this.playerManager.getPlayer(it.getUuid()) == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (IPlayerHandle player : (List)destination$iv$iv) {
                player.startRiding(entity, true);
            }
        }
    }

    private final void scheduleCountdown() {
        int seconds = 0;
        int n = this.config.getCountdownSeconds();
        if (seconds <= n) {
            while (true) {
                int remainingSeconds = this.config.getCountdownSeconds() - seconds;
                CompletableFuture.delayedExecutor(seconds, TimeUnit.SECONDS, this.serverTaskExecutor).execute(() -> CountdownController.scheduleCountdown$lambda$5(this, remainingSeconds));
                if (seconds == n) break;
                ++seconds;
            }
        }
    }

    public final boolean shouldPreventActions() {
        return this.state.getState() == GameState.LOADING || this.state.getState() == GameState.COUNTDOWN;
    }

    private static final void scheduleCountdown$lambda$5(CountdownController this$0, int $remainingSeconds) {
        if (this$0.state.getState() != GameState.COUNTDOWN) {
            return;
        }
        this$0.countdownService.sendCountdownPacket(new CountdownPacket($remainingSeconds));
        if ($remainingSeconds == 0) {
            this$0.state.changeState(this$0.eventBus, GameState.PLAYING);
        }
    }

    private static final Unit _init_$lambda$6(CountdownController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.countdownDelayTicks = this$0.config.getCountdownDelayTicks();
        if (this$0.state.isLobbyMode()) {
            this$0.forcePlayersInvisible();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(CountdownController this$0, StateChangedEvent stateChangedEvent) {
        boolean isLockedState;
        Intrinsics.checkNotNullParameter((Object)stateChangedEvent, (String)"<destruct>");
        GameState toState = stateChangedEvent.component2();
        boolean bl = isLockedState = toState == GameState.LOADING || toState == GameState.COUNTDOWN || toState == GameState.POSTGAME;
        if (this$0.state.isLobbyMode()) {
            this$0.tickManager.setFrozen(isLockedState);
        }
        if (!isLockedState) {
            Iterator<Map.Entry<BingoTeamKey, IBatEntity>> iterator = this$0.entityMap.entrySet().iterator();
            while (iterator.hasNext()) {
                IBatEntity entity = iterator.next().getValue();
                entity.discard();
            }
            this$0.entityMap.clear();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(CountdownController this$0, TickEvent it) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (this$0.state.isLobbyMode() && this$0.shouldPreventActions()) {
                this$0.forcePlayersOnBats();
            }
            Integer n = this$0.countdownDelayTicks;
            if (n == null) break block3;
            int delay = n - 1;
            boolean bl = false;
            if (delay < 0) {
                this$0.scheduleCountdown();
                this$0.countdownDelayTicks = null;
            } else {
                this$0.countdownDelayTicks = delay;
            }
        }
        return Unit.INSTANCE;
    }

    private static final ActionResult _init_$lambda$10(CountdownController this$0, UseBlockEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.shouldPreventActions() ? new ActionResult.Fail<Unit>(Unit.INSTANCE) : null;
    }

    private static final ActionResult _init_$lambda$11(CountdownController this$0, UseEntityEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.shouldPreventActions() ? new ActionResult.Fail<Unit>(Unit.INSTANCE) : null;
    }

    private static final ActionResult _init_$lambda$12(CountdownController this$0, UseItemEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.shouldPreventActions() ? new ActionResult.Fail<Object>(null) : null;
    }

    private static final ActionResult _init_$lambda$13(CountdownController this$0, AttackEntityEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.shouldPreventActions() ? new ActionResult.Fail<Unit>(Unit.INSTANCE) : null;
    }
}

