/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.datapack;

import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.datapack.LobbyWorldService;
import me.jfenn.bingo.common.datapack.ServerProps;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.platform.IModEnvironment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/jfenn/bingo/common/datapack/ServerDatapackManager;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/platform/IModEnvironment;", "environment", "Lme/jfenn/bingo/common/datapack/ServerProps;", "serverProps", "Lme/jfenn/bingo/common/datapack/LobbyWorldService;", "lobbyWorldService", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/platform/IModEnvironment;Lme/jfenn/bingo/common/datapack/ServerProps;Lme/jfenn/bingo/common/datapack/LobbyWorldService;)V", "bingo-common"})
public final class ServerDatapackManager
extends BingoComponent {
    public ServerDatapackManager(@NotNull Logger log, @NotNull BingoConfig config, @NotNull IModEnvironment environment, @NotNull ServerProps serverProps, @NotNull LobbyWorldService lobbyWorldService) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)serverProps, (String)"serverProps");
        Intrinsics.checkNotNullParameter((Object)lobbyWorldService, (String)"lobbyWorldService");
        if (environment.getEnvType() == IModEnvironment.EnvType.SERVER) {
            Path datapackPath = environment.getGameDir().resolve(serverProps.getLevelName() + "/datapacks/bingo.zip");
            if (config.getServer().isLobbyMode()) {
                log.info("[ServerDatapackManager] isLobbyMode=true - Installing the bingo datapack in " + datapackPath);
                Intrinsics.checkNotNull((Object)datapackPath);
                lobbyWorldService.copyDataPack(datapackPath);
            } else {
                log.info("[ServerDatapackManager] isLobbyMode=false - Verifying that " + datapackPath + " does not exist...");
                Intrinsics.checkNotNull((Object)datapackPath);
                if (Files.deleteIfExists(datapackPath)) {
                    log.warn("[ServerDatapackManager] Deleted " + datapackPath);
                }
            }
        }
    }
}

