/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.sound;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.client.common.packet.ClientPacketEvents;
import me.jfenn.bingo.client.common.sound.ClientSounds;
import me.jfenn.bingo.client.common.sound.SoundService;
import me.jfenn.bingo.client.platform.ClientPacket;
import me.jfenn.bingo.common.game.GameOverPacket;
import me.jfenn.bingo.common.scoring.CardCompletedPacket;
import me.jfenn.bingo.common.scoring.ScoredItemPacket;
import me.jfenn.bingo.common.timer.CountdownPacket;
import me.jfenn.bingo.common.timer.TimerPacket;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.IReturnEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lme/jfenn/bingo/client/common/sound/ScorePacketReceiver;", "", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;", "clientPacketEvents", "Lme/jfenn/bingo/client/common/sound/SoundService;", "soundService", "<init>", "(Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;Lme/jfenn/bingo/client/common/sound/SoundService;)V", "Lme/jfenn/bingo/client/platform/ClientPacket;", "Lme/jfenn/bingo/common/game/GameOverPacket;", "clientPacket", "", "onGameOver", "(Lme/jfenn/bingo/client/platform/ClientPacket;)V", "Lme/jfenn/bingo/client/common/sound/SoundService;", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
public final class ScorePacketReceiver {
    @NotNull
    private final SoundService soundService;

    public ScorePacketReceiver(@NotNull IEventBus eventBus, @NotNull ClientPacketEvents clientPacketEvents, @NotNull SoundService soundService) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)clientPacketEvents, (String)"clientPacketEvents");
        Intrinsics.checkNotNullParameter((Object)soundService, (String)"soundService");
        this.soundService = soundService;
        eventBus.register((IReturnEvent)clientPacketEvents.getScoredItemV1(), arg_0 -> ScorePacketReceiver._init_$lambda$0(this, arg_0));
        eventBus.register((IReturnEvent)clientPacketEvents.getScoredItemLostV1(), arg_0 -> ScorePacketReceiver._init_$lambda$1(this, arg_0));
        eventBus.register((IReturnEvent)clientPacketEvents.getCardCompletedV1(), arg_0 -> ScorePacketReceiver._init_$lambda$2(this, arg_0));
        eventBus.register((IReturnEvent)clientPacketEvents.getGameOverV1(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        eventBus.register((IReturnEvent)clientPacketEvents.getGameOverV2(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        eventBus.register((IReturnEvent)clientPacketEvents.getGameOverV3(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        eventBus.register((IReturnEvent)clientPacketEvents.getGameOverV4(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        eventBus.register((IReturnEvent)clientPacketEvents.getGameOverV5(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        eventBus.register((IReturnEvent)clientPacketEvents.getGameOverV6(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        eventBus.register((IReturnEvent)clientPacketEvents.getGameOverV7(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        eventBus.register((IReturnEvent)clientPacketEvents.getGameOverV8(), p0$clientPacket -> {
            this.onGameOver((ClientPacket<GameOverPacket>)p0$clientPacket);
            return Unit.INSTANCE;
        });
        eventBus.register((IReturnEvent)clientPacketEvents.getTimerV1(), arg_0 -> ScorePacketReceiver._init_$lambda$10(this, arg_0));
        eventBus.register((IReturnEvent)clientPacketEvents.getCountdownV1(), arg_0 -> ScorePacketReceiver._init_$lambda$11(this, arg_0));
    }

    private final void onGameOver(ClientPacket<GameOverPacket> clientPacket) {
        GameOverPacket packet = clientPacket.component1();
        if (!packet.isUpdate()) {
            if (packet.isWinner()) {
                SoundService.play$default(this.soundService, ClientSounds.Key.GAME_WON, 0.0f, 0.0f, 0.0f, 14, null);
            } else {
                SoundService.play$default(this.soundService, ClientSounds.Key.GAME_LOST, 0.0f, 0.0f, 0.0f, 14, null);
            }
        }
    }

    private static final Unit _init_$lambda$0(ScorePacketReceiver this$0, ClientPacket clientPacket) {
        Intrinsics.checkNotNullParameter((Object)clientPacket, (String)"<destruct>");
        ScoredItemPacket packet = (ScoredItemPacket)clientPacket.component1();
        int score = packet.getScore().getItems();
        SoundService.play$default(this$0.soundService, packet.isViewerOnTeam() ? ClientSounds.Key.ITEM_SCORED : ClientSounds.Key.OPPONENT_SCORED, 0.0f, 0.5f + (float)score / 25.0f, 0.0f, 10, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ScorePacketReceiver this$0, ClientPacket clientPacket) {
        Intrinsics.checkNotNullParameter((Object)clientPacket, (String)"<unused var>");
        SoundService.play$default(this$0.soundService, ClientSounds.Key.ITEM_LOST, 0.8f, 1.5f, 0.0f, 8, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ScorePacketReceiver this$0, ClientPacket clientPacket) {
        Intrinsics.checkNotNullParameter((Object)clientPacket, (String)"<destruct>");
        CardCompletedPacket packet = (CardCompletedPacket)clientPacket.component1();
        SoundService.play$default(this$0.soundService, packet.isWinner() ? ClientSounds.Key.GAME_WON : ClientSounds.Key.GAME_LOST, 0.0f, 0.0f, 0.0f, 14, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$10(ScorePacketReceiver this$0, ClientPacket clientPacket) {
        Intrinsics.checkNotNullParameter((Object)clientPacket, (String)"<destruct>");
        TimerPacket packet = (TimerPacket)clientPacket.component1();
        int n = packet.getSecondsRemaining();
        boolean bl = 1 <= n ? n < 21 : false;
        if (bl && packet.getSecondsRemaining() % 2 != 0) {
            float volume = 1.0f - (float)packet.getSecondsRemaining() / 20.0f;
            SoundService.play$default(this$0.soundService, ClientSounds.Key.TIMER_TICK, volume * 0.8f, volume * 0.5f + 0.5f, 0.0f, 8, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$11(ScorePacketReceiver this$0, ClientPacket clientPacket) {
        Intrinsics.checkNotNullParameter((Object)clientPacket, (String)"<destruct>");
        CountdownPacket packet = (CountdownPacket)clientPacket.component1();
        int n = packet.getSecondsRemaining();
        boolean bl = 1 <= n ? n < 4 : false;
        if (bl) {
            SoundService.play$default(this$0.soundService, ClientSounds.Key.START_COUNTDOWN, 0.0f, 0.0f, 0.0f, 14, null);
        } else if (n == 0) {
            SoundService.play$default(this$0.soundService, ClientSounds.Key.START_RELEASE, 0.0f, 0.0f, 0.0f, 14, null);
        }
        return Unit.INSTANCE;
    }
}

