/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.card.objective;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.CardGeneratorState;
import me.jfenn.bingo.common.card.data.CommonKt;
import me.jfenn.bingo.common.card.data.ObjectiveData;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.card.objective.BingoObjectiveCapture;
import me.jfenn.bingo.common.card.objective.IObjectiveManager;
import me.jfenn.bingo.common.card.objective.LoggingKt;
import me.jfenn.bingo.common.card.objective.ObjectiveDisplay;
import me.jfenn.bingo.common.card.objective.ObjectiveDisplayService;
import me.jfenn.bingo.common.card.objective.ObjectiveService;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.StringKt;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.player.PlayerProfile;
import me.jfenn.bingo.platform.scoreboard.IObjectiveHandle;
import me.jfenn.bingo.platform.scoreboard.IScoreboardManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001d\u001a\u00020!2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b\u001d\u0010\"J'\u0010)\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020#2\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020!2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b+\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010,R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010-R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010.R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010/R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00100R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00101R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u00102\u00a8\u00063"}, d2={"Lme/jfenn/bingo/common/card/objective/ScoreboardObjectiveManager;", "Lme/jfenn/bingo/common/card/objective/IObjectiveManager;", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;", "scoreboardManager", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/data/ScopedData;", "data", "Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;", "objectiveDisplayService", "Lme/jfenn/bingo/common/card/objective/ObjectiveService;", "objectiveService", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;Lme/jfenn/bingo/common/card/objective/ObjectiveService;Lme/jfenn/bingo/common/text/TextProvider;)V", "", "", "list", "()Ljava/lang/Iterable;", "id", "Lme/jfenn/bingo/common/card/CardGeneratorState;", "Lme/jfenn/bingo/common/card/objective/BingoObjective;", "find", "(Ljava/lang/String;Lme/jfenn/bingo/common/card/CardGeneratorState;)Lme/jfenn/bingo/common/card/objective/BingoObjective;", "objective", "", "init", "(Lme/jfenn/bingo/common/card/objective/BingoObjective;)Z", "Lme/jfenn/bingo/common/card/BingoCard;", "card", "", "(Lme/jfenn/bingo/common/card/BingoCard;)V", "Lme/jfenn/bingo/common/card/objective/BingoObjective$ScoreboardEntry;", "Lme/jfenn/bingo/platform/scoreboard/IObjectiveHandle;", "scoreboard", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "getScoreboardValue", "(Lme/jfenn/bingo/common/card/objective/BingoObjective$ScoreboardEntry;Lme/jfenn/bingo/platform/scoreboard/IObjectiveHandle;Lme/jfenn/bingo/platform/IPlayerHandle;)I", "tick", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;", "Lme/jfenn/bingo/common/card/objective/ObjectiveService;", "Lme/jfenn/bingo/common/text/TextProvider;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nScoreboardObjectiveManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreboardObjectiveManager.kt\nme/jfenn/bingo/common/card/objective/ScoreboardObjectiveManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BingoCard.kt\nme/jfenn/bingo/common/card/BingoCard\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,159:1\n1#2:160\n34#3:161\n34#3:180\n808#4,11:162\n808#4,11:181\n1252#4,4:194\n1563#4:207\n1634#4,3:208\n382#5,7:173\n478#5:192\n424#5:193\n126#6:198\n153#6,3:199\n666#7:202\n747#7,4:203\n*S KotlinDebug\n*F\n+ 1 ScoreboardObjectiveManager.kt\nme/jfenn/bingo/common/card/objective/ScoreboardObjectiveManager\n*L\n79#1:161\n99#1:180\n79#1:162,11\n99#1:181,11\n105#1:194,4\n122#1:207\n122#1:208,3\n87#1:173,7\n105#1:192\n105#1:193\n107#1:198\n107#1:199,3\n124#1:202\n124#1:203,4\n*E\n"})
public final class ScoreboardObjectiveManager
implements IObjectiveManager {
    @NotNull
    private final Logger log;
    @NotNull
    private final IScoreboardManager scoreboardManager;
    @NotNull
    private final BingoState state;
    @NotNull
    private final ScopedData data;
    @NotNull
    private final ObjectiveDisplayService objectiveDisplayService;
    @NotNull
    private final ObjectiveService objectiveService;
    @NotNull
    private final TextProvider text;

    public ScoreboardObjectiveManager(@NotNull Logger log, @NotNull IScoreboardManager scoreboardManager, @NotNull BingoState state, @NotNull ScopedData data, @NotNull ObjectiveDisplayService objectiveDisplayService, @NotNull ObjectiveService objectiveService, @NotNull TextProvider text) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)scoreboardManager, (String)"scoreboardManager");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)objectiveDisplayService, (String)"objectiveDisplayService");
        Intrinsics.checkNotNullParameter((Object)objectiveService, (String)"objectiveService");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.log = log;
        this.scoreboardManager = scoreboardManager;
        this.state = state;
        this.data = data;
        this.objectiveDisplayService = objectiveDisplayService;
        this.objectiveService = objectiveService;
        this.text = text;
    }

    @Override
    @NotNull
    public Iterable<String> list() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(CommonKt.getRootObjectives(this.data.getObjectives()), ScoreboardObjectiveManager::list$lambda$0), ScoreboardObjectiveManager::list$lambda$1));
    }

    @Override
    @Nullable
    public BingoObjective find(@NotNull String id, @NotNull CardGeneratorState state) {
        BingoObjective.ScoreboardEntry scoreboardEntry;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ObjectiveData objectiveData = this.data.getObjectives().get(id);
        ObjectiveData.Scoreboard scoreboard = objectiveData instanceof ObjectiveData.Scoreboard ? (ObjectiveData.Scoreboard)objectiveData : null;
        if (scoreboard == null) {
            return null;
        }
        ObjectiveData.Scoreboard data = scoreboard;
        BingoObjective.ScoreboardEntry it = scoreboardEntry = new BingoObjective.ScoreboardEntry(id, data, data.getMin().resolve(state), data.getMax().resolve(state));
        boolean bl = false;
        return this.init(it) ? scoreboardEntry : null;
    }

    private final boolean init(BingoObjective objective) {
        if (!(objective instanceof BingoObjective.ScoreboardEntry)) {
            return false;
        }
        IObjectiveHandle scoreboard = this.scoreboardManager.getByName(((BingoObjective.ScoreboardEntry)objective).getData().getScoreboardName());
        if (scoreboard == null) {
            LoggingKt.objectiveError$default(this.log, ((BingoObjective.ScoreboardEntry)objective).getId(), "Could not find scoreboard " + ((BingoObjective.ScoreboardEntry)objective).getData().getScoreboardName() + " - is it not created yet?", null, false, 12, null);
            return false;
        }
        ((BingoObjective.ScoreboardEntry)objective).setScoreboard(scoreboard);
        ObjectiveDisplay.Resolved display2 = new ObjectiveDisplay.Resolved(this.text.literal(StringKt.formatTitle(((BingoObjective.ScoreboardEntry)objective).getData().getScoreboardName())).append(": %min%"), null, null, CardTile.Decoration.ADVANCEMENT, null, 22, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"%min%", (Object)String.valueOf(((BingoObjective.ScoreboardEntry)objective).getValueMin())), TuplesKt.to((Object)"%max%", (Object)String.valueOf(((BingoObjective.ScoreboardEntry)objective).getValueMax()))};
        objective.setDisplay(this.objectiveDisplayService.resolve(((BingoObjective.ScoreboardEntry)objective).getId(), ((BingoObjective.ScoreboardEntry)objective).getData().getDisplay(), display2, MapsKt.mapOf((Pair[])pairArray)));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull BingoCard card) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        BingoCard this_$iv = card;
        boolean $i$f$objectivesByInstance = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getObjectives().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BingoObjective.ScoreboardEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.ScoreboardEntry goal : (List)destination$iv$iv$iv) {
            this.init(goal);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getScoreboardValue(BingoObjective.ScoreboardEntry objective, IObjectiveHandle scoreboard, IPlayerHandle player) {
        int n;
        if (objective.getData().getRelative()) {
            Object object;
            void $this$getOrPut$iv;
            Map<UUID, Integer> map = objective.getBaseScores();
            UUID key$iv = player.getUuid();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Integer n2 = scoreboard.getForPlayer(player);
                Integer answer$iv = n2 != null ? n2 : 0;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            n = ((Number)object).intValue();
        } else {
            n = 0;
        }
        int base = n;
        Integer n3 = scoreboard.getForPlayer(player);
        int score = n3 != null ? n3 : 0;
        return score - base;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick(@NotNull BingoCard card) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Instant instant = this.state.getUpdatedAt();
        if (instant == null) {
            instant = Instant.MIN;
        }
        Instant now = instant;
        BingoCard this_$iv = card;
        boolean $i$f$objectivesByInstance = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getObjectives().values();
        boolean $i$f$filterIsInstance2 = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BingoObjective.ScoreboardEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.ScoreboardEntry objective : (List)destination$iv$iv$iv) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            IObjectiveHandle scoreboard;
            void $this$mapTo$iv$iv;
            Map teamPlayers;
            Object object;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            if (objective.getScoreboard() == null) continue;
            this.objectiveService.updateTeamsOnceAchieved(objective);
            Map<BingoTeam, List<IPlayerHandle>> $i$f$filterIsInstance2 = this.objectiveService.getPlayersByTeam(card);
            boolean $i$f$mapKeys = false;
            destination$iv$iv$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Object it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                BingoTeamKey bingoTeamKey = BingoTeamKey.box-impl(((BingoTeam)it.getKey()).getKey-zo6Dpdc());
                Map map = object;
                boolean bl2 = false;
                it = it$iv$iv.getValue();
                map.put(bingoTeamKey, it);
            }
            Map $this$map$iv = teamPlayers = destination$iv$iv;
            boolean $i$f$map22 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                Object element$iv$iv$iv;
                element$iv$iv$iv = item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                String team = ((BingoTeamKey)element$iv$iv$iv.getKey()).unbox-impl();
                List players = (List)element$iv$iv$iv.getValue();
                Iterator iterator = ((Iterable)players).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object it = (IPlayerHandle)iterator.next();
                boolean bl3 = false;
                it = this.getScoreboardValue(objective, scoreboard, (IPlayerHandle)it);
                while (iterator.hasNext()) {
                    Object it2 = (IPlayerHandle)iterator.next();
                    $i$a$-maxOf-ScoreboardObjectiveManager$tick$teamsProgress$1$scoreboardProgress$1 = false;
                    if (it.compareTo(it2 = (Comparable)Integer.valueOf(this.getScoreboardValue(objective, scoreboard, (IPlayerHandle)it2))) >= 0) continue;
                    it = it2;
                }
                Object object2 = it;
                int it3 = ((Number)object2).intValue();
                boolean bl4 = false;
                Integer n = (Integer)(it3 <= objective.getValueMax() ? object2 : null);
                int scoreboardProgress = n != null ? n : 0;
                float progress = (float)scoreboardProgress / (float)RangesKt.coerceAtLeast((int)objective.getValueMin(), (int)1);
                object.add(TuplesKt.to((Object)BingoTeamKey.box-impl(team), (Object)Float.valueOf(progress)));
            }
            Map teamsProgress = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            this.objectiveService.updateTeamsSeen(card, objective, (Function1<? super BingoTeamKey, Boolean>)((Function1)new Function1<BingoTeamKey, Boolean>((Map<BingoTeamKey, ? extends List<? extends IPlayerHandle>>)teamPlayers, this, objective, scoreboard){
                final /* synthetic */ Map<BingoTeamKey, List<IPlayerHandle>> $teamPlayers;
                final /* synthetic */ ScoreboardObjectiveManager this$0;
                final /* synthetic */ BingoObjective.ScoreboardEntry $objective;
                final /* synthetic */ IObjectiveHandle $scoreboard;
                {
                    this.$teamPlayers = $teamPlayers;
                    this.this$0 = $receiver;
                    this.$objective = $objective;
                    this.$scoreboard = $scoreboard;
                }

                /*
                 * WARNING - void declaration
                 */
                public final Boolean invoke-DNZx0G4(String team) {
                    boolean bl;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
                        List<IPlayerHandle> list = this.$teamPlayers.get(BingoTeamKey.box-impl(team));
                        if (list != null) {
                            void $this$any$iv;
                            Iterable iterable = list;
                            ScoreboardObjectiveManager scoreboardObjectiveManager = this.this$0;
                            BingoObjective.ScoreboardEntry scoreboardEntry = this.$objective;
                            IObjectiveHandle iObjectiveHandle = this.$scoreboard;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    IPlayerHandle it = (IPlayerHandle)element$iv;
                                    boolean bl2 = false;
                                    if (!(ScoreboardObjectiveManager.access$getScoreboardValue(scoreboardObjectiveManager, scoreboardEntry, iObjectiveHandle, it) > 0)) continue;
                                    bl = true;
                                    break block5;
                                }
                                bl = false;
                            }
                        } else {
                            bl = false;
                        }
                    }
                    return bl;
                }
            }));
            Sequence $i$f$map22 = SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)MapsKt.asSequence((Map)teamPlayers), ScoreboardObjectiveManager::tick$lambda$9), arg_0 -> ScoreboardObjectiveManager.tick$lambda$10(objective, this, scoreboard, arg_0));
            boolean $i$f$associate = false;
            destination$iv$iv2 = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv3;
                Pair pair = (Pair)element$iv$iv;
                boolean bl = false;
                String team = ((BingoTeamKey)pair.component1()).unbox-impl();
                IPlayerHandle player = (IPlayerHandle)pair.component2();
                BingoObjectiveCapture bingoObjectiveCapture = objective.getPlayersHolding().get(player.getUuid());
                if (bingoObjectiveCapture == null) {
                    PlayerProfile playerProfile = player.getProfile();
                    Intrinsics.checkNotNull((Object)now);
                    bingoObjectiveCapture = new BingoObjectiveCapture(team, playerProfile, now, null);
                }
                BingoObjectiveCapture capture = bingoObjectiveCapture;
                pair = TuplesKt.to((Object)player.getUuid(), (Object)capture);
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map it = destination$iv$iv3;
            boolean bl = false;
            Map playersHolding = objective.getData().getPermanent() ? MapsKt.plus((Map)it, objective.getPlayersHolding()) : it;
            Map<UUID, BingoObjectiveCapture> players = this.objectiveService.getPlayers(card, playersHolding, objective.getPlayers(), false);
            Set<BingoTeamKey> teams2 = this.objectiveService.getTeams(players);
            this.objectiveService.update(objective, playersHolding, players, teamsProgress, teams2);
        }
    }

    @Override
    @NotNull
    public Iterable<String> listExcludedIds() {
        return IObjectiveManager.DefaultImpls.listExcludedIds(this);
    }

    private static final boolean list$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ObjectiveData it = (ObjectiveData)entry.getValue();
        return it instanceof ObjectiveData.Scoreboard;
    }

    private static final String list$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getKey();
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable tick$lambda$9(Map.Entry entry) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String team = ((BingoTeamKey)entry.getKey()).unbox-impl();
        List players = (List)entry.getValue();
        Iterable $this$map$iv = players;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IPlayerHandle iPlayerHandle = (IPlayerHandle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)BingoTeamKey.box-impl(team), (Object)it));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean tick$lambda$10(BingoObjective.ScoreboardEntry $objective, ScoreboardObjectiveManager this$0, IObjectiveHandle $scoreboard, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        IPlayerHandle player = (IPlayerHandle)pair.component2();
        IntRange intRange = $objective.getValueRange();
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        int n3 = this$0.getScoreboardValue($objective, $scoreboard, player);
        return n <= n3 ? n3 <= n2 : false;
    }

    public static final /* synthetic */ int access$getScoreboardValue(ScoreboardObjectiveManager $this, BingoObjective.ScoreboardEntry objective, IObjectiveHandle scoreboard, IPlayerHandle player) {
        return $this.getScoreboardValue(objective, scoreboard, player);
    }
}

