/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.impl.networking;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.impl.PlayerHandle;
import me.jfenn.bingo.impl.networking.PacketBufImpl;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import me.jfenn.bingo.platform.packet.IServerNetworking;
import me.jfenn.bingo.platform.packet.IServerPacketHandlerC2S;
import me.jfenn.bingo.platform.packet.IServerPacketHandlerS2C;
import me.jfenn.bingo.platform.packet.PacketConverter;
import me.jfenn.bingo.platform.packet.ServerPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl;", "Lme/jfenn/bingo/platform/packet/IServerNetworking;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lme/jfenn/bingo/platform/item/IItemStackFactory;Lme/jfenn/bingo/platform/event/IEventBus;)V", "T", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "converter", "Lme/jfenn/bingo/platform/packet/IServerPacketHandlerC2S;", "registerC2S", "(Lme/jfenn/bingo/platform/packet/PacketConverter;)Lme/jfenn/bingo/platform/packet/IServerPacketHandlerC2S;", "Lme/jfenn/bingo/platform/packet/IServerPacketHandlerS2C;", "registerS2C", "(Lme/jfenn/bingo/platform/packet/PacketConverter;)Lme/jfenn/bingo/platform/packet/IServerPacketHandlerS2C;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "Lme/jfenn/bingo/platform/event/IEventBus;", "ServerPacketHandlerC2S", "ServerPacketHandlerS2C", "bingo"})
public final class ServerNetworkingImpl
implements IServerNetworking {
    @NotNull
    private final IItemStackFactory itemStackFactory;
    @NotNull
    private final IEventBus eventBus;

    public ServerNetworkingImpl(@NotNull IItemStackFactory itemStackFactory, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.itemStackFactory = itemStackFactory;
        this.eventBus = eventBus;
    }

    @Override
    @NotNull
    public <T> IServerPacketHandlerC2S<T> registerC2S(@NotNull PacketConverter<T> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return new ServerPacketHandlerC2S<T>(converter);
    }

    @Override
    @NotNull
    public <T> IServerPacketHandlerS2C<T> registerS2C(@NotNull PacketConverter<T> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return new ServerPacketHandlerS2C<T>(converter);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0007R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl$ServerPacketHandlerC2S;", "T", "Lme/jfenn/bingo/platform/packet/IServerPacketHandlerC2S;", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "converter", "<init>", "(Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl;Lme/jfenn/bingo/platform/packet/PacketConverter;)V", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "bingo"})
    public final class ServerPacketHandlerC2S<T>
    implements IServerPacketHandlerC2S<T> {
        @NotNull
        private final PacketConverter<T> converter;
        @NotNull
        private final String name;

        public ServerPacketHandlerC2S(PacketConverter<T> converter) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            this.converter = converter;
            this.name = "packetC2S=" + this.converter.getId();
            ServerPlayNetworking.registerGlobalReceiver((class_2960)this.converter.getId(), (arg_0, arg_1, arg_2, arg_3, arg_4) -> ServerPacketHandlerC2S._init_$lambda$1(this, ServerNetworkingImpl.this, arg_0, arg_1, arg_2, arg_3, arg_4));
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        private static final void lambda$1$lambda$0(ServerNetworkingImpl this$0, ServerPacketHandlerC2S this$1, ServerPacket $data) {
            this$0.eventBus.emit(this$1, $data);
        }

        private static final void _init_$lambda$1(ServerPacketHandlerC2S this$0, ServerNetworkingImpl this$1, MinecraftServer server, class_3222 player, class_3244 class_32442, class_2540 buf, PacketSender packetSender) {
            PacketConverter packetConverter = this$0.converter;
            Intrinsics.checkNotNull((Object)buf);
            Object packet = packetConverter.fromPacketBuf(new PacketBufImpl(buf, this$1.itemStackFactory));
            Intrinsics.checkNotNull((Object)player);
            ServerPacket data = new ServerPacket(new PlayerHandle(player, null, 2, null), packet);
            server.execute(() -> ServerPacketHandlerC2S.lambda$1$lambda$0(this$1, this$0, data));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl$ServerPacketHandlerS2C;", "T", "Lme/jfenn/bingo/platform/packet/IServerPacketHandlerS2C;", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "converter", "<init>", "(Lme/jfenn/bingo/impl/networking/ServerNetworkingImpl;Lme/jfenn/bingo/platform/packet/PacketConverter;)V", "Lnet/minecraft/class_3222;", "player", "", "isSupported", "(Lnet/minecraft/class_3222;)Z", "packet", "send", "(Lnet/minecraft/class_3222;Ljava/lang/Object;)Z", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "bingo"})
    public final class ServerPacketHandlerS2C<T>
    implements IServerPacketHandlerS2C<T> {
        @NotNull
        private final PacketConverter<T> converter;

        public ServerPacketHandlerS2C(PacketConverter<T> converter) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            this.converter = converter;
        }

        @Override
        public boolean isSupported(@NotNull class_3222 player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return ServerPlayNetworking.canSend((class_3222)player, (class_2960)this.converter.getId());
        }

        @Override
        public boolean send(@NotNull class_3222 player, T packet) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (this.isSupported(player)) {
                class_2540 buf = PacketByteBufs.create();
                Intrinsics.checkNotNull((Object)buf);
                this.converter.toPacketBuf(packet, new PacketBufImpl(buf, ServerNetworkingImpl.this.itemStackFactory));
                ServerPlayNetworking.send((class_3222)player, (class_2960)this.converter.getId(), (class_2540)buf);
                return true;
            }
            return false;
        }

        @Override
        public boolean isSupported(@NotNull IPlayerHandle player) {
            return IServerPacketHandlerS2C.DefaultImpls.isSupported(this, player);
        }

        @Override
        public boolean send(@NotNull IPlayerHandle player, T packet) {
            return IServerPacketHandlerS2C.DefaultImpls.send(this, player, packet);
        }
    }
}

