/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.sqldelight.logs;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.sqldelight.Query;
import me.jfenn.bingo.sqldelight.Transacter;
import me.jfenn.bingo.sqldelight.db.QueryResult;
import me.jfenn.bingo.sqldelight.db.SqlCursor;
import me.jfenn.bingo.sqldelight.db.SqlDriver;
import me.jfenn.bingo.sqldelight.db.SqlPreparedStatement;
import me.jfenn.bingo.sqldelight.logs.StatementParameterInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\r\u001a\u00020\u00052\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\t\"\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0011\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013JJ\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00142\u0019\u0010\u001a\u001a\u0015\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0019H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJj\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b\"\u0004\b\u0000\u0010\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00042\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u00032\u0006\u0010\u0017\u001a\u00020\u00142\u0019\u0010\u001a\u001a\u0015\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0019H\u0016\u00a2\u0006\u0004\b\"\u0010#J*\u0010$\u001a\u00020\u00052\u0019\u0010\u001a\u001a\u0015\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0019H\u0002\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bH\u0016\u00a2\u0006\u0004\b&\u0010'J#\u0010(\u001a\u00020\u00052\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\t\"\u00020\u0004H\u0016\u00a2\u0006\u0004\b(\u0010)J+\u0010*\u001a\u00020\u00052\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\t\"\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b*\u0010\u000eR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010+R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010,\u00a8\u0006-"}, d2={"Lme/jfenn/bingo/sqldelight/logs/LogSqliteDriver;", "Lme/jfenn/bingo/sqldelight/db/SqlDriver;", "sqlDriver", "Lkotlin/Function1;", "", "", "logger", "<init>", "(Lapp/cash/sqldelight/db/SqlDriver;Lkotlin/jvm/functions/Function1;)V", "", "queryKeys", "Lme/jfenn/bingo/sqldelight/Query$Listener;", "listener", "addListener", "([Ljava/lang/String;Lapp/cash/sqldelight/Query$Listener;)V", "close", "()V", "Lme/jfenn/bingo/sqldelight/Transacter$Transaction;", "currentTransaction", "()Lme/jfenn/bingo/sqldelight/Transacter$Transaction;", "", "identifier", "sql", "parameters", "Lme/jfenn/bingo/sqldelight/db/SqlPreparedStatement;", "Lkotlin/ExtensionFunctionType;", "binders", "Lme/jfenn/bingo/sqldelight/db/QueryResult;", "", "execute", "(Ljava/lang/Integer;Ljava/lang/String;ILkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "R", "Lme/jfenn/bingo/sqldelight/db/SqlCursor;", "mapper", "executeQuery", "(Ljava/lang/Integer;Ljava/lang/String;Lkotlin/jvm/functions/Function1;ILkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "logParameters", "(Lkotlin/jvm/functions/Function1;)V", "newTransaction", "()Lme/jfenn/bingo/sqldelight/db/QueryResult;", "notifyListeners", "([Ljava/lang/String;)V", "removeListener", "Lkotlin/jvm/functions/Function1;", "Lme/jfenn/bingo/sqldelight/db/SqlDriver;", "runtime"})
public final class LogSqliteDriver
implements SqlDriver {
    @NotNull
    private final SqlDriver sqlDriver;
    @NotNull
    private final Function1<String, Unit> logger;

    public LogSqliteDriver(@NotNull SqlDriver sqlDriver, @NotNull Function1<? super String, Unit> logger) {
        Intrinsics.checkNotNullParameter((Object)sqlDriver, (String)"sqlDriver");
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.sqlDriver = sqlDriver;
        this.logger = logger;
    }

    @Override
    @Nullable
    public Transacter.Transaction currentTransaction() {
        return this.sqlDriver.currentTransaction();
    }

    @Override
    @NotNull
    public QueryResult<Long> execute(@Nullable Integer identifier, @NotNull String sql, int parameters, @Nullable Function1<? super SqlPreparedStatement, Unit> binders) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.logger.invoke((Object)("EXECUTE\n " + sql));
        this.logParameters(binders);
        return this.sqlDriver.execute(identifier, sql, parameters, binders);
    }

    @Override
    @NotNull
    public <R> QueryResult<R> executeQuery(@Nullable Integer identifier, @NotNull String sql, @NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper, int parameters, @Nullable Function1<? super SqlPreparedStatement, Unit> binders) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.logger.invoke((Object)("QUERY\n " + sql));
        this.logParameters(binders);
        return this.sqlDriver.executeQuery(identifier, sql, mapper, parameters, binders);
    }

    @Override
    @NotNull
    public QueryResult<Transacter.Transaction> newTransaction() {
        this.logger.invoke((Object)"TRANSACTION BEGIN");
        Transacter.Transaction transaction = this.sqlDriver.newTransaction().getValue();
        transaction.afterCommit((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LogSqliteDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                LogSqliteDriver.access$getLogger$p(this.this$0).invoke((Object)"TRANSACTION COMMIT");
            }
        }));
        transaction.afterRollback((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LogSqliteDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                LogSqliteDriver.access$getLogger$p(this.this$0).invoke((Object)"TRANSACTION ROLLBACK");
            }
        }));
        return QueryResult.Value.box-impl(QueryResult.Value.constructor-impl(transaction));
    }

    @Override
    public void close() {
        this.logger.invoke((Object)"CLOSE CONNECTION");
        this.sqlDriver.close();
    }

    @Override
    public void addListener(@NotNull String[] queryKeys, @NotNull Query.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.logger.invoke((Object)("BEGIN " + listener + " LISTENING TO [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        this.sqlDriver.addListener(Arrays.copyOf(queryKeys, queryKeys.length), listener);
    }

    @Override
    public void removeListener(@NotNull String[] queryKeys, @NotNull Query.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.logger.invoke((Object)("END " + listener + " LISTENING TO [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        this.sqlDriver.removeListener(Arrays.copyOf(queryKeys, queryKeys.length), listener);
    }

    @Override
    public void notifyListeners(String ... queryKeys) {
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        this.logger.invoke((Object)("NOTIFYING LISTENERS OF [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        this.sqlDriver.notifyListeners(Arrays.copyOf(queryKeys, queryKeys.length));
    }

    private final void logParameters(Function1<? super SqlPreparedStatement, Unit> binders) {
        block1: {
            Function1<? super SqlPreparedStatement, Unit> function1 = binders;
            if (function1 == null) break block1;
            Function1<? super SqlPreparedStatement, Unit> func = function1;
            boolean bl = false;
            StatementParameterInterceptor parametersInterceptor = new StatementParameterInterceptor();
            func.invoke((Object)parametersInterceptor);
            List<Object> logParameters = parametersInterceptor.getAndClearParameters();
            if (!((Collection)logParameters).isEmpty()) {
                this.logger.invoke((Object)("" + ' ' + logParameters));
            }
        }
    }

    public static final /* synthetic */ Function1 access$getLogger$p(LogSqliteDriver $this) {
        return $this.logger;
    }
}

