/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.world;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.bingo.client.platform.IWorldService;
import me.jfenn.bingo.client.world.BingoWorldState;
import me.jfenn.bingo.client.world.ScreenState;
import me.jfenn.bingo.common.ConstantsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_437;
import net.minecraft.class_5218;
import net.minecraft.class_525;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u001c\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lme/jfenn/bingo/client/world/WorldServiceImpl;", "Lme/jfenn/bingo/client/platform/IWorldService;", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/client/world/BingoWorldState;", "worldState", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/client/world/BingoWorldState;)V", "", "createBingoWorld", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "isBingoWorld", "(Lnet/minecraft/server/MinecraftServer;)Z", "deleteSave", "(Lnet/minecraft/server/MinecraftServer;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/client/world/BingoWorldState;", "Lnet/minecraft/class_310;", "kotlin.jvm.PlatformType", "client", "Lnet/minecraft/class_310;", "bingo_client"})
@Environment(value=EnvType.CLIENT)
public final class WorldServiceImpl
implements IWorldService {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoWorldState worldState;
    private final class_310 client;

    public WorldServiceImpl(@NotNull Logger log, @NotNull BingoWorldState worldState) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)worldState, (String)"worldState");
        this.log = log;
        this.worldState = worldState;
        this.client = class_310.method_1551();
    }

    @Override
    public void createBingoWorld() {
        class_437 parent = this.client.field_1755;
        this.worldState.setState(ScreenState.CreateBingoWorld);
        class_525.method_31130((class_310)this.client, (class_437)parent);
    }

    @Override
    public boolean isBingoWorld(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        String string = server.method_27728().method_150();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLevelName(...)");
        return StringsKt.startsWith$default((String)string, (String)ConstantsKt.getBINGO_WORLD_PREFIX(), (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSave(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.log.info("Deleting closed BINGO world save");
        Path path = server.method_27050(class_5218.field_24188).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        String dirName = PathsKt.getName((Path)path);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.method_1586().method_27002(dirName);
        Throwable throwable = null;
        try {
            class_32.class_5143 it = (class_32.class_5143)autoCloseable;
            boolean bl = false;
            it.method_27015();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }
}

