/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.game;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.OptionsChangedEvent;
import me.jfenn.bingo.common.event.model.StateChangedEvent;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.game.GameStatusPacket;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.event.model.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0014\u001a\u00020\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0018R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lme/jfenn/bingo/common/game/GameStatusController;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packets", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "serverTaskExecutor", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/event/ScopedEvents;", "scopedEvents", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/event/ScopedEvents;)V", "", "Lme/jfenn/bingo/platform/IPlayerHandle;", "players", "", "sendGameStatus", "(Ljava/util/List;)V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "bingo-common"})
public final class GameStatusController {
    @NotNull
    private final BingoState state;
    @NotNull
    private final ServerPacketEvents packets;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IExecutors.IServerTaskExecutor serverTaskExecutor;

    public GameStatusController(@NotNull BingoState state, @NotNull ServerPacketEvents packets, @NotNull IPlayerManager playerManager, @NotNull IExecutors.IServerTaskExecutor serverTaskExecutor, @NotNull IEventBus eventBus, @NotNull ScopedEvents scopedEvents) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)serverTaskExecutor, (String)"serverTaskExecutor");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)scopedEvents, (String)"scopedEvents");
        this.state = state;
        this.packets = packets;
        this.playerManager = playerManager;
        this.serverTaskExecutor = serverTaskExecutor;
        eventBus.register(PlayerEvent.ChannelRegister.INSTANCE, arg_0 -> GameStatusController._init_$lambda$0(this, arg_0));
        eventBus.register(StateChangedEvent.Companion, arg_0 -> GameStatusController._init_$lambda$1(this, arg_0));
        eventBus.register(OptionsChangedEvent.INSTANCE, arg_0 -> GameStatusController._init_$lambda$2(this, arg_0));
        scopedEvents.onUpdateTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> GameStatusController._init_$lambda$3(this, arg_0)));
    }

    private final void sendGameStatus(List<? extends IPlayerHandle> players) {
        Duration duration2 = this.state.ingameDuration();
        Duration duration3 = this.state.remainingDuration();
        if (duration3 == null) {
            duration3 = this.state.getOptions().getTimeLimit();
        }
        GameStatusPacket packet = new GameStatusPacket(duration2, duration3);
        for (IPlayerHandle iPlayerHandle : players) {
            this.packets.getGameStatusV1().send(iPlayerHandle, packet);
        }
    }

    private static final Unit _init_$lambda$0(GameStatusController this$0, PlayerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.sendGameStatus(CollectionsKt.listOf((Object)it.getPlayer()));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(GameStatusController this$0, StateChangedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.sendGameStatus(this$0.playerManager.getPlayers());
        CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS, this$0.serverTaskExecutor).execute(() -> GameStatusController.lambda$1$0(this$0));
        return Unit.INSTANCE;
    }

    private static final void lambda$1$0(GameStatusController this$0) {
        this$0.sendGameStatus(this$0.playerManager.getPlayers());
    }

    private static final Unit _init_$lambda$2(GameStatusController this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.sendGameStatus(this$0.playerManager.getPlayers());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(GameStatusController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.state.getState() == GameState.PLAYING) {
            this$0.sendGameStatus(this$0.playerManager.getPlayers());
        }
        return Unit.INSTANCE;
    }
}

