/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.scoring;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.scoring.ScoreRanking;
import me.jfenn.bingo.common.scoring.ScoreService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamWinner;
import me.jfenn.bingo.common.utils.DurationKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/jfenn/bingo/common/scoring/ScoreRankingService;", "", "<init>", "()V", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "Ljava/time/Duration;", "getTeamDuration", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/team/BingoTeam;)Ljava/time/Duration;", "", "Lme/jfenn/bingo/common/scoring/ScoreRanking;", "getScoreRankings", "(Lme/jfenn/bingo/common/state/BingoState;)Ljava/util/List;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nScoreRankingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreRankingService.kt\nme/jfenn/bingo/common/scoring/ScoreRankingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1563#2:54\n1634#2,3:55\n*S KotlinDebug\n*F\n+ 1 ScoreRankingService.kt\nme/jfenn/bingo/common/scoring/ScoreRankingService\n*L\n26#1:54\n26#1:55,3\n*E\n"})
public final class ScoreRankingService {
    @NotNull
    public static final ScoreRankingService INSTANCE = new ScoreRankingService();

    private ScoreRankingService() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Duration getTeamDuration(BingoState state, BingoTeam team) {
        Duration duration2;
        TeamWinner teamWinner = team.getWinner();
        if (teamWinner == null) return null;
        Instant instant = teamWinner.getInstant();
        if (instant == null) return null;
        Instant completedAt = instant;
        boolean bl = false;
        Instant instant2 = state.getStartedAt();
        if (instant2 == null) {
            instant2 = completedAt;
        }
        if ((duration2 = DurationKt.minus(completedAt, instant2)) == null) return null;
        Duration duration3 = duration2.plus(state.getTimeAdjustment());
        if (duration3 == null) return null;
        Duration duration4 = duration3.minus(state.getTimeOffline());
        return duration4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ScoreRanking> getScoreRankings(@NotNull BingoState state) {
        List list;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> ScoreRankingService.getScoreRankings$lambda$1(arg_0 -> ScoreRankingService.getScoreRankings$lambda$0(state, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        Comparator<Object> comparator2 = comparator;
        Object object = ScoreService.INSTANCE.getComparator(state);
        Comparator scoreRankingComparator = new Comparator(comparator2, (Comparator)object){
            final /* synthetic */ Comparator $this_thenByDescending;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenByDescending = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    BingoTeam bingoTeam = (BingoTeam)b;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    BingoTeam it = (BingoTeam)a;
                    void var7_7 = it;
                    bl = false;
                    BingoTeam bingoTeam2 = it;
                    n = comparator.compare(var7_7, bingoTeam2);
                }
                return n;
            }
        };
        object = CollectionsKt.sortedWith((Iterable)state.getRegisteredTeams(), (Comparator)scoreRankingComparator);
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void team;
            BingoTeam bingoTeam = (BingoTeam)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Duration duration2 = INSTANCE.getTeamDuration(state, (BingoTeam)team);
            collection.add(new ScoreRanking(0, team.getKey-zo6Dpdc(), team.getScore(), duration2, null));
        }
        List scoreRankingScores = (List)destination$iv$iv;
        List $this$getScoreRankings_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int index = -1;
        for (ScoreRanking ranking : scoreRankingScores) {
            ScoreRanking prevRanking;
            ScoreRanking scoreRanking = prevRanking = (ScoreRanking)CollectionsKt.lastOrNull((List)$this$getScoreRankings_u24lambda_u244);
            if (!Intrinsics.areEqual((Object)(scoreRanking != null ? scoreRanking.getScore() : null), (Object)ranking.getScore()) || !Intrinsics.areEqual((Object)prevRanking.getDuration(), (Object)ranking.getDuration())) {
                ++index;
            }
            $this$getScoreRankings_u24lambda_u244.add(ScoreRanking.copy-5kVK-bM$default(ranking, index, null, null, null, 14, null));
        }
        List scoreRankings = CollectionsKt.build((List)list);
        return scoreRankings;
    }

    private static final Duration getScoreRankings$lambda$0(BingoState $state, BingoTeam team) {
        Intrinsics.checkNotNull((Object)team);
        Duration duration2 = INSTANCE.getTeamDuration($state, team);
        if (duration2 == null) {
            duration2 = Duration.ofMillis(Long.MAX_VALUE);
        }
        return duration2;
    }

    private static final Duration getScoreRankings$lambda$1(Function1 $tmp0, Object p0) {
        return (Duration)$tmp0.invoke(p0);
    }
}

