/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.hud.card;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.client.common.state.BingoHudState;
import me.jfenn.bingo.client.platform.INativeImage;
import me.jfenn.bingo.client.platform.renderer.IDrawService;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.map.CardTileImage;
import me.jfenn.bingo.platform.item.IItemStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJE\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u0016J-\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\u000fJ/\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lme/jfenn/bingo/client/common/hud/card/CardTileRenderer;", "", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "hudState", "<init>", "(Lme/jfenn/bingo/client/common/state/BingoHudState;)V", "Lme/jfenn/bingo/client/platform/renderer/IDrawService;", "drawService", "Lme/jfenn/bingo/common/map/CardTile;", "tile", "", "itemX", "itemY", "", "renderTile", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;Lme/jfenn/bingo/common/map/CardTile;II)V", "Lme/jfenn/bingo/common/map/CardTileImage;", "image", "", "imageList", "Lme/jfenn/bingo/common/map/CardTile$Decoration;", "decoration", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;Lme/jfenn/bingo/common/map/CardTileImage;Ljava/util/List;Lme/jfenn/bingo/common/map/CardTile$Decoration;II)V", "renderTileImage", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;Lme/jfenn/bingo/common/map/CardTileImage;II)V", "renderTileDecorations", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;Lme/jfenn/bingo/common/map/CardTile$Decoration;II)V", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "Companion", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nCardTileRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardTileRenderer.kt\nme/jfenn/bingo/client/common/hud/card/CardTileRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class CardTileRenderer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final BingoHudState hudState;
    @NotNull
    private static final class_2960 ADVANCEMENT_FRAME_ID;
    @NotNull
    private static final class_2960 FRAME_FREE_SPACE_ID;
    @NotNull
    private static final class_2960 FRAME_MULTI_ID;
    @NotNull
    private static final class_2960 FRAME_FORBIDDEN_ID;

    public CardTileRenderer(@NotNull BingoHudState hudState) {
        Intrinsics.checkNotNullParameter((Object)hudState, (String)"hudState");
        this.hudState = hudState;
    }

    public final void renderTile(@NotNull IDrawService drawService, @NotNull CardTile tile, int itemX, int itemY) {
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        this.renderTile(drawService, tile.getImage(), tile.getImageList(), tile.getDecoration(), itemX, itemY);
    }

    public final void renderTile(@NotNull IDrawService drawService, @NotNull CardTileImage image2, @NotNull List<CardTileImage> imageList, @Nullable CardTile.Decoration decoration, int itemX, int itemY) {
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        Intrinsics.checkNotNullParameter(imageList, (String)"imageList");
        if (imageList.size() > 1 && decoration == CardTile.Decoration.ONE_OF) {
            drawService.getMatrices().push();
            drawService.getMatrices().translate(itemX, itemY, 0.0f);
            float scale = 0.75f;
            float translate = 4.0f / scale / 2.0f;
            drawService.getMatrices().scale(scale, scale, 1.0f);
            for (int i = 0; i < 3; ++i) {
                CardTileImage imageListImage;
                if ((CardTileImage)CollectionsKt.getOrNull(imageList, (int)i) == null) continue;
                drawService.getMatrices().push();
                drawService.getMatrices().translate(translate * (float)i, translate * (float)i, 10.0f * (float)(3 - i));
                float tint = 0.5f + (1.0f - (float)i / 2.0f) * 0.5f;
                drawService.setShaderColor(tint, tint, tint, 1.0f);
                this.renderTileImage(drawService, imageListImage, 0, 0);
                drawService.getMatrices().pop();
            }
            drawService.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            drawService.getMatrices().pop();
        } else if (imageList.size() > 1 && decoration == CardTile.Decoration.MANY_OF) {
            drawService.getMatrices().push();
            drawService.getMatrices().translate(itemX, itemY, 0.0f);
            float scale = 0.5625f;
            drawService.getMatrices().scale(scale, scale, 1.0f);
            for (int i = 0; i < 4; ++i) {
                CardTileImage imageListImage;
                if ((CardTileImage)CollectionsKt.getOrNull(imageList, (int)i) == null) continue;
                this.renderTileImage(drawService, imageListImage, i % 2 * 12, i / 2 * 12);
            }
            drawService.getMatrices().pop();
        } else {
            this.renderTileImage(drawService, image2, itemX, itemY);
        }
    }

    public final void renderTileImage(@NotNull IDrawService drawService, @NotNull CardTileImage image2, int itemX, int itemY) {
        INativeImage iNativeImage;
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        String string = image2.getTexture();
        if (string != null) {
            String it = string;
            boolean bl = false;
            iNativeImage = this.hudState.getImages().get(it);
        } else {
            iNativeImage = null;
        }
        INativeImage texture = iNativeImage;
        IItemStack item2 = image2.getItem();
        if (texture != null) {
            drawService.drawDynamicTexture(texture, itemX, itemY, 16, 16);
        } else if (item2 != null) {
            drawService.drawItemStack(item2, itemX, itemY, itemX + itemY * 122);
        }
    }

    public final void renderTileDecorations(@NotNull IDrawService drawService, @NotNull CardTile tile, int itemX, int itemY) {
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        this.renderTileDecorations(drawService, tile.getDecoration(), itemX, itemY);
    }

    public final void renderTileDecorations(@NotNull IDrawService drawService, @Nullable CardTile.Decoration decoration, int itemX, int itemY) {
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        if (decoration == CardTile.Decoration.ADVANCEMENT) {
            drawService.drawGuiTexture(ADVANCEMENT_FRAME_ID, itemX - 2, itemY - 2, 300, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        if (decoration == CardTile.Decoration.FREE_SPACE) {
            drawService.drawGuiTexture(FRAME_FREE_SPACE_ID, itemX - 2, itemY - 2, 301, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        if (decoration == CardTile.Decoration.MULTI_ITEM) {
            drawService.drawGuiTexture(FRAME_MULTI_ID, itemX - 2, itemY - 2, 300, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        if (decoration == CardTile.Decoration.FORBIDDEN) {
            drawService.drawGuiTexture(FRAME_FORBIDDEN_ID, itemX - 2, itemY - 2, 301, 0.0f, 0.0f, 20, 20, 20, 20);
        }
    }

    static {
        class_2960 class_29602 = class_2960.method_43902((String)"minecraft", (String)"bingo/image_frame_advancement");
        Intrinsics.checkNotNull((Object)class_29602);
        ADVANCEMENT_FRAME_ID = class_29602;
        class_2960 class_29603 = class_2960.method_43902((String)"minecraft", (String)"bingo/image_frame_free_space");
        Intrinsics.checkNotNull((Object)class_29603);
        FRAME_FREE_SPACE_ID = class_29603;
        class_2960 class_29604 = class_2960.method_43902((String)"minecraft", (String)"bingo/image_frame_multi");
        Intrinsics.checkNotNull((Object)class_29604);
        FRAME_MULTI_ID = class_29604;
        class_2960 class_29605 = class_2960.method_43902((String)"minecraft", (String)"bingo/image_frame_forbidden");
        Intrinsics.checkNotNull((Object)class_29605);
        FRAME_FORBIDDEN_ID = class_29605;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lme/jfenn/bingo/client/common/hud/card/CardTileRenderer$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ADVANCEMENT_FRAME_ID", "Lnet/minecraft/class_2960;", "getADVANCEMENT_FRAME_ID", "()Lnet/minecraft/class_2960;", "FRAME_FREE_SPACE_ID", "getFRAME_FREE_SPACE_ID", "FRAME_MULTI_ID", "getFRAME_MULTI_ID", "FRAME_FORBIDDEN_ID", "getFRAME_FORBIDDEN_ID", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getADVANCEMENT_FRAME_ID() {
            return ADVANCEMENT_FRAME_ID;
        }

        @NotNull
        public final class_2960 getFRAME_FREE_SPACE_ID() {
            return FRAME_FREE_SPACE_ID;
        }

        @NotNull
        public final class_2960 getFRAME_MULTI_ID() {
            return FRAME_MULTI_ID;
        }

        @NotNull
        public final class_2960 getFRAME_FORBIDDEN_ID() {
            return FRAME_FORBIDDEN_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

