/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.client.platform.ClientPacket;
import me.jfenn.bingo.client.platform.IClientNetworking;
import me.jfenn.bingo.client.platform.IClientPacketHandlerC2S;
import me.jfenn.bingo.client.platform.IClientPacketHandlerS2C;
import me.jfenn.bingo.impl.networking.PacketBufImpl;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import me.jfenn.bingo.platform.packet.PacketConverter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lme/jfenn/bingo/client/impl/ClientNetworkingImpl;", "Lme/jfenn/bingo/client/platform/IClientNetworking;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lme/jfenn/bingo/platform/item/IItemStackFactory;Lme/jfenn/bingo/platform/event/IEventBus;)V", "T", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "converter", "Lme/jfenn/bingo/client/platform/IClientPacketHandlerC2S;", "registerC2S", "(Lme/jfenn/bingo/platform/packet/PacketConverter;)Lme/jfenn/bingo/client/platform/IClientPacketHandlerC2S;", "Lme/jfenn/bingo/client/platform/IClientPacketHandlerS2C;", "registerS2C", "(Lme/jfenn/bingo/platform/packet/PacketConverter;)Lme/jfenn/bingo/client/platform/IClientPacketHandlerS2C;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "Lme/jfenn/bingo/platform/event/IEventBus;", "ClientPacketHandlerC2S", "ClientPacketHandlerS2C", "bingo_client"})
@Environment(value=EnvType.CLIENT)
public final class ClientNetworkingImpl
implements IClientNetworking {
    @NotNull
    private final IItemStackFactory itemStackFactory;
    @NotNull
    private final IEventBus eventBus;

    public ClientNetworkingImpl(@NotNull IItemStackFactory itemStackFactory, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.itemStackFactory = itemStackFactory;
        this.eventBus = eventBus;
    }

    @Override
    @NotNull
    public <T> IClientPacketHandlerC2S<T> registerC2S(@NotNull PacketConverter<T> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return new ClientPacketHandlerC2S<T>(converter);
    }

    @Override
    @NotNull
    public <T> IClientPacketHandlerS2C<T> registerS2C(@NotNull PacketConverter<T> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return new ClientPacketHandlerS2C<T>(converter);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/jfenn/bingo/client/impl/ClientNetworkingImpl$ClientPacketHandlerC2S;", "T", "Lme/jfenn/bingo/client/platform/IClientPacketHandlerC2S;", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "converter", "<init>", "(Lme/jfenn/bingo/client/impl/ClientNetworkingImpl;Lme/jfenn/bingo/platform/packet/PacketConverter;)V", "", "isSupported", "()Z", "packet", "send", "(Ljava/lang/Object;)Z", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "bingo_client"})
    @Environment(value=EnvType.CLIENT)
    public final class ClientPacketHandlerC2S<T>
    implements IClientPacketHandlerC2S<T> {
        @NotNull
        private final PacketConverter<T> converter;

        public ClientPacketHandlerC2S(PacketConverter<T> converter) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            this.converter = converter;
        }

        @Override
        public boolean isSupported() {
            return ClientPlayNetworking.canSend((class_2960)this.converter.getId());
        }

        @Override
        public boolean send(T packet) {
            if (this.isSupported()) {
                class_2540 buf = PacketByteBufs.create();
                Intrinsics.checkNotNull((Object)buf);
                this.converter.toPacketBuf(packet, new PacketBufImpl(buf, ClientNetworkingImpl.this.itemStackFactory));
                ClientPlayNetworking.send((class_2960)this.converter.getId(), (class_2540)buf);
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0007R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lme/jfenn/bingo/client/impl/ClientNetworkingImpl$ClientPacketHandlerS2C;", "T", "Lme/jfenn/bingo/client/platform/IClientPacketHandlerS2C;", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "converter", "<init>", "(Lme/jfenn/bingo/client/impl/ClientNetworkingImpl;Lme/jfenn/bingo/platform/packet/PacketConverter;)V", "Lme/jfenn/bingo/platform/packet/PacketConverter;", "", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "bingo_client"})
    @Environment(value=EnvType.CLIENT)
    public final class ClientPacketHandlerS2C<T>
    implements IClientPacketHandlerS2C<T> {
        @NotNull
        private final PacketConverter<T> converter;
        @NotNull
        private final String name;

        public ClientPacketHandlerS2C(PacketConverter<T> converter) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            this.converter = converter;
            this.name = "packetS2C=" + this.converter.getId();
            ClientPlayNetworking.registerGlobalReceiver((class_2960)this.converter.getId(), (arg_0, arg_1, arg_2, arg_3) -> ClientPacketHandlerS2C._init_$lambda$1(this, ClientNetworkingImpl.this, arg_0, arg_1, arg_2, arg_3));
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        private static final void lambda$1$lambda$0(ClientNetworkingImpl this$0, ClientPacketHandlerS2C this$1, ClientPacket $data) {
            this$0.eventBus.emit(this$1, $data);
        }

        private static final void _init_$lambda$1(ClientPacketHandlerS2C this$0, ClientNetworkingImpl this$1, class_310 client, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
            PacketConverter packetConverter = this$0.converter;
            Intrinsics.checkNotNull((Object)buf);
            Object packet = packetConverter.fromPacketBuf(new PacketBufImpl(buf, this$1.itemStackFactory));
            ClientPacket data = new ClientPacket(packet);
            client.execute(() -> ClientPacketHandlerS2C.lambda$1$lambda$0(this$1, this$0, data));
        }
    }
}

