/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.autorestart;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import me.jfenn.bingo.common.bossbar.BossBarService;
import me.jfenn.bingo.common.menu.MenuController;
import me.jfenn.bingo.common.scoreboard.ScoreboardService;
import me.jfenn.bingo.common.spawn.SpawnService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.state.PersistentStates;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.platform.IPersistentStateManager;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.IServerWorldFactory;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.game.GameResetEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0002\u00a2\u0006\u0004\b \u0010!R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\"R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010%R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010&R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010'R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010(R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010)R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010*R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010+R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010,R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010-\u00a8\u0006."}, d2={"Lme/jfenn/bingo/common/autorestart/ResetService;", "", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/spawn/SpawnService;", "spawnService", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/scoreboard/ScoreboardService;", "scoreboardService", "Lme/jfenn/bingo/common/bossbar/BossBarService;", "bossBarService", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "serverWorldFactory", "Lme/jfenn/bingo/common/menu/MenuController;", "menuController", "Lme/jfenn/bingo/platform/IPersistentStateManager;", "persistentStateManager", "Lme/jfenn/bingo/common/state/PersistentStates;", "persistentStates", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/spawn/SpawnService;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/scoreboard/ScoreboardService;Lme/jfenn/bingo/common/bossbar/BossBarService;Lme/jfenn/bingo/platform/IServerWorldFactory;Lme/jfenn/bingo/common/menu/MenuController;Lme/jfenn/bingo/platform/IPersistentStateManager;Lme/jfenn/bingo/common/state/PersistentStates;Lorg/slf4j/Logger;)V", "", "resetGame", "()V", "", "resetGameWorlds", "()Ljava/util/List;", "Lme/jfenn/bingo/platform/event/IEventBus;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/spawn/SpawnService;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/scoreboard/ScoreboardService;", "Lme/jfenn/bingo/common/bossbar/BossBarService;", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "Lme/jfenn/bingo/common/menu/MenuController;", "Lme/jfenn/bingo/platform/IPersistentStateManager;", "Lme/jfenn/bingo/common/state/PersistentStates;", "Lorg/slf4j/Logger;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nResetService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResetService.kt\nme/jfenn/bingo/common/autorestart/ResetService\n+ 2 Logger.kt\nme/jfenn/bingo/common/utils/LoggerKt\n*L\n1#1,76:1\n10#2,8:77\n*S KotlinDebug\n*F\n+ 1 ResetService.kt\nme/jfenn/bingo/common/autorestart/ResetService\n*L\n43#1:77,8\n*E\n"})
public final class ResetService {
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final BingoState state;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final SpawnService spawnService;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final ScoreboardService scoreboardService;
    @NotNull
    private final BossBarService bossBarService;
    @NotNull
    private final IServerWorldFactory serverWorldFactory;
    @NotNull
    private final MenuController menuController;
    @NotNull
    private final IPersistentStateManager persistentStateManager;
    @NotNull
    private final PersistentStates persistentStates;
    @NotNull
    private final Logger log;

    public ResetService(@NotNull IEventBus eventBus, @NotNull BingoState state, @NotNull IPlayerManager playerManager, @NotNull SpawnService spawnService, @NotNull TeamService teamService, @NotNull ScoreboardService scoreboardService, @NotNull BossBarService bossBarService, @NotNull IServerWorldFactory serverWorldFactory, @NotNull MenuController menuController, @NotNull IPersistentStateManager persistentStateManager, @NotNull PersistentStates persistentStates, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)spawnService, (String)"spawnService");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)scoreboardService, (String)"scoreboardService");
        Intrinsics.checkNotNullParameter((Object)bossBarService, (String)"bossBarService");
        Intrinsics.checkNotNullParameter((Object)serverWorldFactory, (String)"serverWorldFactory");
        Intrinsics.checkNotNullParameter((Object)menuController, (String)"menuController");
        Intrinsics.checkNotNullParameter((Object)persistentStateManager, (String)"persistentStateManager");
        Intrinsics.checkNotNullParameter((Object)persistentStates, (String)"persistentStates");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.eventBus = eventBus;
        this.state = state;
        this.playerManager = playerManager;
        this.spawnService = spawnService;
        this.teamService = teamService;
        this.scoreboardService = scoreboardService;
        this.bossBarService = bossBarService;
        this.serverWorldFactory = serverWorldFactory;
        this.menuController = menuController;
        this.persistentStateManager = persistentStateManager;
        this.persistentStates = persistentStates;
        this.log = log;
    }

    public final void resetGame() {
        if (!this.state.isLobbyMode()) {
            throw new IllegalStateException("This shouldn't be happening. Tell fennifith to stop writing bad code.".toString());
        }
        this.resetGameWorlds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Unit> resetGameWorlds() {
        List<Unit> list;
        void $this$measureTime$iv;
        Logger logger = this.log;
        String message$iv = "Resetting worlds...";
        boolean $i$f$measureTime = false;
        long start$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        $this$measureTime$iv.info(message$iv);
        try {
            boolean bl = false;
            this.log.info("[Reset] Clearing game data");
            this.teamService.clearTeams();
            this.scoreboardService.clearScoreboards();
            this.bossBarService.clearBossBars();
            this.state.reset();
            this.log.info("[Reset] Recreating worlds");
            this.serverWorldFactory.recreateWorlds(Random.Default.nextLong(), (Function0<Unit>)((Function0)() -> ResetService.resetGameWorlds$lambda$1$lambda$0(this)));
            this.log.info("[Reset] Transferring game state");
            this.persistentStateManager.put(this.persistentStates.getBingo(), this.state);
            this.log.info("[Reset] Teleporting players back to lobby");
            this.state.changeState(this.eventBus, GameState.PREGAME);
            for (IPlayerHandle player : this.playerManager.getPlayers()) {
                this.spawnService.teleportToLobby(player);
                ((Collection)this.state.getPlayersJoinedIds()).add(player.getUuid());
            }
            list = this.eventBus.emit(GameResetEvent.Companion, new GameResetEvent());
        }
        finally {
            $this$measureTime$iv.info(message$iv + " - done in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)start$iv)) + "!");
        }
        return list;
    }

    private static final Unit resetGameWorlds$lambda$1$lambda$0(ResetService this$0) {
        this$0.menuController.prepareLobbyFiles();
        return Unit.INSTANCE;
    }
}

