/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.card;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.BingoCardEntry;
import me.jfenn.bingo.common.card.CardGeneratorState;
import me.jfenn.bingo.common.card.TagExpansionService;
import me.jfenn.bingo.common.card.data.ObjectiveData;
import me.jfenn.bingo.common.card.data.ObjectiveRequirements;
import me.jfenn.bingo.common.card.filter.ObjectiveFilter;
import me.jfenn.bingo.common.card.filter.ObjectiveFilterList;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.card.objective.BingoObjectiveManager;
import me.jfenn.bingo.common.card.objective.LoggingKt;
import me.jfenn.bingo.common.card.tag.TagData;
import me.jfenn.bingo.common.card.tag.TagService;
import me.jfenn.bingo.common.card.tierlist.TierLabel;
import me.jfenn.bingo.common.card.tierlist.TierListConfig;
import me.jfenn.bingo.common.card.tierlist.TierListEntry;
import me.jfenn.bingo.common.config.ConfigService;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.options.BingoCardOptions;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.Build;
import me.jfenn.bingo.common.utils.CacheDelegateArg;
import me.jfenn.bingo.common.utils.CacheDelegateKt;
import me.jfenn.bingo.common.utils.RangeKt;
import me.jfenn.bingo.common.utils.ToMapKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.text.IText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.MDC;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001tBO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010!\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0016\u00a2\u0006\u0004\b#\u0010\u0018J!\u0010(\u001a\u00020'2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00160$\u00a2\u0006\u0004\b(\u0010)J3\u0010-\u001a\u00020'2\u0006\u0010*\u001a\u00020%2\u0006\u0010,\u001a\u00020+2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00160$H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0015\u00102\u001a\u0002012\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b2\u00103J%\u00107\u001a\u00020\u00162\u0006\u00104\u001a\u0002012\u000e\b\u0002\u00106\u001a\b\u0012\u0004\u0012\u00020\u001905\u00a2\u0006\u0004\b7\u00108J+\u0010;\u001a\u0002012\b\b\u0002\u00104\u001a\u0002012\b\b\u0002\u0010\u0007\u001a\u00020/2\b\b\u0002\u0010:\u001a\u000209\u00a2\u0006\u0004\b;\u0010<J%\u0010A\u001a\u00020\u00162\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020\u0019\u00a2\u0006\u0004\bA\u0010BJ%\u0010A\u001a\u00020\u00162\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020=2\u0006\u0010D\u001a\u00020C\u00a2\u0006\u0004\bA\u0010EJ=\u0010H\u001a\u0002012\u0006\u00104\u001a\u0002012\b\b\u0002\u0010:\u001a\u0002092\f\u0010H\u001a\b\u0012\u0004\u0012\u00020G0F2\u000e\b\u0002\u00106\u001a\b\u0012\u0004\u0012\u00020\u001905\u00a2\u0006\u0004\bH\u0010IJ-\u0010N\u001a\u0004\u0018\u00010\u001b2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001b0J2\u0006\u0010M\u001a\u00020LH\u0002\u00a2\u0006\u0004\bN\u0010OJ#\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001f0J2\u0006\u0010Q\u001a\u00020PH\u0002\u00a2\u0006\u0004\bR\u0010SJ+\u0010U\u001a\u00020\u001f2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001b0T2\u0006\u0010Q\u001a\u00020PH\u0002\u00a2\u0006\u0004\bU\u0010VJK\u0010Z\u001a\b\u0012\u0004\u0012\u00020Y0F2\u0006\u0010:\u001a\u0002092\u0006\u00100\u001a\u00020/2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0019052\f\u0010W\u001a\b\u0012\u0004\u0012\u00020=0F2\b\b\u0002\u0010X\u001a\u00020=H\u0002\u00a2\u0006\u0004\bZ\u0010[J5\u0010^\u001a\u0002012\u0006\u0010]\u001a\u00020\\2\u0006\u0010:\u001a\u0002092\u0006\u00100\u001a\u00020/2\u000e\b\u0002\u00106\u001a\b\u0012\u0004\u0012\u00020\u001905\u00a2\u0006\u0004\b^\u0010_J\u001d\u0010a\u001a\u00020\u00162\f\u0010`\u001a\b\u0012\u0004\u0012\u00020G0FH\u0002\u00a2\u0006\u0004\ba\u0010bJM\u0010f\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020C\u0018\u00010J2\b\u0010c\u001a\u0004\u0018\u00010\u00192\u0006\u0010@\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020d2\u0014\b\u0002\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020C0TH\u0002\u00a2\u0006\u0004\bf\u0010gR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010hR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010iR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010jR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010kR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010lR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010mR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010nR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010oR\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010pR&\u0010r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001905\u0012\u0004\u0012\u00020\u00160q8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\br\u0010s\u00a8\u0006u"}, d2={"Lme/jfenn/bingo/common/card/CardService;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/config/ConfigService;", "configService", "Lme/jfenn/bingo/common/data/ScopedData;", "data", "Lme/jfenn/bingo/common/card/tag/TagService;", "tagService", "Lme/jfenn/bingo/common/card/objective/BingoObjectiveManager;", "objectiveManager", "Lme/jfenn/bingo/common/card/TagExpansionService;", "tagExpansionService", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/config/ConfigService;Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/card/tag/TagService;Lme/jfenn/bingo/common/card/objective/BingoObjectiveManager;Lme/jfenn/bingo/common/card/TagExpansionService;Lme/jfenn/bingo/common/text/TextProvider;)V", "", "validateLists", "()V", "", "name", "Lme/jfenn/bingo/common/card/tag/TagData;", "tag", "validateTag", "(Ljava/lang/String;Lme/jfenn/bingo/common/card/tag/TagData;)V", "Lme/jfenn/bingo/common/card/tierlist/TierListConfig;", "list", "validateList", "(Ljava/lang/String;Lme/jfenn/bingo/common/card/tierlist/TierListConfig;)V", "createInitialCards", "Lkotlin/Function1;", "Lme/jfenn/bingo/platform/text/IText;", "err", "", "isSupported", "(Lkotlin/jvm/functions/Function1;)Z", "listName", "Lme/jfenn/bingo/common/card/data/ObjectiveRequirements;", "reqs", "checkSoftRequirements", "(Lme/jfenn/bingo/platform/text/IText;Lme/jfenn/bingo/common/card/data/ObjectiveRequirements;Lkotlin/jvm/functions/Function1;)Z", "Lme/jfenn/bingo/common/options/BingoCardOptions;", "cardOptions", "Lme/jfenn/bingo/common/card/BingoCard;", "newCard", "(Lme/jfenn/bingo/common/options/BingoCardOptions;)Lme/jfenn/bingo/common/card/BingoCard;", "card", "", "excludeObjectives", "shuffleCard", "(Lme/jfenn/bingo/common/card/BingoCard;Ljava/util/Set;)V", "", "seed", "generateCard", "(Lme/jfenn/bingo/common/card/BingoCard;Lme/jfenn/bingo/common/options/BingoCardOptions;J)Lme/jfenn/bingo/common/card/BingoCard;", "", "x", "y", "objectiveId", "replaceEntry", "(IILjava/lang/String;)V", "Lme/jfenn/bingo/common/card/objective/BingoObjective;", "objective", "(IILme/jfenn/bingo/common/card/objective/BingoObjective;)V", "", "Lme/jfenn/bingo/common/card/BingoCardEntry;", "replaceEntries", "(Lme/jfenn/bingo/common/card/BingoCard;JLjava/util/List;Ljava/util/Set;)Lme/jfenn/bingo/common/card/BingoCard;", "", "tags", "Lme/jfenn/bingo/common/card/filter/ObjectiveFilter;", "filter", "getFilterTag", "(Ljava/util/Map;Lme/jfenn/bingo/common/card/filter/ObjectiveFilter;)Lme/jfenn/bingo/common/card/tag/TagData;", "Lme/jfenn/bingo/common/card/filter/ObjectiveFilterList;", "filterList", "getTierLists", "(Lme/jfenn/bingo/common/card/filter/ObjectiveFilterList;)Ljava/util/Map;", "", "assembleTierList", "(Ljava/util/Map;Lme/jfenn/bingo/common/card/filter/ObjectiveFilterList;)Lme/jfenn/bingo/common/card/tierlist/TierListConfig;", "dist", "minItems", "Lme/jfenn/bingo/common/card/CardService$GeneratedObjective;", "generateObjectives", "(JLme/jfenn/bingo/common/options/BingoCardOptions;Ljava/util/Set;Ljava/util/List;I)Ljava/util/List;", "Ljava/util/UUID;", "id", "generate", "(Ljava/util/UUID;JLme/jfenn/bingo/common/options/BingoCardOptions;Ljava/util/Set;)Lme/jfenn/bingo/common/card/BingoCard;", "entries", "assignTileNames", "(Ljava/util/List;)V", "objectiveType", "Lme/jfenn/bingo/common/card/CardGeneratorState;", "objectives", "createObjectives", "(Ljava/lang/String;Ljava/lang/String;Lme/jfenn/bingo/common/card/CardGeneratorState;Ljava/util/Map;)Ljava/util/Map;", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/config/ConfigService;", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/card/tag/TagService;", "Lme/jfenn/bingo/common/card/objective/BingoObjectiveManager;", "Lme/jfenn/bingo/common/card/TagExpansionService;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/common/utils/CacheDelegateArg;", "supportedObjectiveIds", "Lme/jfenn/bingo/common/utils/CacheDelegateArg;", "GeneratedObjective", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nCardService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardService.kt\nme/jfenn/bingo/common/card/CardService\n+ 2 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logging.kt\nme/jfenn/bingo/common/card/objective/LoggingKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 8 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,647:1\n65#2:648\n774#3:649\n865#3,2:650\n1869#3,2:652\n774#3:654\n865#3,2:655\n1869#3,2:657\n1563#3:672\n1634#3,3:673\n1374#3:679\n1460#3,5:680\n1563#3:685\n1634#3,3:686\n1740#3,3:689\n1761#3,3:692\n1969#3,14:695\n1563#3:709\n1634#3,2:710\n1788#3,4:712\n1636#3:716\n1252#3,4:719\n808#3,11:723\n1761#3,3:734\n808#3,11:740\n1761#3,3:751\n808#3,11:761\n1761#3,3:772\n808#3,11:775\n1761#3,3:786\n1869#3,2:797\n827#3:799\n855#3,2:800\n1563#3:802\n1634#3,3:803\n2756#3:806\n1563#3:808\n1634#3,3:809\n1761#3,3:812\n774#3:815\n865#3,2:816\n1617#3,9:818\n1869#3:827\n1870#3:829\n1626#3:830\n808#3,11:831\n1617#3,9:842\n1869#3:851\n1870#3:853\n1626#3:854\n1563#3:855\n1634#3,3:856\n1563#3:859\n1634#3,3:860\n774#3:863\n865#3,2:864\n808#3,11:866\n1617#3,9:877\n1869#3:886\n1563#3:887\n1634#3,3:888\n1870#3:892\n1626#3:893\n1563#3:894\n1634#3,3:895\n1374#3:898\n1460#3,5:899\n1878#3,3:904\n1617#3,9:914\n1869#3:923\n1870#3:925\n1626#3:926\n1563#3:927\n1634#3,3:928\n1761#3,3:932\n1761#3,3:935\n1374#3:938\n1460#3,5:939\n774#3:944\n865#3,2:945\n1761#3,3:947\n774#3:950\n865#3,2:951\n1374#3:953\n1460#3,5:954\n2746#3,3:959\n33#4,2:659\n35#4,4:663\n33#4,2:667\n35#4:671\n37#4,2:676\n33#4,2:907\n35#4,3:911\n38#4:931\n13472#5,2:661\n13472#5,2:669\n13472#5,2:909\n1#6:678\n1#6:807\n1#6:828\n1#6:852\n1#6:891\n1#6:924\n463#7:717\n413#7:718\n561#7:737\n546#7,2:738\n548#7,4:754\n536#7:758\n521#7,2:759\n523#7,4:789\n126#8:793\n153#8,3:794\n*S KotlinDebug\n*F\n+ 1 CardService.kt\nme/jfenn/bingo/common/card/CardService\n*L\n45#1:648\n51#1:649\n51#1:650,2\n52#1:652,2\n54#1:654\n54#1:655,2\n55#1:657,2\n86#1:672\n86#1:673,3\n129#1:679\n129#1:680,5\n130#1:685\n130#1:686,3\n139#1:689,3\n160#1:692,3\n263#1:695,14\n267#1:709\n267#1:710,2\n267#1:712,4\n267#1:716\n289#1:719,4\n330#1:723,11\n331#1:734,3\n336#1:740,11\n337#1:751,3\n342#1:761,11\n343#1:772,3\n344#1:775,11\n345#1:786,3\n363#1:797,2\n370#1:799\n370#1:800,2\n371#1:802\n371#1:803,3\n372#1:806\n377#1:808\n377#1:809,3\n387#1:812,3\n391#1:815\n391#1:816,2\n392#1:818,9\n392#1:827\n392#1:829\n392#1:830\n395#1:831,11\n396#1:842,9\n396#1:851\n396#1:853\n396#1:854\n447#1:855\n447#1:856,3\n449#1:859\n449#1:860,3\n464#1:863\n464#1:864,2\n475#1:866,11\n476#1:877,9\n476#1:886\n481#1:887\n481#1:888,3\n476#1:892\n476#1:893\n595#1:894\n595#1:895,3\n598#1:898\n598#1:899,5\n607#1:904,3\n628#1:914,9\n628#1:923\n628#1:925\n628#1:926\n631#1:927\n631#1:928,3\n406#1:932,3\n407#1:935,3\n498#1:938\n498#1:939,5\n499#1:944\n499#1:945,2\n500#1:947,3\n516#1:950\n516#1:951,2\n522#1:953\n522#1:954,5\n549#1:959,3\n58#1:659,2\n58#1:663,4\n76#1:667,2\n76#1:671\n76#1:676,2\n622#1:907,2\n622#1:911,3\n622#1:931\n58#1:661,2\n76#1:669,2\n622#1:909,2\n372#1:807\n392#1:828\n396#1:852\n476#1:891\n628#1:924\n289#1:717\n289#1:718\n335#1:737\n335#1:738,2\n335#1:754,4\n339#1:758\n339#1:759,2\n339#1:789,4\n360#1:793\n360#1:794,3\n*E\n"})
public final class CardService {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final ScopedData data;
    @NotNull
    private final TagService tagService;
    @NotNull
    private final BingoObjectiveManager objectiveManager;
    @NotNull
    private final TagExpansionService tagExpansionService;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final CacheDelegateArg<Set<String>, Unit> supportedObjectiveIds;

    public CardService(@NotNull Logger log, @NotNull BingoState state, @NotNull BingoOptions options, @NotNull ConfigService configService, @NotNull ScopedData data, @NotNull TagService tagService, @NotNull BingoObjectiveManager objectiveManager, @NotNull TagExpansionService tagExpansionService, @NotNull TextProvider text) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tagService, (String)"tagService");
        Intrinsics.checkNotNullParameter((Object)objectiveManager, (String)"objectiveManager");
        Intrinsics.checkNotNullParameter((Object)tagExpansionService, (String)"tagExpansionService");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.log = log;
        this.state = state;
        this.options = options;
        this.configService = configService;
        this.data = data;
        this.tagService = tagService;
        this.objectiveManager = objectiveManager;
        this.tagExpansionService = tagExpansionService;
        this.text = text;
        int $this$seconds$iv = 5;
        boolean $i$f$getSeconds = false;
        Duration duration2 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        this.supportedObjectiveIds = CacheDelegateKt.cacheFor(duration2, arg_0 -> CardService.supportedObjectiveIds$lambda$0(this, arg_0));
    }

    public final void validateLists() {
        Object tag;
        String name2;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.data.getTags().entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            TagData tag2 = (TagData)entry.getValue();
            if (!(Build.INSTANCE.isDebug() || tag2.getShouldValidate())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry $i$f$filterTo2 = (Map.Entry)element$iv;
            boolean bl = false;
            name2 = (String)$i$f$filterTo2.getKey();
            tag = (TagData)$i$f$filterTo2.getValue();
            this.validateTag(name2, (TagData)tag);
        }
        $this$filter$iv = this.data.getTierLists().entrySet();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo2 = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            tag = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            TierListConfig list = (TierListConfig)tag.getValue();
            if (!(Build.INSTANCE.isDebug() || list.getShouldValidate())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl3 = false;
            name2 = (String)entry.getKey();
            TierListConfig list = (TierListConfig)entry.getValue();
            this.validateList(name2, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void validateTag(String name2, TagData tag) {
        int n;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"yet-another-minecraft-bingo:filename", (Object)(name2 + ".json")), TuplesKt.to((Object)"yet-another-minecraft-bingo:debug", (Object)"true")};
        Pair[] params$iv = pairArray;
        boolean $i$f$withMdc = false;
        try {
            Pair[] $this$forEach$iv$iv = params$iv;
            boolean $i$f$forEach = false;
            n = $this$forEach$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                Pair element$iv$iv;
                Pair pair = element$iv$iv = $this$forEach$iv$iv[i];
                boolean bl = false;
                String key$iv = (String)pair.component1();
                String value$iv = (String)pair.component2();
                MDC.pushByKey((String)key$iv, (String)value$iv);
            }
            boolean bl = false;
            this.log.info("[CardService] Validating tag " + name2 + ".json...");
            Set objectiveIds = TagExpansionService.expandItemTags$default(this.tagExpansionService, tag.getValues(), null, 2, null);
            for (String objectiveId : objectiveIds) {
                Map map = CardService.createObjectives$default(this, null, objectiveId, CardGeneratorState.Companion.getDEFAULT(), null, 8, null);
                if (map != null) continue;
                LoggingKt.objectiveError$default(this.log, objectiveId, "Not found", null, false, 12, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Pair[] $this$forEach$iv$iv = params$iv;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv$iv.length;
            for (n = 0; n < n2; ++n) {
                Pair element$iv$iv;
                Pair bl = element$iv$iv = $this$forEach$iv$iv[n];
                boolean bl2 = false;
                String key$iv = (String)bl.component1();
                MDC.popByKey((String)key$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void validateList(String name2, TierListConfig list) {
        int n;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"yet-another-minecraft-bingo:filename", (Object)(name2 + ".tierlist.json")), TuplesKt.to((Object)"yet-another-minecraft-bingo:debug", (Object)"true")};
        Pair[] params$iv = pairArray;
        boolean $i$f$withMdc = false;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Pair[] $this$forEach$iv$iv = params$iv;
            boolean $i$f$forEach = false;
            n = $this$forEach$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                Pair element$iv$iv;
                Pair pair = element$iv$iv = $this$forEach$iv$iv[i];
                boolean bl = false;
                String key$iv = (String)pair.component1();
                String value$iv = (String)pair.component2();
                MDC.pushByKey((String)key$iv, (String)value$iv);
            }
            boolean bl = false;
            this.log.info("[CardService] Validating list " + name2 + ".tierlist.json...");
            TierListConfig it = list.expandTags(this.tagExpansionService);
            boolean bl2 = false;
            Iterable iterable = CollectionsKt.flatten((Iterable)it.getGroups());
            Set set = SetsKt.plus(it.getValues(), (Iterable)SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus(it.getS(), (Iterable)it.getA()), (Iterable)it.getB()), (Iterable)it.getC()), (Iterable)it.getD()));
            boolean $i$f$map = false;
            void var20_33 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void item2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new TierListEntry(null, (String)item2));
            }
            Set listEntries = SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv));
            for (TierListEntry entry : listEntries) {
                Map map = CardService.createObjectives$default(this, entry.getType(), entry.getItem(), CardGeneratorState.Companion.getDEFAULT(), null, 8, null);
                if (map != null) continue;
                LoggingKt.objectiveError$default(this.log, entry.getItem(), "Not found", null, false, 12, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Pair[] $this$forEach$iv$iv = params$iv;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv$iv.length;
            for (n = 0; n < n2; ++n) {
                Pair element$iv$iv;
                Pair bl = element$iv$iv = $this$forEach$iv$iv[n];
                boolean bl4 = false;
                String key$iv = (String)bl.component1();
                MDC.popByKey((String)key$iv);
            }
        }
    }

    public final void createInitialCards() {
        List list;
        this.log.info("[CardService] Generating initial cards from game-options.json");
        this.state.getCards().clear();
        List it = list = this.options.getCards();
        boolean bl = false;
        List list2 = !((Collection)it).isEmpty() && this.options.isValid() ? list : null;
        if (list2 == null) {
            list2 = CollectionsKt.listOf((Object)new BingoCardOptions(null, null, null, false, false, false, false, 127, null));
        }
        List cardOptionsList = list2;
        this.options.setCards(cardOptionsList);
        for (BingoCardOptions cardOptions : cardOptionsList) {
            try {
                BingoCard it2 = this.newCard(cardOptions);
                boolean bl2 = false;
                this.state.pushCardTail(it2);
            }
            catch (Throwable e) {
                this.log.info("[CardService] Cannot create card from config:", e);
            }
        }
        this.state.resetTeamCards();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSupported(@NotNull Function1<? super IText, Unit> err) {
        boolean bl;
        block8: {
            void $this$mapTo$iv$iv;
            Object list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(err, (String)"err");
            Iterable $this$flatMap$iv = this.state.getCards();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BingoCard it = (BingoCard)element$iv$iv;
                boolean bl2 = false;
                list$iv$iv = it.getObjectives().values();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                boolean bl3;
                ObjectiveRequirements objectiveRequirements;
                void objective;
                list$iv$iv = (BingoObjective)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                ObjectiveData objectiveData = objective.getData();
                if (objectiveData != null && (objectiveRequirements = objectiveData.getValidate()) != null) {
                    ObjectiveRequirements it = objectiveRequirements;
                    boolean bl5 = false;
                    IText iText = objective.getDisplay().getName();
                    if (iText == null) {
                        iText = this.text.literal(objective.getId());
                    }
                    IText listName = iText;
                    bl3 = this.checkSoftRequirements(listName, it, err);
                } else {
                    bl3 = true;
                }
                collection.add(bl3);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl6 = false;
                    if (it) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSoftRequirements(IText listName, ObjectiveRequirements reqs, Function1<? super IText, Unit> err) {
        boolean bl;
        Object[] objectArray;
        boolean isSupported;
        block7: {
            isSupported = true;
            List<BingoTeam> teams2 = this.state.getRegisteredTeams();
            objectArray = reqs.getNumTeams();
            int n = objectArray.getFirst();
            int n2 = objectArray.getLast();
            int n3 = teams2.size();
            if (!(n <= n3 ? n3 <= n2 : false)) {
                objectArray = new Object[]{listName, RangeKt.formatString(reqs.getNumTeams()), "/bingo start ignore_warnings"};
                err.invoke((Object)this.text.string(StringKey.CommandStartDataRecommendsNumTeams, objectArray));
                isSupported = false;
            }
            objectArray = reqs.getNumPlayers();
            n = objectArray.getFirst();
            n2 = objectArray.getLast();
            Iterable iterable = teams2;
            int n4 = 0;
            for (Object t : iterable) {
                void it;
                BingoTeam bingoTeam = (BingoTeam)t;
                int n5 = n4;
                boolean bl2 = false;
                int n6 = it.getPlayers().size();
                n4 = n5 + n6;
            }
            n3 = n4;
            if (!(n <= n3 ? n3 <= n2 : false)) {
                objectArray = new Object[]{listName, RangeKt.formatString(reqs.getNumPlayersPerTeam()), "/bingo start ignore_warnings"};
                err.invoke((Object)this.text.string(StringKey.CommandStartDataRecommendsNumPlayers, objectArray));
                isSupported = false;
            }
            Iterable $this$any$iv = teams2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BingoTeam it = (BingoTeam)element$iv;
                    boolean bl3 = false;
                    IntRange intRange = reqs.getNumPlayersPerTeam();
                    int n7 = intRange.getFirst();
                    int n8 = intRange.getLast();
                    int n9 = it.getPlayers().size();
                    boolean bl4 = n7 <= n9 ? n9 <= n8 : false;
                    if (!(!bl4)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            objectArray = new Object[]{listName, RangeKt.formatString(reqs.getNumPlayersPerTeam()), "/bingo start ignore_warnings"};
            err.invoke((Object)this.text.string(StringKey.CommandStartDataRecommendsPlayersPerTeam, objectArray));
            isSupported = false;
        }
        return isSupported;
    }

    @NotNull
    public final BingoCard newCard(@NotNull BingoCardOptions cardOptions) {
        Intrinsics.checkNotNullParameter((Object)cardOptions, (String)"cardOptions");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        BingoCard newCard = CardService.generate$default(this, uUID, Random.Default.nextLong(), cardOptions, null, 8, null);
        return newCard;
    }

    public final void shuffleCard(@NotNull BingoCard card, @NotNull Set<String> excludeObjectives) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Intrinsics.checkNotNullParameter(excludeObjectives, (String)"excludeObjectives");
        if (!card.getOptions().isValid()) {
            throw new IllegalArgumentException("Cannot reroll card; invalid options");
        }
        long newSeed = Random.Default.nextLong();
        BingoCard newCard = this.generate(card.getId(), newSeed, card.getOptions(), excludeObjectives);
        this.objectiveManager.init(newCard);
        this.state.replaceCard(newCard);
    }

    public static /* synthetic */ void shuffleCard$default(CardService cardService, BingoCard bingoCard, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        cardService.shuffleCard(bingoCard, set);
    }

    @NotNull
    public final BingoCard generateCard(@NotNull BingoCard card, @NotNull BingoCardOptions options, long seed) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        BingoCard newCard = CardService.generate$default(this, card.getId(), seed, options, null, 8, null);
        this.state.replaceCard(newCard);
        return newCard;
    }

    public static /* synthetic */ BingoCard generateCard$default(CardService cardService, BingoCard bingoCard, BingoCardOptions bingoCardOptions, long l, int n, Object object) {
        if ((n & 1) != 0) {
            bingoCard = cardService.state.getActiveCard();
        }
        if ((n & 2) != 0) {
            bingoCardOptions = bingoCard.getOptions();
        }
        if ((n & 4) != 0) {
            l = bingoCard.getSeed();
        }
        return cardService.generateCard(bingoCard, bingoCardOptions, l);
    }

    public final void replaceEntry(int x, int y, @NotNull String objectiveId) {
        Intrinsics.checkNotNullParameter((Object)objectiveId, (String)"objectiveId");
        BingoObjective bingoObjective = this.objectiveManager.find(objectiveId, CardGeneratorState.Companion.getDEFAULT());
        if (bingoObjective == null) {
            throw new IllegalArgumentException("Could not find objective '" + objectiveId + "'");
        }
        BingoObjective objective = bingoObjective;
        this.replaceEntry(x, y, objective);
    }

    public final void replaceEntry(int x, int y, @NotNull BingoObjective objective) {
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        BingoCard activeCard = this.state.getActiveCard();
        List entries = CollectionsKt.toMutableList((Collection)activeCard.getEntries());
        entries.set(x + y * 5, new BingoCardEntry(objective.getId(), null, null, null, 8, null));
        Map objectives = new LinkedHashMap();
        for (BingoCardEntry entry : entries) {
            Map objectiveMap;
            if (CardService.createObjectives$default(this, null, entry.getObjectiveId(), CardGeneratorState.Companion.getDEFAULT(), null, 8, null) == null) continue;
            objectives.putAll(objectiveMap);
        }
        for (String key2 : CollectionsKt.toSet((Iterable)objectives.keySet())) {
            BingoObjective it;
            if (activeCard.getObjectives().get(key2) == null) continue;
            boolean bl = false;
            objectives.put(key2, it);
        }
        objectives.put(objective.getId(), objective);
        this.assignTileNames(entries);
        BingoCard newCard = new BingoCard(activeCard.getId(), null, activeCard.getSeed(), entries, objectives, activeCard.getOptions(), 0, 66, null);
        this.state.replaceCard(newCard);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BingoCard replaceEntries(@NotNull BingoCard card, long seed, @NotNull List<BingoCardEntry> replaceEntries, @NotNull Set<String> excludeObjectives) {
        Object $this$count$iv;
        Object object;
        Iterator $this$mapTo$iv$iv;
        void $this$map$iv;
        Object t;
        void $this$maxBy$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Intrinsics.checkNotNullParameter(replaceEntries, (String)"replaceEntries");
        Intrinsics.checkNotNullParameter(excludeObjectives, (String)"excludeObjectives");
        Iterable iterable = CollectionsKt.shuffled((Iterable)CollectionsKt.withIndex((Iterable)((Iterable)TierLabel.getEntries())));
        boolean $i$f$maxByOrThrow22 = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = maxElem$iv;
        } else {
            IndexedValue indexedValue = (IndexedValue)maxElem$iv;
            boolean bl = false;
            int i2 = indexedValue.component1();
            Integer n = (Integer)CollectionsKt.getOrNull(card.getOptions().getItemDistribution(), (int)i2);
            int maxValue$iv = n != null ? n : 0;
            do {
                int v$iv;
                Object e$iv = iterator$iv.next();
                IndexedValue i2 = (IndexedValue)e$iv;
                $i$a$-maxByOrThrow-CardService$replaceEntries$maxTier$1 = false;
                int i3 = i2.component1();
                Integer n2 = (Integer)CollectionsKt.getOrNull(card.getOptions().getItemDistribution(), (int)i3);
                int n3 = v$iv = n2 != null ? n2 : 0;
                if (maxValue$iv >= v$iv) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = maxElem$iv;
        }
        TierLabel maxTier = (TierLabel)((Object)((IndexedValue)t).getValue());
        Iterable $i$f$maxByOrThrow22 = (Iterable)TierLabel.getEntries();
        boolean $i$f$map = false;
        maxElem$iv = $this$map$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator v$iv = $this$mapTo$iv$iv.iterator();
        while (v$iv.hasNext()) {
            int n;
            Object item$iv$iv = v$iv.next();
            TierLabel i3 = (TierLabel)((Object)item$iv$iv);
            object = destination$iv$iv2;
            boolean bl = false;
            $this$count$iv = replaceEntries;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Iterator iterator = $this$count$iv.iterator();
                while (iterator.hasNext()) {
                    void tier;
                    Object element$iv = iterator.next();
                    BingoCardEntry it = (BingoCardEntry)element$iv;
                    boolean bl2 = false;
                    TierLabel tierLabel = it.getTier();
                    if (tierLabel == null) {
                        tierLabel = maxTier;
                    }
                    if (!(tierLabel == tier) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            object.add(n);
        }
        List dist = (List)destination$iv$iv2;
        List replacements = CardService.generateObjectives$default(this, seed, card.getOptions(), SetsKt.plus(excludeObjectives, (Iterable)card.getObjectives().keySet()), dist, 0, 16, null);
        List entries = CollectionsKt.toMutableList((Collection)card.getEntries());
        for (Object destination$iv$iv2 : CollectionsKt.zip((Iterable)replaceEntries, (Iterable)replacements)) {
            BingoCardEntry entry = (BingoCardEntry)destination$iv$iv2.component1();
            GeneratedObjective replacement = (GeneratedObjective)destination$iv$iv2.component2();
            int index = entries.indexOf(entry);
            if (index == -1) continue;
            entries.set(index, replacement.getEntry());
        }
        Map objectives = new LinkedHashMap();
        for (BingoCardEntry entry : entries) {
            Map map;
            Map map2;
            Object v6;
            GeneratedObjective it;
            Object object2;
            block16: {
                object2 = replacements;
                $this$count$iv = object2.iterator();
                while ($this$count$iv.hasNext()) {
                    Object $i$f$count = $this$count$iv.next();
                    it = (GeneratedObjective)$i$f$count;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getEntry(), (Object)entry)) continue;
                    v6 = $i$f$count;
                    break block16;
                }
                v6 = null;
            }
            GeneratedObjective generatedObjective = v6;
            if (generatedObjective != null && (map2 = generatedObjective.getObjectives()) != null) {
                map = map2;
            } else {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                object2 = CardService.createObjectives$default(this, null, entry.getObjectiveId(), CardGeneratorState.Companion.getDEFAULT(), null, 8, null);
                if (object2 == null) continue;
                $this$count$iv = object2;
                boolean $i$f$mapValues = false;
                it = $this$mapValues$iv;
                Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv3;
                    boolean bl = false;
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    object = map3;
                    boolean bl3 = false;
                    String key2 = (String)entry3.getKey();
                    BingoObjective value = (BingoObjective)entry3.getValue();
                    BingoObjective bingoObjective = card.getObjectives().get(key2);
                    if (bingoObjective == null) {
                        bingoObjective = value;
                    }
                    BingoObjective bingoObjective2 = bingoObjective;
                    object.put(k, bingoObjective2);
                }
                map = destination$iv$iv3;
            }
            Map objectiveMap = map;
            objectives.putAll(objectiveMap);
        }
        this.assignTileNames(entries);
        BingoCard newCard = new BingoCard(card.getId(), null, seed, entries, objectives, card.getOptions(), 0, 66, null);
        this.state.replaceCard(newCard);
        return newCard;
    }

    public static /* synthetic */ BingoCard replaceEntries$default(CardService cardService, BingoCard bingoCard, long l, List list, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            l = bingoCard.getSeed() + 1L;
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return cardService.replaceEntries(bingoCard, l, list, set);
    }

    private final TagData getFilterTag(Map<String, TagData> tags, ObjectiveFilter filter) {
        TagData tagData = tags.get(filter.getTag());
        if (tagData == null) {
            CardService $this$getFilterTag_u24lambda_u2423 = this;
            boolean bl = false;
            if (!$this$getFilterTag_u24lambda_u2423.data.getTierLists().containsKey(filter.getTag()) && !Intrinsics.areEqual((Object)filter.getTag(), (Object)"uncategorized")) {
                $this$getFilterTag_u24lambda_u2423.log.error("[CardService] Objective tag '" + filter.getTag() + "' does not exist!");
            }
            tagData = null;
        }
        return tagData;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Map<String, TierListConfig> getTierLists(ObjectiveFilterList filterList) {
        block21: {
            if (this.data.getTierLists().isEmpty()) {
                throw new IllegalStateException("[CardService] Cannot generate a card - tier lists have not been loaded yet!");
            }
            $this$filterIsInstance$iv = filterList;
            $i$f$filterIsInstance = false;
            var5_5 = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterIsInstanceTo = false;
            var8_11 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (var8_11.hasNext()) {
                element$iv$iv = var8_11.next();
                if (!(element$iv$iv instanceof ObjectiveFilter.Include)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$any$iv = (List)destination$iv$iv;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (ObjectiveFilter.Include)element$iv;
                    $i$a$-any-CardService$getTierLists$hasIncludeList$1 = false;
                    if (!this.data.getTierLists().containsKey(it.getTag())) continue;
                    v0 = true;
                    break block21;
                }
                v0 = false;
            }
        }
        hasIncludeList = v0;
        $i$f$any = this.data.getTierLists();
        $i$f$filterNot = false;
        element$iv = $this$filterNot$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterNotTo = false;
        var9_14 = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (var9_14.hasNext()) {
            block22: {
                var11_17 = element$iv$iv = var9_14.next();
                $i$a$-filterNot-CardService$getTierLists$lists$1 = false;
                listName = (String)var11_17.getKey();
                $this$filterIsInstance$iv = filterList;
                $i$f$filterIsInstance = false;
                var16_22 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                var19_30 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (var19_30.hasNext()) {
                    element$iv$iv = var19_30.next();
                    if (!(element$iv$iv instanceof ObjectiveFilter.Exclude)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    $this$filterIsInstanceTo$iv$iv = $this$any$iv.iterator();
                    while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                        element$iv /* !! */  = $this$filterIsInstanceTo$iv$iv.next();
                        it = (ObjectiveFilter.Exclude)element$iv /* !! */ ;
                        $i$a$-any-CardService$getTierLists$lists$1$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getTag(), (Object)listName)) continue;
                        v1 = true;
                        break block22;
                    }
                    v1 = false;
                }
            }
            if (v1) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filterNot$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var9_14 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var9_14.hasNext()) {
            block24: {
                block23: {
                    var11_17 = element$iv$iv = var9_14.next();
                    $i$a$-filter-CardService$getTierLists$lists$2 = false;
                    listName = (String)var11_17.getKey();
                    if (!hasIncludeList) ** GOTO lbl-1000
                    $this$filterIsInstance$iv = filterList;
                    $i$f$filterIsInstance = false;
                    $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    $i$a$-any-CardService$getTierLists$lists$1$1 = $this$filterIsInstanceTo$iv$iv.iterator();
                    while ($i$a$-any-CardService$getTierLists$lists$1$1.hasNext()) {
                        element$iv$iv = $i$a$-any-CardService$getTierLists$lists$1$1.next();
                        if (!(element$iv$iv instanceof ObjectiveFilter.Include)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v2 = false;
                    } else {
                        for (E element$iv : $this$any$iv) {
                            it = (ObjectiveFilter.Include)element$iv /* !! */ ;
                            $i$a$-any-CardService$getTierLists$lists$2$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getTag(), (Object)listName)) continue;
                            v2 = true;
                            break block23;
                        }
                        v2 = false;
                    }
                }
                if (v2) ** GOTO lbl-1000
                $this$filterIsInstance$iv = filterList;
                $i$f$filterIsInstance = false;
                $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                $i$a$-any-CardService$getTierLists$lists$2$1 = $this$filterIsInstanceTo$iv$iv.iterator();
                while ($i$a$-any-CardService$getTierLists$lists$2$1.hasNext()) {
                    element$iv$iv = $i$a$-any-CardService$getTierLists$lists$2$1.next();
                    if (!(element$iv$iv instanceof ObjectiveFilter.Count)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v3 = false;
                } else {
                    for (E element$iv : $this$any$iv) {
                        it = (ObjectiveFilter.Count)element$iv /* !! */ ;
                        $i$a$-any-CardService$getTierLists$lists$2$2 = false;
                        if (!Intrinsics.areEqual((Object)it.getTag(), (Object)listName)) continue;
                        v3 = true;
                        break block24;
                    }
                    v3 = false;
                }
            }
            if (v3) lbl-1000:
            // 3 sources

            {
                v4 = true;
            } else {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        lists = destination$iv$iv;
        return lists;
    }

    /*
     * WARNING - void declaration
     */
    private final TierListConfig assembleTierList(Map<String, TagData> tags, ObjectiveFilterList filterList) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object element$iv32;
        boolean bl;
        Collection destination$iv$iv;
        List uncategorizedObjectives;
        TierListConfig tierList;
        block14: {
            void $this$mapTo$iv$iv;
            Map<String, TagData> $this$onEach$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            void $this$forEach$iv;
            Iterator $this$mapTo$iv$iv3;
            Iterable $this$map$iv2;
            Object $this$assembleTierList_u24lambda_u2432 = this;
            boolean bl2 = false;
            TierListConfig list = null;
            list = TierListConfig.Companion.getEMPTY();
            Map<String, TierListConfig> map = ((CardService)$this$assembleTierList_u24lambda_u2432).getTierLists(filterList);
            boolean $i$f$map = false;
            void var10_18 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                String name2 = (String)entry2.getKey();
                TierListConfig otherList = (TierListConfig)entry2.getValue();
                collection.add(otherList.expandTags(((CardService)$this$assembleTierList_u24lambda_u2432).tagExpansionService).expandName(name2));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                TierListConfig it2 = (TierListConfig)element$iv2;
                boolean bl4 = false;
                list = list.combine(it2);
            }
            tierList = list;
            $this$assembleTierList_u24lambda_u2432 = this.supportedObjectiveIds.get(Unit.INSTANCE);
            boolean $i$f$filterNot = false;
            list = $this$filterNot$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it3 = (String)element$iv$iv;
                boolean bl5 = false;
                if (tierList.contains(it3)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv3;
            boolean $i$f$map2 = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String it3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl6 = false;
                collection.add(new TierListEntry(null, (String)it));
            }
            $this$map$iv = (List)destination$iv$iv4;
            boolean $i$f$onEach232 = false;
            void $this$onEach_u24lambda_u2418$iv = $this$mapTo$iv$iv2 = $this$onEach$iv;
            boolean $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv232 = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                TierListEntry it4 = (TierListEntry)element$iv;
                boolean bl7 = false;
                it4.setListName("uncategorized");
            }
            uncategorizedObjectives = (List)$this$mapTo$iv$iv2;
            $this$onEach$iv = tags;
            String $i$f$onEach232 = "uncategorized";
            Object $this$map$iv3 = uncategorizedObjectives;
            boolean $i$f$map3 = false;
            Iterable $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv232 = $this$map$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TierListEntry tierListEntry = (TierListEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add(tierListEntry.getItem());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            boolean bl3 = false;
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            $this$map$iv3 = new TagData(set, bl3, n, defaultConstructorMarker);
            $this$onEach$iv.put($i$f$onEach232, (TagData)$this$map$iv3);
            $this$onEach$iv = tags;
            $i$f$onEach232 = "unobtainable";
            Object object = tags.get("unobtainable");
            if (object == null || (object = ((TagData)object).getValues()) == null) {
                object = SetsKt.emptySet();
            }
            $this$map$iv3 = new TagData(SetsKt.plus((Set)object, (Iterable)this.data.getUnobtainableItems()), false, 2, null);
            $this$onEach$iv.put($i$f$onEach232, (TagData)$this$map$iv3);
            Iterable $this$any$iv = filterList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv32 : $this$any$iv) {
                    ObjectiveFilter it5 = (ObjectiveFilter)element$iv32;
                    boolean bl10 = false;
                    if (!(it5 instanceof ObjectiveFilter.Include)) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        boolean hasIncludeTag = bl;
        Iterable $i$f$any = filterList;
        boolean $i$f$filter = false;
        element$iv32 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ObjectiveFilter objectiveFilter = (ObjectiveFilter)element$iv$iv;
            boolean bl11 = false;
            if (!(objectiveFilter instanceof ObjectiveFilter.Include || objectiveFilter instanceof ObjectiveFilter.Count)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull232 = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TagData it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl12 = false;
            ObjectiveFilter it6 = (ObjectiveFilter)element$iv$iv;
            boolean bl13 = false;
            if (this.getFilterTag(tags, it6) == null) continue;
            boolean bl14 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List includeFilters = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $i$f$mapNotNull232 = filterList;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object t : $this$filterIsInstanceTo$iv$iv) {
            if (!(t instanceof ObjectiveFilter.Exclude)) continue;
            destination$iv$iv4.add(t);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv4;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean bl4 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            TagData it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl15 = false;
            ObjectiveFilter.Exclude it7 = (ObjectiveFilter.Exclude)element$iv$iv;
            boolean bl16 = false;
            if (this.getFilterTag(tags, it7) == null) continue;
            boolean bl17 = false;
            destination$iv$iv5.add(it$iv$iv);
        }
        List excludeFilters = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv5));
        return TierListConfig.copy$default(tierList, false, SetsKt.plus(tierList.getValues(), (Iterable)CollectionsKt.toSet((Iterable)uncategorizedObjectives)), null, null, null, null, null, null, 253, null).filter((Function1<? super TierListEntry, Boolean>)((Function1)arg_0 -> CardService.assembleTierList$lambda$43(hasIncludeTag, includeFilters, excludeFilters, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<GeneratedObjective> generateObjectives(long seed, BingoCardOptions cardOptions, Set<String> excludeObjectives, List<Integer> dist, int minItems) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Set set;
        Iterator it;
        Iterable $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        Iterable iterable;
        List items = new ArrayList();
        if (this.configService.getConfig().getExcludeSpawnKitItemsFromCards()) {
            Collection collection;
            boolean $i$f$mapTo;
            Iterable $this$map$iv;
            boolean $i$f$map;
            Set set2;
            Set $this$generateObjectives_u24lambda_u2446 = set2 = SetsKt.createSetBuilder();
            boolean bl = false;
            if (this.options.isPlayerKit()) {
                Iterable iterable2 = this.data.getSpawnKits().getPlayerKit().getItems();
                iterable = $this$generateObjectives_u24lambda_u2446;
                $i$f$map = false;
                void var15_15 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    IItemStack iItemStack = (IItemStack)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getIdentifier().toString());
                }
                iterable.addAll((List)destination$iv$iv);
            }
            if (this.options.isTeamKit()) {
                $this$map$iv = this.data.getSpawnKits().getTeamKit().getItems();
                iterable = $this$generateObjectives_u24lambda_u2446;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (IItemStack)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getIdentifier().toString());
                }
                iterable.addAll((List)destination$iv$iv);
            }
            if (this.options.isElytra()) {
                $this$generateObjectives_u24lambda_u2446.add("minecraft:elytra");
                $this$generateObjectives_u24lambda_u2446.add("minecraft:firework_rocket");
            }
            set = CollectionsKt.toMutableSet((Iterable)SetsKt.build((Set)set2));
        } else {
            set = new LinkedHashSet();
        }
        Set excludedObjectives = set;
        excludedObjectives.addAll((Collection)excludeObjectives);
        Random random = RandomKt.Random((long)seed);
        CardGeneratorState state = new CardGeneratorState(random);
        this.log.info("[CardService] Using random BINGO card seed: " + seed);
        Map tags = MapsKt.toMutableMap(this.tagService.getTags());
        iterable = cardOptions.getItemFilter();
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            it = (ObjectiveFilter)element$iv$iv;
            boolean bl4 = false;
            if (tags.containsKey(((ObjectiveFilter)((Object)it)).getTag())) {
                bl = true;
            } else {
                this.log.error("[CardService] Tag " + (ObjectiveFilter)((Object)it) + " in filters does not exist!");
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it2 = (List)destination$iv$iv;
        boolean $i$a$-let-CardService$generateObjectives$filterList$32 = false;
        ObjectiveFilterList filterList = new ObjectiveFilterList(it2);
        TierListConfig tierList = this.assembleTierList(tags, filterList);
        Iterable $i$a$-let-CardService$generateObjectives$filterList$32 = filterList;
        boolean $i$f$filterIsInstance = false;
        void $i$f$filterTo22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectiveFilter.Count)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator bl3 = $this$forEach$iv$iv$iv.iterator();
        while (bl3.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl3.next();
            boolean bl = false;
            ObjectiveFilter.Count filter = (ObjectiveFilter.Count)element$iv$iv;
            boolean bl5 = false;
            if (this.getFilterTag(tags, filter) == null) {
                pair = null;
            } else {
                TagData tag;
                void $this$mapTo$iv$iv2;
                int remainingCount = 0;
                remainingCount = filter.getCount();
                Iterable $this$map$iv = dist;
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void distItems;
                    int n = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv3;
                    boolean bl6 = false;
                    int count = RangesKt.coerceAtMost((int)((int)Math.ceil((double)filter.getCount() * (double)distItems / (double)25)), (int)remainingCount);
                    remainingCount -= count;
                    collection.add(count);
                }
                List filterDist = (List)destination$iv$iv3;
                pair = TuplesKt.to((Object)tag, (Object)filterDist);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List requiredTagCounts = (List)destination$iv$iv2;
        Iterator iterator = ((Iterable)TierLabel.getEntries()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int tierIndex = n++;
            TierLabel tier = (TierLabel)((Object)iterator.next());
            int tierCountRemaining = 0;
            tierCountRemaining = ((Number)dist.get(tierIndex)).intValue();
            for (Pair $i$f$forEach2 : CollectionsKt.shuffled((Iterable)requiredTagCounts, (Random)random)) {
                TagData tag = (TagData)$i$f$forEach2.component1();
                List count = (List)$i$f$forEach2.component2();
                int itemCount = RangesKt.coerceAtMost((int)((Number)count.get(tierIndex)).intValue(), (int)tierCountRemaining);
                List it3 = SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.take((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(tierList.pick(tier, excludedObjectives, random), arg_0 -> CardService.generateObjectives$lambda$56(tag, arg_0)), arg_0 -> CardService.generateObjectives$lambda$57(this, state, excludedObjectives, arg_0)), (int)itemCount), arg_0 -> CardService.generateObjectives$lambda$58(excludedObjectives, tierList, arg_0)));
                boolean bl = false;
                items.addAll(it3);
                tierCountRemaining -= it3.size();
            }
            List it4 = SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.take((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(tierList.pick(tier, excludedObjectives, random), arg_0 -> CardService.generateObjectives$lambda$61(requiredTagCounts, arg_0)), arg_0 -> CardService.generateObjectives$lambda$62(this, state, excludedObjectives, arg_0)), (int)tierCountRemaining), arg_0 -> CardService.generateObjectives$lambda$63(excludedObjectives, tierList, arg_0)));
            boolean bl = false;
            items.addAll(it4);
            tierCountRemaining -= it4.size();
        }
        if (items.size() < CollectionsKt.sumOfInt((Iterable)dist)) {
            this.log.error("Card has generated with " + items.size() + " entries, when the item distribution needed " + CollectionsKt.sumOfInt((Iterable)dist) + "!");
            this.log.error("This might be caused by a small tier list or too many item groups in the configuration...");
        }
        while (items.size() < minItems) {
            items.add(GeneratedObjective.Companion.freeSpace());
        }
        CollectionsKt.shuffle((List)items, (Random)random);
        return CollectionsKt.take((Iterable)items, (int)minItems);
    }

    static /* synthetic */ List generateObjectives$default(CardService cardService, long l, BingoCardOptions bingoCardOptions, Set set, List list, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = CollectionsKt.sumOfInt((Iterable)list);
        }
        return cardService.generateObjectives(l, bingoCardOptions, set, list, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BingoCard generate(@NotNull UUID id, long seed, @NotNull BingoCardOptions cardOptions, @NotNull Set<String> excludeObjectives) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void it;
        GeneratedObjective it2;
        Collection<BingoCardEntry> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)cardOptions, (String)"cardOptions");
        Intrinsics.checkNotNullParameter(excludeObjectives, (String)"excludeObjectives");
        cardOptions.assertValid();
        List<GeneratedObjective> generatedObjectives = this.generateObjectives(seed, cardOptions, excludeObjectives, cardOptions.getItemDistribution(), 25);
        Iterable iterable = generatedObjectives;
        long l = seed;
        UUID uUID = null;
        UUID uUID2 = id;
        boolean $i$f$map22 = false;
        void var9_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GeneratedObjective generatedObjective = (GeneratedObjective)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getEntry());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        Collection<BingoCardEntry> $i$f$map22 = $this$map$iv;
        boolean $i$a$-also-CardService$generate$32 = false;
        this.assignTileNames((List<BingoCardEntry>)it);
        collection = Unit.INSTANCE;
        Collection<BingoCardEntry> collection2 = $this$map$iv;
        $this$map$iv = generatedObjectives;
        collection = collection2;
        boolean $i$f$flatMap = false;
        void $i$a$-also-CardService$generate$32 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it2 = (GeneratedObjective)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getObjectives().entrySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 66;
        int n2 = 0;
        BingoCardOptions bingoCardOptions = cardOptions;
        Map map = ToMapKt.toMap(list);
        Collection<BingoCardEntry> collection3 = collection;
        long l2 = l;
        UUID uUID3 = uUID;
        UUID uUID4 = uUID2;
        return new BingoCard(uUID4, uUID3, l2, (List)collection3, map, bingoCardOptions, n2, n, defaultConstructorMarker);
    }

    public static /* synthetic */ BingoCard generate$default(CardService cardService, UUID uUID, long l, BingoCardOptions bingoCardOptions, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return cardService.generate(uUID, l, bingoCardOptions, set);
    }

    /*
     * WARNING - void declaration
     */
    private final void assignTileNames(List<BingoCardEntry> entries) {
        char[] cArray = "bingo".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] cols = cArray;
        char[] cArray2 = "12345".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
        char[] rows = cArray2;
        Iterable $this$forEachIndexed$iv = entries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BingoCardEntry bingoCardEntry = (BingoCardEntry)item$iv;
            int i = n;
            boolean bl = false;
            Character col = ArraysKt.getOrNull((char[])cols, (int)(i % 5));
            Character row = ArraysKt.getOrNull((char[])rows, (int)(i / 5));
            if (col == null || row == null) continue;
            entry.setTileName("" + col + row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<String, BingoObjective> createObjectives(String objectiveType, String objectiveId, CardGeneratorState state, Map<String, BingoObjective> objectives) {
        Map<String, BingoObjective> map;
        Set resolvedObjectives;
        BingoObjective objective;
        int n;
        Pair[] params$iv;
        block17: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            BingoObjective bingoObjective;
            block16: {
                Object object;
                block20: {
                    block19: {
                        object = objectiveType;
                        if (object == null) break block19;
                        String it = object;
                        boolean bl = false;
                        String string = it + "!" + objectiveId;
                        object = string;
                        if (string != null) break block20;
                    }
                    object = objectiveId;
                }
                String id = object;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"yet-another-minecraft-bingo:objective", (Object)id)};
                params$iv = pairArray;
                boolean $i$f$withMdc = false;
                Pair[] $this$forEach$iv$iv = params$iv;
                boolean $i$f$forEach = false;
                n = $this$forEach$iv$iv.length;
                for (int i = 0; i < n; ++i) {
                    Pair element$iv$iv;
                    Pair pair = element$iv$iv = $this$forEach$iv$iv[i];
                    boolean bl2 = false;
                    String key$iv = (String)pair.component1();
                    String value$iv = (String)pair.component2();
                    MDC.pushByKey((String)key$iv, (String)value$iv);
                }
                boolean bl = false;
                if (this.objectiveManager.find(id, state) != null) break block16;
                Map<String, BingoObjective> map2 = null;
                for (Pair bl2 : params$iv) {
                    MDC.popByKey((String)((String)bl2.component1()));
                }
                return map2;
            }
            objective = bingoObjective;
            objectives.put(objectiveId, objective);
            Iterable iterable = objective.getDependsOnObjectives();
            boolean $i$f$mapNotNull = false;
            void var21_38 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                BingoObjective bingoObjective2 = objectives.get(it);
                if (bingoObjective2 == null) {
                    Map<String, BingoObjective> map3 = this.createObjectives(null, it, state, objectives);
                    bingoObjective2 = map3 != null ? map3.get(it) : null;
                }
                if (bingoObjective2 == null) continue;
                BingoObjective it$iv$iv = bingoObjective2;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (BingoObjective)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            resolvedObjectives = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (objective.satisfiesDependencies(resolvedObjectives)) break block17;
            LoggingKt.objectiveError$default(this.log, objectiveId, "Could not resolve dependencies", null, false, 12, null);
            Map<String, BingoObjective> map4 = null;
            for (Pair bl2 : params$iv) {
                MDC.popByKey((String)((String)bl2.component1()));
            }
            return map4;
        }
        try {
            if (resolvedObjectives.size() < objective.getDependsOnObjectives().size()) {
                LoggingKt.objectiveError$default(this.log, objectiveId, "Only " + resolvedObjectives.size() + " of " + objective.getDependsOnObjectives().size() + " dependencies could be resolved", null, false, 12, null);
            }
            map = objectives;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Pair[] $this$forEach$iv$iv = params$iv;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv$iv.length;
            for (n = 0; n < n2; ++n) {
                Pair element$iv$iv;
                Pair bl2 = element$iv$iv = $this$forEach$iv$iv[n];
                boolean bl = false;
                String key$iv = (String)bl2.component1();
                MDC.popByKey((String)key$iv);
            }
        }
        return map;
    }

    static /* synthetic */ Map createObjectives$default(CardService cardService, String string, String string2, CardGeneratorState cardGeneratorState, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            map = new LinkedHashMap();
        }
        return cardService.createObjectives(string, string2, cardGeneratorState, map);
    }

    private static final Set supportedObjectiveIds$lambda$0(CardService this$0, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        return CollectionsKt.toSet(this$0.objectiveManager.list());
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean assembleTierList$lambda$43(boolean $hasIncludeTag, List $includeFilters, List $excludeFilters, TierListEntry entry) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                if (!$hasIncludeTag) ** GOTO lbl-1000
                $this$any$iv = $includeFilters;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (TagData)element$iv;
                        $i$a$-any-CardService$assembleTierList$2$isIncluded$1 = false;
                        if (!it.contains(entry.getItem())) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = false;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            isIncluded = v1;
            $this$any$iv = $excludeFilters;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (TagData)element$iv;
                    $i$a$-any-CardService$assembleTierList$2$isExcluded$1 = false;
                    if (!it.contains(entry.getItem())) continue;
                    v2 = true;
                    break block9;
                }
                v2 = false;
            }
        }
        isExcluded = v2;
        return isIncluded != false && isExcluded == false;
    }

    /*
     * WARNING - void declaration
     */
    private static final GeneratedObjective generateObjectives$createObjectivePair(CardService this$0, CardGeneratorState state, Set<String> excludedObjectives, TierListEntry entry) {
        boolean bl;
        Map objectiveMap;
        block7: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object it;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Map map = CardService.createObjectives$default(this$0, entry.getType(), entry.getItem(), state, null, 8, null);
            if (map == null) {
                return null;
            }
            objectiveMap = map;
            Iterable iterable = objectiveMap.values();
            boolean $i$f$flatMap = false;
            Iterator iterator = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (BingoObjective)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = ((BingoObjective)it).getConflictsWithObjectives();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl3 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)entry.getItem()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List objectiveConflicts = (List)destination$iv$iv;
            Iterable $this$any$iv = objectiveConflicts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it2 = (String)element$iv;
                    boolean bl4 = false;
                    if (!excludedObjectives.contains(it2)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return new GeneratedObjective(new BingoCardEntry(entry.getItem(), entry.getTierLabel(), entry.getListName(), null, 8, null), objectiveMap);
    }

    /*
     * WARNING - void declaration
     */
    private static final void generateObjectives$addToExcluded(Set<String> excludedObjectives, TierListConfig tierList, GeneratedObjective objective) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        excludedObjectives.add(objective.getEntry().getObjectiveId());
        Iterable $this$filter$iv = tierList.getGroups();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Set group = (Set)element$iv$iv;
            boolean bl = false;
            if (!group.contains(objective.getEntry().getObjectiveId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Set group : (List)destination$iv$iv) {
            excludedObjectives.addAll(group);
        }
        Iterable iterable2 = objective.getObjectives().values();
        Set<String> set = excludedObjectives;
        boolean $i$f$flatMap = false;
        void $i$f$filter22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            BingoObjective it = (BingoObjective)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getConflictsWithObjectives();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        set.addAll((List)destination$iv$iv2);
    }

    private static final boolean generateObjectives$lambda$56(TagData $tag, TierListEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $tag.contains(it.getItem());
    }

    private static final GeneratedObjective generateObjectives$lambda$57(CardService this$0, CardGeneratorState $state, Set $excludedObjectives, TierListEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CardService.generateObjectives$createObjectivePair(this$0, $state, $excludedObjectives, it);
    }

    private static final Unit generateObjectives$lambda$58(Set $excludedObjectives, TierListConfig $tierList, GeneratedObjective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CardService.generateObjectives$addToExcluded($excludedObjectives, $tierList, it);
        return Unit.INSTANCE;
    }

    private static final boolean generateObjectives$lambda$61(List $requiredTagCounts, TierListEntry entry) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Iterable $this$none$iv = $requiredTagCounts;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    TagData tag = (TagData)pair.component1();
                    if (!tag.contains(entry.getItem())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final GeneratedObjective generateObjectives$lambda$62(CardService this$0, CardGeneratorState $state, Set $excludedObjectives, TierListEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CardService.generateObjectives$createObjectivePair(this$0, $state, $excludedObjectives, it);
    }

    private static final Unit generateObjectives$lambda$63(Set $excludedObjectives, TierListConfig $tierList, GeneratedObjective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CardService.generateObjectives$addToExcluded($excludedObjectives, $tierList, it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ0\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u000bR#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\r\u00a8\u0006\u001e"}, d2={"Lme/jfenn/bingo/common/card/CardService$GeneratedObjective;", "", "Lme/jfenn/bingo/common/card/BingoCardEntry;", "entry", "", "", "Lme/jfenn/bingo/common/card/objective/BingoObjective;", "objectives", "<init>", "(Lme/jfenn/bingo/common/card/BingoCardEntry;Ljava/util/Map;)V", "component1", "()Lme/jfenn/bingo/common/card/BingoCardEntry;", "component2", "()Ljava/util/Map;", "copy", "(Lme/jfenn/bingo/common/card/BingoCardEntry;Ljava/util/Map;)Lme/jfenn/bingo/common/card/CardService$GeneratedObjective;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Lme/jfenn/bingo/common/card/BingoCardEntry;", "getEntry", "Ljava/util/Map;", "getObjectives", "Companion", "bingo-common"})
    public static final class GeneratedObjective {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final BingoCardEntry entry;
        @NotNull
        private final Map<String, BingoObjective> objectives;

        public GeneratedObjective(@NotNull BingoCardEntry entry, @NotNull Map<String, ? extends BingoObjective> objectives) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter(objectives, (String)"objectives");
            this.entry = entry;
            this.objectives = objectives;
        }

        @NotNull
        public final BingoCardEntry getEntry() {
            return this.entry;
        }

        @NotNull
        public final Map<String, BingoObjective> getObjectives() {
            return this.objectives;
        }

        @NotNull
        public final BingoCardEntry component1() {
            return this.entry;
        }

        @NotNull
        public final Map<String, BingoObjective> component2() {
            return this.objectives;
        }

        @NotNull
        public final GeneratedObjective copy(@NotNull BingoCardEntry entry, @NotNull Map<String, ? extends BingoObjective> objectives) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter(objectives, (String)"objectives");
            return new GeneratedObjective(entry, objectives);
        }

        public static /* synthetic */ GeneratedObjective copy$default(GeneratedObjective generatedObjective, BingoCardEntry bingoCardEntry, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                bingoCardEntry = generatedObjective.entry;
            }
            if ((n & 2) != 0) {
                map = generatedObjective.objectives;
            }
            return generatedObjective.copy(bingoCardEntry, map);
        }

        @NotNull
        public String toString() {
            return "GeneratedObjective(entry=" + this.entry + ", objectives=" + this.objectives + ")";
        }

        public int hashCode() {
            int result = this.entry.hashCode();
            result = result * 31 + ((Object)this.objectives).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GeneratedObjective)) {
                return false;
            }
            GeneratedObjective generatedObjective = (GeneratedObjective)other;
            if (!Intrinsics.areEqual((Object)this.entry, (Object)generatedObjective.entry)) {
                return false;
            }
            return Intrinsics.areEqual(this.objectives, generatedObjective.objectives);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/jfenn/bingo/common/card/CardService$GeneratedObjective$Companion;", "", "<init>", "()V", "Lme/jfenn/bingo/common/card/CardService$GeneratedObjective;", "freeSpace", "()Lme/jfenn/bingo/common/card/CardService$GeneratedObjective;", "bingo-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final GeneratedObjective freeSpace() {
                Companion $this$freeSpace_u24lambda_u240 = this;
                boolean bl = false;
                BingoObjective.FreeSpace freeSpace = new BingoObjective.FreeSpace();
                return new GeneratedObjective(new BingoCardEntry(freeSpace.getId(), null, null, null, 8, null), MapsKt.mapOf((Pair)TuplesKt.to((Object)freeSpace.getId(), (Object)freeSpace)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

