/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.card.objective;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.CardGeneratorState;
import me.jfenn.bingo.common.card.data.CommonKt;
import me.jfenn.bingo.common.card.data.ObjectiveData;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.card.objective.BingoObjectiveCapture;
import me.jfenn.bingo.common.card.objective.IObjectiveManager;
import me.jfenn.bingo.common.card.objective.ObjectiveDisplay;
import me.jfenn.bingo.common.card.objective.ObjectiveDisplayService;
import me.jfenn.bingo.common.card.objective.ObjectiveService;
import me.jfenn.bingo.common.data.ScopedData;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.platform.player.PlayerProfile;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010 R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010!\u00a8\u0006\""}, d2={"Lme/jfenn/bingo/common/card/objective/InverseObjectiveManager;", "Lme/jfenn/bingo/common/card/objective/IObjectiveManager;", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/data/ScopedData;", "data", "Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;", "objectiveDisplayService", "Lme/jfenn/bingo/common/card/objective/ObjectiveService;", "objectiveService", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/data/ScopedData;Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;Lme/jfenn/bingo/common/card/objective/ObjectiveService;Lme/jfenn/bingo/common/text/TextProvider;)V", "", "", "list", "()Ljava/lang/Iterable;", "id", "Lme/jfenn/bingo/common/card/CardGeneratorState;", "Lme/jfenn/bingo/common/card/objective/BingoObjective;", "find", "(Ljava/lang/String;Lme/jfenn/bingo/common/card/CardGeneratorState;)Lme/jfenn/bingo/common/card/objective/BingoObjective;", "Lme/jfenn/bingo/common/card/BingoCard;", "card", "", "init", "(Lme/jfenn/bingo/common/card/BingoCard;)V", "tick", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/data/ScopedData;", "Lme/jfenn/bingo/common/card/objective/ObjectiveDisplayService;", "Lme/jfenn/bingo/common/card/objective/ObjectiveService;", "Lme/jfenn/bingo/common/text/TextProvider;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nInverseObjectiveManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InverseObjectiveManager.kt\nme/jfenn/bingo/common/card/objective/InverseObjectiveManager\n+ 2 BingoCard.kt\nme/jfenn/bingo/common/card/BingoCard\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,100:1\n34#2:101\n34#2:113\n808#3,11:102\n808#3,11:114\n2746#3,3:134\n1563#3:137\n1634#3,3:138\n697#4:125\n730#4,4:126\n126#5:130\n153#5,3:131\n*S KotlinDebug\n*F\n+ 1 InverseObjectiveManager.kt\nme/jfenn/bingo/common/card/objective/InverseObjectiveManager\n*L\n41#1:101\n55#1:113\n41#1:102,11\n55#1:114,11\n68#1:134,3\n74#1:137\n74#1:138,3\n75#1:125\n75#1:126,4\n90#1:130\n90#1:131,3\n*E\n"})
public final class InverseObjectiveManager
implements IObjectiveManager {
    @NotNull
    private final BingoState state;
    @NotNull
    private final ScopedData data;
    @NotNull
    private final ObjectiveDisplayService objectiveDisplayService;
    @NotNull
    private final ObjectiveService objectiveService;
    @NotNull
    private final TextProvider text;

    public InverseObjectiveManager(@NotNull BingoState state, @NotNull ScopedData data, @NotNull ObjectiveDisplayService objectiveDisplayService, @NotNull ObjectiveService objectiveService, @NotNull TextProvider text) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)objectiveDisplayService, (String)"objectiveDisplayService");
        Intrinsics.checkNotNullParameter((Object)objectiveService, (String)"objectiveService");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.state = state;
        this.data = data;
        this.objectiveDisplayService = objectiveDisplayService;
        this.objectiveService = objectiveService;
        this.text = text;
    }

    @Override
    @NotNull
    public Iterable<String> list() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(CommonKt.getRootObjectives(this.data.getObjectives()), InverseObjectiveManager::list$lambda$0), InverseObjectiveManager::list$lambda$1));
    }

    @Override
    @Nullable
    public BingoObjective find(@NotNull String id, @NotNull CardGeneratorState state) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ObjectiveData objectiveData = this.data.getObjectives().get(id);
        ObjectiveData.Inverse inverse = objectiveData instanceof ObjectiveData.Inverse ? (ObjectiveData.Inverse)objectiveData : null;
        if (inverse == null) {
            return null;
        }
        ObjectiveData.Inverse data = inverse;
        return new BingoObjective.InverseEntry(id, data, data.expandReference(id, data.getObjective()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull BingoCard card) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        BingoCard this_$iv = card;
        boolean $i$f$objectivesByInstance = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getObjectives().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BingoObjective.InverseEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.InverseEntry objective : (List)destination$iv$iv$iv) {
            ObjectiveDisplay.Resolved resolved;
            if (card.getObjectives().get(objective.getInverseObjective()) != null) {
                BingoObjective inverse;
                boolean bl = false;
                Object[] objectArray = new Object[1];
                IText iText = inverse.getDisplay().getName();
                if (iText == null) {
                    iText = class_2561.method_43473();
                }
                objectArray[0] = iText;
                resolved = new ObjectiveDisplay.Resolved(this.text.string(StringKey.ObjectiveInverse, objectArray), null, inverse.getDisplay().getItem(), CardTile.Decoration.FORBIDDEN, null, 18, null);
            } else {
                resolved = ObjectiveDisplay.Resolved.Companion.getEMPTY();
            }
            ObjectiveDisplay.Resolved display2 = resolved;
            objective.setDisplay(ObjectiveDisplayService.resolve$default(this.objectiveDisplayService, objective.getId(), objective.getData().getDisplay(), display2, null, 8, null));
        }
    }

    /*
     * Could not resolve type clashes
     * WARNING - void declaration
     */
    @Override
    public void tick(@NotNull BingoCard card) {
        Sequence $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        BingoCard this_$iv = card;
        boolean $i$f$objectivesByInstance = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getObjectives().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BingoObjective.InverseEntry)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        for (BingoObjective.InverseEntry objective : (List)destination$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            Object team;
            Object object;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            BingoObjective inverse;
            if (card.getObjectives().get(objective.getInverseObjective()) == null) continue;
            this.objectiveService.updateTeamsOnceAchieved(objective);
            if (objective.getPermanent()) {
                objective.getPlayersOnceAchieved().addAll((Collection<UUID>)inverse.getPlayersHolding().keySet());
            }
            Sequence teamsAchieved = SequencesKt.filter(this.objectiveService.getTeams(card), arg_0 -> InverseObjectiveManager.tick$lambda$4(inverse, objective, arg_0));
            $this$filterIsInstanceTo$iv$iv$iv = SequencesKt.flatMapIterable((Sequence)teamsAchieved, InverseObjectiveManager::tick$lambda$6);
            boolean $i$f$associateBy = false;
            void $i$f$filterIsInstanceTo2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Object object2 = (Pair)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                PlayerProfile player = (PlayerProfile)object2.component2();
                object2 = (Pair)element$iv$iv;
                UUID uUID = player.getUuid();
                boolean bl2 = false;
                team = (BingoTeam)object2.component1();
                PlayerProfile player2 = (PlayerProfile)object2.component2();
                String string = ((BingoTeam)team).getKey-zo6Dpdc();
                Instant instant = this.state.getStartedAt();
                if (instant == null) {
                    instant = Instant.MIN;
                }
                Instant instant2 = instant;
                Intrinsics.checkNotNull((Object)instant2);
                BingoObjectiveCapture bingoObjectiveCapture = new BingoObjectiveCapture(string, player2, instant2, null);
                object.put(uUID, bingoObjectiveCapture);
            }
            Map playersHolding = destination$iv$iv;
            objective.setTeamsSeen(inverse.getTeamsSeen());
            Map<UUID, BingoObjectiveCapture> players = objective.getPlayersHolding();
            Map<UUID, BingoObjectiveCapture> $this$map$iv = objective.getPlayersHolding();
            boolean $i$f$map = false;
            Map<UUID, BingoObjectiveCapture> $i$f$associateByTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                void it;
                team = item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(BingoTeamKey.box-impl(((BingoObjectiveCapture)it.getValue()).getTeam-zo6Dpdc()));
            }
            Set teams2 = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
            ObjectiveService.update$default(this.objectiveService, objective, playersHolding, players, null, teams2, 8, null);
        }
    }

    @Override
    @NotNull
    public Iterable<String> listExcludedIds() {
        return IObjectiveManager.DefaultImpls.listExcludedIds(this);
    }

    private static final boolean list$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ObjectiveData it = (ObjectiveData)entry.getValue();
        return it instanceof ObjectiveData.Inverse;
    }

    private static final String list$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getKey();
    }

    private static final boolean tick$lambda$4(BingoObjective $inverse, BingoObjective.InverseEntry $objective, BingoTeam team) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)team, (String)"team");
            Iterable $this$none$iv = team.getPlayers();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    PlayerProfile player = (PlayerProfile)element$iv;
                    boolean bl2 = false;
                    if (!($inverse.getPlayersHolding().containsKey(player.getUuid()) || $objective.getPlayersOnceAchieved().contains(player.getUuid()))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable tick$lambda$6(BingoTeam team) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        Iterable $this$map$iv = team.getPlayers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PlayerProfile playerProfile = (PlayerProfile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)team, (Object)it));
        }
        return (List)destination$iv$iv;
    }
}

