/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.config;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import me.jfenn.bingo.common.config.ConfigService;
import me.jfenn.bingo.common.config.TrackedFile;
import me.jfenn.bingo.common.utils.JsonKt;
import me.jfenn.bingo.platform.IModEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001!B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ>\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\"\n\b\u0000\u0010\u000e\u0018\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00018\u00002\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0086\b\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0017\u0010\u0018JW\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u00192\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00028\u00000\u0019\u00a2\u0006\u0004\b\u0015\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010 \u00a8\u0006\""}, d2={"Lme/jfenn/bingo/common/config/TrackedFileService;", "", "Lme/jfenn/bingo/common/config/ConfigService;", "configService", "Lme/jfenn/bingo/platform/IModEnvironment;", "environment", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/common/config/ConfigService;Lme/jfenn/bingo/platform/IModEnvironment;Lorg/slf4j/Logger;)V", "", "data", "md5Of", "(Ljava/lang/String;)Ljava/lang/String;", "T", "Ljava/nio/file/Path;", "path", "resource", "Lkotlinx/serialization/json/Json;", "jsonInstance", "Lme/jfenn/bingo/common/config/TrackedFileService$Result;", "readFileOrResource", "(Ljava/nio/file/Path;Ljava/lang/Object;Lkotlinx/serialization/json/Json;)Lme/jfenn/bingo/common/config/TrackedFileService$Result;", "readTextFileOrResource", "(Ljava/nio/file/Path;Ljava/lang/String;)Lme/jfenn/bingo/common/config/TrackedFileService$Result;", "Lkotlin/Function1;", "serialize", "Ljava/io/InputStream;", "deserialize", "(Ljava/nio/file/Path;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lme/jfenn/bingo/common/config/TrackedFileService$Result;", "Lme/jfenn/bingo/common/config/ConfigService;", "Lme/jfenn/bingo/platform/IModEnvironment;", "Lorg/slf4j/Logger;", "Result", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nTrackedFileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackedFileService.kt\nme/jfenn/bingo/common/config/TrackedFileService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class TrackedFileService {
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final IModEnvironment environment;
    @NotNull
    private final Logger log;

    public TrackedFileService(@NotNull ConfigService configService, @NotNull IModEnvironment environment, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.configService = configService;
        this.environment = environment;
        this.log = log;
    }

    private final String md5Of(String data) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] digest = md.digest(byArray);
        String hexDigest = new BigInteger(1, digest).toString(16);
        Intrinsics.checkNotNull((Object)hexDigest);
        return hexDigest;
    }

    public final /* synthetic */ <T> Result<T> readFileOrResource(Path path, T resource, Json jsonInstance) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)jsonInstance, (String)"jsonInstance");
        boolean $i$f$readFileOrResource = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.simple");
        KSerializer serializer2 = SerializersKt.serializer(null);
        Intrinsics.needClassReification();
        Function1 function1 = new Function1<T, String>(jsonInstance, serializer2){
            final /* synthetic */ Json $jsonInstance;
            final /* synthetic */ KSerializer<T> $serializer;
            {
                this.$jsonInstance = $jsonInstance;
                this.$serializer = $serializer;
            }

            public final String invoke(T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$jsonInstance.encodeToString((SerializationStrategy)this.$serializer, it);
            }
        };
        Intrinsics.needClassReification();
        return this.readFileOrResource(path, resource, function1, (Function1)new Function1<InputStream, T>(jsonInstance, serializer2){
            final /* synthetic */ Json $jsonInstance;
            final /* synthetic */ KSerializer<T> $serializer;
            {
                this.$jsonInstance = $jsonInstance;
                this.$serializer = $serializer;
            }

            public final T invoke(InputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (T)JvmStreamsKt.decodeFromStream((Json)this.$jsonInstance, (DeserializationStrategy)((DeserializationStrategy)this.$serializer), (InputStream)it);
            }
        });
    }

    public static /* synthetic */ Result readFileOrResource$default(TrackedFileService $this, Path path, Object resource, Json jsonInstance, int n, Object object) {
        if ((n & 4) != 0) {
            jsonInstance = JsonKt.getJson();
        }
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)jsonInstance, (String)"jsonInstance");
        boolean $i$f$readFileOrResource = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.simple");
        KSerializer serializer2 = SerializersKt.serializer(null);
        Intrinsics.needClassReification();
        Function1 function1 = new /* invalid duplicate definition of identical inner class */;
        Intrinsics.needClassReification();
        return $this.readFileOrResource(path, resource, function1, (Function1)new /* invalid duplicate definition of identical inner class */);
    }

    @NotNull
    public final Result<String> readTextFileOrResource(@NotNull Path path, @Nullable String resource) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.readFileOrResource(path, resource, TrackedFileService::readTextFileOrResource$lambda$0, TrackedFileService::readTextFileOrResource$lambda$2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final <T> Result<T> readFileOrResource(@NotNull Path path, @Nullable T resource, @NotNull Function1<? super T, String> serialize, @NotNull Function1<? super InputStream, ? extends T> deserialize) {
        Result<T> result;
        String fileJson;
        String resourceJson;
        Object fileConfig;
        TrackedFile trackedFile;
        String name2;
        block22: {
            block21: {
                String string;
                Object object;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter(serialize, (String)"serialize");
                Intrinsics.checkNotNullParameter(deserialize, (String)"deserialize");
                name2 = ((Object)this.environment.getConfigDir().resolve("yet-another-minecraft-bingo").relativize(path)).toString();
                trackedFile = this.configService.getFiles().getFilesMap().get(name2);
                File file = path.toFile();
                if (file.exists()) {
                    Object object2;
                    try {
                        Object object3;
                        object2 = new FileInputStream(path.toFile());
                        Throwable throwable = null;
                        try {
                            FileInputStream fileInputStream = (FileInputStream)object2;
                            boolean bl = false;
                            object3 = deserialize.invoke((Object)fileInputStream);
                        }
                        catch (Throwable bl) {
                            throwable = bl;
                            throw bl;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                        }
                        object2 = object3;
                    }
                    catch (Throwable e) {
                        this.log.error("[" + name2 + "] Error reading config:", e);
                        return new Result<Object>(true, null);
                    }
                    object = object2;
                } else {
                    object = null;
                }
                fileConfig = object;
                T t = resource;
                if (t != null) {
                    T t2 = t;
                    boolean bl = false;
                    string = (String)serialize.invoke(t2);
                } else {
                    string = null;
                }
                resourceJson = string;
                Object object4 = fileConfig;
                if (object4 != null) {
                    Object it = object4;
                    boolean bl = false;
                    v4 = (String)serialize.invoke(it);
                } else {
                    v4 = fileJson = null;
                }
                if (resourceJson == null) {
                    if (fileJson == null) return new Result<Object>(true, fileConfig);
                    TrackedFile trackedFile2 = trackedFile;
                    if (!Intrinsics.areEqual((Object)this.md5Of(fileJson), (Object)(trackedFile2 != null ? trackedFile2.getMd5() : null))) return new Result<Object>(true, fileConfig);
                    this.log.warn("[" + name2 + "] Resource no longer exists - removing from config folder!");
                    Files.deleteIfExists(path);
                    this.configService.setFiles(this.configService.getFiles().minus(trackedFile));
                    return new Result<Object>(false, null);
                }
                if (fileConfig == null || fileJson == null) break block21;
                TrackedFile trackedFile3 = trackedFile;
                if (!Intrinsics.areEqual((Object)this.md5Of(fileJson), (Object)(trackedFile3 != null ? trackedFile3.getMd5() : null)) && !Intrinsics.areEqual((Object)this.md5Of(fileJson), (Object)this.md5Of(resourceJson))) break block22;
            }
            this.log.debug("[{}] Applying updates!", (Object)name2);
            Object object = trackedFile;
            if (object == null || (object = ((TrackedFile)object).getCreatedAt()) == null) {
                object = Instant.now();
            }
            Object object5 = object;
            Intrinsics.checkNotNull((Object)object5);
            Object it = object5;
            object5 = this.md5Of(resourceJson);
            TrackedFile trackedFile4 = new TrackedFile(name2, (String)object5, (Instant)it);
            try {
                path.getParent().toFile().mkdirs();
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                FilesKt.writeText$default((File)file, (String)resourceJson, null, (int)2, null);
                this.configService.setFiles(this.configService.getFiles().plus(trackedFile4));
            }
            catch (IOException e) {
                this.log.error("Error writing to " + path + ":", (Throwable)e);
            }
            result = new Result<T>(false, resource);
            return result;
        }
        if (this.log.isDebugEnabled()) {
            TrackedFile trackedFile5 = trackedFile;
            this.log.debug("[" + name2 + "] Skipping - " + (trackedFile5 != null ? trackedFile5.getMd5() : null) + " != " + this.md5Of(fileJson) + " (original = " + this.md5Of(resourceJson) + ")");
        }
        result = new Result<T>(true, fileConfig);
        return result;
    }

    private static final String readTextFileOrResource$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String readTextFileOrResource$lambda$2(InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Closeable closeable = stream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ,\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0000H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000f\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0017\u001a\u0004\b\u0004\u0010\tR\u0019\u0010\u0005\u001a\u0004\u0018\u00018\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lme/jfenn/bingo/common/config/TrackedFileService$Result;", "T", "", "", "isModified", "config", "<init>", "(ZLjava/lang/Object;)V", "component1", "()Z", "component2", "()Ljava/lang/Object;", "copy", "(ZLjava/lang/Object;)Lme/jfenn/bingo/common/config/TrackedFileService$Result;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Z", "Ljava/lang/Object;", "getConfig", "bingo-common"})
    public static final class Result<T> {
        private final boolean isModified;
        @Nullable
        private final T config;

        public Result(boolean isModified, @Nullable T config) {
            this.isModified = isModified;
            this.config = config;
        }

        public final boolean isModified() {
            return this.isModified;
        }

        @Nullable
        public final T getConfig() {
            return this.config;
        }

        public final boolean component1() {
            return this.isModified;
        }

        @Nullable
        public final T component2() {
            return this.config;
        }

        @NotNull
        public final Result<T> copy(boolean isModified, @Nullable T config) {
            return new Result<T>(isModified, config);
        }

        public static /* synthetic */ Result copy$default(Result result, boolean bl, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                bl = result.isModified;
            }
            if ((n & 2) != 0) {
                object = result.config;
            }
            return result.copy(bl, object);
        }

        @NotNull
        public String toString() {
            return "Result(isModified=" + this.isModified + ", config=" + this.config + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isModified);
            result = result * 31 + (this.config == null ? 0 : this.config.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (this.isModified != result.isModified) {
                return false;
            }
            return Intrinsics.areEqual(this.config, result.config);
        }
    }
}

