/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.game;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.commands.CommonKt;
import me.jfenn.bingo.common.game.GameEndReason;
import me.jfenn.bingo.common.game.GameResumeService;
import me.jfenn.bingo.common.game.GameService;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.commands.CommandBuilder;
import me.jfenn.bingo.platform.commands.ICommandManager;
import me.jfenn.bingo.platform.commands.IExecutionContext;
import me.jfenn.bingo.platform.commands.IExecutionSource;
import me.jfenn.bingo.platform.text.IText;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\f\u001a\u00020\u000b*\u00020\b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lme/jfenn/bingo/common/game/GameCommands;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/platform/commands/ICommandManager;", "commandManager", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "<init>", "(Lme/jfenn/bingo/platform/commands/ICommandManager;Lme/jfenn/bingo/common/text/TextProvider;)V", "Lme/jfenn/bingo/platform/commands/IExecutionContext;", "", "ignoreWarnings", "", "start", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;Z)V", "Lme/jfenn/bingo/common/text/TextProvider;", "Companion", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nGameCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameCommands.kt\nme/jfenn/bingo/common/game/GameCommands\n+ 2 Scope.kt\norg/koin/core/scope/Scope\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n132#2,5:100\n132#2,5:105\n132#2,5:113\n132#2,5:118\n132#2,5:123\n132#2,5:128\n1878#3,3:110\n*S KotlinDebug\n*F\n+ 1 GameCommands.kt\nme/jfenn/bingo/common/game/GameCommands\n*L\n23#1:100,5\n25#1:105,5\n62#1:113,5\n63#1:118,5\n80#1:123,5\n84#1:128,5\n34#1:110,3\n*E\n"})
public final class GameCommands
extends BingoComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextProvider text;
    @NotNull
    public static final String START_COMMAND = "/bingo start";
    @NotNull
    public static final String IGNORE_WARNINGS_COMMAND = "/bingo start ignore_warnings";
    @NotNull
    public static final String END_COMMAND = "/bingo end";
    @NotNull
    public static final String RESUME_COMMAND = "/bingo resume";

    public GameCommands(@NotNull ICommandManager commandManager, @NotNull TextProvider text) {
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        commandManager.register("bingo", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> GameCommands._init_$lambda$13(this, arg_0)));
    }

    private final void start(IExecutionContext $this$start, boolean ignoreWarnings) {
        Scope $this$iv = $this$start.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        GameService gameService = (GameService)$this$iv.get(Reflection.getOrCreateKotlinClass(GameService.class), qualifier$iv, parameters$iv);
        $this$iv = $this$start.getScope();
        qualifier$iv = null;
        parameters$iv = null;
        $i$f$get = false;
        ((IExecutors.IServerTaskExecutor)$this$iv.get(Reflection.getOrCreateKotlinClass(IExecutors.IServerTaskExecutor.class), qualifier$iv, parameters$iv)).execute(() -> GameCommands.start$lambda$1(gameService, ignoreWarnings, $this$start, this));
        $this$start.sendFeedback(this.text.string(StringKey.CommandStartSuccess));
    }

    /*
     * WARNING - void declaration
     */
    private static final void start$lambda$1(GameService $gameService, boolean $ignoreWarnings, IExecutionContext $this_start, GameCommands this$0) {
        List warnings = new ArrayList();
        $gameService.start(warnings, $ignoreWarnings, $ignoreWarnings);
        Iterable $this$forEachIndexed$iv = warnings;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void warning;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IText iText = (IText)item$iv;
            int i = n;
            boolean bl = false;
            $this_start.sendMessage(CommonKt.formatWarning(this$0.text, (IText)warning, i == 0));
        }
    }

    private static final boolean lambda$13$lambda$6$lambda$2(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        GameState[] gameStateArray = new GameState[]{GameState.PREGAME};
        return CommonKt.hasState($this$requires, gameStateArray) && CommonKt.hasPermission($this$requires, Permission.INSTANCE.getCONFIGURE_GAME());
    }

    private static final Unit lambda$13$lambda$6$lambda$3(GameCommands this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.start($this$executes, false);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$13$lambda$6$lambda$5$lambda$4(GameCommands this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.start($this$executes, true);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$13$lambda$6$lambda$5(GameCommands this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> GameCommands.lambda$13$lambda$6$lambda$5$lambda$4(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$13$lambda$6(GameCommands this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)GameCommands::lambda$13$lambda$6$lambda$2));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> GameCommands.lambda$13$lambda$6$lambda$3(this$0, arg_0)));
        $this$literal.literal("ignore_warnings", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> GameCommands.lambda$13$lambda$6$lambda$5(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$13$lambda$9$lambda$7(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        GameState[] gameStateArray = new GameState[]{GameState.PLAYING};
        return CommonKt.hasState($this$requires, gameStateArray) && CommonKt.hasPermission($this$requires, Permission.INSTANCE.getCONFIGURE_GAME());
    }

    private static final Unit lambda$13$lambda$9$lambda$8(GameCommands this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        Scope $this$iv = $this$executes.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        GameService gameService = (GameService)$this$iv.get(Reflection.getOrCreateKotlinClass(GameService.class), qualifier$iv, parameters$iv);
        Scope $this$iv2 = $this$executes.getScope();
        Qualifier qualifier$iv2 = null;
        Function0<? extends ParametersHolder> parameters$iv2 = null;
        boolean $i$f$get2 = false;
        BingoState state = (BingoState)$this$iv2.get(Reflection.getOrCreateKotlinClass(BingoState.class), qualifier$iv2, parameters$iv2);
        state.setForfeit(true);
        IPlayerHandle player = $this$executes.getPlayer();
        IPlayerHandle iPlayerHandle = player;
        String playerName = iPlayerHandle != null ? iPlayerHandle.getPlayerName() : ($this$executes.isConsole() ? "RCON" : "[unknown]");
        gameService.end(new GameEndReason.Command(playerName));
        $this$executes.sendFeedback(this$0.text.string(StringKey.CommandEndSuccess));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$13$lambda$9(GameCommands this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)GameCommands::lambda$13$lambda$9$lambda$7));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> GameCommands.lambda$13$lambda$9$lambda$8(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$13$lambda$12$lambda$10(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        Scope $this$iv = $this$requires.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        GameResumeService resumeService = (GameResumeService)$this$iv.get(Reflection.getOrCreateKotlinClass(GameResumeService.class), qualifier$iv, parameters$iv);
        return resumeService.isResumeAvailable($this$requires.getPlayer());
    }

    private static final Unit lambda$13$lambda$12$lambda$11(GameCommands this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        Scope $this$iv = $this$executes.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        GameResumeService resumeService = (GameResumeService)$this$iv.get(Reflection.getOrCreateKotlinClass(GameResumeService.class), qualifier$iv, parameters$iv);
        resumeService.resume();
        $this$executes.sendFeedback(this$0.text.string(StringKey.CommandResumeSuccess));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$13$lambda$12(GameCommands this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)GameCommands::lambda$13$lambda$12$lambda$10));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> GameCommands.lambda$13$lambda$12$lambda$11(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$13(GameCommands this$0, CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.literal("start", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> GameCommands.lambda$13$lambda$6(this$0, arg_0)));
        $this$register.literal("end", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> GameCommands.lambda$13$lambda$9(this$0, arg_0)));
        $this$register.literal("resume", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> GameCommands.lambda$13$lambda$12(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lme/jfenn/bingo/common/game/GameCommands$Companion;", "", "<init>", "()V", "", "START_COMMAND", "Ljava/lang/String;", "IGNORE_WARNINGS_COMMAND", "END_COMMAND", "RESUME_COMMAND", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

