/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.infobook;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.PlayerSettingsEvent;
import me.jfenn.bingo.common.infobook.InfoBookService;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.event.model.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0010R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0011R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0012R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lme/jfenn/bingo/common/infobook/InfoBookController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/infobook/InfoBookService;", "bookService", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/infobook/InfoBookService;Lme/jfenn/bingo/platform/IPlayerManager;)V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/infobook/InfoBookService;", "Lme/jfenn/bingo/platform/IPlayerManager;", "bingo-common"})
public final class InfoBookController
extends BingoComponent {
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final InfoBookService bookService;
    @NotNull
    private final IPlayerManager playerManager;

    public InfoBookController(@NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull BingoState state, @NotNull BingoConfig config, @NotNull InfoBookService bookService, @NotNull IPlayerManager playerManager) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)bookService, (String)"bookService");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        this.state = state;
        this.config = config;
        this.bookService = bookService;
        this.playerManager = playerManager;
        events.onGameTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> InfoBookController._init_$lambda$0(this, arg_0)));
        eventBus.register(PlayerSettingsEvent.Companion, arg_0 -> InfoBookController._init_$lambda$1(this, arg_0));
        events.onPlayerChannelRegister((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> InfoBookController._init_$lambda$2(this, arg_0)));
    }

    private static final Unit _init_$lambda$0(InfoBookController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.state.getState() != GameState.PREGAME) {
            return Unit.INSTANCE;
        }
        if (!this$0.config.getLobbyTutorialBook()) {
            return Unit.INSTANCE;
        }
        if (!this$0.state.isLobbyMode()) {
            return Unit.INSTANCE;
        }
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            this$0.bookService.giveBookItem(player);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(InfoBookController this$0, PlayerSettingsEvent playerSettingsEvent) {
        Intrinsics.checkNotNullParameter((Object)playerSettingsEvent, (String)"<destruct>");
        IPlayerHandle player = playerSettingsEvent.component1();
        this$0.bookService.updateBookItem(player);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(InfoBookController this$0, PlayerEvent playerEvent) {
        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
        IPlayerHandle player = playerEvent.component1();
        this$0.bookService.updateBookItem(player);
        return Unit.INSTANCE;
    }
}

