/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.map;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.card.BingoCard;
import me.jfenn.bingo.common.card.BingoCardEntry;
import me.jfenn.bingo.common.card.CardScreenHandler;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.card.tierlist.TierLabel;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.map.BingoMap;
import me.jfenn.bingo.common.map.CardDisplay;
import me.jfenn.bingo.common.map.CardDisplayPacket;
import me.jfenn.bingo.common.map.CardResetPacket;
import me.jfenn.bingo.common.map.CardShuffledPacket;
import me.jfenn.bingo.common.map.CardTile;
import me.jfenn.bingo.common.map.CardTileAction;
import me.jfenn.bingo.common.map.CardTileImage;
import me.jfenn.bingo.common.map.CardTilesPacket;
import me.jfenn.bingo.common.map.CardUpdatePacket;
import me.jfenn.bingo.common.map.CardView;
import me.jfenn.bingo.common.map.MapRenderService;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IMapService;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.item.IItemStackFactory;
import me.jfenn.bingo.platform.player.PlayerProfile;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0000\u0018\u0000 [2\u00020\u0001:\u0001[Bg\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010\"\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\"\u0010#J-\u0010(\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001c2\u0014\u0010'\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020&0$H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010,\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\b,\u0010-J\u0015\u00100\u001a\u00020!2\u0006\u0010/\u001a\u00020.\u00a2\u0006\u0004\b0\u00101J\u0015\u00102\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b2\u0010#J\u0015\u00103\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b3\u0010 J\u001d\u00106\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00105\u001a\u000204\u00a2\u0006\u0004\b6\u00107J\u0015\u00108\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b8\u0010 J\u001f\u00109\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u00105\u001a\u0004\u0018\u000104\u00a2\u0006\u0004\b9\u00107J\u0017\u0010;\u001a\u00020:2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0004\b;\u0010<J1\u0010C\u001a\u00020B2\b\u00105\u001a\u0004\u0018\u0001042\u0006\u0010>\u001a\u00020=2\u0006\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020:H\u0002\u00a2\u0006\u0004\bC\u0010DJ#\u0010G\u001a\u00020F2\b\u00105\u001a\u0004\u0018\u0001042\b\b\u0002\u0010E\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\bG\u0010HJ\u0019\u0010I\u001a\u00020*2\b\u00105\u001a\u0004\u0018\u000104H\u0002\u00a2\u0006\u0004\bI\u0010JJ!\u0010L\u001a\u00020!2\b\u00105\u001a\u0004\u0018\u0001042\b\b\u0002\u0010K\u001a\u00020\u001e\u00a2\u0006\u0004\bL\u0010MJ\u0015\u0010N\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\bN\u0010#R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010OR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010PR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010QR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010RR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010SR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010TR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010UR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010VR\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010WR\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010XR\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010YR\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010Z\u00a8\u0006\\"}, d2={"Lme/jfenn/bingo/common/map/CardViewService;", "", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/platform/IMapService;", "mapService", "Lme/jfenn/bingo/common/map/MapRenderService;", "mapRenderService", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "Lme/jfenn/bingo/common/text/TextProvider;", "textProvider", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packets", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "itemStackFactory", "<init>", "(Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/platform/IMapService;Lme/jfenn/bingo/common/map/MapRenderService;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lme/jfenn/bingo/platform/item/IItemStackFactory;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "supportsCardHud", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "", "sendClearDisplayPacket", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "Lme/jfenn/bingo/common/map/CardDisplay;", "displayCards", "sendCardDisplayPacket", "(Lme/jfenn/bingo/platform/IPlayerHandle;Ljava/util/Map;)V", "Lme/jfenn/bingo/common/map/CardView;", "view", "sendEntireCardTilesPacket", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/map/CardView;)V", "Ljava/util/UUID;", "cardId", "sendCardShuffledPacket", "(Ljava/util/UUID;)V", "sendUpdatePackets", "isViewingPreviewCard", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "isViewingTeamCard", "(Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/team/BingoTeam;)Z", "isViewingSpectatorCards", "isViewingCard", "Lme/jfenn/bingo/common/card/BingoCard;", "getPlayerCard", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Lme/jfenn/bingo/common/card/BingoCard;", "Lme/jfenn/bingo/common/card/BingoCardEntry;", "entry", "Lme/jfenn/bingo/common/card/objective/BingoObjective;", "objective", "card", "Lme/jfenn/bingo/common/map/CardTile;", "getTileState", "(Lme/jfenn/bingo/common/team/BingoTeam;Lme/jfenn/bingo/common/card/BingoCardEntry;Lme/jfenn/bingo/common/card/objective/BingoObjective;Lme/jfenn/bingo/common/card/BingoCard;)Lme/jfenn/bingo/common/map/CardTile;", "playerName", "Lme/jfenn/bingo/platform/text/IText;", "getMapName", "(Lme/jfenn/bingo/common/team/BingoTeam;Z)Lme/jfenn/bingo/platform/text/IText;", "getMapView", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/common/map/CardView;", "forceNotFlashing", "updateCard", "(Lme/jfenn/bingo/common/team/BingoTeam;Z)V", "openCard", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/platform/IMapService;", "Lme/jfenn/bingo/common/map/MapRenderService;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lme/jfenn/bingo/platform/item/IItemStackFactory;", "Companion", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nCardViewService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardViewService.kt\nme/jfenn/bingo/common/map/CardViewService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n*L\n1#1,412:1\n1193#2,2:413\n1267#2,4:415\n774#2:419\n865#2,2:420\n774#2:422\n865#2,2:423\n774#2:425\n865#2,2:426\n1617#2,9:428\n1869#2:437\n1870#2:440\n1626#2:441\n1617#2,9:442\n1869#2:451\n1870#2:453\n1626#2:454\n1056#2:455\n1563#2:456\n1634#2,3:457\n774#2:460\n865#2,2:461\n1563#2:463\n1634#2,3:464\n1563#2:467\n1634#2,3:468\n774#2:471\n865#2,2:472\n1563#2:474\n1634#2,3:475\n1285#2,2:478\n1299#2,4:480\n774#2:484\n865#2,2:485\n1#3:438\n1#3:439\n1#3:452\n65#4:487\n*S KotlinDebug\n*F\n+ 1 CardViewService.kt\nme/jfenn/bingo/common/map/CardViewService\n*L\n89#1:413,2\n89#1:415,4\n113#1:419\n113#1:420,2\n119#1:422\n119#1:423,2\n134#1:425\n134#1:426,2\n137#1:428,9\n137#1:437\n137#1:440\n137#1:441\n236#1:442,9\n236#1:451\n236#1:453\n236#1:454\n237#1:455\n246#1:456\n246#1:457,3\n291#1:460\n291#1:461,2\n320#1:463\n320#1:464,3\n341#1:467\n341#1:468,3\n350#1:471\n350#1:472,2\n351#1:474\n351#1:475,3\n362#1:478,2\n362#1:480,4\n371#1:484\n371#1:485,2\n137#1:439\n236#1:452\n45#1:487\n*E\n"})
public final class CardViewService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final BingoState state;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final IMapService mapService;
    @NotNull
    private final MapRenderService mapRenderService;
    @NotNull
    private final IPermissionsApi permissions;
    @NotNull
    private final TextProvider textProvider;
    @NotNull
    private final ServerPacketEvents packets;
    @NotNull
    private final IItemStackFactory itemStackFactory;
    @NotNull
    private static final Duration FLASHING_DURATION;

    public CardViewService(@NotNull MinecraftServer server, @NotNull BingoConfig config, @NotNull BingoOptions options, @NotNull BingoState state, @NotNull IPlayerManager playerManager, @NotNull TeamService teamService, @NotNull IMapService mapService, @NotNull MapRenderService mapRenderService, @NotNull IPermissionsApi permissions, @NotNull TextProvider textProvider, @NotNull ServerPacketEvents packets, @NotNull IItemStackFactory itemStackFactory) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)mapService, (String)"mapService");
        Intrinsics.checkNotNullParameter((Object)mapRenderService, (String)"mapRenderService");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)textProvider, (String)"textProvider");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)itemStackFactory, (String)"itemStackFactory");
        this.server = server;
        this.config = config;
        this.options = options;
        this.state = state;
        this.playerManager = playerManager;
        this.teamService = teamService;
        this.mapService = mapService;
        this.mapRenderService = mapRenderService;
        this.permissions = permissions;
        this.textProvider = textProvider;
        this.packets = packets;
        this.itemStackFactory = itemStackFactory;
    }

    public final boolean supportsCardHud(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.config.getSupportClientHud() && (this.packets.getCardDisplayV1().isSupported(player) || this.packets.getCardDisplayV2().isSupported(player));
    }

    public final void sendClearDisplayPacket(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.packets.getCardResetV1().send(player, new CardResetPacket())) {
            this.sendCardDisplayPacket(player, MapsKt.emptyMap());
        }
    }

    private final void sendCardDisplayPacket(IPlayerHandle player, Map<BingoTeamKey, CardDisplay> displayCards) {
        CardDisplayPacket packet = new CardDisplayPacket(displayCards);
        if (this.packets.getCardDisplayV2().send(player, packet) || this.packets.getCardDisplayV1().send(player, packet)) {
            // empty if block
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendEntireCardTilesPacket(IPlayerHandle player, CardView view) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable iterable = CollectionsKt.withIndex((Iterable)view.getTiles());
        String string = view.getTeamKey-fzvlhXk();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getIndex(), (Object)it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        boolean bl = false;
        Map map = destination$iv$iv;
        String string2 = string;
        CardTilesPacket tilesPacket = new CardTilesPacket(string2, map, bl, defaultConstructorMarker);
        CardUpdatePacket updatePacket = new CardUpdatePacket(view);
        if (this.packets.getCardTilesV2().send(player, tilesPacket) || this.packets.getCardTilesV1().send(player, tilesPacket) || this.packets.getCardUpdateV6().send(player, updatePacket) || this.packets.getCardUpdateV5().send(player, updatePacket) || this.packets.getCardUpdateV4().send(player, updatePacket) || this.packets.getCardUpdateV3().send(player, updatePacket) || this.packets.getCardUpdateV2().send(player, updatePacket)) {
            // empty if block
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendCardShuffledPacket(@NotNull UUID cardId) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        List list = CollectionsKt.createListBuilder();
        List $this$sendCardShuffledPacket_u24lambda_u242 = list;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)this.state.getActiveCard().getId(), (Object)cardId)) {
            $this$sendCardShuffledPacket_u24lambda_u242.add(null);
        }
        Object object = this.state.getRegisteredTeams();
        List list2 = $this$sendCardShuffledPacket_u24lambda_u242;
        boolean $i$f$filter3 = false;
        void var9_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BingoTeam it = (BingoTeam)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it.getCardId(), (Object)cardId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2.addAll((List)destination$iv$iv);
        List affectedTeams = CollectionsKt.build((List)list);
        for (IPlayerHandle player : this.playerManager.getPlayers()) {
            void $this$filterTo$iv$iv2;
            $this$filter$iv = affectedTeams;
            boolean $i$f$filter2 = false;
            Iterable $i$f$filter3 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                BingoTeam it = (BingoTeam)element$iv$iv;
                boolean bl3 = false;
                if (!this.isViewingCard(player, it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List playerTeams = (List)destination$iv$iv2;
            object = playerTeams.iterator();
            while (object.hasNext()) {
                BingoTeam team;
                BingoTeam bingoTeam = team = (BingoTeam)object.next();
                CardShuffledPacket packet = new CardShuffledPacket(bingoTeam != null ? bingoTeam.getKey-zo6Dpdc() : null, null);
                this.packets.getCardShuffledV1().send(player, packet);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void sendUpdatePackets(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.supportsCardHud(player)) {
            return;
        }
        teams = this.state.getRegisteredTeams();
        var4_3 = CollectionsKt.plus((Collection)teams, null);
        $i$f$filter = false;
        var6_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (BingoTeam)element$iv$iv;
            $i$a$-filter-CardViewService$sendUpdatePackets$displayTeams$1 = false;
            if (!this.isViewingCard(player, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        displayTeams = (List)destination$iv$iv;
        isViewingSpectatorCards = displayTeams.size() > 1;
        $this$mapNotNull$iv = displayTeams;
        $i$f$mapNotNull = false;
        $i$f$filterTo = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var13_22 = $this$forEach$iv$iv$iv.iterator();
        while (var13_22.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var13_22.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            team = (BingoTeam)element$iv$iv;
            $i$a$-mapNotNull-CardViewService$sendUpdatePackets$displayCards$1 = false;
            if (team == null) ** GOTO lbl-1000
            it = team;
            $i$a$-let-CardViewService$sendUpdatePackets$displayCards$1$map$1 = false;
            var21_31 = this.teamService.getTeamMap(it);
            if (var21_31 != null) {
                v0 = var21_31;
            } else lbl-1000:
            // 2 sources

            {
                v0 = map = this.state.getPreviewMap(this.mapService);
            }
            if (!((v1 = map.getView()) != null && (v1 = v1.getTiles()) != null ? v1.isEmpty() : false)) {
                CardViewService.updateCard$default(this, team, false, 2, null);
            }
            if (isViewingSpectatorCards) {
                v2 = map.getView();
                v3 = v2 != null && (v2 = v2.getDisplay()) != null ? CardDisplay.copy$default((CardDisplay)v2, null, this.getMapName(team, true), null, 5, null) : null;
            } else {
                v4 = map.getView();
                v3 = display = v4 != null ? v4.getDisplay() : null;
            }
            if (display != null) {
                $i$a$-let-CardViewService$sendUpdatePackets$displayCards$1$1 = false;
                v5 = team;
                v6 = v5 != null ? v5.getKey-zo6Dpdc() : null;
                v7 = new Pair((Object)(v6 != null ? BingoTeamKey.box-impl(v6) : null), (Object)it);
            } else {
                v7 = null;
            }
            if (v7 == null) continue;
            it$iv$iv = v7;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        displayCards = (List)destination$iv$iv;
        this.sendCardDisplayPacket(player, MapsKt.toMap((Iterable)displayCards));
        for (Pair var7_10 : displayCards) {
            v8 = (BingoTeamKey)var7_10.component1();
            key = v8 != null ? v8.unbox-impl() : null;
            display = (CardDisplay)var7_10.component2();
            v9 = key;
            var13_22 = v9 != null ? BingoTeamKey.box-impl(v9) : null;
            var11_17 = this.state.getTeams().get(var13_22);
            if (var11_17 == null) ** GOTO lbl-1000
            it = var11_17;
            $i$a$-let-CardViewService$sendUpdatePackets$map$1 = false;
            var12_19 = this.teamService.getTeamMap((BingoTeam)it);
            if (var12_19 != null) {
                v10 = var12_19;
            } else lbl-1000:
            // 2 sources

            {
                v10 = this.state.getPreviewMap(this.mapService);
            }
            if ((var11_17 = (map = v10).getView()) == null || (var12_20 = CardView.copy-LF857-w$default((CardView)var11_17, null, display, null, 5, null)) == null) continue;
            it = var12_20;
            $i$a$-let-CardViewService$sendUpdatePackets$1 = false;
            this.sendEntireCardTilesPacket(player, (CardView)it);
        }
    }

    public final boolean isViewingPreviewCard(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.state.getState() == GameState.PREGAME && this.options.getShowPreviewCard() && this.state.isLobbyMode() && !this.teamService.isPlaying(player);
    }

    public final boolean isViewingTeamCard(@NotNull IPlayerHandle player, @NotNull BingoTeam team) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)team, (String)"team");
        return (this.state.getState() == GameState.PLAYING || this.options.getShowPreviewCard() && this.state.getState() != GameState.POSTGAME) && team.includesPlayer(player);
    }

    public final boolean isViewingSpectatorCards(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BingoTeam team = this.teamService.getPlayerTeam(player);
        return switch (WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()]) {
            case 1 -> {
                if ((team == null || team.isWinner()) && this.permissions.hasPermission(player, Permission.INSTANCE.getSPECTATOR_VIEW_CARDS())) {
                    yield true;
                }
                yield false;
            }
            case 2 -> true;
            default -> false;
        };
    }

    public final boolean isViewingCard(@NotNull IPlayerHandle player, @Nullable BingoTeam team) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return team == null && this.isViewingPreviewCard(player) || team != null && this.isViewingTeamCard(player, team) || team != null && this.isViewingSpectatorCards(player);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final BingoCard getPlayerCard(@Nullable IPlayerHandle player) {
        BingoCard bingoCard;
        if (player != null) {
            IPlayerHandle it = player;
            boolean bl = false;
            BingoTeam bingoTeam = this.teamService.getPlayerTeam(it);
            if (bingoTeam != null) {
                BingoTeam it2 = bingoTeam;
                boolean bl2 = false;
                BingoCard bingoCard2 = this.state.getCard(it2);
                if (bingoCard2 != null) {
                    bingoCard = bingoCard2;
                    return bingoCard;
                }
            }
        }
        bingoCard = this.state.getActiveCard();
        return bingoCard;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final CardTile getTileState(BingoTeam team, BingoCardEntry entry, BingoObjective objective, BingoCard card) {
        actualCard = this.state.getCard(card.getId());
        v0 = actualCard;
        actualObjective = v0 != null && (v0 = v0.getObjectives()) != null ? (BingoObjective)v0.get(objective.getId()) : null;
        isFreeSpace = objective instanceof BingoObjective.FreeSpace;
        if (!card.getOptions().isHiddenItemsMode() || team != null && objective.hasSeen-DNZx0G4(team.getKey-zo6Dpdc()) || isFreeSpace || this.state.getState() == GameState.POSTGAME) ** GOTO lbl-1000
        v1 = team;
        if (!(v1 != null ? v1.isWinner() : false)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        isHidden = v2;
        isLocked = card.getOptions().isLockoutMode() != false && objective.hasAnyAchieved() != false && team != null && objective.hasAchieved-DNZx0G4(team.getKey-zo6Dpdc()) == false;
        isAchieved = team != null && objective.hasAchieved-DNZx0G4(team.getKey-zo6Dpdc()) != false;
        image = new CardTileImage(isHidden != false ? null : entry.getDisplay().getItem(), isHidden != false ? null : entry.getDisplay().getImage());
        if (objective instanceof BingoObjective.SomeOfEntry) {
            it /* !! */  = var15_12 = ((BingoObjective.SomeOfEntry)objective).getSomeOfObjectives();
            $i$a$-takeIf-CardViewService$getTileState$imageListObjectives$1 = false;
            v3 = var14_23 = (isHidden == false && ArraysKt.contains((Object[])(var18_20 = new CardTile.Decoration[]{CardTile.Decoration.ONE_OF, CardTile.Decoration.MANY_OF}), (Object)objective.getDisplay().getDecoration()) != false) != false ? var15_12 : null;
            if (var14_23 != null) {
                it /* !! */  = var14_23;
                $i$f$mapNotNull = false;
                var18_20 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var23_36 = $this$forEach$iv$iv$iv.iterator();
                while (var23_36.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var23_36.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (String)element$iv$iv;
                    $i$a$-mapNotNull-CardViewService$getTileState$imageListObjectives$2 = false;
                    if (card.getObjectives().get(it) == null) continue;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                $i$f$sortedBy = false;
                v4 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(team){
                    final /* synthetic */ BingoTeam $team$inlined;
                    {
                        this.$team$inlined = bingoTeam;
                    }

                    public final int compare(T a, T b) {
                        boolean bl;
                        boolean bl2;
                        boolean bl3;
                        String it;
                        BingoObjective innerObjective = (BingoObjective)a;
                        boolean bl4 = false;
                        if (this.$team$inlined != null) {
                            it = this.$team$inlined.getKey-zo6Dpdc();
                            bl3 = false;
                            bl2 = innerObjective.hasAchieved-DNZx0G4(it);
                        } else {
                            bl2 = false;
                        }
                        boolean isInnerAchieved = bl2;
                        innerObjective = (BingoObjective)b;
                        Comparable comparable = Integer.valueOf(isInnerAchieved ? 1 : 0);
                        bl4 = false;
                        if (this.$team$inlined != null) {
                            it = this.$team$inlined.getKey-zo6Dpdc();
                            bl3 = false;
                            bl = innerObjective.hasAchieved-DNZx0G4(it);
                        } else {
                            bl = false;
                        }
                        isInnerAchieved = bl;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(isInnerAchieved ? 1 : 0));
                    }
                });
            } else {
                v4 = null;
            }
        } else {
            v4 = imageListObjectives = CollectionsKt.emptyList();
        }
        if (imageListObjectives != null) {
            var14_23 = (Set<String>)imageListObjectives;
            $i$f$map = false;
            $this$sortedBy$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (E item$iv$iv : $this$mapTo$iv$iv) {
                $this$forEach$iv$iv$iv = (BingoObjective)item$iv$iv;
                var38_49 = destination$iv$iv;
                $i$a$-map-CardViewService$getTileState$imageList$1 = false;
                var38_49.add(new CardTileImage(innerObjective.getDisplay().getItem(), innerObjective.getDisplay().getImage()));
            }
            v5 = (List)destination$iv$iv;
        } else {
            v5 = v6 = null;
        }
        if (v5 == null) {
            v6 = imageList = CollectionsKt.emptyList();
        }
        if ((v7 = imageListObjectives) == null || (v7 = (BingoObjective)CollectionsKt.firstOrNull((List)v7)) == null) {
            v7 = objective;
        }
        actionObjective = v7;
        if (actionObjective instanceof BingoObjective.ItemEntry) {
            v8 = ((BingoObjective.ItemEntry)actionObjective).getItemStack();
            if (v8 != null) {
                it = v8;
                $i$a$-let-CardViewService$getTileState$action$1 = false;
                v9 = new CardTileAction.Item(it);
            } else {
                v9 = CardTileAction.None.INSTANCE;
            }
        } else {
            v9 = actionObjective instanceof BingoObjective.AdvancementEntry != false ? (CardTileAction)new CardTileAction.Advancement(((BingoObjective.AdvancementEntry)actionObjective).getAdvancementId()) : (CardTileAction)CardTileAction.None.INSTANCE;
        }
        action = v9;
        v10 = team;
        isFlashing = objective.isFlashing-vRxwntw(v10 != null ? v10.getKey-zo6Dpdc() : null, CardViewService.FLASHING_DURATION);
        var17_19 = objective.getId();
        it = var17_19;
        $i$a$-takeIf-CardViewService$getTileState$1 = false;
        var16_16 = isHidden == false != false ? var17_19 : null;
        it = var19_26 /* !! */  = action;
        $i$a$-takeIf-CardViewService$getTileState$2 = false;
        v11 = isHidden == false != false ? var19_26 /* !! */  : null;
        if (v11 == null) {
            v11 = CardTileAction.None.INSTANCE;
        }
        var17_19 = v11;
        it = var19_26 /* !! */  = entry.getTier();
        $i$a$-takeIf-CardViewService$getTileState$3 = false;
        var18_22 /* !! */  = (card.getOptions().isHiddenItemsMode() == false || this.options.getShowHiddenTiers() != false || isHidden == false) != false ? var19_26 /* !! */  : null;
        var20_29 = entry.getDisplay().getName();
        it = var20_29;
        $i$a$-takeIf-CardViewService$getTileState$4 = false;
        var19_26 /* !! */  = isHidden == false != false ? var20_29 : null;
        it = var22_34 /* !! */  = entry.getDisplay().getLore();
        $i$a$-takeIf-CardViewService$getTileState$5 = false;
        v12 = isHidden == false != false ? var22_34 /* !! */  : null;
        if (v12 == null) {
            v12 = CollectionsKt.emptyList();
        }
        var20_29 = v12;
        it = var22_34 /* !! */  = objective.getDisplay().getDecoration();
        $i$a$-takeIf-CardViewService$getTileState$6 = false;
        var21_32 /* !! */  = (isFreeSpace != false || isHidden == false) != false ? var22_34 /* !! */  : null;
        var22_35 = isFlashing != false && this.server.method_3780() / 10 % 2 == 0;
        v13 = isAchieved != false ? 1.0f : (var23_37 = isLocked == false && team != null ? objective.getProgress-DNZx0G4(team.getKey-zo6Dpdc()) : 0.0f);
        if (actualObjective == null) ** GOTO lbl-1000
        it = var26_43 = actualObjective;
        $i$a$-takeIf-CardViewService$getTileState$7 = false;
        v14 = var25_41 = (this.options.getShowCompletedItems() != false && this.state.getState() != GameState.POSTGAME) != false ? var26_43 : null;
        if (var25_41 != null && (var26_43 = var25_41.getTeamsAchieved()) != null && (var27_44 = var26_43.keySet()) != null) {
            it$iv$iv = var27_44;
            $i$f$filter = false;
            var31_51 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = ((BingoTeamKey)element$iv$iv).unbox-impl();
                $i$a$-filter-CardViewService$getTileState$8 = false;
                v15 = team;
                v16 = v15 != null ? v15.getKey-zo6Dpdc() : null;
                if (!((v16 == null ? false : BingoTeamKey.equals-impl0(it, v16)) == false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v17 = (List)destination$iv$iv;
        } else lbl-1000:
        // 2 sources

        {
            v17 = CollectionsKt.emptyList();
        }
        var24_40 = v17;
        return new CardTile(var16_16, image, imageList, (CardTileAction)var17_19, (TierLabel)var18_22 /* !! */ , (IText)var19_26 /* !! */ , (List<? extends IText>)var20_29, (CardTile.Decoration)var21_32 /* !! */ , isHidden, isLocked, var22_35, isFlashing, isAchieved, var23_37, var24_40);
    }

    private final IText getMapName(BingoTeam team, boolean playerName) {
        IText iText;
        IText iText2;
        return team != null && (iText2 = team.getName(this.textProvider, playerName, false, false, StringKey.CardTeamCardTitle)) != null && (iText = iText2.resetStyle()) != null ? iText : this.textProvider.string(StringKey.CardPreviewCard);
    }

    static /* synthetic */ IText getMapName$default(CardViewService cardViewService, BingoTeam bingoTeam, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return cardViewService.getMapName(bingoTeam, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final CardView getMapView(BingoTeam team) {
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BingoTeam it;
        Object object;
        block9: {
            block8: {
                object = team;
                if (object == null) break block8;
                it = object;
                boolean bl = false;
                BingoCard bingoCard = this.state.getCard(it);
                object = bingoCard;
                if (bingoCard != null) break block9;
            }
            object = this.state.getActiveCard();
        }
        Object card = object;
        BingoTeam bingoTeam = team;
        String string = bingoTeam != null ? bingoTeam.getKey-zo6Dpdc() : null;
        BingoTeam bingoTeam2 = team;
        Object object2 = bingoTeam2 != null ? bingoTeam2.getMapColor() : null;
        IText iText = CardViewService.getMapName$default(this, team, false, 2, null);
        Object object3 = team;
        if (object3 == null || (object3 = ((BingoTeam)object3).getPlayers()) == null || (object3 = CollectionsKt.toList((Iterable)((Iterable)object3))) == null) {
            object3 = CollectionsKt.emptyList();
        }
        Iterable iterable = ((BingoCard)card).getEntries();
        CardDisplay cardDisplay = new CardDisplay((class_124)object2, iText, (List<PlayerProfile>)object3);
        String string2 = string;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object4;
            block11: {
                block10: {
                    void entry;
                    BingoCardEntry bingoCardEntry = (BingoCardEntry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    BingoObjective goal = ((BingoCard)card).getObjectives().get(entry.getObjectiveId());
                    object4 = goal;
                    if (object4 == null) break block10;
                    BingoObjective it2 = object4;
                    boolean bl2 = false;
                    CardTile cardTile = this.getTileState(team, (BingoCardEntry)entry, it2, (BingoCard)card);
                    object4 = cardTile;
                    if (cardTile != null) break block11;
                }
                object4 = CardTile.Companion.getEMPTY();
            }
            collection.add(object4);
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        List list = CollectionsKt.toMutableList((Collection)collection);
        CardDisplay cardDisplay2 = cardDisplay;
        String string3 = string2;
        return new CardView(string3, cardDisplay2, list, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCard(@Nullable BingoTeam team, boolean forceNotFlashing) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$associateWith$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Collection collection;
        Object item$iv$iv2;
        String string;
        Map map;
        Object map2;
        Object it;
        CardView currentView;
        Object card;
        block20: {
            Object object;
            block19: {
                Object object2;
                block18: {
                    block17: {
                        object2 = team;
                        if (object2 == null) break block17;
                        BingoTeam it2 = object2;
                        boolean bl = false;
                        BingoCard bingoCard = this.state.getCard(it2);
                        object2 = bingoCard;
                        if (bingoCard != null) break block18;
                    }
                    object2 = this.state.getActiveCard();
                }
                card = object2;
                currentView = null;
                currentView = this.getMapView(team);
                object = team;
                if (object == null) break block19;
                it = object;
                boolean bl = false;
                BingoMap bingoMap = this.teamService.getTeamMap((BingoTeam)it);
                object = bingoMap;
                if (bingoMap != null) break block20;
            }
            object = map2 = this.state.getPreviewMap(this.mapService);
        }
        if (forceNotFlashing) {
            List list;
            List list2;
            CardView cardView = currentView;
            String string2 = null;
            Map map3 = null;
            Object object = ((BingoMap)map2).getView();
            if (object != null && (object = ((CardView)object).getTiles()) != null) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                it = (Iterable)object;
                map = map3;
                string = string2;
                CardView cardView2 = cardView;
                boolean $i$f$map = false;
                void var10_19 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it3;
                    CardTile cardTile = (CardTile)item$iv$iv2;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(CardTile.copy$default((CardTile)it3, null, null, null, null, null, null, null, null, false, false, false, null, false, 0.0f, null, 31743, null));
                }
                collection = (List)destination$iv$iv;
                cardView = cardView2;
                string2 = string;
                map3 = map;
                list2 = collection;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            currentView = CardView.copy-LF857-w$default(cardView, string2, map3, CollectionsKt.toMutableList((Collection)list), 3, null);
        }
        Iterable bl = CollectionsKt.withIndex((Iterable)currentView.getTiles());
        boolean $i$f$filter = false;
        void $i$f$map = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Object object;
            item$iv$iv2 = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            int i = item$iv$iv2.component1();
            CardTile tile = (CardTile)item$iv$iv2.component2();
            if (!(!Intrinsics.areEqual((Object)tile, (object = ((BingoMap)map2).getView()) != null && (object = ((CardView)object).getTiles()) != null ? (CardTile)CollectionsKt.getOrNull((List)object, (int)i) : null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it4;
            item$iv$iv2 = (IndexedValue)item$iv$iv3;
            Collection collection2 = destination$iv$iv;
            boolean bl3 = false;
            collection2.add(it4.getIndex());
        }
        List changedTiles = (List)destination$iv$iv;
        if (changedTiles.isEmpty()) {
            return;
        }
        ((BingoMap)map2).setView(currentView);
        this.mapRenderService.update-ZBGTal8(team, (BingoMap)map2, changedTiles);
        BingoTeam bingoTeam = team;
        Iterable $i$f$map22 = changedTiles;
        string = bingoTeam != null ? bingoTeam.getKey-zo6Dpdc() : null;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it5;
            int bl3 = ((Number)element$iv$iv).intValue();
            collection = element$iv$iv;
            map = result$iv;
            boolean bl4 = false;
            CardTile cardTile = currentView.getTiles().get((int)it5);
            map.put(collection, cardTile);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        boolean bl5 = this.state.getState() == GameState.PLAYING && ((BingoCard)card).getTicks() > 3 && !forceNotFlashing;
        Map map4 = result$iv;
        String string3 = string;
        CardTilesPacket cardTilesPacket = new CardTilesPacket(string3, map4, bl5, defaultConstructorMarker);
        Iterable $i$f$associateWith22 = this.playerManager.getPlayers();
        boolean $i$f$filter2 = false;
        $this$associateWithTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IPlayerHandle it6 = (IPlayerHandle)element$iv$iv;
            boolean bl6 = false;
            if (!this.isViewingCard(it6, team)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List players = (List)destination$iv$iv2;
        for (IPlayerHandle player : players) {
            if (this.packets.getCardTilesV2().send(player, cardTilesPacket) || this.packets.getCardTilesV1().send(player, cardTilesPacket)) continue;
            this.sendEntireCardTilesPacket(player, currentView);
        }
    }

    public static /* synthetic */ void updateCard$default(CardViewService cardViewService, BingoTeam bingoTeam, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cardViewService.updateCard(bingoTeam, bl);
    }

    public final void openCard(@NotNull IPlayerHandle player) {
        CardView view;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BingoTeam team = this.teamService.getPlayerTeam(player);
        if (!this.isViewingCard(player, team)) {
            v0 = null;
        } else if (team == null) {
            BingoMap bingoMap = this.state.getPreviewMap();
            v0 = bingoMap != null ? bingoMap.getView() : null;
        } else {
            BingoMap bingoMap = team.getMap();
            v0 = view = bingoMap != null ? bingoMap.getView() : null;
        }
        if (view == null) {
            player.sendHotbarMessage(this.textProvider.string(StringKey.CardNoCards));
            return;
        }
        player.getPlayer().method_17355((class_3908)new class_747((arg_0, arg_1, arg_2) -> CardViewService.openCard$lambda$36(view, this, arg_0, arg_1, arg_2), this.textProvider.string(StringKey.CardTitle).getValue()));
    }

    private static final class_1703 openCard$lambda$36(CardView $view, CardViewService this$0, int syncId, class_1661 inv, class_1657 class_16572) {
        IItemStackFactory iItemStackFactory = this$0.itemStackFactory;
        Intrinsics.checkNotNull((Object)inv);
        return new CardScreenHandler(syncId, $view, iItemStackFactory, inv, this$0.textProvider);
    }

    static {
        int $this$seconds$iv = 4;
        boolean $i$f$getSeconds = false;
        Duration duration2 = Duration.ofSeconds($this$seconds$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        FLASHING_DURATION = duration2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/jfenn/bingo/common/map/CardViewService$Companion;", "", "<init>", "()V", "Ljava/time/Duration;", "FLASHING_DURATION", "Ljava/time/Duration;", "bingo-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameState.values().length];
            try {
                nArray[GameState.PLAYING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.POSTGAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

