/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.bingo.common.config.PlayerSettings;
import me.jfenn.bingo.common.config.PlayerSettingsService;
import me.jfenn.bingo.common.map.CardViewService;
import me.jfenn.bingo.common.map.MapItemService;
import me.jfenn.bingo.common.scoreboard.ScoreboardView;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.ITextSerializer;
import me.jfenn.bingo.platform.PlayerGameMode;
import me.jfenn.bingo.platform.scoreboard.IObjectiveHandle;
import me.jfenn.bingo.platform.scoreboard.IScoreboardManager;
import me.jfenn.bingo.platform.scoreboard.ScoreChange;
import me.jfenn.bingo.platform.text.IText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dJ+\u0010$\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190!\u00a2\u0006\u0004\b$\u0010%J1\u0010'\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u00162\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190!\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020#\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010+R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010,R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010-R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010.R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010/R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00100R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u00101R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u00102R \u00106\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u00068"}, d2={"Lme/jfenn/bingo/common/scoreboard/ScoreboardService;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;", "scoreboardManager", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "playerSettingsService", "Lme/jfenn/bingo/common/map/CardViewService;", "cardViewService", "Lme/jfenn/bingo/common/map/MapItemService;", "mapItemService", "Lme/jfenn/bingo/platform/ITextSerializer;", "textSerializer", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/common/config/PlayerSettingsService;Lme/jfenn/bingo/common/map/CardViewService;Lme/jfenn/bingo/common/map/MapItemService;Lme/jfenn/bingo/platform/ITextSerializer;Lme/jfenn/bingo/common/team/TeamService;)V", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "Lme/jfenn/bingo/platform/scoreboard/IObjectiveHandle;", "getScoreboardObjective", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/platform/scoreboard/IObjectiveHandle;", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "shouldDisplayScoreboard", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "objective", "Lme/jfenn/bingo/platform/text/IText;", "title", "", "players", "", "setScoreboardTitle", "(Lme/jfenn/bingo/platform/scoreboard/IObjectiveHandle;Lme/jfenn/bingo/platform/text/IText;Ljava/util/List;)V", "contents", "setScoreboardContents", "(Lme/jfenn/bingo/platform/scoreboard/IObjectiveHandle;Ljava/util/List;Ljava/util/List;)V", "clearScoreboards", "()V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/platform/scoreboard/IScoreboardManager;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "Lme/jfenn/bingo/common/map/CardViewService;", "Lme/jfenn/bingo/common/map/MapItemService;", "Lme/jfenn/bingo/platform/ITextSerializer;", "Lme/jfenn/bingo/common/team/TeamService;", "", "", "Lme/jfenn/bingo/common/scoreboard/ScoreboardView;", "scoreboardViews", "Ljava/util/Map;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nScoreboardService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreboardService.kt\nme/jfenn/bingo/common/scoreboard/ScoreboardService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,132:1\n1563#2:133\n1634#2,3:134\n1563#2:137\n1634#2,3:138\n1563#2:148\n1634#2,3:149\n382#3,7:141\n*S KotlinDebug\n*F\n+ 1 ScoreboardService.kt\nme/jfenn/bingo/common/scoreboard/ScoreboardService\n*L\n80#1:133\n80#1:134,3\n86#1:137\n86#1:138,3\n111#1:148\n111#1:149,3\n88#1:141,7\n*E\n"})
public final class ScoreboardService {
    @NotNull
    private final BingoState state;
    @NotNull
    private final IScoreboardManager scoreboardManager;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final PlayerSettingsService playerSettingsService;
    @NotNull
    private final CardViewService cardViewService;
    @NotNull
    private final MapItemService mapItemService;
    @NotNull
    private final ITextSerializer textSerializer;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final Map<String, ScoreboardView> scoreboardViews;

    public ScoreboardService(@NotNull BingoState state, @NotNull IScoreboardManager scoreboardManager, @NotNull IPlayerManager playerManager, @NotNull PlayerSettingsService playerSettingsService, @NotNull CardViewService cardViewService, @NotNull MapItemService mapItemService, @NotNull ITextSerializer textSerializer, @NotNull TeamService teamService) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scoreboardManager, (String)"scoreboardManager");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)playerSettingsService, (String)"playerSettingsService");
        Intrinsics.checkNotNullParameter((Object)cardViewService, (String)"cardViewService");
        Intrinsics.checkNotNullParameter((Object)mapItemService, (String)"mapItemService");
        Intrinsics.checkNotNullParameter((Object)textSerializer, (String)"textSerializer");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        this.state = state;
        this.scoreboardManager = scoreboardManager;
        this.playerManager = playerManager;
        this.playerSettingsService = playerSettingsService;
        this.cardViewService = cardViewService;
        this.mapItemService = mapItemService;
        this.textSerializer = textSerializer;
        this.teamService = teamService;
        this.scoreboardViews = new LinkedHashMap();
    }

    @NotNull
    public final IObjectiveHandle getScoreboardObjective(@Nullable BingoTeam team) {
        Object object = team;
        String objectiveName = "bingo_sidebar_" + (object != null && (object = ((BingoTeam)object).getId()) != null ? StringsKt.removePrefix((String)object, (CharSequence)"bingo_") : null);
        IObjectiveHandle objective = this.scoreboardManager.createDummyObjective(objectiveName);
        return objective;
    }

    public final boolean shouldDisplayScoreboard(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean isOnTeam = this.teamService.isPlaying(player.getPlayer());
        if (!this.state.isLobbyMode() && !isOnTeam) {
            return false;
        }
        PlayerSettings settings = this.playerSettingsService.getPlayer(player);
        if (!settings.getScoreboard()) {
            return false;
        }
        if (!settings.getScoreboardAutoHide()) {
            return true;
        }
        if (this.cardViewService.supportsCardHud(player)) {
            return true;
        }
        boolean isHoldingMapItem = player.getGameMode() != PlayerGameMode.SURVIVAL || this.mapItemService.isMapItem(player.getMainHandStack()) || this.mapItemService.isMapItem(player.getOffHandStack());
        return isHoldingMapItem;
    }

    public final void setScoreboardTitle(@NotNull IObjectiveHandle objective, @NotNull IText title, @NotNull List<? extends IPlayerHandle> players) {
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(players, (String)"players");
        if (Intrinsics.areEqual((Object)title, (Object)objective.getDisplayName())) {
            return;
        }
        objective.setDisplayName(title);
        for (IPlayerHandle iPlayerHandle : players) {
            this.scoreboardManager.sendObjectiveDisplayUpdate(iPlayerHandle, objective);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setScoreboardContents(@NotNull IObjectiveHandle objective, @NotNull List<? extends IText> contents, @NotNull List<? extends IPlayerHandle> players) {
        void $this$mapTo$iv$iv;
        Object otherView22;
        Object object;
        void $this$getOrPut$iv;
        Collection<ScoreChange.Create> collection;
        void $this$mapTo$iv$iv2;
        ScoreboardView.ScoreboardItem it;
        boolean bl;
        Object object2;
        Iterable $this$mapTo$iv$iv22;
        Intrinsics.checkNotNullParameter((Object)objective, (String)"objective");
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Iterable $this$map$iv = contents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            IText iText = (IText)item$iv$iv;
            object2 = collection2;
            bl = false;
            object2.add(new ScoreboardView.ScoreboardItem(this.textSerializer.toRawString(it.getValue()), it.getValue()));
        }
        List contentItems = (List)collection2;
        $this$map$iv = contentItems;
        IObjectiveHandle iObjectiveHandle = objective;
        object2 = this.scoreboardManager;
        boolean $i$f$map42 = false;
        $this$mapTo$iv$iv22 = $this$map$iv;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (ScoreboardView.ScoreboardItem)item$iv$iv;
            collection = collection3;
            bl = false;
            collection.add(new ScoreChange.Create(it.getString(), it.getText(), 0));
        }
        collection = (List)collection3;
        object2.setScoreboardText(iObjectiveHandle, (List<ScoreChange.Create>)collection);
        Map<String, ScoreboardView> $i$f$map42 = this.scoreboardViews;
        String key$iv = objective.getName();
        boolean bl2 = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl3 = false;
            ScoreboardView answer$iv = new ScoreboardView(objective.getName());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ScoreboardView view = (ScoreboardView)object;
        List<ScoreChange> changes = view.updateContents(contentItems);
        for (IPlayerHandle iPlayerHandle : players) {
            if (!view.getPlayers().contains(iPlayerHandle.getUuid())) {
                for (Object otherView22 : CollectionsKt.minus((Iterable)this.scoreboardViews.values(), (Object)view)) {
                    if (!((ScoreboardView)otherView22).getPlayers().contains(iPlayerHandle.getUuid())) continue;
                    IObjectiveHandle otherObjective = this.scoreboardManager.createDummyObjective(((ScoreboardView)otherView22).getObjectiveName());
                    this.scoreboardManager.sendObjectiveDelete(iPlayerHandle, otherObjective);
                    ((ScoreboardView)otherView22).setPlayers(SetsKt.minus(((ScoreboardView)otherView22).getPlayers(), (Object)iPlayerHandle.getUuid()));
                }
                this.scoreboardManager.sendObjectiveCreate(iPlayerHandle, objective);
                this.scoreboardManager.sendScoreChanges(iPlayerHandle, objective, view.createChanges(contentItems));
                continue;
            }
            this.scoreboardManager.sendScoreChanges(iPlayerHandle, objective, changes);
        }
        Iterable iterable2 = players;
        boolean $i$f$map3 = false;
        otherView22 = iterable2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IPlayerHandle iPlayerHandle = (IPlayerHandle)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl4 = false;
            object2.add(it2.getUuid());
        }
        Set playerUuids = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        for (UUID removedPlayerUuid : SetsKt.minus(view.getPlayers(), (Iterable)playerUuids)) {
            IPlayerHandle removedPlayer;
            if (this.playerManager.getPlayer(removedPlayerUuid) == null) continue;
            this.scoreboardManager.sendObjectiveDelete(removedPlayer, objective);
        }
        view.setPlayers(playerUuids);
    }

    public final void clearScoreboards() {
        for (ScoreboardView view : this.scoreboardViews.values()) {
            IObjectiveHandle objective = this.scoreboardManager.createDummyObjective(view.getObjectiveName());
            for (UUID playerId : view.getPlayers()) {
                IPlayerHandle player;
                if (this.playerManager.getPlayer(playerId) == null) continue;
                this.scoreboardManager.sendObjectiveDelete(player, objective);
            }
            this.scoreboardManager.removeObjective(objective);
        }
        this.scoreboardViews.clear();
    }
}

