/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.spawn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.jfenn.bingo.common.ConstantsKt;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.event.model.TeamWinnerEvent;
import me.jfenn.bingo.common.map.CardViewService;
import me.jfenn.bingo.common.map.MapItemService;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.spawn.ElytraService;
import me.jfenn.bingo.common.spawn.PlayerState;
import me.jfenn.bingo.common.spawn.SpawnService;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.integrations.vanish.IVanishApi;
import me.jfenn.bingo.platform.EffectType;
import me.jfenn.bingo.platform.IAdvancementManager;
import me.jfenn.bingo.platform.IExecutors;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.IRecipeManager;
import me.jfenn.bingo.platform.IServerWorld;
import me.jfenn.bingo.platform.IServerWorldFactory;
import me.jfenn.bingo.platform.IStatHandle;
import me.jfenn.bingo.platform.IStatManager;
import me.jfenn.bingo.platform.IStatusEffectHandle;
import me.jfenn.bingo.platform.PlayerGameMode;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.PlayerEvent;
import me.jfenn.bingo.platform.event.model.TickEvent;
import me.jfenn.bingo.platform.item.IItemStack;
import me.jfenn.bingo.platform.player.PlayerProfile;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0016\b\u0000\u0018\u00002\u00020\u0001B\u0097\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\u0006\u0010!\u001a\u00020 \u0012\u0006\u0010#\u001a\u00020\"\u0012\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010/\u001a\u00020.2\u0006\u0010)\u001a\u00020(2\b\b\u0002\u0010-\u001a\u00020*\u00a2\u0006\u0004\b/\u00100J\u0017\u00101\u001a\u00020.2\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b1\u00102J\u0017\u00103\u001a\u00020.2\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b3\u00102R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00104R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00105R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00106R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00107R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u00108R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u00109R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010:R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010;R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010<R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010=R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010>R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010?R\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010@R\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010AR\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010BR\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010C\u00a8\u0006D"}, d2={"Lme/jfenn/bingo/common/spawn/PlayerController;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lorg/slf4j/Logger;", "log", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/options/BingoOptions;", "options", "Lme/jfenn/bingo/common/spawn/SpawnService;", "spawnService", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/platform/IStatManager;", "statManager", "Lme/jfenn/bingo/common/map/CardViewService;", "cardViewService", "Lme/jfenn/bingo/common/map/MapItemService;", "mapItemService", "Lme/jfenn/bingo/common/spawn/ElytraService;", "elytraService", "Lme/jfenn/bingo/platform/IAdvancementManager;", "advancementManager", "Lme/jfenn/bingo/platform/IRecipeManager;", "recipeManager", "Lme/jfenn/bingo/integrations/vanish/IVanishApi;", "vanishApi", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "serverTaskExecutor", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "serverWorldFactory", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lorg/slf4j/Logger;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/options/BingoOptions;Lme/jfenn/bingo/common/spawn/SpawnService;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/platform/IStatManager;Lme/jfenn/bingo/common/map/CardViewService;Lme/jfenn/bingo/common/map/MapItemService;Lme/jfenn/bingo/common/spawn/ElytraService;Lme/jfenn/bingo/platform/IAdvancementManager;Lme/jfenn/bingo/platform/IRecipeManager;Lme/jfenn/bingo/integrations/vanish/IVanishApi;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;Lme/jfenn/bingo/platform/IServerWorldFactory;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "updateVanishStatus", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "forceReset", "", "updateGameMode", "(Lme/jfenn/bingo/platform/IPlayerHandle;Z)V", "resetPlayerHealth", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "respawnPlayer", "Lorg/slf4j/Logger;", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/options/BingoOptions;", "Lme/jfenn/bingo/common/spawn/SpawnService;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/platform/IStatManager;", "Lme/jfenn/bingo/common/map/CardViewService;", "Lme/jfenn/bingo/common/map/MapItemService;", "Lme/jfenn/bingo/common/spawn/ElytraService;", "Lme/jfenn/bingo/platform/IAdvancementManager;", "Lme/jfenn/bingo/platform/IRecipeManager;", "Lme/jfenn/bingo/integrations/vanish/IVanishApi;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/platform/IExecutors$IServerTaskExecutor;", "Lme/jfenn/bingo/platform/IServerWorldFactory;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nPlayerController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerController.kt\nme/jfenn/bingo/common/spawn/PlayerController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n827#2:341\n855#2,2:342\n827#2:344\n855#2,2:345\n1869#2,2:347\n1869#2,2:351\n1617#2,9:354\n1869#2:363\n1870#2:365\n1626#2:366\n1321#3,2:349\n1#4:353\n1#4:364\n*S KotlinDebug\n*F\n+ 1 PlayerController.kt\nme/jfenn/bingo/common/spawn/PlayerController\n*L\n144#1:341\n144#1:342,2\n146#1:344\n146#1:345,2\n147#1:347,2\n193#1:351,2\n281#1:354,9\n281#1:363\n281#1:365\n281#1:366\n179#1:349,2\n281#1:364\n*E\n"})
public final class PlayerController
extends BingoComponent {
    @NotNull
    private final Logger log;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final BingoState state;
    @NotNull
    private final BingoOptions options;
    @NotNull
    private final SpawnService spawnService;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final IStatManager statManager;
    @NotNull
    private final CardViewService cardViewService;
    @NotNull
    private final MapItemService mapItemService;
    @NotNull
    private final ElytraService elytraService;
    @NotNull
    private final IAdvancementManager advancementManager;
    @NotNull
    private final IRecipeManager recipeManager;
    @NotNull
    private final IVanishApi vanishApi;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IExecutors.IServerTaskExecutor serverTaskExecutor;
    @NotNull
    private final IServerWorldFactory serverWorldFactory;

    public PlayerController(@NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull Logger log, @NotNull MinecraftServer server, @NotNull BingoState state, @NotNull BingoOptions options, @NotNull SpawnService spawnService, @NotNull TeamService teamService, @NotNull IStatManager statManager, @NotNull CardViewService cardViewService, @NotNull MapItemService mapItemService, @NotNull ElytraService elytraService, @NotNull IAdvancementManager advancementManager, @NotNull IRecipeManager recipeManager, @NotNull IVanishApi vanishApi, @NotNull IPlayerManager playerManager, @NotNull IExecutors.IServerTaskExecutor serverTaskExecutor, @NotNull IServerWorldFactory serverWorldFactory) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)spawnService, (String)"spawnService");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)statManager, (String)"statManager");
        Intrinsics.checkNotNullParameter((Object)cardViewService, (String)"cardViewService");
        Intrinsics.checkNotNullParameter((Object)mapItemService, (String)"mapItemService");
        Intrinsics.checkNotNullParameter((Object)elytraService, (String)"elytraService");
        Intrinsics.checkNotNullParameter((Object)advancementManager, (String)"advancementManager");
        Intrinsics.checkNotNullParameter((Object)recipeManager, (String)"recipeManager");
        Intrinsics.checkNotNullParameter((Object)vanishApi, (String)"vanishApi");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)serverTaskExecutor, (String)"serverTaskExecutor");
        Intrinsics.checkNotNullParameter((Object)serverWorldFactory, (String)"serverWorldFactory");
        this.log = log;
        this.server = server;
        this.state = state;
        this.options = options;
        this.spawnService = spawnService;
        this.teamService = teamService;
        this.statManager = statManager;
        this.cardViewService = cardViewService;
        this.mapItemService = mapItemService;
        this.elytraService = elytraService;
        this.advancementManager = advancementManager;
        this.recipeManager = recipeManager;
        this.vanishApi = vanishApi;
        this.playerManager = playerManager;
        this.serverTaskExecutor = serverTaskExecutor;
        this.serverWorldFactory = serverWorldFactory;
        events.onPlayerInit((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> PlayerController._init_$lambda$7(this, arg_0)));
        events.onPlayerJoin((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> PlayerController._init_$lambda$9(this, arg_0)));
        events.onPlayerRespawn((Function1<? super PlayerEvent, Unit>)((Function1)arg_0 -> PlayerController._init_$lambda$11(this, arg_0)));
        ScopedEvents.onEnter$default(events, GameState.LOADING, false, arg_0 -> PlayerController._init_$lambda$12(this, arg_0), 2, null);
        ScopedEvents.onEnter$default(events, GameState.PLAYING, false, arg_0 -> PlayerController._init_$lambda$13(this, arg_0), 2, null);
        eventBus.register(TeamWinnerEvent.Companion, arg_0 -> PlayerController._init_$lambda$15(this, arg_0));
        ScopedEvents.onEnter$default(events, GameState.POSTGAME, false, arg_0 -> PlayerController._init_$lambda$16(this, arg_0), 2, null);
        events.onGameTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> PlayerController._init_$lambda$17(this, arg_0)));
    }

    private final boolean updateVanishStatus(IPlayerHandle player) {
        BingoTeam team;
        BingoTeam bingoTeam = team = this.teamService.getPlayerTeam(player.getPlayer());
        boolean isOnActiveTeam = bingoTeam != null ? bingoTeam.isPlaying() : false;
        boolean isVanished = !isOnActiveTeam && (this.state.getState() == GameState.LOADING || this.state.getState() == GameState.COUNTDOWN || this.state.getState() == GameState.PLAYING);
        this.vanishApi.setVanish(player, isVanished);
        return isVanished;
    }

    public final void updateGameMode(@NotNull IPlayerHandle player, boolean forceReset) {
        boolean isVanished;
        boolean isStuckInWorld;
        BingoTeam team;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_3218 class_32182 = ConstantsKt.getLobbyWorld(this.server);
        if (class_32182 == null) {
            return;
        }
        class_3218 lobbyWorld = class_32182;
        if (!this.state.isLobbyMode()) {
            this.log.error("[PlayerController] Attempted updateGameMode, but isLobbyMode=false!");
            return;
        }
        BingoTeam bingoTeam = team = this.teamService.getPlayerTeam(player.getPlayer());
        boolean isOnActiveTeam = bingoTeam != null ? bingoTeam.isPlaying() : false;
        this.log.debug("updateGameMode({}, forceReset={})", (Object)player.getPlayerName(), (Object)forceReset);
        PlayerState playerState = this.state.getPlayers().get(player.getUuid());
        if (playerState == null) {
            playerState = PlayerState.Companion.getDEFAULT();
        }
        PlayerState oldPlayerState = playerState;
        BingoTeam bingoTeam2 = team;
        PlayerState newPlayerState = new PlayerState(this.state.getGameId(), this.state.getState(), bingoTeam2 != null ? bingoTeam2.getKey-zo6Dpdc() : null, null);
        PlayerGameMode gameMode = switch (WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()]) {
            case 2, 3, 4, 5 -> PlayerGameMode.ADVENTURE;
            case 1, 6, 7 -> {
                if (isOnActiveTeam) {
                    if (WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()] == 1) {
                        yield PlayerGameMode.SURVIVAL;
                    }
                    yield PlayerGameMode.ADVENTURE;
                }
                if (!this.cardViewService.supportsCardHud(player) && this.vanishApi.isInstalled()) {
                    yield PlayerGameMode.ADVENTURE;
                }
                yield PlayerGameMode.SPECTATOR;
            }
            case 8 -> {
                if (this.cardViewService.supportsCardHud(player)) {
                    yield PlayerGameMode.SPECTATOR;
                }
                yield PlayerGameMode.CREATIVE;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        GameState[] gameStateArray = new GameState[]{GameState.PREGAME, GameState.STARTING, GameState.PRELOADING, GameState.LOADING, GameState.COUNTDOWN};
        GameState[] preGameStates = gameStateArray;
        boolean isRespawnNeeded = !(Intrinsics.areEqual((Object)newPlayerState, (Object)oldPlayerState) && !forceReset || !ArraysKt.contains((Object[])preGameStates, (Object)((Object)this.state.getState())) && !isOnActiveTeam || this.state.getState() == GameState.POSTGAME);
        boolean isStuckInLobby = Intrinsics.areEqual((Object)player.getServerWorld(), (Object)lobbyWorld) && this.state.getState() != GameState.PREGAME;
        boolean bl = isStuckInWorld = !Intrinsics.areEqual((Object)player.getServerWorld(), (Object)lobbyWorld) && this.state.getState() == GameState.PREGAME;
        if (isRespawnNeeded || isStuckInLobby || isStuckInWorld) {
            if (!player.isAlive()) {
                this.log.debug("[PlayerController] respawnPlayer({}, {})", (Object)player.getPlayerName(), (Object)player.getUuid());
                IPlayerHandle newPlayer = player.respawn();
                this.serverTaskExecutor.execute(() -> PlayerController.updateGameMode$lambda$0(this, newPlayer));
                return;
            }
            this.respawnPlayer(player);
            this.state.getPlayers().put(player.getUuid(), newPlayerState);
        }
        if (player.getGameMode() != gameMode) {
            player.setGameMode(gameMode);
        }
        if ((isVanished = this.updateVanishStatus(player)) && this.vanishApi.isInstalled()) {
            player.getPlayer().method_31549().field_7478 = true;
            player.getPlayer().method_7355();
        }
    }

    public static /* synthetic */ void updateGameMode$default(PlayerController playerController, IPlayerHandle iPlayerHandle, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        playerController.updateGameMode(iPlayerHandle, bl);
    }

    private final void resetPlayerHealth(IPlayerHandle player) {
        IStatusEffectHandle it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = player.getEffects();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IStatusEffectHandle)element$iv$iv;
            boolean bl = false;
            if (this.options.isNightVision() && it.getType() == EffectType.NIGHT_VISION) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IStatusEffectHandle)element$iv$iv;
            boolean bl = false;
            if (this.state.getState() == GameState.COUNTDOWN && it.getType() == EffectType.INVISIBILITY) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IStatusEffectHandle it2 = (IStatusEffectHandle)element$iv;
            boolean bl = false;
            this.log.debug("[PlayerController] Removing effect {} from {}", (Object)it2.getType(), (Object)player);
            player.removeEffect(it2);
        }
        player.setFireTicks(0);
        player.setOnFire(false);
        player.setHealth(player.getMaxHealth());
        player.setAir(player.getMaxAir());
        player.setFoodLevel(player.getMaxFoodLevel());
        player.setSaturationLevel(player.getMaxSaturationLevel());
        player.setExhaustion(0.0f);
        player.setExperienceLevel(0);
        player.setExperienceProgress(0.0f);
    }

    private final void respawnPlayer(IPlayerHandle player) {
        Iterable $this$forEach$iv;
        this.log.debug("respawnPlayer({})", (Object)player.getPlayerName());
        this.resetPlayerHealth(player);
        BingoTeam team = this.teamService.getPlayerTeam(player);
        boolean isViewingCard = this.cardViewService.isViewingCard(player, team);
        Sequence sequence = SequencesKt.filterNot(player.allHeldStacks(), arg_0 -> PlayerController.respawnPlayer$lambda$4(isViewingCard, team, this, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IItemStack stack = (IItemStack)element$iv;
            boolean bl = false;
            stack.setCount(0);
        }
        if (this.state.getState() == GameState.PLAYING) {
            if (this.options.isUnlockRecipes()) {
                this.recipeManager.unlockRecipes(player, this.recipeManager.listRecipes());
            } else {
                this.recipeManager.lockRecipes(player, this.recipeManager.listRecipes());
            }
        }
        $this$forEach$iv = this.statManager.list();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IStatHandle it = (IStatHandle)element$iv;
            boolean bl = false;
            it.reset(player);
        }
        this.advancementManager.clearAdvancements(player.getPlayer());
        if (this.state.getState() == GameState.PREGAME || this.state.getState() == GameState.STARTING || this.state.getState() == GameState.PRELOADING) {
            this.spawnService.teleportToLobby(player);
        } else {
            this.spawnService.teleportPlayer(player);
            if (this.teamService.isPlaying(player.getPlayer()) && this.state.getState() == GameState.PLAYING) {
                this.spawnService.giveSpawnEquipment(CollectionsKt.listOf((Object)player));
            }
        }
    }

    private static final void updateGameMode$lambda$0(PlayerController this$0, IPlayerHandle $newPlayer) {
        this$0.updateGameMode($newPlayer, true);
    }

    private static final boolean respawnPlayer$lambda$4(boolean $isViewingCard, BingoTeam $team, PlayerController this$0, IItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return $isViewingCard && ($team == null ? this$0.mapItemService.isPreviewMapItem(stack) : this$0.mapItemService.isMapTeamItem(stack, $team));
    }

    private static final Unit _init_$lambda$7(PlayerController this$0, PlayerEvent playerEvent) {
        Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
        IPlayerHandle player = playerEvent.component1();
        this$0.updateVanishStatus(player);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(PlayerController this$0, PlayerEvent playerEvent) {
        Object v0;
        IPlayerHandle player;
        block3: {
            Intrinsics.checkNotNullParameter((Object)playerEvent, (String)"<destruct>");
            player = playerEvent.component1();
            Iterable iterable = this$0.serverWorldFactory.listWorlds();
            for (Object t : iterable) {
                IServerWorld it = (IServerWorld)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIdentifier(), (Object)ConstantsKt.getLOBBY_WORLD_IDENTIFIER())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        IServerWorld iServerWorld = v0;
        if (iServerWorld == null) {
            return Unit.INSTANCE;
        }
        IServerWorld lobbyWorld = iServerWorld;
        if (this$0.state.getState() == GameState.PREGAME) {
            player.setSpawnPoint(lobbyWorld, this$0.state.getLobbySpawnPos(), this$0.state.getLobbySpawnYaw(), true, false);
        }
        this$0.state.getPlayersJoinedIds().add(player.getUuid());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$11(PlayerController this$0, PlayerEvent event) {
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this$0.state.isLobbyMode()) {
                return Unit.INSTANCE;
            }
            Iterable iterable = this$0.serverWorldFactory.listWorlds();
            for (Object t : iterable) {
                IServerWorld it = (IServerWorld)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIdentifier(), (Object)ConstantsKt.getLOBBY_WORLD_IDENTIFIER())) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        IServerWorld iServerWorld = v0;
        if (iServerWorld == null) {
            return Unit.INSTANCE;
        }
        IServerWorld lobbyWorld = iServerWorld;
        IPlayerHandle player = event.getPlayer();
        if (this$0.state.getState() == GameState.PREGAME) {
            BlockPosition spawnPos = this$0.state.getLobbySpawnPos();
            player.setSpawnPoint(lobbyWorld, spawnPos, this$0.state.getLobbySpawnYaw(), true, false);
            Vector3d vector3d = spawnPos.toVector3d().add(0.5, 0.0, 0.5);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
            player.teleport(lobbyWorld, vector3d, this$0.state.getLobbySpawnYaw(), 0.0f);
        }
        if (this$0.state.getState() == GameState.PLAYING && !((class_1928.class_4310)this$0.server.method_3767().method_20746(class_1928.field_19389)).method_20753() && this$0.teamService.isPlaying(player.getPlayer())) {
            this$0.spawnService.giveSpawnEquipment(CollectionsKt.listOf((Object)player));
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$12(PlayerController this$0, GameState prevState) {
        Intrinsics.checkNotNullParameter((Object)((Object)prevState), (String)"prevState");
        if (prevState == GameState.LOADING) {
            return Unit.INSTANCE;
        }
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            if (!this$0.state.isLobbyMode()) continue;
            this$0.updateGameMode(player, true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$13(PlayerController this$0, GameState prevState) {
        Intrinsics.checkNotNullParameter((Object)((Object)prevState), (String)"prevState");
        if (prevState == GameState.PLAYING) {
            return Unit.INSTANCE;
        }
        boolean forceReset = prevState != GameState.POSTGAME;
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            if (!this$0.state.isLobbyMode()) continue;
            this$0.updateGameMode(player, forceReset);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$15(PlayerController this$0, TeamWinnerEvent teamWinnerEvent) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)teamWinnerEvent, (String)"<destruct>");
        BingoTeam team = teamWinnerEvent.component1();
        Iterable $this$mapNotNull$iv = team.getPlayers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IPlayerHandle it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PlayerProfile it = (PlayerProfile)element$iv$iv;
            boolean bl2 = false;
            if (this$0.playerManager.getPlayer(it.getUuid()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List teamPlayers = (List)destination$iv$iv;
        for (IPlayerHandle player : teamPlayers) {
            if (this$0.state.isLobbyMode()) {
                PlayerController.updateGameMode$default(this$0, player, false, 2, null);
                continue;
            }
            this$0.elytraService.takeElytra(player);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$16(PlayerController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            if (this$0.state.isLobbyMode()) {
                PlayerController.updateGameMode$default(this$0, player, false, 2, null);
                continue;
            }
            this$0.elytraService.takeElytra(player);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$17(PlayerController this$0, TickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (IPlayerHandle player : this$0.playerManager.getPlayers()) {
            boolean isSpectating;
            UUID playerUuid = player.getUuid();
            if (this$0.state.getPlayersJoinedIds().contains(playerUuid)) {
                this$0.state.getPlayersJoinedIds().remove(playerUuid);
                if (this$0.state.isLobbyMode()) {
                    PlayerController.updateGameMode$default(this$0, player, false, 2, null);
                }
            }
            if (this$0.state.isLobbyMode() && this$0.state.getState() == GameState.PREGAME && player.getPlayer().method_7344().method_7586() < 10) {
                player.getPlayer().method_7344().method_7580(10);
            }
            if (this$0.state.getState() != GameState.PLAYING || !(player.getPlayer().method_6032() > 0.0f) || player.isSpectator()) continue;
            if (this$0.options.isElytra() && this$0.teamService.isPlaying(player.getPlayer())) {
                this$0.elytraService.giveElytra(this$0.playerManager.forPlayer(player.getPlayer()));
            }
            if (!this$0.state.isLobbyMode() || player.getPlayer().field_13974.method_14257() != class_1934.field_9216) continue;
            boolean bl = isSpectating = !this$0.teamService.isPlaying(player.getPlayer());
            if (isSpectating) {
                this$0.resetPlayerHealth(player);
            }
            if (isSpectating == player.getPlayer().method_31549().field_7478) continue;
            player.getPlayer().method_31549().field_7478 = isSpectating;
            player.getPlayer().method_7355();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameState.values().length];
            try {
                nArray[GameState.PLAYING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.UNINITIALIZED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.PREGAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.STARTING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.PRELOADING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.LOADING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.COUNTDOWN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.POSTGAME.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

