/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.stats;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.stats.CommonKt;
import me.jfenn.bingo.common.stats.StatsService;
import me.jfenn.bingo.common.stats.data.PlayerStatsSummary;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.commands.CommandArgument;
import me.jfenn.bingo.platform.commands.CommandBuilder;
import me.jfenn.bingo.platform.commands.ICommandManager;
import me.jfenn.bingo.platform.commands.IExecutionContext;
import me.jfenn.bingo.platform.commands.IExecutionSource;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_124;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\f\u001a\u00020\u000b*\u00020\b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u000f\u001a\u00020\u000b*\u00020\b2\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0013\u0010\u0010\u001a\u00020\u000b*\u00020\bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u000b*\u00020\bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u0018\u0010\u0017\u001a\u00020\u0014*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lme/jfenn/bingo/common/stats/StatsCommand;", "", "Lme/jfenn/bingo/platform/commands/ICommandManager;", "commandManager", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "<init>", "(Lme/jfenn/bingo/platform/commands/ICommandManager;Lme/jfenn/bingo/common/text/TextProvider;)V", "Lme/jfenn/bingo/platform/commands/IExecutionContext;", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "getStatsSummary", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;Lme/jfenn/bingo/platform/IPlayerHandle;)V", "playerToReset", "clearPlayerStats", "clearGameStats", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;)V", "clearAllStats", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/common/stats/StatsService;", "getStatsService", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;)Lme/jfenn/bingo/common/stats/StatsService;", "statsService", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nStatsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsCommand.kt\nme/jfenn/bingo/common/stats/StatsCommand\n+ 2 Scope.kt\norg/koin/core/scope/Scope\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n132#2,5:134\n132#2,5:140\n1#3:139\n*S KotlinDebug\n*F\n+ 1 StatsCommand.kt\nme/jfenn/bingo/common/stats/StatsCommand\n*L\n20#1:134,5\n73#1:140,5\n*E\n"})
public final class StatsCommand {
    @NotNull
    private final TextProvider text;

    public StatsCommand(@NotNull ICommandManager commandManager, @NotNull TextProvider text) {
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        commandManager.register("bingostats", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> StatsCommand._init_$lambda$21(this, arg_0)));
    }

    private final StatsService getStatsService(IExecutionContext $this$statsService) {
        Scope $this$iv = $this$statsService.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        return (StatsService)$this$iv.get(Reflection.getOrCreateKotlinClass(StatsService.class), qualifier$iv, parameters$iv);
    }

    private final void getStatsSummary(IExecutionContext $this$getStatsSummary, IPlayerHandle player) {
        PlayerStatsSummary summary = StatsService.getPlayerSummary$default(this.getStatsService($this$getStatsSummary), player.getUuid(), null, 2, null);
        Object[] objectArray = new Object[]{player.getPlayerName()};
        $this$getStatsSummary.sendMessage(this.text.string(StringKey.CommandStatsPlayer, objectArray));
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1054};
        $this$getStatsSummary.sendMessage(this.text.literal("\u2605 ").append(this.text.string(StringKey.StatsAllTime)).formatted((class_124[])objectArray));
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1080};
        IText iText = this.text.literal("  ").append(this.text.string(StringKey.StatsGames).formatted((class_124[])objectArray)).append(": " + CommonKt.formatLargeNumber(summary.getTotalGames()) + ", ");
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1080};
        IText iText2 = iText.append(this.text.string(StringKey.StatsWinLoss).formatted((class_124[])objectArray)).append(": " + CommonKt.formatLargeNumber(summary.getTotalWins()) + "/" + CommonKt.formatLargeNumber(summary.getTotalLosses()) + ", ");
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1080};
        $this$getStatsSummary.sendMessage(iText2.append(this.text.string(StringKey.StatsItems).formatted((class_124[])objectArray)).append(": " + CommonKt.formatLargeNumber(summary.getTotalItems())));
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1080};
        $this$getStatsSummary.sendMessage(this.text.literal("  ").append(this.text.string(StringKey.StatsPlaytime).formatted((class_124[])objectArray)).append(": " + DurationKt.formatString(summary.getTotalPlaytime())));
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1075};
        $this$getStatsSummary.sendMessage(this.text.literal("\ud83d\udcc6 ").append(this.text.string(StringKey.StatsMonthly)).formatted((class_124[])objectArray));
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1080};
        IText iText3 = this.text.literal("  ").append(this.text.string(StringKey.StatsGames).formatted((class_124[])objectArray)).append(": " + CommonKt.formatLargeNumber(summary.getMonthlyGames()) + ", ");
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1080};
        IText iText4 = iText3.append(this.text.string(StringKey.StatsWinLoss).formatted((class_124[])objectArray)).append(": " + CommonKt.formatLargeNumber(summary.getMonthlyWins()) + "/" + CommonKt.formatLargeNumber(summary.getMonthlyLosses()) + ", ");
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1080};
        $this$getStatsSummary.sendMessage(iText4.append(this.text.string(StringKey.StatsItems).formatted((class_124[])objectArray)).append(": " + CommonKt.formatLargeNumber(summary.getMonthlyItems())));
        objectArray = new class_124[]{class_124.field_1067, class_124.field_1080};
        $this$getStatsSummary.sendMessage(this.text.literal("  ").append(this.text.string(StringKey.StatsPlaytime).formatted((class_124[])objectArray)).append(": " + DurationKt.formatString(summary.getMonthlyPlaytime())));
    }

    private final void clearPlayerStats(IExecutionContext $this$clearPlayerStats, IPlayerHandle playerToReset) {
        this.getStatsService($this$clearPlayerStats).resetPlayerStats(playerToReset.getUuid());
        Object object = new Object[]{playerToReset.getPlayerName()};
        IText iText = this.text.string(StringKey.CommandStatsResetPlayer, object);
        object = new class_124[]{class_124.field_1054};
        Object it = object = iText.formatted((class_124[])object);
        boolean bl = false;
        $this$clearPlayerStats.sendFeedback((IText)it);
    }

    private final void clearGameStats(IExecutionContext $this$clearGameStats) {
        Scope $this$iv = $this$clearGameStats.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        BingoOptions options = (BingoOptions)$this$iv.get(Reflection.getOrCreateKotlinClass(BingoOptions.class), qualifier$iv, parameters$iv);
        this.getStatsService($this$clearGameStats).resetGameStats(options);
        Object object = new class_124[]{class_124.field_1054};
        Object it = object = this.text.string(StringKey.CommandStatsResetGame).formatted((class_124)object);
        boolean bl = false;
        $this$clearGameStats.sendFeedback((IText)it);
    }

    private final void clearAllStats(IExecutionContext $this$clearAllStats) {
        this.getStatsService($this$clearAllStats).resetAllStats();
        Object object = new class_124[]{class_124.field_1054};
        Object it = object = this.text.string(StringKey.CommandStatsResetAll).formatted((class_124)object);
        boolean bl = false;
        $this$clearAllStats.sendFeedback((IText)it);
    }

    private static final boolean lambda$21$lambda$5$lambda$3(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return me.jfenn.bingo.common.commands.CommonKt.hasPermission($this$requires, Permission.INSTANCE.getSTATS_VIEW_PLAYER());
    }

    private static final Unit lambda$21$lambda$5$lambda$4(CommandArgument $playerArg, StatsCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        IPlayerHandle player = (IPlayerHandle)$this$executes.getArgument($playerArg);
        this$0.getStatsSummary($this$executes, player);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$21$lambda$5(StatsCommand this$0, CommandBuilder $this$player, CommandArgument playerArg) {
        Intrinsics.checkNotNullParameter((Object)$this$player, (String)"$this$player");
        Intrinsics.checkNotNullParameter((Object)playerArg, (String)"playerArg");
        $this$player.requires((Function1<? super IExecutionSource, Boolean>)((Function1)StatsCommand::lambda$21$lambda$5$lambda$3));
        $this$player.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$5$lambda$4(playerArg, this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$21$lambda$18$lambda$11$lambda$6(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return me.jfenn.bingo.common.commands.CommonKt.hasPermission($this$requires, Permission.INSTANCE.getSTATS_RESET_SELF()) || me.jfenn.bingo.common.commands.CommonKt.hasPermission($this$requires, Permission.INSTANCE.getSTATS_RESET_GLOBAL());
    }

    private static final Unit lambda$21$lambda$18$lambda$11$lambda$7(StatsCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.clearPlayerStats($this$executes, $this$executes.getPlayerOrThrow());
        return Unit.INSTANCE;
    }

    private static final boolean lambda$21$lambda$18$lambda$11$lambda$10$lambda$8(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return me.jfenn.bingo.common.commands.CommonKt.hasPermission($this$requires, Permission.INSTANCE.getSTATS_RESET_GLOBAL());
    }

    private static final Unit lambda$21$lambda$18$lambda$11$lambda$10$lambda$9(StatsCommand this$0, CommandArgument $playerArg, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.clearPlayerStats($this$executes, (IPlayerHandle)$this$executes.getArgument($playerArg));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$21$lambda$18$lambda$11$lambda$10(StatsCommand this$0, CommandBuilder $this$player, CommandArgument playerArg) {
        Intrinsics.checkNotNullParameter((Object)$this$player, (String)"$this$player");
        Intrinsics.checkNotNullParameter((Object)playerArg, (String)"playerArg");
        $this$player.requires((Function1<? super IExecutionSource, Boolean>)((Function1)StatsCommand::lambda$21$lambda$18$lambda$11$lambda$10$lambda$8));
        $this$player.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$18$lambda$11$lambda$10$lambda$9(this$0, playerArg, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$21$lambda$18$lambda$11(StatsCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)StatsCommand::lambda$21$lambda$18$lambda$11$lambda$6));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$18$lambda$11$lambda$7(this$0, arg_0)));
        $this$literal.player("player", (Function2<? super CommandBuilder, ? super CommandArgument<IPlayerHandle>, Unit>)((Function2)(arg_0, arg_1) -> StatsCommand.lambda$21$lambda$18$lambda$11$lambda$10(this$0, arg_0, arg_1)));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$21$lambda$18$lambda$14$lambda$12(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return me.jfenn.bingo.common.commands.CommonKt.hasPermission($this$requires, Permission.INSTANCE.getSTATS_RESET_GLOBAL());
    }

    private static final Unit lambda$21$lambda$18$lambda$14$lambda$13(StatsCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.clearGameStats($this$executes);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$21$lambda$18$lambda$14(StatsCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)StatsCommand::lambda$21$lambda$18$lambda$14$lambda$12));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$18$lambda$14$lambda$13(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$21$lambda$18$lambda$17$lambda$15(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return me.jfenn.bingo.common.commands.CommonKt.hasPermission($this$requires, Permission.INSTANCE.getSTATS_RESET_GLOBAL());
    }

    private static final Unit lambda$21$lambda$18$lambda$17$lambda$16(StatsCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.clearAllStats($this$executes);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$21$lambda$18$lambda$17(StatsCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.requires((Function1<? super IExecutionSource, Boolean>)((Function1)StatsCommand::lambda$21$lambda$18$lambda$17$lambda$15));
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$18$lambda$17$lambda$16(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$21$lambda$18(StatsCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.literal("player", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$18$lambda$11(this$0, arg_0)));
        $this$literal.literal("game", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$18$lambda$14(this$0, arg_0)));
        $this$literal.literal("all", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$18$lambda$17(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$21$lambda$19(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        return me.jfenn.bingo.common.commands.CommonKt.hasPermission($this$requires, Permission.INSTANCE.getSTATS_VIEW_SELF());
    }

    private static final Unit lambda$21$lambda$20(StatsCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.getStatsSummary($this$executes, $this$executes.getPlayerOrThrow());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$21(StatsCommand this$0, CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.player("player", (Function2<? super CommandBuilder, ? super CommandArgument<IPlayerHandle>, Unit>)((Function2)(arg_0, arg_1) -> StatsCommand.lambda$21$lambda$5(this$0, arg_0, arg_1)));
        $this$register.literal("reset", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$18(this$0, arg_0)));
        $this$register.requires((Function1<? super IExecutionSource, Boolean>)((Function1)StatsCommand::lambda$21$lambda$19));
        $this$register.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> StatsCommand.lambda$21$lambda$20(this$0, arg_0)));
        return Unit.INSTANCE;
    }
}

