/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.stats;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import me.jfenn.bingo.common.card.objective.BingoObjective;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.packet.ServerPacketEvents;
import me.jfenn.bingo.common.options.BingoOptions;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.stats.StatsService;
import me.jfenn.bingo.common.stats.data.GameInfo;
import me.jfenn.bingo.common.stats.data.GamePlayerInfo;
import me.jfenn.bingo.common.stats.data.GameTeamInfo;
import me.jfenn.bingo.common.stats.data.PlayerGameSummary;
import me.jfenn.bingo.common.stats.packets.StatsGamePacket;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamCompletedCard;
import me.jfenn.bingo.common.utils.JsonKt;
import me.jfenn.bingo.platform.IJsonSerializers;
import me.jfenn.bingo.platform.player.PlayerProfile;
import me.jfenn.bingo.platform.text.IText;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001d\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010 R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010!R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\"R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010#R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010$\u00a8\u0006%"}, d2={"Lme/jfenn/bingo/common/stats/WriteStatsService;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/stats/StatsService;", "stats", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "packets", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/platform/IJsonSerializers;", "serializers", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/stats/StatsService;Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/platform/IJsonSerializers;)V", "Lme/jfenn/bingo/common/stats/data/GameInfo;", "gameInfo", "Lme/jfenn/bingo/common/stats/data/GameTeamInfo;", "teamInfo", "Lme/jfenn/bingo/common/stats/data/GamePlayerInfo;", "playerInfo", "", "broadcastResult", "(Lme/jfenn/bingo/common/stats/data/GameInfo;Lme/jfenn/bingo/common/stats/data/GameTeamInfo;Lme/jfenn/bingo/common/stats/data/GamePlayerInfo;)V", "writeGameResult", "()Lme/jfenn/bingo/common/stats/data/GameInfo;", "writeGame", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/stats/StatsService;", "Lme/jfenn/bingo/common/event/packet/ServerPacketEvents;", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/platform/IJsonSerializers;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nWriteStatsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteStatsService.kt\nme/jfenn/bingo/common/stats/WriteStatsService\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Logger.kt\nme/jfenn/bingo/common/utils/LoggerKt\n*L\n1#1,118:1\n205#2:119\n205#2:124\n1#3:120\n2746#4,3:121\n10#5,8:125\n*S KotlinDebug\n*F\n+ 1 WriteStatsService.kt\nme/jfenn/bingo/common/stats/WriteStatsService\n*L\n52#1:119\n79#1:124\n70#1:121,3\n114#1:125,8\n*E\n"})
public final class WriteStatsService
extends BingoComponent {
    @NotNull
    private final Logger log;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoState state;
    @NotNull
    private final StatsService stats;
    @NotNull
    private final ServerPacketEvents packets;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final IJsonSerializers serializers;

    public WriteStatsService(@NotNull Logger log, @NotNull BingoConfig config, @NotNull BingoState state, @NotNull StatsService stats, @NotNull ServerPacketEvents packets, @NotNull MinecraftServer server, @NotNull IJsonSerializers serializers) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
        this.log = log;
        this.config = config;
        this.state = state;
        this.stats = stats;
        this.packets = packets;
        this.server = server;
        this.serializers = serializers;
    }

    private final void broadcastResult(GameInfo gameInfo, GameTeamInfo teamInfo, GamePlayerInfo playerInfo) {
        class_3222 class_32222 = this.server.method_3760().method_14602(playerInfo.getMinecraftId());
        if (class_32222 == null) {
            return;
        }
        class_3222 player = class_32222;
        this.packets.getStatsGameV1S2C().send(player, new StatsGamePacket(new PlayerGameSummary(gameInfo, teamInfo, playerInfo)));
    }

    /*
     * WARNING - void declaration
     */
    private final GameInfo writeGameResult() {
        int n;
        int n2;
        Object it;
        int n3;
        Object object;
        UUID uUID;
        String string;
        String string2;
        Instant instant;
        Instant instant2;
        Object object2;
        List<BingoTeam> teams2;
        List insertPlayers;
        List insertTeams;
        block10: {
            void $this$none$iv;
            Object $this$writeGameResult_u24lambda_u240;
            void this_$iv;
            insertTeams = new ArrayList();
            insertPlayers = new ArrayList();
            teams2 = this.state.getRegisteredTeams();
            Json json = JsonKt.getJson();
            BingoOptions value$iv = this.state.getOptions();
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String options = this_$iv.encodeToString((SerializationStrategy)BingoOptions.Companion.serializer(), (Object)value$iv);
            Instant instant3 = this.state.getStartedAt();
            if (instant3 == null) {
                $this$writeGameResult_u24lambda_u240 = this;
                boolean bl = false;
                ((WriteStatsService)$this$writeGameResult_u24lambda_u240).log.error("state.startedAt is null!");
                instant3 = Instant.now();
            }
            Instant startedAt = instant3;
            Instant instant4 = this.state.getEndedAt();
            if (instant4 == null) {
                WriteStatsService $this$writeGameResult_u24lambda_u241 = this;
                boolean bl = false;
                $this$writeGameResult_u24lambda_u241.log.error("state.endedAt is null!");
                instant4 = Instant.now();
            }
            Instant endedAt = instant4;
            UUID uUID2 = this.state.getGameId();
            String string3 = this.state.getOptions().getShaHash();
            Intrinsics.checkNotNull((Object)startedAt);
            Intrinsics.checkNotNull((Object)endedAt);
            java.time.Duration duration2 = this.state.ingameDuration();
            if (duration2 == null) {
                duration2 = java.time.Duration.ZERO;
            }
            $this$writeGameResult_u24lambda_u240 = duration2;
            Intrinsics.checkNotNull((Object)$this$writeGameResult_u24lambda_u240);
            Object object3 = $this$writeGameResult_u24lambda_u240;
            $this$writeGameResult_u24lambda_u240 = teams2;
            object2 = object3;
            instant2 = endedAt;
            instant = startedAt;
            string2 = string3;
            string = options;
            uUID = uUID2;
            int $this$writeGameResult_u24lambda_u241 = 0;
            Iterator bl = $this$writeGameResult_u24lambda_u240.iterator();
            while (bl.hasNext()) {
                object = bl.next();
                BingoTeam bingoTeam = (BingoTeam)object;
                n3 = $this$writeGameResult_u24lambda_u241;
                boolean bl2 = false;
                n2 = ((BingoTeam)it).getPlayers().size();
                $this$writeGameResult_u24lambda_u241 = n3 + n2;
            }
            n3 = $this$writeGameResult_u24lambda_u241;
            $this$writeGameResult_u24lambda_u240 = teams2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                n = 1;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (BingoTeam)element$iv;
                    boolean bl3 = false;
                    if (!((BingoTeam)it).isWinner()) continue;
                    n = 0;
                    break block10;
                }
                n = 1;
            }
        }
        n2 = n;
        UUID uUID3 = this.config.getStatsHostId();
        boolean bl = this.state.isForfeit();
        boolean bl4 = n2 != 0 && teams2.size() > 1;
        int n4 = n3;
        Object object4 = object2;
        Instant instant5 = instant2;
        Instant instant6 = instant;
        String string4 = string2;
        String string5 = string;
        UUID uUID4 = uUID;
        GameInfo insertGame = new GameInfo(uUID4, string5, string4, instant6, instant5, (java.time.Duration)object4, n4, bl4, bl, uUID3);
        for (BingoTeam team : teams2) {
            void this_$iv;
            Object element$iv;
            element$iv = this.serializers.getJson();
            IText value$iv = team.getSimpleName();
            boolean $i$f$encodeToString = false;
            it = object = new GameTeamInfo(team.getKey-zo6Dpdc(), insertGame.getId(), this_$iv.encodeToString((SerializationStrategy)SerializersKt.moduleThenPolymorphic((SerializersModule)this_$iv.getSerializersModule(), (KClass)Reflection.getOrCreateKotlinClass(IText.class)), (Object)value$iv), team.isWinner(), null);
            boolean bl5 = false;
            insertTeams.add(it);
            Object insertTeam = object;
            object = team.getPlayers().iterator();
            while (object.hasNext()) {
                PlayerProfile player = (PlayerProfile)object.next();
                Iterable iterable = team.getCompletedCards();
                int n5 = 0;
                for (Object t : iterable) {
                    void completion;
                    TeamCompletedCard teamCompletedCard = (TeamCompletedCard)t;
                    int n6 = n5;
                    boolean bl6 = false;
                    int n7 = completion.getCard().countItems((Function1<? super BingoObjective, Boolean>)((Function1)arg_0 -> WriteStatsService.writeGameResult$lambda$6$lambda$5(player, arg_0)));
                    n5 = n6 + n7;
                }
                int itemCount = n5;
                GamePlayerInfo insertPlayer = new GamePlayerInfo(((GameTeamInfo)insertTeam).getId-zo6Dpdc(), insertGame.getId(), player.getUuid(), player.getName(), itemCount, null);
                this.broadcastResult(insertGame, (GameTeamInfo)insertTeam, insertPlayer);
                insertPlayers.add(insertPlayer);
            }
        }
        this.stats.insertGame(insertGame, insertTeams, insertPlayers);
        this.stats.updateBestStats(insertGame, insertPlayers);
        return insertGame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final GameInfo writeGame() {
        GameInfo gameInfo;
        void $this$measureTime$iv;
        Logger logger = this.log;
        String message$iv = "Writing game result to stats.db...";
        boolean $i$f$measureTime = false;
        long start$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        $this$measureTime$iv.info(message$iv);
        try {
            boolean bl = false;
            gameInfo = this.writeGameResult();
        }
        finally {
            $this$measureTime$iv.info(message$iv + " - done in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)start$iv)) + "!");
        }
        return gameInfo;
    }

    private static final boolean writeGameResult$lambda$6$lambda$5(PlayerProfile $player, BingoObjective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPlayers().containsKey($player.getUuid());
    }
}

