/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.team;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import me.jfenn.bingo.platform.player.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lme/jfenn/bingo/common/team/OfflinePlayerCache;", "", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/platform/IPlayerManager;Lorg/slf4j/Logger;)V", "Lme/jfenn/bingo/platform/player/PlayerProfile;", "profile", "Lme/jfenn/bingo/platform/IPlayerHandle;", "getOfflinePlayer", "(Lme/jfenn/bingo/platform/player/PlayerProfile;)Lme/jfenn/bingo/platform/IPlayerHandle;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lorg/slf4j/Logger;", "", "offlinePlayerCache", "Ljava/util/Map;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nOfflinePlayerCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflinePlayerCache.kt\nme/jfenn/bingo/common/team/OfflinePlayerCache\n+ 2 Logger.kt\nme/jfenn/bingo/common/utils/LoggerKt\n*L\n1#1,40:1\n10#2,8:41\n*S KotlinDebug\n*F\n+ 1 OfflinePlayerCache.kt\nme/jfenn/bingo/common/team/OfflinePlayerCache\n*L\n32#1:41,8\n*E\n"})
public final class OfflinePlayerCache {
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final Logger log;
    @NotNull
    private final Map<PlayerProfile, IPlayerHandle> offlinePlayerCache;

    public OfflinePlayerCache(@NotNull IPlayerManager playerManager, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.playerManager = playerManager;
        this.log = log;
        this.offlinePlayerCache = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final IPlayerHandle getOfflinePlayer(@NotNull PlayerProfile profile) {
        IPlayerHandle iPlayerHandle;
        void $this$measureTime$iv;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        IPlayerHandle onlinePlayer = this.playerManager.getPlayer(profile.getUuid());
        if (onlinePlayer != null) {
            this.offlinePlayerCache.put(profile, onlinePlayer);
            return onlinePlayer;
        }
        IPlayerHandle cachedPlayer = this.offlinePlayerCache.get(profile);
        if (cachedPlayer != null) {
            return cachedPlayer;
        }
        Logger logger = this.log;
        String message$iv = "Loading offline player data for " + profile.getName();
        boolean $i$f$measureTime = false;
        long start$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        $this$measureTime$iv.info(message$iv);
        try {
            boolean bl = false;
            iPlayerHandle = this.playerManager.getOfflinePlayer(profile);
        }
        finally {
            $this$measureTime$iv.info(message$iv + " - done in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)start$iv)) + "!");
        }
        IPlayerHandle player = iPlayerHandle;
        this.offlinePlayerCache.put(profile, player);
        return player;
    }
}

