/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.timer;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.event.ScopedEvents;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.timer.CountdownPacket;
import me.jfenn.bingo.common.timer.CountdownService;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.mixinhandler.ServerPlayNetworkHandlerMixinHandler;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.model.TickEvent;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0014R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0015R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0016R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0017R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0018R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0019R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lme/jfenn/bingo/common/timer/WaitUntilLoadedController;", "", "Lme/jfenn/bingo/common/event/ScopedEvents;", "events", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/timer/CountdownService;", "countdownService", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lnet/minecraft/server/MinecraftServer;", "server", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/common/event/ScopedEvents;Lme/jfenn/bingo/platform/event/IEventBus;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/timer/CountdownService;Lme/jfenn/bingo/common/team/TeamService;Lnet/minecraft/server/MinecraftServer;Lorg/slf4j/Logger;)V", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/timer/CountdownService;", "Lme/jfenn/bingo/common/team/TeamService;", "Lnet/minecraft/server/MinecraftServer;", "Lorg/slf4j/Logger;", "Ljava/time/Instant;", "startedLoading", "Ljava/time/Instant;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nWaitUntilLoadedController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitUntilLoadedController.kt\nme/jfenn/bingo/common/timer/WaitUntilLoadedController\n+ 2 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n64#2:65\n65#2:72\n774#3:66\n865#3,2:67\n1740#3,3:69\n*S KotlinDebug\n*F\n+ 1 WaitUntilLoadedController.kt\nme/jfenn/bingo/common/timer/WaitUntilLoadedController\n*L\n43#1:65\n52#1:72\n46#1:66\n46#1:67,2\n47#1:69,3\n*E\n"})
public final class WaitUntilLoadedController {
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final BingoState state;
    @NotNull
    private final CountdownService countdownService;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final Logger log;
    @Nullable
    private Instant startedLoading;

    public WaitUntilLoadedController(@NotNull ScopedEvents events, @NotNull IEventBus eventBus, @NotNull BingoConfig config, @NotNull BingoState state, @NotNull CountdownService countdownService, @NotNull TeamService teamService, @NotNull MinecraftServer server, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)countdownService, (String)"countdownService");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.config = config;
        this.state = state;
        this.countdownService = countdownService;
        this.teamService = teamService;
        this.server = server;
        this.log = log;
        ScopedEvents.onEnter$default(events, GameState.LOADING, false, arg_0 -> WaitUntilLoadedController._init_$lambda$0(this, arg_0), 2, null);
        events.onGameTick((Function1<? super TickEvent, Unit>)((Function1)arg_0 -> WaitUntilLoadedController._init_$lambda$3(this, eventBus, arg_0)));
    }

    private static final Unit _init_$lambda$0(WaitUntilLoadedController this$0, GameState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.startedLoading = Instant.now();
        this$0.log.info("Waiting until all players have loaded spawn terrain...");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$3(WaitUntilLoadedController this$0, IEventBus $eventBus, TickEvent it) {
        Instant startedLoading;
        block14: {
            block13: {
                boolean isEveryPlayerLoaded;
                block12: {
                    void $this$all$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (this$0.state.getState() != GameState.LOADING) {
                        return Unit.INSTANCE;
                    }
                    Instant instant = this$0.startedLoading;
                    if (instant == null) {
                        return Unit.INSTANCE;
                    }
                    int $this$milliseconds$iv = 40;
                    boolean $i$f$getMilliseconds22 = false;
                    Duration duration2 = Duration.ofMillis($this$milliseconds$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
                    startedLoading = instant.plus(duration2);
                    List list = this$0.server.method_3760().method_14571();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
                    Iterable $i$f$getMilliseconds22 = list;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        class_3222 it2 = (class_3222)element$iv$iv;
                        boolean bl = false;
                        TeamService teamService = this$0.teamService;
                        Intrinsics.checkNotNull((Object)it2);
                        if (!teamService.isPlaying(it2)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v4 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            class_3222 player = (class_3222)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)player);
                            Instant lastMovementPacket = ServerPlayNetworkHandlerMixinHandler.INSTANCE.getLastPlayerMovement(player);
                            if (lastMovementPacket != null && lastMovementPacket.compareTo(startedLoading) > 0) continue;
                            v4 = false;
                            break block12;
                        }
                        v4 = isEveryPlayerLoaded = true;
                    }
                }
                if (!isEveryPlayerLoaded) break block13;
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
                Intrinsics.checkNotNull((Object)startedLoading);
                Duration duration3 = DurationKt.minus(instant, startedLoading);
                int $this$seconds$iv = 40;
                boolean $i$f$getSeconds = false;
                Duration duration4 = Duration.ofSeconds($this$seconds$iv);
                Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
                if (duration3.compareTo(duration4) <= 0) break block14;
            }
            return Unit.INSTANCE;
        }
        Logger logger = this$0.log;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        logger.info("Waiting until all players have loaded spawn terrain... Done! (" + DurationKt.minus(instant, startedLoading) + ")");
        if (this$0.config.getCountdownDelayTicks() > 0 || this$0.config.getCountdownSeconds() > 0) {
            this$0.state.changeState($eventBus, GameState.COUNTDOWN);
        } else {
            this$0.state.changeState($eventBus, GameState.PLAYING);
            this$0.countdownService.sendCountdownPacket(new CountdownPacket(0));
        }
        return Unit.INSTANCE;
    }
}

