/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.integrations.chunky;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.integrations.chunky.ChunkyConfig;
import me.jfenn.bingo.integrations.chunky.IChunkyApi;
import me.jfenn.bingo.platform.ICommandRunner;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0012R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lme/jfenn/bingo/integrations/chunky/ChunkyImpl;", "Lme/jfenn/bingo/integrations/chunky/IChunkyApi;", "Lnet/minecraft/server/MinecraftServer;", "server", "Lme/jfenn/bingo/integrations/chunky/ChunkyConfig;", "config", "Lme/jfenn/bingo/platform/ICommandRunner;", "commandRunner", "Lorg/slf4j/Logger;", "log", "<init>", "(Lnet/minecraft/server/MinecraftServer;Lme/jfenn/bingo/integrations/chunky/ChunkyConfig;Lme/jfenn/bingo/platform/ICommandRunner;Lorg/slf4j/Logger;)V", "", "startPregen", "()V", "cancelTasks", "Lnet/minecraft/server/MinecraftServer;", "Lme/jfenn/bingo/integrations/chunky/ChunkyConfig;", "Lme/jfenn/bingo/platform/ICommandRunner;", "Lorg/slf4j/Logger;", "bingo-integration-chunky"})
@SourceDebugExtension(value={"SMAP\nChunkyImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkyImpl.kt\nme/jfenn/bingo/integrations/chunky/ChunkyImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,42:1\n216#2,2:43\n*S KotlinDebug\n*F\n+ 1 ChunkyImpl.kt\nme/jfenn/bingo/integrations/chunky/ChunkyImpl\n*L\n20#1:43,2\n*E\n"})
public final class ChunkyImpl
implements IChunkyApi {
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final ChunkyConfig config;
    @NotNull
    private final ICommandRunner commandRunner;
    @NotNull
    private final Logger log;

    public ChunkyImpl(@NotNull MinecraftServer server, @NotNull ChunkyConfig config, @NotNull ICommandRunner commandRunner, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)commandRunner, (String)"commandRunner");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.server = server;
        this.config = config;
        this.commandRunner = commandRunner;
        this.log = log;
        this.log.info("Integrations: Chunky is installed!");
    }

    @Override
    public void startPregen() {
        try {
            Map<String, Integer> $this$forEach$iv = this.config.getChunkyWorlds();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> element$iv;
                Map.Entry<String, Integer> entry = element$iv = iterator.next();
                boolean bl = false;
                String world = entry.getKey();
                int size = ((Number)entry.getValue()).intValue();
                if (size <= 0) continue;
                this.commandRunner.runSilentCommand(this.server, "chunky world " + world);
                this.commandRunner.runSilentCommand(this.server, "chunky radius " + size);
                this.commandRunner.runSilentCommand(this.server, "chunky start");
            }
            this.commandRunner.runSilentCommand(this.server, "chunky continue");
        }
        catch (Throwable e) {
            this.log.error("Error starting chunky pre-generation:", e);
        }
    }

    @Override
    public void cancelTasks() {
        try {
            this.commandRunner.runSilentCommand(this.server, "chunky cancel");
            this.commandRunner.runSilentCommand(this.server, "chunky confirm");
        }
        catch (Throwable e) {
            this.log.error("Error cancelling chunky pre-generation:", e);
        }
    }
}

