/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.bossbar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.bingo.common.config.PlayerSettings;
import me.jfenn.bingo.common.config.PlayerSettingsService;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.platform.IBossBar;
import me.jfenn.bingo.platform.IBossBarManager;
import me.jfenn.bingo.platform.IPlayerHandle;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001bR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001cR\"\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0012\u0004\u0012\u00020\u000e0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lme/jfenn/bingo/common/bossbar/BossBarService;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "playerSettingsService", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/platform/IBossBarManager;", "bossBarManager", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/config/PlayerSettingsService;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/platform/IBossBarManager;)V", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "Lme/jfenn/bingo/platform/IBossBar;", "createBossbar", "(Lme/jfenn/bingo/common/team/BingoTeam;)Lme/jfenn/bingo/platform/IBossBar;", "getBossbar", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "updateBossBar", "(Lme/jfenn/bingo/platform/IPlayerHandle;)V", "clearBossBars", "()V", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/config/PlayerSettingsService;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/platform/IBossBarManager;", "", "Lme/jfenn/bingo/common/team/BingoTeamKey;", "bossBars", "Ljava/util/Map;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nBossBarService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BossBarService.kt\nme/jfenn/bingo/common/bossbar/BossBarService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n382#2,7:64\n774#3:71\n865#3,2:72\n1869#3,2:74\n*S KotlinDebug\n*F\n+ 1 BossBarService.kt\nme/jfenn/bingo/common/bossbar/BossBarService\n*L\n37#1:64,7\n59#1:71\n59#1:72,2\n60#1:74,2\n*E\n"})
public final class BossBarService
extends BingoComponent {
    @NotNull
    private final BingoState state;
    @NotNull
    private final PlayerSettingsService playerSettingsService;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final IBossBarManager bossBarManager;
    @NotNull
    private final Map<BingoTeamKey, IBossBar> bossBars;

    public BossBarService(@NotNull BingoState state, @NotNull PlayerSettingsService playerSettingsService, @NotNull TeamService teamService, @NotNull IBossBarManager bossBarManager) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)playerSettingsService, (String)"playerSettingsService");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)bossBarManager, (String)"bossBarManager");
        this.state = state;
        this.playerSettingsService = playerSettingsService;
        this.teamService = teamService;
        this.bossBarManager = bossBarManager;
        this.bossBars = new LinkedHashMap();
    }

    private final IBossBar createBossbar(BingoTeam team) {
        IBossBar bar;
        IBossBar iBossBar;
        String id;
        IBossBar iBossBar2;
        Object object = team;
        if (object == null || (object = ((BingoTeam)object).getId()) == null) {
            object = "preview";
        }
        if ((iBossBar2 = this.bossBarManager.get(id = "yet-another-minecraft-bingo:" + (String)object)) == null) {
            class_5250 class_52502 = class_2561.method_43470((String)"Time Remaining");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            iBossBar2 = this.bossBarManager.add(id, (class_2561)class_52502);
        }
        IBossBar $this$createBossbar_u24lambda_u240 = iBossBar = (bar = iBossBar2);
        boolean bl = false;
        $this$createBossbar_u24lambda_u240.setColor(IBossBar.Color.WHITE);
        $this$createBossbar_u24lambda_u240.setStyle(IBossBar.Style.PROGRESS);
        $this$createBossbar_u24lambda_u240.setValue(0);
        $this$createBossbar_u24lambda_u240.setMaxValue(10000);
        return iBossBar;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IBossBar getBossbar(@Nullable BingoTeam team) {
        Object object;
        void $this$getOrPut$iv;
        Map<BingoTeamKey, IBossBar> map = this.bossBars;
        BingoTeam bingoTeam = team;
        String string = bingoTeam != null ? bingoTeam.getKey-zo6Dpdc() : null;
        BingoTeamKey key$iv = string != null ? BingoTeamKey.box-impl(string) : null;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            IBossBar answer$iv = this.createBossbar(team);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IBossBar)object;
    }

    public final void updateBossBar(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerSettings settings = this.playerSettingsService.getPlayer(player);
        BingoTeam team = this.teamService.getPlayerTeam(player);
        for (Map.Entry<BingoTeamKey, IBossBar> entry : this.bossBars.entrySet()) {
            boolean shouldIncludePlayer;
            BingoTeamKey bingoTeamKey = entry.getKey();
            String teamKey2 = bingoTeamKey != null ? bingoTeamKey.unbox-impl() : null;
            IBossBar bossBar = entry.getValue();
            boolean bl = shouldIncludePlayer = this.state.isLobbyMode() || team != null;
            if (settings.getBossbar()) {
                boolean bl2;
                String string;
                BingoTeam bingoTeam = team;
                String string2 = string = bingoTeam != null ? bingoTeam.getKey-zo6Dpdc() : null;
                if (teamKey2 == null) {
                    bl2 = string == null;
                } else {
                    String string3 = string;
                    bl2 = string3 == null ? false : BingoTeamKey.equals-impl0(teamKey2, string3);
                }
                if (bl2 && shouldIncludePlayer) {
                    bossBar.addPlayer(player);
                    continue;
                }
            }
            bossBar.removePlayer(player);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearBossBars() {
        void $this$filterTo$iv$iv;
        for (IBossBar bossBar : this.bossBars.values()) {
            this.bossBarManager.remove(bossBar);
        }
        this.bossBars.clear();
        Iterable $this$filter$iv = this.bossBarManager.list();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IBossBar it = (IBossBar)element$iv$iv;
            boolean bl = false;
            String string = it.getId();
            boolean bl2 = string != null ? StringsKt.startsWith$default((String)string, (String)"yet-another-minecraft-bingo:", (boolean)false, (int)2, null) : false;
            if (!(bl2 || it.getId() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IBossBar it = (IBossBar)element$iv;
            boolean bl = false;
            this.bossBarManager.remove(it);
        }
    }
}

