/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.commands;

import cn.superiormc.ultimateshop.commands.AbstractCommand;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.methods.Product.SellProductMethod;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SubQuickSell
extends AbstractCommand {
    public SubQuickSell() {
        this.id = "quicksell";
        this.requiredPermission = "ultimateshop." + this.id;
        this.onlyInGame = false;
        this.requiredArgLength = new Integer[]{3, 4};
        this.requiredConsoleArgLength = new Integer[]{4, 5};
    }

    @Override
    public void executeCommandInGame(String[] args, Player player) {
        ObjectShop tempVal1 = ConfigManager.configManager.getShop(args[1]);
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText(player, "error.shop-not-found", "shop", args[1]);
            return;
        }
        ObjectItem tempVal2 = tempVal1.getProductNotHidden(args[2]);
        if (tempVal2 == null) {
            LanguageManager.languageManager.sendStringText(player, "error.product-not-found", "product", args[2]);
            return;
        }
        switch (args.length) {
            case 3: {
                SellProductMethod.startSell(tempVal2, player, true);
                break;
            }
            case 4: {
                boolean sellAll;
                if (args[args.length - 1].equals("*")) {
                    // empty if block
                }
                SellProductMethod.startSell(tempVal2, player, true, false, sellAll, (sellAll = false) ? 1 : Integer.parseInt(args[3]));
            }
        }
    }

    @Override
    public void executeCommandInConsole(String[] args) {
        Player player = Bukkit.getPlayer((String)args[args.length - 1]);
        if (player == null) {
            LanguageManager.languageManager.sendStringText("error.player-not-found", "player", args[args.length - 1]);
            return;
        }
        ObjectShop tempVal1 = ConfigManager.configManager.getShop(args[1]);
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText(player, "error.shop-not-found", "shop", args[1]);
            return;
        }
        ObjectItem tempVal2 = tempVal1.getProductNotHidden(args[2]);
        if (tempVal2 == null) {
            LanguageManager.languageManager.sendStringText(player, "error.product-not-found", "product", args[2]);
            return;
        }
        switch (args.length) {
            case 4: {
                SellProductMethod.startSell(tempVal2, player, true);
                break;
            }
            case 5: {
                boolean sellAll;
                if (args[args.length - 1].equals("*")) {
                    // empty if block
                }
                SellProductMethod.startSell(tempVal2, player, true, false, sellAll, (sellAll = false) ? 1 : Integer.parseInt(args[3]));
            }
        }
    }

    @Override
    public List<String> getTabResult(String[] args) {
        ArrayList<String> tempVal1 = new ArrayList<String>();
        switch (args.length) {
            case 2: {
                for (ObjectShop tempVal2 : ConfigManager.configManager.getShops()) {
                    tempVal1.add(tempVal2.getShopName());
                }
                break;
            }
            case 3: {
                ObjectShop tempVal3 = ConfigManager.configManager.getShop(args[1]);
                if (tempVal3 == null) {
                    tempVal1.add(LanguageManager.languageManager.getStringText("command-tab.unknown-shop"));
                    break;
                }
                for (ObjectItem tempVal4 : tempVal3.getProductListNotHidden()) {
                    tempVal1.add(tempVal4.getItemConfig().getName());
                }
                break;
            }
            case 4: {
                tempVal1.add("1");
                tempVal1.add("5");
            }
        }
        return tempVal1;
    }
}

