/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.commands;

import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.commands.AbstractCommand;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.caches.ObjectRandomPlaceholderCache;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectRandomPlaceholder;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SubResetRandomPlaceholder
extends AbstractCommand {
    public SubResetRandomPlaceholder() {
        this.id = "resetrandomplaceholder";
        this.requiredPermission = "ultimateshop." + this.id;
        this.onlyInGame = false;
        this.premiumOnly = true;
        this.requiredArgLength = new Integer[]{2, 3};
    }

    @Override
    public void executeCommandInGame(String[] args, Player player) {
        ServerCache tempVal1;
        ObjectRandomPlaceholder placeholder = ConfigManager.configManager.getRandomPlaceholder(args[1]);
        if (placeholder == null) {
            LanguageManager.languageManager.sendStringText(player, "error.random-placeholder-not-found", "placeholder", args[1]);
            return;
        }
        if (args.length < 3 || args[2].equals("global")) {
            tempVal1 = ServerCache.serverCache;
        } else {
            Player changePlayer = Bukkit.getPlayer((String)args[2]);
            if (changePlayer == null) {
                LanguageManager.languageManager.sendStringText(player, "error.player-not-found", "player", args[2]);
                return;
            }
            tempVal1 = CacheManager.cacheManager.getPlayerCache(changePlayer);
        }
        ObjectRandomPlaceholderCache cache = tempVal1.getRandomPlaceholderCache().get(placeholder);
        if (cache == null) {
            tempVal1.addRandomPlaceholderCache(placeholder);
            cache = tempVal1.getRandomPlaceholderCache().get(placeholder);
        }
        if (cache == null) {
            LanguageManager.languageManager.sendStringText(player, "error.random-placeholder-player-arg-required", "placeholder", args[1]);
            return;
        }
        cache.removeRefreshDoneTime();
        cache.setRefreshTime();
        LanguageManager.languageManager.sendStringText(player, "reset-random-placeholder", "placeholder", args[1], "value", CommonUtil.translateStringList(cache.getNowValue()));
    }

    @Override
    public void executeCommandInConsole(String[] args) {
        ServerCache tempVal1;
        ObjectRandomPlaceholder placeholder = ConfigManager.configManager.getRandomPlaceholder(args[1]);
        if (placeholder == null) {
            LanguageManager.languageManager.sendStringText("error.random-placeholder-not-found", "placeholder", args[1]);
            return;
        }
        if (args.length < 3 || args[2].equals("global")) {
            tempVal1 = ServerCache.serverCache;
        } else {
            Player changePlayer = Bukkit.getPlayer((String)args[2]);
            if (changePlayer == null) {
                LanguageManager.languageManager.sendStringText("error.player-not-found", "player", args[2]);
                return;
            }
            tempVal1 = CacheManager.cacheManager.getPlayerCache(changePlayer);
        }
        ObjectRandomPlaceholderCache cache = tempVal1.getRandomPlaceholderCache().get(placeholder);
        if (cache == null) {
            tempVal1.addRandomPlaceholderCache(placeholder);
            cache = tempVal1.getRandomPlaceholderCache().get(placeholder);
        }
        if (cache == null) {
            LanguageManager.languageManager.sendStringText("error.random-placeholder-player-arg-required", "placeholder", args[1]);
            return;
        }
        cache.removeRefreshDoneTime();
        cache.setRefreshTime();
        LanguageManager.languageManager.sendStringText("reset-random-placeholder", "placeholder", args[1], "value", CommonUtil.translateStringList(cache.getNowValue()));
    }

    @Override
    public List<String> getTabResult(String[] args) {
        ArrayList<String> tempVal1 = new ArrayList<String>();
        switch (args.length) {
            case 2: {
                for (ObjectRandomPlaceholder tempVal2 : ConfigManager.configManager.getRandomPlaceholders()) {
                    tempVal1.add(tempVal2.getID());
                }
                break;
            }
            case 3: {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    tempVal1.add(player.getName());
                }
                tempVal1.add("global");
            }
        }
        return tempVal1;
    }
}

