/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.database;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.libs.hikari.HikariConfig;
import cn.superiormc.ultimateshop.libs.hikari.HikariDataSource;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class SQLDatabase {
    public static HikariDataSource dataSource;

    public static void initSQL() {
        UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fTrying connect to SQL database...");
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(ConfigManager.configManager.getString("database.jdbc-class", new String[0]));
        config.setJdbcUrl(ConfigManager.configManager.getString("database.jdbc-url", new String[0]));
        if (ConfigManager.configManager.getString("database.properties.user", new String[0]) != null) {
            config.setUsername(ConfigManager.configManager.getString("database.properties.user", new String[0]));
            config.setPassword(ConfigManager.configManager.getString("database.properties.password", new String[0]));
        }
        dataSource = new HikariDataSource(config);
        try (Connection conn = dataSource.getConnection();){
            if (!conn.isValid(5)) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cFailed connect to SQL database!");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        SQLDatabase.createTable();
    }

    public static void closeSQL() {
        if (dataSource != null && !dataSource.isClosed()) {
            dataSource.close();
        }
    }

    public static void createTable() {
        try (Connection conn = dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS ultimateshop_useTimes (\n    playerUUID VARCHAR(36) NOT NULL,\n    shop VARCHAR(48) NOT NULL,\n    product VARCHAR(48) NOT NULL,\n    buyUseTimes INT DEFAULT 0,\n    totalBuyUseTimes INT DEFAULT 0,\n    sellUseTimes INT DEFAULT 0,\n    totalSellUseTimes INT DEFAULT 0,\n    lastBuyTime DATETIME NULL,\n    lastSellTime DATETIME NULL,\n    lastResetBuyTime DATETIME NULL,\n    lastResetSellTime DATETIME NULL,\n    cooldownBuyTime DATETIME NULL,\n    cooldownSellTime DATETIME NULL,\n    PRIMARY KEY (playerUUID, shop, product)\n)\n");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void checkData(ServerCache cache) {
        CompletableFuture.supplyAsync(() -> {
            try (Connection conn = dataSource.getConnection();){
                PreparedStatement ps;
                if (cache.server) {
                    ps = conn.prepareStatement("SELECT * FROM ultimateshop_useTimes WHERE playerUUID = 'Global-Server'");
                } else {
                    ps = conn.prepareStatement("SELECT * FROM ultimateshop_useTimes WHERE playerUUID = ?");
                    ps.setString(1, cache.player.getUniqueId().toString());
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        cache.setUseTimesCache(rs.getString("shop"), rs.getString("product"), rs.getInt("buyUseTimes"), rs.getInt("totalBuyUseTimes"), rs.getInt("sellUseTimes"), rs.getInt("totalSellUseTimes"), rs.getString("lastBuyTime"), rs.getString("lastSellTime"), rs.getString("lastResetBuyTime"), rs.getString("lastResetSellTime"), rs.getString("cooldownBuyTime"), rs.getString("cooldownSellTime"));
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    public static void updateData(ServerCache cache, boolean quitServer) {
        String playerUUID = cache.server ? "Global-Server" : cache.player.getUniqueId().toString();
        Map<ObjectItem, ObjectUseTimesCache> tempVal1 = cache.getUseTimesCache();
        for (ObjectItem item : tempVal1.keySet()) {
            ObjectUseTimesCache tempCache = tempVal1.get(item);
            if (tempCache == null || tempCache.isEmpty()) continue;
            CompletableFuture.runAsync(() -> {
                String sql = "INSERT INTO ultimateshop_useTimes\n(playerUUID, shop, product, buyUseTimes, totalBuyUseTimes, sellUseTimes, totalSellUseTimes,\n lastBuyTime, lastSellTime, lastResetBuyTime, lastResetSellTime, cooldownBuyTime, cooldownSellTime)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    buyUseTimes = VALUES(buyUseTimes),\n    totalBuyUseTimes = VALUES(totalBuyUseTimes),\n    sellUseTimes = VALUES(sellUseTimes),\n    totalSellUseTimes = VALUES(totalSellUseTimes),\n    lastBuyTime = VALUES(lastBuyTime),\n    lastSellTime = VALUES(lastSellTime),\n    lastResetBuyTime = VALUES(lastResetBuyTime),\n    lastResetSellTime = VALUES(lastResetSellTime),\n    cooldownBuyTime = VALUES(cooldownBuyTime),\n    cooldownSellTime = VALUES(cooldownSellTime)\n";
                try (Connection conn = dataSource.getConnection();
                     PreparedStatement ps = conn.prepareStatement(sql);){
                    ps.setString(1, playerUUID);
                    ps.setString(2, item.getShop());
                    ps.setString(3, item.getProduct());
                    ps.setInt(4, tempCache.getBuyUseTimes());
                    ps.setInt(5, tempCache.getTotalBuyUseTimes());
                    ps.setInt(6, tempCache.getSellUseTimes());
                    ps.setInt(7, tempCache.getTotalSellUseTimes());
                    ps.setString(8, tempCache.getLastBuyTime());
                    ps.setString(9, tempCache.getLastSellTime());
                    ps.setString(10, tempCache.getLastResetBuyTime());
                    ps.setString(11, tempCache.getLastResetSellTime());
                    ps.setString(12, tempCache.getCooldownBuyTime());
                    ps.setString(13, tempCache.getCooldownSellTime());
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            });
        }
        if (quitServer) {
            CacheManager.cacheManager.removePlayerCache(cache.player);
        }
    }

    public static void updateDataOnDisable(ServerCache cache, boolean disable) {
        String playerUUID = cache.server ? "Global-Server" : cache.player.getUniqueId().toString();
        Map<ObjectItem, ObjectUseTimesCache> tempVal1 = cache.getUseTimesCache();
        for (ObjectItem item : tempVal1.keySet()) {
            ObjectUseTimesCache tempCache = tempVal1.get(item);
            if (tempCache == null || tempCache.isEmpty()) continue;
            String sql = "INSERT INTO ultimateshop_useTimes\n(playerUUID, shop, product, buyUseTimes, totalBuyUseTimes, sellUseTimes, totalSellUseTimes,\n lastBuyTime, lastSellTime, lastResetBuyTime, lastResetSellTime, cooldownBuyTime, cooldownSellTime)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    buyUseTimes = VALUES(buyUseTimes),\n    totalBuyUseTimes = VALUES(totalBuyUseTimes),\n    sellUseTimes = VALUES(sellUseTimes),\n    totalSellUseTimes = VALUES(totalSellUseTimes),\n    lastBuyTime = VALUES(lastBuyTime),\n    lastSellTime = VALUES(lastSellTime),\n    lastResetBuyTime = VALUES(lastResetBuyTime),\n    lastResetSellTime = VALUES(lastResetSellTime),\n    cooldownBuyTime = VALUES(cooldownBuyTime),\n    cooldownSellTime = VALUES(cooldownSellTime)\n";
            try {
                Connection conn = dataSource.getConnection();
                try {
                    PreparedStatement ps = conn.prepareStatement(sql);
                    try {
                        ps.setString(1, playerUUID);
                        ps.setString(2, item.getShop());
                        ps.setString(3, item.getProduct());
                        ps.setInt(4, tempCache.getBuyUseTimes());
                        ps.setInt(5, tempCache.getTotalBuyUseTimes());
                        ps.setInt(6, tempCache.getSellUseTimes());
                        ps.setInt(7, tempCache.getTotalSellUseTimes());
                        ps.setString(8, tempCache.getLastBuyTime());
                        ps.setString(9, tempCache.getLastSellTime());
                        ps.setString(10, tempCache.getLastResetBuyTime());
                        ps.setString(11, tempCache.getLastResetSellTime());
                        ps.setString(12, tempCache.getCooldownBuyTime());
                        ps.setString(13, tempCache.getCooldownSellTime());
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps == null) continue;
                        ps.close();
                    }
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (cache.server) {
            // empty if block
        }
        CacheManager.cacheManager.removePlayerCache(cache.player);
    }
}

