/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.form;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.cache.PlayerCache;
import cn.superiormc.ultimateshop.gui.FormGUI;
import cn.superiormc.ultimateshop.gui.form.FormBuyMoreGUI;
import cn.superiormc.ultimateshop.gui.form.FormShopGUI;
import cn.superiormc.ultimateshop.gui.inv.ShopGUI;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.methods.ModifyDisplayItem;
import cn.superiormc.ultimateshop.methods.Product.BuyProductMethod;
import cn.superiormc.ultimateshop.methods.Product.SellProductMethod;
import cn.superiormc.ultimateshop.methods.ProductTradeStatus;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.ObjectAction;
import cn.superiormc.ultimateshop.objects.menus.ObjectMoreMenu;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.form.SimpleForm;

public class FormInfoGUI
extends FormGUI {
    private final ObjectItem item;
    private final ObjectMoreMenu menu;
    private final String amount;

    public FormInfoGUI(Player owner, ObjectItem item) {
        super(owner);
        this.item = item;
        this.menu = item.getBuyMoreMenu();
        this.amount = "1";
        this.constructGUI();
    }

    public FormInfoGUI(Player owner, ObjectItem item, String amount) {
        super(owner);
        this.item = item;
        this.menu = item.getBuyMoreMenu();
        this.amount = amount;
        this.constructGUI();
    }

    @Override
    protected void constructGUI() {
        PlayerCache tempVal1 = CacheManager.cacheManager.getPlayerCache(this.player.getPlayer());
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText(this.player.getPlayer(), "error.player-not-found", "player", this.player.getName());
            return;
        }
        SimpleForm.Builder tempVal2 = SimpleForm.builder();
        tempVal2.title(TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.title", "Shop", "item-name", this.item.getDisplayName(this.player), "amount", this.amount)));
        ArrayList<String> content = new ArrayList<String>();
        if (this.item.getDisplayItem(this.player).hasItemMeta() && this.item.getDisplayItem(this.player).getItemMeta().hasLore()) {
            content.addAll(UltimateShop.methodUtil.getItemLore(this.item.getDisplayItem(this.player).getItemMeta()));
            content.add(" ");
        }
        content.addAll(ModifyDisplayItem.getModifiedLore(this.player.getPlayer(), this.getAmount(), this.item, false, true, "general"));
        tempVal2.content(TextUtil.parse(this.bedrockTransfer(content)));
        String itemName = this.item.getDisplayName(this.player);
        ButtonComponent buy = ButtonComponent.of((String)TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.buttons.buy", "Buy", "item-name", itemName)));
        ButtonComponent sell = ButtonComponent.of((String)TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.buttons.sell", "Sell", "item-name", itemName)));
        ButtonComponent sellAll = ButtonComponent.of((String)TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.buttons.sell-all", "Sell All", "item-name", itemName)));
        ButtonComponent buyMore = ButtonComponent.of((String)TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.buttons.buy-more", "Buy More", "item-name", itemName)));
        HashMap<ClickType, ButtonComponent> clickEvents = new HashMap<ClickType, ButtonComponent>();
        for (ClickType type : ClickType.values()) {
            ConfigurationSection tempVal3;
            String clickType = ConfigManager.configManager.getClickAction(type, this.item);
            if (CommonUtil.containsAnyString(clickType, "buy", "sell", "buy-or-sell", "sell-all", "select-amount") || (tempVal3 = ConfigManager.configManager.getSection("menu.click-event-actions." + clickType)) == null || tempVal3.getBoolean("buy-only", false) && this.item.getBuyPrice().empty || tempVal3.getBoolean("sell-only", false) && this.item.getSellPrice().empty) continue;
            ButtonComponent clickEvent = ButtonComponent.of((String)TextUtil.parse(this.player, tempVal3.getString("display-name", clickType)));
            clickEvents.put(type, clickEvent);
        }
        ButtonComponent back = ButtonComponent.of((String)TextUtil.parse(this.player, ConfigManager.configManager.getString("menu.bedrock.info.buttons.back", "Back")));
        if (!this.item.getBuyPrice().empty) {
            tempVal2.button(buy);
        }
        if (!this.item.getSellPrice().empty) {
            tempVal2.button(sell);
            if (ConfigManager.configManager.containsClickAction("sell-all") && this.item.isEnableSellAll()) {
                tempVal2.button(sellAll);
            }
        }
        if (this.item.getBuyMore() && ConfigManager.configManager.containsClickAction("select-amount")) {
            tempVal2.button(buyMore);
        }
        for (ButtonComponent buttonComponent : clickEvents.values()) {
            tempVal2.button(buttonComponent);
        }
        tempVal2.button(back);
        tempVal2.validResultHandler(response -> {
            this.removeOpenGUIStatus();
            if (response.clickedButton().equals((Object)buy)) {
                this.doThing(true);
            } else if (response.clickedButton().equals((Object)sell)) {
                this.doThing(false);
            } else if (response.clickedButton().equals((Object)buyMore)) {
                FormBuyMoreGUI buyOrSellGUI = new FormBuyMoreGUI(this.player, this.item);
                buyOrSellGUI.openGUI(true);
            } else if (response.clickedButton().equals((Object)back)) {
                FormShopGUI shopGUI = new FormShopGUI(this.player, this.item.getShopObject(), this.item.getShopObject().getShopMenuObject(), true);
                shopGUI.openGUI(true);
            } else if (response.clickedButton().equals((Object)sellAll)) {
                SellProductMethod.startSell(this.item, this.player, !ConfigManager.configManager.getBoolean("placeholder.click.enabled"), false, true, this.menu.getSection().getInt("max-amount", 64));
                if (ConfigManager.configManager.getBoolean("menu.bedrock.not-auto-close")) {
                    ShopGUI.openGUI(this.player, this.item.getShopObject(), true, true);
                }
            }
            for (ClickType type : clickEvents.keySet()) {
                ButtonComponent buttonComponent = (ButtonComponent)clickEvents.get(type);
                if (!response.clickedButton().equals((Object)buttonComponent)) continue;
                String clickType = ConfigManager.configManager.getClickAction(type, this.item);
                ObjectAction action = new ObjectAction(ConfigManager.configManager.getSection("menu.click-event-actions." + clickType), this.item);
                action.runAllActions(new ObjectThingRun(this.player, type));
                if (action.getLastTradeStatus() == null || action.getLastTradeStatus().getStatus() == ProductTradeStatus.Status.DONE) continue;
                this.item.getFailAction().runAllActions(new ObjectThingRun(this.player, type));
            }
        });
        tempVal2.closedOrInvalidResultHandler(response -> this.removeOpenGUIStatus());
        this.form = tempVal2.build();
    }

    private String bedrockTransfer(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    public ObjectItem getItem() {
        return this.item;
    }

    public void doThing(boolean buyOrSell) {
        this.removeOpenGUIStatus();
        if (this.amount == null) {
            return;
        }
        boolean b = ConfigManager.configManager.getBoolean("placeholder.click.enabled");
        if (!buyOrSell && this.amount.equals("all")) {
            if (!this.item.getSellPrice().empty) {
                SellProductMethod.startSell(this.item, this.player, !b, false, true, this.menu.getSection().getInt("max-amount", 64));
            }
            return;
        }
        if (buyOrSell) {
            if (!this.item.getBuyPrice().empty) {
                BuyProductMethod.startBuy(this.item, this.player, !b, false, this.getAmount());
            }
        } else if (!this.item.getSellPrice().empty) {
            SellProductMethod.startSell(this.item, this.player, !b, false, this.getAmount());
        }
        if (ConfigManager.configManager.getBoolean("menu.bedrock.not-auto-close")) {
            ShopGUI.openGUI(this.player, this.item.getShopObject(), true, true);
        }
    }

    public int getAmount() {
        int realAmount;
        try {
            realAmount = Integer.parseInt(this.amount);
            if (realAmount < 1) {
                realAmount = 1;
            } else if (realAmount > this.menu.getSection().getInt("max-amount", 64)) {
                realAmount = this.menu.getSection().getInt("max-amount", 64);
            }
        }
        catch (Throwable e) {
            realAmount = 1;
        }
        return realAmount;
    }
}

