/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.form;

import cn.superiormc.ultimateshop.cache.PlayerCache;
import cn.superiormc.ultimateshop.cache.ServerCache;
import cn.superiormc.ultimateshop.gui.FormGUI;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItemStack;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.menus.MenuSender;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.form.SimpleForm;

public class FormShopGUI
extends FormGUI {
    private final ObjectShop shop;
    private final boolean bypass;
    private final ObjectMenu shopMenu;

    public FormShopGUI(Player owner, ObjectShop shop, ObjectMenu shopMenu, boolean bypass) {
        super(owner);
        this.shop = shop;
        this.bypass = bypass;
        this.shopMenu = shopMenu;
        this.constructGUI();
    }

    @Override
    protected void constructGUI() {
        AbstractButton button;
        int slot;
        PlayerCache tempVal1 = CacheManager.cacheManager.getPlayerCache(this.player);
        ServerCache tempVal2 = ServerCache.serverCache;
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText(this.player, "error.player-not-found", "player", this.player.getName());
            return;
        }
        if (this.shop.getShopMenuObject() == null) {
            LanguageManager.languageManager.sendStringText(this.player, "error.shop-does-not-have-menu", "shop", this.shop.getShopName());
            return;
        }
        if (this.shop.getShopMenuObject().menuConfigs == null) {
            LanguageManager.languageManager.sendStringText(this.player, "error.shop-menu-not-found", "shop", this.shop.getShopName(), "menu", this.shop.getShopMenu());
            return;
        }
        if (!this.bypass && !this.shop.getShopMenuObject().getCondition().getAllBoolean(new ObjectThingRun(this.player))) {
            LanguageManager.languageManager.sendStringText(this.player, "menu-condition-not-meet", "menu", this.shop.getShopMenu());
            return;
        }
        for (ObjectItem tempVal5 : this.shop.getProductList()) {
            ObjectUseTimesCache tempVal4;
            ObjectUseTimesCache tempVal3 = tempVal1.getUseTimesCache().get(tempVal5);
            if (tempVal3 != null) {
                tempVal3.refreshBuyTimes();
                tempVal3.refreshSellTimes();
            }
            if ((tempVal4 = tempVal2.getUseTimesCache().get(tempVal5)) == null) continue;
            tempVal4.refreshBuyTimes();
            tempVal4.refreshSellTimes();
        }
        this.menuButtons = this.shop.getShopMenuObject().getMenu(MenuSender.of(this.player));
        SimpleForm.Builder tempVal5 = SimpleForm.builder();
        LinkedHashMap<Integer, AbstractButton> tempVal8 = new LinkedHashMap<Integer, AbstractButton>();
        LinkedHashMap<Integer, AbstractButton> tempVal7 = new LinkedHashMap<Integer, AbstractButton>();
        Iterator iterator = this.menuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            button = (AbstractButton)this.menuButtons.get(slot);
            if (button instanceof ObjectItem) {
                tempVal8.put(slot, button);
                continue;
            }
            tempVal7.put(slot, button);
        }
        tempVal8.putAll(tempVal7);
        iterator = tempVal8.keySet().iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            button = (AbstractButton)tempVal8.get(slot);
            ObjectDisplayItemStack displayItem = button.getDisplayItem(this.player, 1);
            ButtonComponent tempVal6 = displayItem.parseToBedrockButton();
            if (tempVal6 != null) {
                tempVal5.button(tempVal6);
            }
            this.menuItems.put(tempVal6, slot);
        }
        tempVal5.title(TextUtil.parse(this.player, this.shop.getShopMenuObject().getString("title", this.shop.getShopDisplayName()).replace("{shop-name}", this.shop.getShopDisplayName())));
        tempVal5.validResultHandler(response -> {
            this.removeOpenGUIStatus();
            ((AbstractButton)this.menuButtons.get(this.menuItems.get(response.clickedButton()))).clickEvent(ClickType.LEFT, this.player);
        });
        tempVal5.closedOrInvalidResultHandler(response -> this.removeOpenGUIStatus());
        if (this.getMenu().getString("bedrock.content", null) != null) {
            tempVal5.content(TextUtil.parse(this.player, this.getMenu().getString("bedrock.content", "")));
        }
        this.form = tempVal5.build();
    }

    @Override
    public ObjectMenu getMenu() {
        return this.shop.getShopMenuObject();
    }
}

