/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.inv;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.InvGUI;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.methods.Product.BuyProductMethod;
import cn.superiormc.ultimateshop.methods.Product.SellProductMethod;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ButtonType;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.buttons.ObjectMoreBuyButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectMoreDisplayButton;
import cn.superiormc.ultimateshop.objects.menus.MenuSender;
import cn.superiormc.ultimateshop.objects.menus.ObjectMoreMenu;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BuyMoreGUI
extends InvGUI {
    private final ObjectItem item;
    private final ObjectMoreMenu menu;
    private int nowingAmount;

    private BuyMoreGUI(Player owner, ObjectItem item) {
        super(owner);
        this.item = item;
        this.menu = item.getBuyMoreMenu();
        this.nowingAmount = 1;
    }

    private BuyMoreGUI(Player owner, ObjectItem item, ObjectMoreMenu menu) {
        super(owner);
        this.item = item;
        this.menu = menu;
        this.nowingAmount = 1;
    }

    @Override
    protected void constructGUI() {
        if (this.menu == null) {
            return;
        }
        this.menuButtons = this.menu.getMenu(MenuSender.of(this.player));
        this.menuItems = this.getMenuItems(this.player);
        int displaySlot = this.menu.getDisplayItemSlot();
        ItemStack tempVal1 = (ItemStack)this.menuItems.get(displaySlot);
        tempVal1.setAmount(this.nowingAmount);
        this.title = this.menu.getString("title", "Buy More Menu");
        if (Objects.isNull(this.inv)) {
            this.inv = UltimateShop.methodUtil.createNewInv(this.player, this.menu.getInt("size", 54), this.title);
        }
        this.inv.setItem(displaySlot, tempVal1);
        Iterator iterator = this.menuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            this.inv.setItem(slot, (ItemStack)this.menuItems.get(slot));
        }
    }

    @Override
    public boolean clickEventHandle(Inventory inventory, ClickType type, int slot) {
        AbstractButton button = (AbstractButton)this.menuButtons.get(slot);
        if (button == null) {
            return true;
        }
        switch (button.type) {
            case SELECT_AMOUNT: {
                if (button.config.getInt("add-amount", 0) == 0) {
                    if (button.config.getInt("set-amount", -1) == -1) {
                        ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not find add-amount section in select amount button, or you are setting add-amount to 0?");
                        return true;
                    }
                    this.nowingAmount = button.config.getInt("set-amount");
                } else {
                    this.nowingAmount += button.config.getInt("add-amount");
                }
                if (this.nowingAmount < 1) {
                    this.nowingAmount = 1;
                }
                if (this.nowingAmount < this.menu.getSection().getInt("max-amount", 64)) break;
                this.nowingAmount = this.menu.getSection().getInt("max-amount", 64);
                break;
            }
            case DISPLAY: {
                break;
            }
            case CONFIRM: {
                boolean b = ConfigManager.configManager.getBoolean("placeholder.click.enabled");
                String clickType = ConfigManager.configManager.getClickAction(type, button);
                if (((ObjectMoreBuyButton)button).getClickType() != null) {
                    clickType = ((ObjectMoreBuyButton)button).getClickType().toLowerCase();
                }
                switch (clickType) {
                    case "buy": {
                        if (this.item.getBuyPrice().empty) break;
                        BuyProductMethod.startBuy(this.item, this.player, !b, false, this.nowingAmount);
                        break;
                    }
                    case "sell": {
                        if (this.item.getSellPrice().empty) break;
                        SellProductMethod.startSell(this.item, this.player, !b, false, this.nowingAmount);
                        break;
                    }
                    case "buy-or-sell": {
                        if (this.item.getBuyPrice().empty && !this.item.getSellPrice().empty) {
                            SellProductMethod.startSell(this.item, this.player, !b, false, this.nowingAmount);
                            break;
                        }
                        BuyProductMethod.startBuy(this.item, this.player, !b, false, this.nowingAmount);
                        break;
                    }
                    case "sell-all": {
                        if (this.item.getSellPrice().empty || !this.item.isEnableSellAll()) break;
                        SellProductMethod.startSell(this.item, this.player, !b, false, true, this.nowingAmount);
                    }
                }
                break;
            }
            default: {
                ((AbstractButton)this.menuButtons.get(slot)).clickEvent(type, this.player.getPlayer());
            }
        }
        this.constructGUI();
        return true;
    }

    @Override
    public Map<Integer, ItemStack> getMenuItems(Player player) {
        Map tempVal1 = this.menuButtons;
        HashMap<Integer, ItemStack> resultItems = new HashMap<Integer, ItemStack>();
        Iterator iterator = tempVal1.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            AbstractButton tempVal2 = (AbstractButton)tempVal1.get(i);
            if (tempVal2.type == ButtonType.DISPLAY) {
                ObjectMoreDisplayButton tempVal3 = (ObjectMoreDisplayButton)tempVal2;
                resultItems.put(i, tempVal3.getDisplayItem(player, this.nowingAmount).getItemStack());
                continue;
            }
            if (tempVal2.type == ButtonType.CONFIRM) {
                ObjectMoreBuyButton tempVal4 = (ObjectMoreBuyButton)tempVal2;
                resultItems.put(i, tempVal4.getDisplayItem(player, this.nowingAmount).getItemStack());
                continue;
            }
            resultItems.put(i, tempVal2.getDisplayItem(player, 1).getItemStack());
        }
        return resultItems;
    }

    public static void openGUI(Player player, ObjectItem item) {
        if (ConfigManager.configManager.getBoolean("menu.buy-more-menu.not-open-when-invalid") && item.getBuyMoreMenu().isInvalid()) {
            return;
        }
        BuyMoreGUI gui = new BuyMoreGUI(player, item);
        gui.openGUI(true);
    }

    public static void openGUI(Player player, ObjectItem item, ObjectMoreMenu menu) {
        if (ConfigManager.configManager.getBoolean("menu.buy-more-menu.not-open-when-invalid") && menu.isInvalid()) {
            return;
        }
        BuyMoreGUI gui = new BuyMoreGUI(player, item, menu);
        gui.openGUI(true);
    }
}

