/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.inv;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.InvGUI;
import cn.superiormc.ultimateshop.gui.form.FormCommonGUI;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.menus.MenuSender;
import cn.superiormc.ultimateshop.objects.menus.MenuType;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.util.Iterator;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CommonGUI
extends InvGUI {
    private ObjectMenu commonMenu = null;
    private final boolean bypass;

    private CommonGUI(Player owner, ObjectMenu menu, boolean bypass) {
        super(owner);
        this.commonMenu = menu;
        this.bypass = bypass;
    }

    @Override
    protected void constructGUI() {
        if (!this.bypass && !this.commonMenu.getCondition().getAllBoolean(new ObjectThingRun(this.player))) {
            LanguageManager.languageManager.sendStringText(this.player, "menu-condition-not-meet", "menu", this.commonMenu.getName());
            return;
        }
        this.menuButtons = this.commonMenu.getMenu(MenuSender.of(this.player));
        this.menuItems = this.getMenuItems(this.player);
        this.title = this.commonMenu.getString("title", "Shop");
        if (Objects.isNull(this.inv)) {
            this.inv = UltimateShop.methodUtil.createNewInv(this.player, this.commonMenu.getInt("size", 54), this.title);
        }
        Iterator iterator = this.menuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            this.inv.setItem(slot, (ItemStack)this.menuItems.get(slot));
        }
    }

    @Override
    public boolean clickEventHandle(Inventory inventory, ClickType type, int slot) {
        if (this.menuButtons.get(slot) == null) {
            return true;
        }
        ((AbstractButton)this.menuButtons.get(slot)).clickEvent(type, this.player.getPlayer());
        if (ConfigManager.configManager.getBoolean("menu.shop.click-update")) {
            this.constructGUI();
        } else {
            this.menuItems.put(slot, this.getMenuItem(this.player, slot));
            this.inv.setItem(slot, (ItemStack)this.menuItems.get(slot));
        }
        return true;
    }

    @Override
    public ObjectMenu getMenu() {
        return this.commonMenu;
    }

    public static void openGUI(Player player, String fileName, boolean bypass, boolean reopen) {
        ObjectMenu commonMenu = ObjectMenu.commonMenus.get(fileName);
        if (commonMenu == null || commonMenu.menuConfigs == null) {
            LanguageManager.languageManager.sendStringText(player, "error.menu-not-found", "menu", fileName);
            return;
        }
        if (commonMenu.getType().equals((Object)MenuType.More)) {
            LanguageManager.languageManager.sendStringText(player, "error.buy-more-menu-direct-open");
            return;
        }
        if (UltimateShop.useGeyser && commonMenu.isUseGeyser() && CommonUtil.isBedrockPlayer(player)) {
            FormCommonGUI formCommonGUI = new FormCommonGUI(player, commonMenu, bypass);
            formCommonGUI.openGUI(reopen);
            return;
        }
        CommonGUI gui = new CommonGUI(player, commonMenu, bypass);
        gui.openGUI(reopen);
    }
}

