/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.hooks.economy;

import cn.superiormc.ultimateshop.hooks.economy.AbstractEconomyHook;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import me.TechsCode.UltraEconomy.UltraEconomy;
import me.TechsCode.UltraEconomy.UltraEconomyAPI;
import me.TechsCode.UltraEconomy.objects.Account;
import me.TechsCode.UltraEconomy.objects.Currency;
import org.bukkit.entity.Player;

public class EconomyUltraEconomyHook
extends AbstractEconomyHook {
    private final UltraEconomyAPI ueAPI = UltraEconomy.getAPI();

    public EconomyUltraEconomyHook() {
        super("UltraEconomy");
    }

    @Override
    public double getEconomy(Player player, String currencyID) {
        if (!UltraEconomy.getAPI().getCurrencies().name(currencyID).isPresent()) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in UltraEconomy plugin!");
            return 0.0;
        }
        if (UltraEconomy.getAPI().getAccounts().uuid(player.getUniqueId()).isPresent()) {
            return ((Account)UltraEconomy.getAPI().getAccounts().uuid(player.getUniqueId()).get()).getBalance((Currency)UltraEconomy.getAPI().getCurrencies().name(currencyID).get()).getOnHand();
        }
        return 0.0;
    }

    @Override
    public void takeEconomy(Player player, double value, String currencyID) {
        if (!UltraEconomy.getAPI().getCurrencies().name(currencyID).isPresent()) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in UltraEconomy plugin!");
            return;
        }
        if (UltraEconomy.getAPI().getAccounts().uuid(player.getUniqueId()).isPresent()) {
            ((Account)UltraEconomy.getAPI().getAccounts().uuid(player.getUniqueId()).get()).getBalance((Currency)UltraEconomy.getAPI().getCurrencies().name(currencyID).get()).removeHand((double)((float)value));
        }
    }

    @Override
    public void giveEconomy(Player player, double value, String currencyID) {
        if (!UltraEconomy.getAPI().getCurrencies().name(currencyID).isPresent()) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in UltraEconomy plugin!");
            return;
        }
        if (UltraEconomy.getAPI().getAccounts().uuid(player.getUniqueId()).isPresent()) {
            ((Account)UltraEconomy.getAPI().getAccounts().uuid(player.getUniqueId()).get()).getBalance((Currency)UltraEconomy.getAPI().getCurrencies().name(currencyID).get()).addHand((double)((float)value));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.ueAPI == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not hook into UltraEconomy plugin!");
            return false;
        }
        return true;
    }
}

