/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.hooks.economy;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.hooks.economy.AbstractEconomyHook;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyVaultHook
extends AbstractEconomyHook {
    private RegisteredServiceProvider<Economy> rsp = UltimateShop.instance.getServer().getServicesManager().getRegistration(Economy.class);

    public EconomyVaultHook() {
        super("Vault");
    }

    @Override
    public boolean hasEnoughEconomy(Player player, double value, String currencyID) {
        Economy eco = (Economy)this.rsp.getProvider();
        return eco.has((OfflinePlayer)player, value);
    }

    @Override
    public double getEconomy(Player player, String currencyID) {
        Economy eco = (Economy)this.rsp.getProvider();
        return eco.getBalance((OfflinePlayer)player);
    }

    @Override
    public void takeEconomy(Player player, double value, String currencyID) {
        Economy eco = (Economy)this.rsp.getProvider();
        eco.withdrawPlayer((OfflinePlayer)player, value);
    }

    @Override
    public void giveEconomy(Player player, double value, String currencyID) {
        Economy eco = (Economy)this.rsp.getProvider();
        eco.depositPlayer((OfflinePlayer)player, value);
    }

    @Override
    public boolean isEnabled() {
        if (this.rsp == null) {
            this.rsp = UltimateShop.instance.getServer().getServicesManager().getRegistration(Economy.class);
            if (this.rsp == null) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not hook into Vault plugin, Vault is a API plugin, maybe you didn't install a Vault-based economy plugin in your server!");
                return false;
            }
        }
        return true;
    }
}

