/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.hooks.economy.AbstractEconomyHook;
import cn.superiormc.ultimateshop.hooks.economy.EconomyCoinsEngineHook;
import cn.superiormc.ultimateshop.hooks.economy.EconomyEcoBitsHook;
import cn.superiormc.ultimateshop.hooks.economy.EconomyPEconomyHook;
import cn.superiormc.ultimateshop.hooks.economy.EconomyPlayerPointsHook;
import cn.superiormc.ultimateshop.hooks.economy.EconomyRedisEconomyHook;
import cn.superiormc.ultimateshop.hooks.economy.EconomyRoyaleEconomyHook;
import cn.superiormc.ultimateshop.hooks.economy.EconomyUltraEconomyHook;
import cn.superiormc.ultimateshop.hooks.economy.EconomyVaultHook;
import cn.superiormc.ultimateshop.hooks.economy.EconomyVotingPluginHook;
import cn.superiormc.ultimateshop.hooks.items.AbstractItemHook;
import cn.superiormc.ultimateshop.hooks.items.ItemCraftEngineHook;
import cn.superiormc.ultimateshop.hooks.items.ItemEcoArmorHook;
import cn.superiormc.ultimateshop.hooks.items.ItemEcoItemsHook;
import cn.superiormc.ultimateshop.hooks.items.ItemExecutableItemsHook;
import cn.superiormc.ultimateshop.hooks.items.ItemItemsAdderHook;
import cn.superiormc.ultimateshop.hooks.items.ItemMMOItemsHook;
import cn.superiormc.ultimateshop.hooks.items.ItemMythicMobsHook;
import cn.superiormc.ultimateshop.hooks.items.ItemNeigeItemsHook;
import cn.superiormc.ultimateshop.hooks.items.ItemNexoHook;
import cn.superiormc.ultimateshop.hooks.items.ItemOraxenHook;
import cn.superiormc.ultimateshop.hooks.items.ItemecoHook;
import cn.superiormc.ultimateshop.hooks.protection.AbstractProtectionHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionBentoBoxHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionDominionHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionGriefPreventionHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionHuskClaimsHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionHuskTownsHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionLandsHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionPlotSquaredHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionResidenceHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionSuperiorSkyblock2Hook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionTownyHook;
import cn.superiormc.ultimateshop.hooks.protection.ProtectionWorldGuardHook;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.papi.PlaceholderAPIExpansion;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HookManager {
    public static HookManager hookManager;
    private Map<String, AbstractEconomyHook> economyHooks;
    private Map<String, AbstractItemHook> itemHooks;
    private Map<String, AbstractProtectionHook> protectionHooks;

    public HookManager() {
        hookManager = this;
        this.initProtectionHook();
        this.initNormalHook();
        this.initEconomyHook();
        this.initItemHook();
    }

    private void initNormalHook() {
        if (CommonUtil.checkPluginLoad("PlaceholderAPI")) {
            PlaceholderAPIExpansion.papi = new PlaceholderAPIExpansion(UltimateShop.instance);
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fHooking into PlaceholderAPI...");
            if (PlaceholderAPIExpansion.papi.register()) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fFinished hook!");
            }
        }
    }

    private void initEconomyHook() {
        this.economyHooks = new HashMap<String, AbstractEconomyHook>();
        if (CommonUtil.checkPluginLoad("Vault")) {
            this.registerNewEconomyHook("Vault", new EconomyVaultHook());
        }
        if (CommonUtil.checkPluginLoad("PlayerPoints")) {
            this.registerNewEconomyHook("PlayerPoints", new EconomyPlayerPointsHook());
        }
        if (CommonUtil.checkPluginLoad("CoinsEngine")) {
            this.registerNewEconomyHook("CoinsEngine", new EconomyCoinsEngineHook());
        }
        if (CommonUtil.checkPluginLoad("UltraEconomy")) {
            this.registerNewEconomyHook("UltraEconomy", new EconomyUltraEconomyHook());
        }
        if (CommonUtil.checkPluginLoad("EcoBits")) {
            this.registerNewEconomyHook("EcoBits", new EconomyEcoBitsHook());
        }
        if (CommonUtil.checkPluginLoad("PEconomy")) {
            this.registerNewEconomyHook("PEconomy", new EconomyPEconomyHook());
        }
        if (CommonUtil.checkPluginLoad("RedisEconomy")) {
            this.registerNewEconomyHook("RedisEconomy", new EconomyRedisEconomyHook());
        }
        if (CommonUtil.checkPluginLoad("RoyaleEconomy")) {
            this.registerNewEconomyHook("RoyaleEconomy", new EconomyRoyaleEconomyHook());
        }
        if (CommonUtil.checkPluginLoad("VotingPlugin")) {
            this.registerNewEconomyHook("VotingPlugin", new EconomyVotingPluginHook());
        }
    }

    private void initItemHook() {
        this.itemHooks = new HashMap<String, AbstractItemHook>();
        if (CommonUtil.checkPluginLoad("ItemsAdder")) {
            this.registerNewItemHook("ItemsAdder", new ItemItemsAdderHook());
        }
        if (CommonUtil.checkPluginLoad("Oraxen")) {
            this.registerNewItemHook("Oraxen", new ItemOraxenHook());
        }
        if (CommonUtil.checkPluginLoad("MMOItems")) {
            this.registerNewItemHook("MMOItems", new ItemMMOItemsHook());
        }
        if (CommonUtil.checkPluginLoad("EcoItems")) {
            this.registerNewItemHook("EcoItems", new ItemEcoItemsHook());
        }
        if (CommonUtil.checkPluginLoad("EcoArmor")) {
            this.registerNewItemHook("EcoArmor", new ItemEcoArmorHook());
        }
        if (CommonUtil.checkPluginLoad("MythicMobs")) {
            this.registerNewItemHook("MythicMobs", new ItemMythicMobsHook());
        }
        if (CommonUtil.checkPluginLoad("eco")) {
            this.registerNewItemHook("eco", new ItemecoHook());
        }
        if (CommonUtil.checkPluginLoad("NeigeItems")) {
            this.registerNewItemHook("NeigeItems", new ItemNeigeItemsHook());
        }
        if (CommonUtil.checkPluginLoad("ExecutableItems")) {
            this.registerNewItemHook("ExecutableItems", new ItemExecutableItemsHook());
        }
        if (CommonUtil.checkPluginLoad("Nexo")) {
            this.registerNewItemHook("Nexo", new ItemNexoHook());
        }
        if (CommonUtil.checkPluginLoad("CraftEngine")) {
            this.registerNewItemHook("CraftEngine", new ItemCraftEngineHook());
        }
    }

    private void initProtectionHook() {
        this.protectionHooks = new HashMap<String, AbstractProtectionHook>();
        if (CommonUtil.checkPluginLoad("WorldGuard")) {
            this.registerNewProtectionHook("WorldGuard", new ProtectionWorldGuardHook());
        }
        if (CommonUtil.checkPluginLoad("Residence")) {
            this.registerNewProtectionHook("Residence", new ProtectionResidenceHook());
        }
        if (CommonUtil.checkPluginLoad("GriefPrevention")) {
            this.registerNewProtectionHook("GriefPrevention", new ProtectionGriefPreventionHook());
        }
        if (CommonUtil.checkPluginLoad("Lands")) {
            this.registerNewProtectionHook("Lands", new ProtectionLandsHook());
        }
        if (CommonUtil.checkPluginLoad("HuskTowns")) {
            this.registerNewProtectionHook("HuskTowns", new ProtectionHuskTownsHook());
        }
        if (CommonUtil.checkPluginLoad("HuskClaims")) {
            this.registerNewProtectionHook("HuskClaims", new ProtectionHuskClaimsHook());
        }
        if (CommonUtil.checkPluginLoad("PlotSquared")) {
            this.registerNewProtectionHook("PlotSquared", new ProtectionPlotSquaredHook());
        }
        if (CommonUtil.checkPluginLoad("Towny")) {
            this.registerNewProtectionHook("Towny", new ProtectionTownyHook());
        }
        if (CommonUtil.checkPluginLoad("BentoBox")) {
            this.registerNewProtectionHook("BentoBox", new ProtectionBentoBoxHook());
        }
        if (CommonUtil.checkPluginLoad("Dominion")) {
            this.registerNewProtectionHook("Dominion", new ProtectionDominionHook());
        }
        if (CommonUtil.checkPluginLoad("SuperiorSkyblock2")) {
            this.registerNewProtectionHook("SuperiorSkyblock2", new ProtectionSuperiorSkyblock2Hook());
        }
    }

    public void registerNewEconomyHook(String pluginName, AbstractEconomyHook economyHook) {
        if (!this.economyHooks.containsKey(pluginName)) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fHooking into " + pluginName + "...");
            this.economyHooks.put(pluginName, economyHook);
        }
    }

    public void registerNewItemHook(String pluginName, AbstractItemHook itemHook) {
        if (!this.itemHooks.containsKey(pluginName)) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fHooking into " + pluginName + "...");
            this.itemHooks.put(pluginName, itemHook);
        }
    }

    public void registerNewProtectionHook(String pluginName, AbstractProtectionHook protectionHook) {
        if (!this.protectionHooks.containsKey(pluginName)) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fHooking into " + pluginName + "...");
            this.protectionHooks.put(pluginName, protectionHook);
        }
    }

    public double getEconomyAmount(Player player, String pluginName, String currencyID) {
        if (!this.economyHooks.containsKey(pluginName)) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not hook into " + pluginName + " plugin, maybe we do not support this plugin, or your server didn't correctly load this plugin!");
            return 0.0;
        }
        AbstractEconomyHook economyHook = this.economyHooks.get(pluginName);
        if (!economyHook.isEnabled()) {
            return 0.0;
        }
        return economyHook.getEconomy(player, currencyID);
    }

    public int getEconomyAmount(Player player, String vanillaType) {
        if ((vanillaType = vanillaType.toLowerCase()).equals("exp")) {
            return player.getTotalExperience();
        }
        if (vanillaType.equals("levels")) {
            return player.getLevel();
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7cError: You set economy type to " + vanillaType + " in shop config, however for now UltimateShop does not support it!");
        return 0;
    }

    public boolean getPrice(Player player, String pluginName, String currencyID, double value, boolean take) {
        if (value < 0.0) {
            return false;
        }
        if (!this.economyHooks.containsKey(pluginName)) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not hook into " + pluginName + " plugin, maybe we do not support this plugin, or your server didn't correctly load this plugin!");
            return false;
        }
        AbstractEconomyHook economyHook = this.economyHooks.get(pluginName);
        if (player.hasPermission("ultimateshop.bypassprice")) {
            return true;
        }
        return economyHook.isEnabled() && economyHook.checkEconomy(player, value, take, currencyID);
    }

    public boolean getPrice(Player player, String vanillaType, int value, boolean take) {
        if ((vanillaType = vanillaType.toLowerCase()).equals("exp")) {
            if (player.getTotalExperience() >= value) {
                if (take) {
                    player.giveExp(-value);
                }
                return true;
            }
            return false;
        }
        if (vanillaType.equals("levels")) {
            if (player.getLevel() >= value) {
                if (take) {
                    player.giveExpLevels(-value);
                }
                return true;
            }
            return false;
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7cError: You set economy type to " + vanillaType + " in shop config, however for now UltimateShop does not support it!");
        return false;
    }

    public ItemStack getHookItem(Player player, String pluginName, String itemID) {
        if (!this.itemHooks.containsKey(pluginName)) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not hook into " + pluginName + " plugin, maybe we do not support this plugin, or your server didn't correctly load this plugin!");
            return null;
        }
        AbstractItemHook itemHook = this.itemHooks.get(pluginName);
        return itemHook.getHookItemByID(player, itemID);
    }

    public void giveEconomy(String pluginName, String currencyName, Player player, double value) {
        if (!this.economyHooks.containsKey(pluginName)) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not hook into " + pluginName + " plugin, maybe we do not support this plugin, or your server didn't correctly load this plugin!");
            return;
        }
        AbstractEconomyHook economyHook = this.economyHooks.get(pluginName);
        if (!economyHook.isEnabled()) {
            return;
        }
        economyHook.giveEconomy(player, value, currencyName);
    }

    public void giveEconomy(String vanillaType, Player player, int value) {
        if ((vanillaType = vanillaType.toLowerCase()).equals("exp")) {
            player.giveExp(value);
            return;
        }
        if (vanillaType.equals("levels")) {
            player.giveExpLevels(value);
            return;
        }
        ErrorManager.errorManager.sendErrorMessage("\u00a7cError: You set economy type to " + vanillaType + " in shop config, however for now UltimateShop does not support it!");
    }

    public void takeEconomy(String pluginName, String currencyName, Player player, double value) {
        if (!this.economyHooks.containsKey(pluginName)) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not hook into " + pluginName + " plugin, maybe we do not support this plugin, or your server didn't correctly load this plugin!");
            return;
        }
        AbstractEconomyHook economyHook = this.economyHooks.get(pluginName);
        if (!economyHook.isEnabled()) {
            return;
        }
        economyHook.takeEconomy(player, value, currencyName);
    }

    public String getHookItemID(String pluginName, ItemStack hookItem) {
        if (!hookItem.hasItemMeta()) {
            return null;
        }
        if (!this.itemHooks.containsKey(pluginName)) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not hook into " + pluginName + " plugin, maybe we do not support this plugin, or your server didn't correctly load this plugin!");
            return null;
        }
        AbstractItemHook itemHook = this.itemHooks.get(pluginName);
        return itemHook.getIDByItemStack(hookItem);
    }

    public String[] getHookItemPluginAndID(ItemStack hookItem) {
        for (AbstractItemHook itemHook : this.itemHooks.values()) {
            String itemID = itemHook.getIDByItemStack(hookItem);
            if (itemID == null) continue;
            return new String[]{itemHook.getPluginName(), itemHook.getIDByItemStack(hookItem)};
        }
        return null;
    }

    public boolean getProtectionCanUse(Player player, Location location) {
        return true;
    }
}

