/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LanguageManager {
    public static LanguageManager languageManager;
    private YamlConfiguration messageFile;
    private YamlConfiguration tempMessageFile;
    private File file;
    private File tempFile;

    public LanguageManager() {
        languageManager = this;
        this.initLanguage();
    }

    private void initLanguage() {
        InputStream is;
        this.file = new File(String.valueOf(UltimateShop.instance.getDataFolder()) + "/languages/" + ConfigManager.configManager.getStringOrDefault("language", "config-files.language", "en_US") + ".yml");
        if (!this.file.exists()) {
            this.file = new File(UltimateShop.instance.getDataFolder(), "message.yml");
            if (!this.file.exists()) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cWe can not found your message file, please try restart your server!");
            }
        } else {
            this.messageFile = YamlConfiguration.loadConfiguration((File)this.file);
        }
        if ((is = UltimateShop.instance.getResource("languages/en_US.yml")) == null) {
            return;
        }
        this.tempFile = new File(UltimateShop.instance.getDataFolder(), "tempMessage.yml");
        try {
            Files.copy(is, this.tempFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.tempMessageFile = YamlConfiguration.loadConfiguration((File)this.tempFile);
        if (this.messageFile == null) {
            this.messageFile = this.tempMessageFile;
        }
        this.tempFile.delete();
    }

    public void sendStringText(CommandSender sender, String ... args) {
        if (sender instanceof Player) {
            this.sendStringText((Player)sender, args);
        } else {
            this.sendStringText(args);
        }
    }

    public void sendStringText(String ... args) {
        String text = this.messageFile.getString(args[0]);
        if (text == null) {
            if (this.tempMessageFile.getString(args[0]) == null) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cCan not found language key: " + args[0] + "!");
                return;
            }
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cUpdated your language file, added new language key and it's default value: " + args[0] + "!");
            text = this.tempMessageFile.getString(args[0]);
            this.messageFile.set(args[0], (Object)text);
            try {
                this.messageFile.save(this.file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (int i = 1; i < args.length; i += 2) {
            String var = "{" + args[i] + "}";
            text = args[i + 1] == null ? text.replace(var, "") : text.replace(var, args[i + 1]);
        }
        if (!text.isEmpty()) {
            UltimateShop.methodUtil.sendMessage(null, text);
        }
    }

    public void sendStringText(Player player, String ... args) {
        String text = this.messageFile.getString(args[0]);
        if (text == null) {
            if (this.tempMessageFile.getString(args[0]) == null) {
                player.sendMessage(TextUtil.pluginPrefix() + " \u00a7cCan not found language key: " + args[0] + "!");
                return;
            }
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cUpdated your language file, added new language key and it's default value: " + args[0] + "!");
            text = this.tempMessageFile.getString(args[0]);
            this.messageFile.set(args[0], (Object)text);
            try {
                this.messageFile.save(this.file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (int i = 1; i < args.length; i += 2) {
            String var = "{" + args[i] + "}";
            text = args[i + 1] == null ? text.replace(var, "") : text.replace(var, args[i + 1]);
        }
        if (!text.isEmpty()) {
            UltimateShop.methodUtil.sendMessage(player, text);
        }
    }

    public String getStringText(String path) {
        if (this.messageFile.getString(path) == null) {
            if (this.tempMessageFile.getString(path) == null) {
                return "\u00a7cCan not found language key: " + path + "!";
            }
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cUpdated your language file, added new language key and it's default value: " + path + "!");
            this.messageFile.set(path, (Object)this.tempMessageFile.getString(path));
            try {
                this.messageFile.save(this.file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.tempMessageFile.getString(path);
        }
        return this.messageFile.getString(path);
    }

    public List<String> getStringListText(String path) {
        if (this.messageFile.getStringList(path).isEmpty()) {
            ArrayList<String> tempVal1 = new ArrayList<String>();
            if (this.tempMessageFile.getString(path) == null) {
                tempVal1.add("\u00a7cCan not found language key: " + path + "!");
                return tempVal1;
            }
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cUpdated your language file, added new language key and it's default value: " + path + "!");
            this.messageFile.set(path, (Object)this.tempMessageFile.getStringList(path));
            try {
                this.messageFile.save(this.file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.tempMessageFile.getStringList(path);
        }
        return this.messageFile.getStringList(path);
    }
}

